#ifndef QT_RESISTOR_H
#define QT_RESISTOR_H

//qpe#include <qpe/fileselector.h>
#include <qaction.h>
#include <qpopupmenu.h>
#include <qtextview.h>
#include <qlineedit.h>
//#include <qcombobox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qpoint.h>
#include "mainwin.h"

//class QVBoxLayout; 
//class QHBoxLayout; 
//class QGridLayout; 
//class QCheckBox;
//class QComboBox;
//class QLabel;
//class QLineEdit;
//class QPushButton;
//class QTextView;


class QtResistor : public ResistorView
{ 
    Q_OBJECT

public:
    QtResistor( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~QtResistor();

public:
private:
    QString resistance, voltage, current, percentage, power;
    QPopupMenu *band1, *band2, *band3, *band4;
    QString colorList[10];
    QColor colors[17];
    QString percentList[7];
protected:
    QAction *actBand1_1,*actBand1_2,*actBand1_3,*actBand1_4,*actBand1_5;
    QAction *actBand1_6,*actBand1_7,*actBand1_8,*actBand1_9,*actBand1_10;
    QAction *actBand2_1,*actBand2_2;

public slots:
    void calcFromR();
    void calcFromV();
    void calcFromI();
    void calcFromPercent();
    void slotRaisePopupBand1();
    void slotRaisePopupBand2();
    void slotRaisePopupBand3();
    void slotRaisePopupBand4();
    void slotMenu1(int id); 
    void slotMenu2(int id); 
    void slotMenu3(int id); 
    void slotMenu4(int id); 
    //local slots
    void calcResistancePP( );
    void calcBtnGrpSetDisable();

signals:
    void bandColorChanged(QButton *, int);

private:
    void calcTab1();
    void mousePressEvent( QMouseEvent *e );
    void setBandColor(QLabel *, int);
    void setBandColor(QButton *, int);
    void bandUpdate( int band );
    bool validateR( );

};

#endif // QT_RESISTOR_H
