/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WebBrowser;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;

public class Browser
extends Composite {
    WebBrowser webBrowser;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.browser.";
    static final String NO_INPUT_METHOD = "org.eclipse.swt.internal.gtk.noInputMethod";

    public Browser(Composite composite, int n) {
        super(Browser.checkParent(composite), Browser.checkStyle(n));
        String string = SWT.getPlatform();
        Display display = composite.getDisplay();
        if ("gtk".equals(string)) {
            display.setData(NO_INPUT_METHOD, null);
        }
        String string2 = null;
        if ((n & 0x8000) != 0) {
            string2 = "org.eclipse.swt.browser.Mozilla";
        } else if ("win32".equals(string) || "wpf".equals(string)) {
            string2 = "org.eclipse.swt.browser.IE";
        } else if ("motif".equals(string)) {
            string2 = "org.eclipse.swt.browser.Mozilla";
        } else if ("gtk".equals(string)) {
            string2 = "org.eclipse.swt.browser.Mozilla";
        } else if ("carbon".equals(string)) {
            string2 = "org.eclipse.swt.browser.Safari";
        } else if ("photon".equals(string)) {
            string2 = "org.eclipse.swt.browser.Voyager";
        } else {
            this.dispose();
            SWT.error(2);
        }
        try {
            Class<?> clazz = Class.forName(string2);
            this.webBrowser = (WebBrowser)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {}
        if (this.webBrowser == null) {
            this.dispose();
            SWT.error(2);
        }
        this.webBrowser.setBrowser(this);
        this.webBrowser.create(composite, n);
    }

    static Composite checkParent(Composite composite) {
        Display display;
        String string = SWT.getPlatform();
        if (!"gtk".equals(string)) {
            return composite;
        }
        if (composite != null && !composite.isDisposed() && (display = composite.getDisplay()) != null && display.getThread() == Thread.currentThread()) {
            display.setData(NO_INPUT_METHOD, "true");
        }
        return composite;
    }

    static int checkStyle(int n) {
        String string = SWT.getPlatform();
        if ((n & 0x8000) != 0) {
            if ("carbon".equals(string)) {
                return n | 0x1000000;
            }
            if ("motif".equals(string)) {
                return n | 0x1000000;
            }
            return n;
        }
        if ("win32".equals(string)) {
            return n & 0xFFFFF7FF;
        }
        if ("motif".equals(string)) {
            return n | 0x1000000;
        }
        return n;
    }

    public static void clearSessions() {
        WebBrowser.clearSessions();
    }

    public void addCloseWindowListener(CloseWindowListener closeWindowListener) {
        this.checkWidget();
        if (closeWindowListener == null) {
            SWT.error(4);
        }
        this.webBrowser.addCloseWindowListener(closeWindowListener);
    }

    public void addLocationListener(LocationListener locationListener) {
        this.checkWidget();
        if (locationListener == null) {
            SWT.error(4);
        }
        this.webBrowser.addLocationListener(locationListener);
    }

    public void addOpenWindowListener(OpenWindowListener openWindowListener) {
        this.checkWidget();
        if (openWindowListener == null) {
            SWT.error(4);
        }
        this.webBrowser.addOpenWindowListener(openWindowListener);
    }

    public void addProgressListener(ProgressListener progressListener) {
        this.checkWidget();
        if (progressListener == null) {
            SWT.error(4);
        }
        this.webBrowser.addProgressListener(progressListener);
    }

    public void addStatusTextListener(StatusTextListener statusTextListener) {
        this.checkWidget();
        if (statusTextListener == null) {
            SWT.error(4);
        }
        this.webBrowser.addStatusTextListener(statusTextListener);
    }

    public void addTitleListener(TitleListener titleListener) {
        this.checkWidget();
        if (titleListener == null) {
            SWT.error(4);
        }
        this.webBrowser.addTitleListener(titleListener);
    }

    public void addVisibilityWindowListener(VisibilityWindowListener visibilityWindowListener) {
        this.checkWidget();
        if (visibilityWindowListener == null) {
            SWT.error(4);
        }
        this.webBrowser.addVisibilityWindowListener(visibilityWindowListener);
    }

    public boolean back() {
        this.checkWidget();
        return this.webBrowser.back();
    }

    protected void checkSubclass() {
        int n;
        String string = this.getClass().getName();
        if (!string.substring(0, (n = string.lastIndexOf(46)) + 1).equals(PACKAGE_PREFIX)) {
            SWT.error(43);
        }
    }

    public boolean execute(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        return this.webBrowser.execute(string);
    }

    public boolean forward() {
        this.checkWidget();
        return this.webBrowser.forward();
    }

    public String getText() {
        this.checkWidget();
        return this.webBrowser.getText();
    }

    public String getUrl() {
        this.checkWidget();
        return this.webBrowser.getUrl();
    }

    public Object getWebBrowser() {
        this.checkWidget();
        return this.webBrowser.getWebBrowser();
    }

    public boolean isBackEnabled() {
        this.checkWidget();
        return this.webBrowser.isBackEnabled();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.webBrowser.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    public boolean isForwardEnabled() {
        this.checkWidget();
        return this.webBrowser.isForwardEnabled();
    }

    public void refresh() {
        this.checkWidget();
        this.webBrowser.refresh();
    }

    public void removeCloseWindowListener(CloseWindowListener closeWindowListener) {
        this.checkWidget();
        if (closeWindowListener == null) {
            SWT.error(4);
        }
        this.webBrowser.removeCloseWindowListener(closeWindowListener);
    }

    public void removeLocationListener(LocationListener locationListener) {
        this.checkWidget();
        if (locationListener == null) {
            SWT.error(4);
        }
        this.webBrowser.removeLocationListener(locationListener);
    }

    public void removeOpenWindowListener(OpenWindowListener openWindowListener) {
        this.checkWidget();
        if (openWindowListener == null) {
            SWT.error(4);
        }
        this.webBrowser.removeOpenWindowListener(openWindowListener);
    }

    public void removeProgressListener(ProgressListener progressListener) {
        this.checkWidget();
        if (progressListener == null) {
            SWT.error(4);
        }
        this.webBrowser.removeProgressListener(progressListener);
    }

    public void removeStatusTextListener(StatusTextListener statusTextListener) {
        this.checkWidget();
        if (statusTextListener == null) {
            SWT.error(4);
        }
        this.webBrowser.removeStatusTextListener(statusTextListener);
    }

    public void removeTitleListener(TitleListener titleListener) {
        this.checkWidget();
        if (titleListener == null) {
            SWT.error(4);
        }
        this.webBrowser.removeTitleListener(titleListener);
    }

    public void removeVisibilityWindowListener(VisibilityWindowListener visibilityWindowListener) {
        this.checkWidget();
        if (visibilityWindowListener == null) {
            SWT.error(4);
        }
        this.webBrowser.removeVisibilityWindowListener(visibilityWindowListener);
    }

    public boolean setText(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        return this.webBrowser.setText(string);
    }

    public boolean setUrl(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error(4);
        }
        return this.webBrowser.setUrl(string);
    }

    public void stop() {
        this.checkWidget();
        this.webBrowser.stop();
    }
}

