/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.gtk.OS;

public class FileTransfer
extends ByteArrayTransfer {
    private static FileTransfer _instance = new FileTransfer();
    private static final String URI_LIST = "text/uri-list";
    private static final int URI_LIST_ID = FileTransfer.registerType("text/uri-list");
    private static final byte[] separator = new byte[]{13, 10};

    private FileTransfer() {
    }

    public static FileTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkFile(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String[] stringArray = (String[])object;
        byte[] byArray = new byte[]{};
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            String string = stringArray[n];
            if (string != null && (n2 = string.length()) != 0) {
                char[] cArray = new char[n2];
                string.getChars(0, n2, cArray, 0);
                int[] nArray = new int[1];
                int n3 = OS.g_utf16_to_utf8(cArray, cArray.length, null, null, nArray);
                if (nArray[0] == 0 && n3 != 0) {
                    int n4 = OS.g_locale_from_utf8(n3, -1, null, null, nArray);
                    OS.g_free(n3);
                    if (nArray[0] == 0 && n4 != 0) {
                        int n5 = OS.g_filename_to_uri(n4, 0, nArray);
                        OS.g_free(n4);
                        if (nArray[0] == 0 && n5 != 0) {
                            n2 = OS.strlen(n5);
                            byte[] byArray2 = new byte[n2];
                            OS.memmove(byArray2, n5, n2);
                            OS.g_free(n5);
                            int n6 = n > 0 ? byArray.length + separator.length + byArray2.length : byArray2.length;
                            byte[] byArray3 = new byte[n6];
                            int n7 = 0;
                            if (n > 0) {
                                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                                System.arraycopy(separator, 0, byArray3, n7 += byArray.length, separator.length);
                                n7 += separator.length;
                            }
                            System.arraycopy(byArray2, 0, byArray3, n7, byArray2.length);
                            byArray = byArray3;
                        }
                    }
                }
            }
            ++n;
        }
        if (byArray.length == 0) {
            return;
        }
        n = OS.g_malloc(byArray.length + 1);
        OS.memset(n, 0, byArray.length + 1);
        OS.memmove(n, byArray, byArray.length);
        transferData.pValue = n;
        transferData.length = byArray.length;
        transferData.format = 8;
        transferData.result = 1;
    }

    public Object nativeToJava(TransferData transferData) {
        Object[] objectArray;
        int n;
        if (!this.isSupportedType(transferData) || transferData.pValue == 0 || transferData.length <= 0) {
            return null;
        }
        int n2 = transferData.length;
        byte[] byArray = new byte[n2];
        OS.memmove(byArray, transferData.pValue, n2);
        Object[] objectArray2 = new int[]{};
        int n3 = 0;
        int n4 = 0;
        while (n4 < byArray.length - 1) {
            if (byArray[n4] == 13 && byArray[n4 + 1] == 10) {
                n = n4 - n3;
                int n5 = OS.g_malloc(n + 1);
                objectArray = new byte[n + 1];
                System.arraycopy(byArray, n3, objectArray, 0, n);
                OS.memmove(n5, objectArray, n + 1);
                int[] nArray = new int[objectArray2.length + 1];
                System.arraycopy(objectArray2, 0, nArray, 0, objectArray2.length);
                nArray[objectArray2.length] = n5;
                objectArray2 = nArray;
                n3 = n4 + 2;
            }
            ++n4;
        }
        if (n3 < byArray.length - 2) {
            n4 = byArray.length - n3;
            n = OS.g_malloc(n4 + 1);
            byte[] byArray2 = new byte[n4 + 1];
            System.arraycopy(byArray, n3, byArray2, 0, n4);
            OS.memmove(n, byArray2, n4 + 1);
            objectArray = new int[objectArray2.length + 1];
            System.arraycopy(objectArray2, 0, objectArray, 0, objectArray2.length);
            objectArray[objectArray2.length] = n;
            objectArray2 = objectArray;
        }
        String[] stringArray = new String[]{};
        n = 0;
        while (n < objectArray2.length) {
            int[] nArray = new int[1];
            int n6 = OS.g_filename_from_uri(objectArray2[n], null, nArray);
            OS.g_free(objectArray2[n]);
            if (nArray[0] == 0 && n6 != 0) {
                int n7 = OS.g_locale_to_utf8(n6, -1, null, null, nArray);
                OS.g_free(n6);
                if (nArray[0] == 0 && n7 != 0) {
                    int[] nArray2 = new int[1];
                    int n8 = OS.g_utf8_to_utf16(n7, -1, null, nArray2, null);
                    OS.g_free(n7);
                    n2 = nArray2[0];
                    char[] cArray = new char[n2];
                    OS.memmove(cArray, n8, n2 * 2);
                    OS.g_free(n8);
                    String string = new String(cArray);
                    String[] stringArray2 = new String[stringArray.length + 1];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    stringArray2[stringArray.length] = string;
                    stringArray = stringArray2;
                }
            }
            ++n;
        }
        if (stringArray.length == 0) {
            return null;
        }
        return stringArray;
    }

    protected int[] getTypeIds() {
        return new int[]{URI_LIST_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{URI_LIST};
    }

    boolean checkFile(Object object) {
        if (object == null || !(object instanceof String[]) || ((String[])object).length == 0) {
            return false;
        }
        String[] stringArray = (String[])object;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null || stringArray[n].length() == 0) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean validate(Object object) {
        return this.checkFile(object);
    }
}

