/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.eclipse.swt.SWT;

public final class Compatibility {
    public static double PI = Math.PI;
    static double toRadians = PI / 180.0;
    private static ResourceBundle msgs = null;

    public static int cos(int n, int n2) {
        return (int)(Math.cos((double)n * toRadians) * (double)n2);
    }

    public static int sin(int n, int n2) {
        return (int)(Math.sin((double)n * toRadians) * (double)n2);
    }

    public static int ceil(int n, int n2) {
        return (int)Math.ceil((float)n / (float)n2);
    }

    public static int floor(int n, int n2) {
        return (int)Math.floor((double)n / (double)n2);
    }

    public static int round(int n, int n2) {
        return Math.round((float)n / (float)n2);
    }

    public static int pow2(int n) {
        if (n >= 1 && n <= 30) {
            return 2 << n - 1;
        }
        if (n != 0) {
            SWT.error(6);
        }
        return 1;
    }

    public static OutputStream newDeflaterOutputStream(OutputStream outputStream) throws IOException {
        return new DeflaterOutputStream(outputStream);
    }

    public static InputStream newFileInputStream(String string) throws IOException {
        return new FileInputStream(string);
    }

    public static OutputStream newFileOutputStream(String string) throws IOException {
        return new FileOutputStream(string);
    }

    public static InputStream newInflaterInputStream(InputStream inputStream) throws IOException {
        return new BufferedInputStream(new InflaterInputStream(inputStream));
    }

    public static boolean isLetter(char c) {
        return Character.isLetter(c);
    }

    public static boolean isLetterOrDigit(char c) {
        return Character.isLetterOrDigit(c);
    }

    public static boolean isSpaceChar(char c) {
        return Character.isSpaceChar(c);
    }

    public static boolean isWhitespace(char c) {
        return Character.isWhitespace(c);
    }

    public static void exec(String string) throws IOException {
        Runtime.getRuntime().exec(string);
    }

    public static void exec(String[] stringArray) throws IOException {
        Runtime.getRuntime().exec(stringArray);
    }

    public static String getMessage(String string) {
        String string2 = string;
        if (string == null) {
            SWT.error(4);
        }
        if (msgs == null) {
            try {
                msgs = ResourceBundle.getBundle("org.eclipse.swt.internal.SWTMessages");
            }
            catch (MissingResourceException missingResourceException) {
                string2 = String.valueOf(string) + " (no resource bundle)";
            }
        }
        if (msgs != null) {
            try {
                string2 = msgs.getString(string);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return string2;
    }

    public static String getMessage(String string, Object[] objectArray) {
        String string2 = string;
        if (string == null || objectArray == null) {
            SWT.error(4);
        }
        if (msgs == null) {
            try {
                msgs = ResourceBundle.getBundle("org.eclipse.swt.internal.SWTMessages");
            }
            catch (MissingResourceException missingResourceException) {
                string2 = String.valueOf(string) + " (no resource bundle)";
            }
        }
        if (msgs != null) {
            try {
                MessageFormat messageFormat = new MessageFormat("");
                messageFormat.applyPattern(msgs.getString(string));
                string2 = messageFormat.format(objectArray);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return string2;
    }

    public static void interrupt() {
        Thread.currentThread().interrupt();
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        return string.equalsIgnoreCase(string2);
    }
}

