/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkEventScroll;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    int scrolledHandle;
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite parent, int style) {
        super(parent, style);
    }

    int clientHandle() {
        return this.handle;
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkWidget();
        int border = 0;
        if (this.fixedHandle != 0) {
            border += OS.gtk_container_get_border_width(this.fixedHandle);
        }
        if (this.scrolledHandle != 0) {
            border += OS.gtk_container_get_border_width(this.scrolledHandle);
        }
        int trimX = x - border;
        int trimY = y - border;
        int trimWidth = width + border * 2;
        int trimHeight = height + border * 2;
        trimHeight += this.hScrollBarWidth();
        trimWidth += this.vScrollBarWidth();
        if (this.scrolledHandle != 0 && OS.gtk_scrolled_window_get_shadow_type(this.scrolledHandle) != 0) {
            int style = OS.gtk_widget_get_style(this.scrolledHandle);
            int xthickness = OS.gtk_style_get_xthickness(style);
            int ythickness = OS.gtk_style_get_ythickness(style);
            trimX -= xthickness;
            trimY -= ythickness;
            trimWidth += xthickness * 2;
            trimHeight += ythickness * 2;
        }
        return new Rectangle(trimX, trimY, trimWidth, trimHeight);
    }

    ScrollBar createScrollBar(int style) {
        if (this.scrolledHandle == 0) {
            return null;
        }
        ScrollBar bar = new ScrollBar();
        bar.parent = this;
        bar.style = style;
        bar.display = this.display;
        bar.state |= 8;
        if ((style & 0x100) != 0) {
            bar.handle = OS.GTK_SCROLLED_WINDOW_HSCROLLBAR(this.scrolledHandle);
            bar.adjustmentHandle = OS.gtk_scrolled_window_get_hadjustment(this.scrolledHandle);
        } else {
            bar.handle = OS.GTK_SCROLLED_WINDOW_VSCROLLBAR(this.scrolledHandle);
            bar.adjustmentHandle = OS.gtk_scrolled_window_get_vadjustment(this.scrolledHandle);
        }
        bar.setOrientation();
        bar.hookEvents();
        bar.register();
        return bar;
    }

    void createWidget(int index) {
        super.createWidget(index);
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    void deregister() {
        super.deregister();
        if (this.scrolledHandle != 0) {
            this.display.removeWidget(this.scrolledHandle);
        }
    }

    public int getBorderWidth() {
        this.checkWidget();
        int border = 0;
        if (this.fixedHandle != 0) {
            border += OS.gtk_container_get_border_width(this.fixedHandle);
        }
        if (this.scrolledHandle != 0) {
            border += OS.gtk_container_get_border_width(this.scrolledHandle);
            if (OS.gtk_scrolled_window_get_shadow_type(this.scrolledHandle) != 0) {
                border += OS.gtk_style_get_xthickness(OS.gtk_widget_get_style(this.scrolledHandle));
            }
        }
        return border;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        int clientHandle = this.clientHandle();
        int x = OS.GTK_WIDGET_X(clientHandle);
        int y = OS.GTK_WIDGET_Y(clientHandle);
        int width = (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(clientHandle);
        int height = (this.state & 0x400) != 0 ? 0 : OS.GTK_WIDGET_HEIGHT(clientHandle);
        return new Rectangle(x, y, width, height);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    int gtk_scroll_event(int widget, int eventPtr) {
        int result = super.gtk_scroll_event(widget, eventPtr);
        if ((this.state & 2) != 0) {
            GdkEventScroll gdkEvent = new GdkEventScroll();
            OS.memmove(gdkEvent, eventPtr, GdkEventScroll.sizeof);
            ScrollBar scrollBar = gdkEvent.direction == 0 || gdkEvent.direction == 1 ? this.verticalBar : this.horizontalBar;
            if (scrollBar != null && !OS.GTK_WIDGET_VISIBLE(scrollBar.handle) && scrollBar.getEnabled()) {
                GtkAdjustment adjustment = new GtkAdjustment();
                OS.memmove(adjustment, scrollBar.adjustmentHandle);
                int wheel_delta = (int)Math.pow(adjustment.page_size, 0.6666666666666666);
                if (gdkEvent.direction == 0 || gdkEvent.direction == 2) {
                    wheel_delta = -wheel_delta;
                }
                int value = (int)Math.max(adjustment.lower, Math.min(adjustment.upper - adjustment.page_size, adjustment.value + (double)wheel_delta));
                OS.gtk_adjustment_set_value(scrollBar.adjustmentHandle, value);
                return 1;
            }
        }
        return result;
    }

    int hScrollBarWidth() {
        if (this.horizontalBar == null) {
            return 0;
        }
        int hBarHandle = OS.GTK_SCROLLED_WINDOW_HSCROLLBAR(this.scrolledHandle);
        if (hBarHandle == 0) {
            return 0;
        }
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request(hBarHandle, requisition);
        int spacing = OS.GTK_SCROLLED_WINDOW_SCROLLBAR_SPACING(this.scrolledHandle);
        return requisition.height + spacing;
    }

    boolean sendLeaveNotify() {
        return this.scrolledHandle != 0;
    }

    void setOrientation() {
        super.setOrientation();
        if ((this.style & 0x4000000) != 0 && this.scrolledHandle != 0) {
            OS.gtk_widget_set_direction(this.scrolledHandle, 2);
        }
    }

    boolean setScrollBarVisible(ScrollBar bar, boolean visible) {
        int policy;
        if (this.scrolledHandle == 0) {
            return false;
        }
        int[] hsp = new int[1];
        int[] vsp = new int[1];
        OS.gtk_scrolled_window_get_policy(this.scrolledHandle, hsp, vsp);
        int n = policy = visible ? 0 : 2;
        if ((bar.style & 0x100) != 0) {
            if (hsp[0] == policy) {
                return false;
            }
            hsp[0] = policy;
        } else {
            if (vsp[0] == policy) {
                return false;
            }
            vsp[0] = policy;
        }
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp[0], vsp[0]);
        bar.sendEvent(visible ? 22 : 23);
        this.sendEvent(11);
        return true;
    }

    void redrawBackgroundImage() {
    }

    void redrawWidget(int x, int y, int width, int height, boolean redrawAll, boolean all, boolean trim) {
        int paintHandle;
        super.redrawWidget(x, y, width, height, redrawAll, all, trim);
        if ((OS.GTK_WIDGET_FLAGS(this.handle) & 0x40) == 0) {
            return;
        }
        if (!trim) {
            return;
        }
        int topHandle = this.topHandle();
        if (topHandle == (paintHandle = this.paintHandle())) {
            return;
        }
        int window = OS.GTK_WIDGET_WINDOW(topHandle);
        GdkRectangle rect = new GdkRectangle();
        if (redrawAll) {
            rect.width = OS.GTK_WIDGET_WIDTH(topHandle);
            rect.height = OS.GTK_WIDGET_HEIGHT(topHandle);
        } else {
            int[] destX = new int[1];
            int[] destY = new int[1];
            OS.gtk_widget_translate_coordinates(paintHandle, topHandle, x, y, destX, destY);
            rect.x = destX[0];
            rect.y = destY[0];
            rect.width = width;
            rect.height = height;
        }
        OS.gdk_window_invalidate_rect(window, rect, all);
    }

    void register() {
        super.register();
        if (this.scrolledHandle != 0) {
            this.display.addWidget(this.scrolledHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.scrolledHandle = 0;
    }

    void releaseChildren(boolean destroy) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(destroy);
    }

    void resizeHandle(int width, int height) {
        if (this.fixedHandle != 0) {
            OS.gtk_widget_set_size_request(this.fixedHandle, width, height);
        }
        OS.gtk_widget_set_size_request(this.scrolledHandle != 0 ? this.scrolledHandle : this.handle, width, height);
    }

    void showWidget() {
        super.showWidget();
        if (this.scrolledHandle != 0) {
            OS.gtk_widget_show(this.scrolledHandle);
        }
    }

    int topHandle() {
        if (this.fixedHandle != 0) {
            return this.fixedHandle;
        }
        if (this.scrolledHandle != 0) {
            return this.scrolledHandle;
        }
        return super.topHandle();
    }

    void updateScrollBarValue(ScrollBar bar) {
        this.redrawBackgroundImage();
    }

    int vScrollBarWidth() {
        if (this.verticalBar == null) {
            return 0;
        }
        int vBarHandle = OS.GTK_SCROLLED_WINDOW_VSCROLLBAR(this.scrolledHandle);
        if (vBarHandle == 0) {
            return 0;
        }
        GtkRequisition requisition = new GtkRequisition();
        OS.gtk_widget_size_request(vBarHandle, requisition);
        int spacing = OS.GTK_SCROLLED_WINDOW_SCROLLBAR_SPACING(this.scrolledHandle);
        return requisition.width + spacing;
    }
}

