/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.Mozilla;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

class MozillaDelegate {
    Browser browser;
    int mozillaHandle;
    int embedHandle;
    boolean hasFocus;
    Listener listener;
    static Callback eventCallback;
    static int eventProc;
    static final int STOP_PROPOGATE = 1;
    static boolean IsLinux;

    static {
        String string = System.getProperty("os.name").toLowerCase();
        IsLinux = string.startsWith("linux");
    }

    MozillaDelegate(Browser browser) {
        if (!IsLinux) {
            browser.dispose();
            SWT.error(2, null, " [Unsupported platform]");
        }
        this.browser = browser;
    }

    static int eventProc(int n, int n2, int n3) {
        int n4 = OS.gtk_widget_get_parent(n);
        if ((n4 = OS.gtk_widget_get_parent(n4)) == 0) {
            return 0;
        }
        Widget widget = Display.getCurrent().findWidget(n4);
        if (widget != null && widget instanceof Browser) {
            return ((Mozilla)((Browser)widget).webBrowser).delegate.gtk_event(n, n2, n3);
        }
        return 0;
    }

    static Browser findBrowser(int n) {
        int n2 = OS.gtk_widget_get_parent(n);
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(n2);
    }

    static char[] mbcsToWcs(String string, byte[] byArray) {
        return Converter.mbcsToWcs(string, byArray);
    }

    static byte[] wcsToMbcs(String string, String string2, boolean bl) {
        return Converter.wcsToMbcs(string, string2, bl);
    }

    int getHandle() {
        this.embedHandle = OS.gtk_hbox_new(false, 0);
        OS.gtk_container_add(this.browser.handle, this.embedHandle);
        OS.gtk_widget_show(this.embedHandle);
        return this.embedHandle;
    }

    String getLibraryName() {
        return "libxpcom.so";
    }

    String getSWTInitLibraryName() {
        return "swt-xpcominit";
    }

    int gtk_event(int n, int n2, int n3) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, n2, GdkEvent.sizeof);
        if (gdkEvent.type == 4 && !this.hasFocus) {
            this.browser.setFocus();
        }
        if (n3 == 1) {
            return 1;
        }
        return 0;
    }

    void handleFocus() {
        if (this.hasFocus) {
            return;
        }
        this.hasFocus = true;
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == MozillaDelegate.this.browser) {
                    return;
                }
                ((Mozilla)MozillaDelegate.this.browser.webBrowser).Deactivate();
                MozillaDelegate.this.hasFocus = false;
                MozillaDelegate.this.browser.getDisplay().removeFilter(15, this);
                MozillaDelegate.this.browser.getShell().removeListener(27, this);
                MozillaDelegate.this.listener = null;
            }
        };
        this.browser.getDisplay().addFilter(15, this.listener);
        this.browser.getShell().addListener(27, this.listener);
    }

    boolean hookEnterExit() {
        return false;
    }

    void init() {
        int n;
        if (eventCallback == null && (eventProc = (eventCallback = new Callback(this.getClass(), "eventProc", 3)).getAddress()) == 0) {
            this.browser.dispose();
            Mozilla.error(3);
        }
        if ((n = OS.gtk_container_get_children(this.embedHandle)) != 0) {
            this.mozillaHandle = OS.g_list_data(n);
            OS.g_list_free(n);
            if (this.mozillaHandle != 0) {
                OS.g_signal_connect(this.mozillaHandle, OS.event, eventProc, 0);
                OS.g_signal_connect(this.mozillaHandle, OS.key_press_event, eventProc, 1);
                OS.g_signal_connect(this.mozillaHandle, OS.key_release_event, eventProc, 1);
                OS.g_signal_connect(this.mozillaHandle, OS.button_press_event, eventProc, 1);
            }
        }
    }

    boolean needsSpinup() {
        return true;
    }

    void onDispose(int n) {
        if (this.listener != null) {
            this.browser.getDisplay().removeFilter(15, this.listener);
            this.browser.getShell().removeListener(27, this.listener);
            this.listener = null;
        }
        this.browser = null;
    }

    void setSize(int n, int n2, int n3) {
        OS.gtk_widget_set_size_request(n, n2, n3);
    }
}

