/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.gtk.GdkEventScroll;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAdjustment;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class Scrollable
extends Control {
    int scrolledHandle;
    ScrollBar horizontalBar;
    ScrollBar verticalBar;

    Scrollable() {
    }

    public Scrollable(Composite composite, int n) {
        super(composite, n);
    }

    int clientHandle() {
        return this.handle;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        int n5 = 0;
        if (this.fixedHandle != 0) {
            n5 += OS.gtk_container_get_border_width(this.fixedHandle);
        }
        if (this.scrolledHandle != 0) {
            n5 += OS.gtk_container_get_border_width(this.scrolledHandle);
        }
        int n6 = n - n5;
        int n7 = n2 - n5;
        int n8 = n3 + n5 * 2;
        int n9 = n4 + n5 * 2;
        n9 += this.hScrollBarWidth();
        n8 += this.vScrollBarWidth();
        if (this.scrolledHandle != 0 && OS.gtk_scrolled_window_get_shadow_type(this.scrolledHandle) != 0) {
            int n10 = OS.gtk_widget_get_style(this.scrolledHandle);
            int n11 = OS.gtk_style_get_xthickness(n10);
            int n12 = OS.gtk_style_get_ythickness(n10);
            n6 -= n11;
            n7 -= n12;
            n8 += n11 * 2;
            n9 += n12 * 2;
        }
        return new Rectangle(n6, n7, n8, n9);
    }

    ScrollBar createScrollBar(int n) {
        if (this.scrolledHandle == 0) {
            return null;
        }
        ScrollBar scrollBar = new ScrollBar();
        scrollBar.parent = this;
        scrollBar.style = n;
        scrollBar.display = this.display;
        scrollBar.state |= 8;
        if ((n & 0x100) != 0) {
            scrollBar.handle = OS.GTK_SCROLLED_WINDOW_HSCROLLBAR(this.scrolledHandle);
            scrollBar.adjustmentHandle = OS.gtk_scrolled_window_get_hadjustment(this.scrolledHandle);
        } else {
            scrollBar.handle = OS.GTK_SCROLLED_WINDOW_VSCROLLBAR(this.scrolledHandle);
            scrollBar.adjustmentHandle = OS.gtk_scrolled_window_get_vadjustment(this.scrolledHandle);
        }
        scrollBar.setOrientation();
        scrollBar.hookEvents();
        scrollBar.register();
        return scrollBar;
    }

    void createWidget(int n) {
        super.createWidget(n);
        if ((this.style & 0x100) != 0) {
            this.horizontalBar = this.createScrollBar(256);
        }
        if ((this.style & 0x200) != 0) {
            this.verticalBar = this.createScrollBar(512);
        }
    }

    void deregister() {
        super.deregister();
        if (this.scrolledHandle != 0) {
            this.display.removeWidget(this.scrolledHandle);
        }
    }

    public int getBorderWidth() {
        this.checkWidget();
        int n = 0;
        if (this.fixedHandle != 0) {
            n += OS.gtk_container_get_border_width(this.fixedHandle);
        }
        if (this.scrolledHandle != 0) {
            n += OS.gtk_container_get_border_width(this.scrolledHandle);
            if (OS.gtk_scrolled_window_get_shadow_type(this.scrolledHandle) != 0) {
                n += OS.gtk_style_get_xthickness(OS.gtk_widget_get_style(this.scrolledHandle));
            }
        }
        return n;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        this.forceResize();
        int n = this.clientHandle();
        int n2 = OS.GTK_WIDGET_X(n);
        int n3 = OS.GTK_WIDGET_Y(n);
        int n4 = (this.state & 0x200) != 0 ? 0 : OS.GTK_WIDGET_WIDTH(n);
        int n5 = (this.state & 0x400) != 0 ? 0 : OS.GTK_WIDGET_HEIGHT(n);
        return new Rectangle(n2, n3, n4, n5);
    }

    public ScrollBar getHorizontalBar() {
        this.checkWidget();
        return this.horizontalBar;
    }

    public ScrollBar getVerticalBar() {
        this.checkWidget();
        return this.verticalBar;
    }

    int gtk_scroll_event(int n, int n2) {
        int n3 = super.gtk_scroll_event(n, n2);
        if ((this.state & 2) != 0) {
            GdkEventScroll gdkEventScroll = new GdkEventScroll();
            OS.memmove(gdkEventScroll, n2, GdkEventScroll.sizeof);
            ScrollBar scrollBar = gdkEventScroll.direction == 0 || gdkEventScroll.direction == 1 ? this.verticalBar : this.horizontalBar;
            if (scrollBar != null && !OS.GTK_WIDGET_VISIBLE(scrollBar.handle) && scrollBar.getEnabled()) {
                GtkAdjustment gtkAdjustment = new GtkAdjustment();
                OS.memmove(gtkAdjustment, scrollBar.adjustmentHandle);
                int n4 = (int)Math.pow(gtkAdjustment.page_size, 0.6666666666666666);
                if (gdkEventScroll.direction == 0 || gdkEventScroll.direction == 2) {
                    n4 = -n4;
                }
                int n5 = (int)Math.max(gtkAdjustment.lower, Math.min(gtkAdjustment.upper - gtkAdjustment.page_size, gtkAdjustment.value + (double)n4));
                OS.gtk_adjustment_set_value(scrollBar.adjustmentHandle, n5);
                return 1;
            }
        }
        return n3;
    }

    int hScrollBarWidth() {
        if (this.horizontalBar == null) {
            return 0;
        }
        int n = OS.GTK_SCROLLED_WINDOW_HSCROLLBAR(this.scrolledHandle);
        if (n == 0) {
            return 0;
        }
        GtkRequisition gtkRequisition = new GtkRequisition();
        OS.gtk_widget_size_request(n, gtkRequisition);
        int n2 = OS.GTK_SCROLLED_WINDOW_SCROLLBAR_SPACING(this.scrolledHandle);
        return gtkRequisition.height + n2;
    }

    boolean sendLeaveNotify() {
        return this.scrolledHandle != 0;
    }

    void setOrientation() {
        super.setOrientation();
        if ((this.style & 0x4000000) != 0 && this.scrolledHandle != 0) {
            OS.gtk_widget_set_direction(this.scrolledHandle, 2);
        }
    }

    boolean setScrollBarVisible(ScrollBar scrollBar, boolean bl) {
        int n;
        if (this.scrolledHandle == 0) {
            return false;
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        OS.gtk_scrolled_window_get_policy(this.scrolledHandle, nArray, nArray2);
        int n2 = n = bl ? 0 : 2;
        if ((scrollBar.style & 0x100) != 0) {
            if (nArray[0] == n) {
                return false;
            }
            nArray[0] = n;
        } else {
            if (nArray2[0] == n) {
                return false;
            }
            nArray2[0] = n;
        }
        OS.gtk_scrolled_window_set_policy(this.scrolledHandle, nArray[0], nArray2[0]);
        scrollBar.sendEvent(bl ? 22 : 23);
        this.sendEvent(11);
        return true;
    }

    void redrawBackgroundImage() {
    }

    void redrawWidget(int n, int n2, int n3, int n4, boolean bl, boolean bl2, boolean bl3) {
        int n5;
        super.redrawWidget(n, n2, n3, n4, bl, bl2, bl3);
        if ((OS.GTK_WIDGET_FLAGS(this.handle) & 0x40) == 0) {
            return;
        }
        if (!bl3) {
            return;
        }
        int n6 = this.topHandle();
        if (n6 == (n5 = this.paintHandle())) {
            return;
        }
        int n7 = OS.GTK_WIDGET_WINDOW(n6);
        GdkRectangle gdkRectangle = new GdkRectangle();
        if (bl) {
            gdkRectangle.width = OS.GTK_WIDGET_WIDTH(n6);
            gdkRectangle.height = OS.GTK_WIDGET_HEIGHT(n6);
        } else {
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            OS.gtk_widget_translate_coordinates(n5, n6, n, n2, nArray, nArray2);
            gdkRectangle.x = nArray[0];
            gdkRectangle.y = nArray2[0];
            gdkRectangle.width = n3;
            gdkRectangle.height = n4;
        }
        OS.gdk_window_invalidate_rect(n7, gdkRectangle, bl2);
    }

    void register() {
        super.register();
        if (this.scrolledHandle != 0) {
            this.display.addWidget(this.scrolledHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.scrolledHandle = 0;
    }

    void releaseChildren(boolean bl) {
        if (this.horizontalBar != null) {
            this.horizontalBar.release(false);
            this.horizontalBar = null;
        }
        if (this.verticalBar != null) {
            this.verticalBar.release(false);
            this.verticalBar = null;
        }
        super.releaseChildren(bl);
    }

    void resizeHandle(int n, int n2) {
        if (this.fixedHandle != 0) {
            OS.gtk_widget_set_size_request(this.fixedHandle, n, n2);
        }
        OS.gtk_widget_set_size_request(this.scrolledHandle != 0 ? this.scrolledHandle : this.handle, n, n2);
    }

    void showWidget() {
        super.showWidget();
        if (this.scrolledHandle != 0) {
            OS.gtk_widget_show(this.scrolledHandle);
        }
    }

    int topHandle() {
        if (this.fixedHandle != 0) {
            return this.fixedHandle;
        }
        if (this.scrolledHandle != 0) {
            return this.scrolledHandle;
        }
        return super.topHandle();
    }

    void updateScrollBarValue(ScrollBar scrollBar) {
        this.redrawBackgroundImage();
    }

    int vScrollBarWidth() {
        if (this.verticalBar == null) {
            return 0;
        }
        int n = OS.GTK_SCROLLED_WINDOW_VSCROLLBAR(this.scrolledHandle);
        if (n == 0) {
            return 0;
        }
        GtkRequisition gtkRequisition = new GtkRequisition();
        OS.gtk_widget_size_request(n, gtkRequisition);
        int n2 = OS.GTK_SCROLLED_WINDOW_SCROLLBAR_SPACING(this.scrolledHandle);
        return gtkRequisition.width + n2;
    }
}

