/****************************************************************************
**
** Definition of SQLite driver classes
**
** Created : 001103
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the sql module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition licenses may use this
** file in accordance with the Qt Commercial License Agreement provided
** with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef QSQL_SQLITE_H
#define QSQL_SQLITE_H

#include "../../qsqldriver.h"
#include "../../qsqlresult.h"
#include "../../qsqlfield.h"
#include "../../qsqlindex.h"

class QSQLiteDriverPrivate;
class QSQLiteResultPrivate;
class QSQLiteDriver;
class QSqlRecordInfo;

class QSQLiteResult : public QSqlResult
{
    friend class QSQLiteDriver;
public:
    QSQLiteResult( const QSQLiteDriver* db );
    ~QSQLiteResult();

protected:
    void		cleanup();
    bool		fetch( int i );
    bool		fetchNext();
    bool		fetchPrev();
    bool		fetchLast();
    bool		fetchFirst();
    Variant		data( int field );
    bool		isNull( int field );
    bool		reset ( const QString& query );
    int			size();
    int			numRowsAffected();
private:

    static int populate(void *, int, char **, char**);
    int populate(int, char **, char**);

    QSQLiteResultPrivate* d;
};

class QSQLiteDriver : public QSqlDriver
{
    friend class QSQLiteResult;
public:
    QSQLiteDriver( QObject * parent=0, const char * name=0 );
    ~QSQLiteDriver();
    bool		hasFeature( DriverFeature f ) const;
    bool		open( const QString & db,
			      const QString & user = QString::null,
			      const QString & password = QString::null,
			      const QString & host = QString::null,
			      int port = -1 );
    void		close();
    QSqlQuery		createQuery() const;
private:
    QSQLiteDriverPrivate* d;
};

#endif
