/****************************************************************************
** $Id: variant.h,v 1.1 2002/12/20 22:54:04 krackerbelin Exp $
**
** Definition of Variant class
**
** Created : 990414
**
** Copyright (C) 1992-2000 Trolltech AS.  All rights reserved.
**
** This file is part of the kernel module of the Qt GUI Toolkit.
**
** This file may be distributed under the terms of the Q Public License
** as defined by Trolltech AS of Norway and appearing in the file
** LICENSE.QPL included in the packaging of this file.
**
** This file may be distributed and/or modified under the terms of the
** GNU General Public License version 2 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.
**
** Licensees holding valid Qt Enterprise Edition or Qt Professional Edition
** licenses may use this file in accordance with the Qt Commercial License
** Agreement provided with the Software.
**
** This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
** WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
**
** See http://www.trolltech.com/pricing.html or email sales@trolltech.com for
**   information about Qt Commercial License Agreements.
** See http://www.trolltech.com/qpl/ for QPL licensing information.
** See http://www.trolltech.com/gpl/ for GPL licensing information.
**
** Contact info@trolltech.com if any conditions of this licensing are
** not clear to you.
**
**********************************************************************/

#ifndef VARIANT_H
#define VARIANT_H

#include <qstring.h>

class QString;
class QCString;
class QFont;
class QPixmap;
class QBrush;
class QRect;
class QPoint;
class QImage;
class QSize;
class QColor;
class QPalette;
class QColorGroup;
class QIconSet;
class QDataStream;
class QPointArray;
class QRegion;
class QBitmap;
class QCursor;
class QStringList;
class QSizePolicy;
class QDate;
class QTime;
class QDateTime;
class QBitArray;
// Some headers rejected after Variant declaration for GCC 2.7.* compatibility
class Variant;
#ifndef QT_NO_TEMPLATE_VARIANT
template <class T> class QValueList;
template <class T> class QValueListConstIterator;
template <class T> class QValueListNode;
template <class Key, class T> class QMap;
template <class Key, class T> class QMapConstIterator;
#endif

QString isoString(const QDateTime &dt);
QString isoString(const QTime &dt);
QString isoString(const QDate &dt);
QDateTime isoDateTime(const QString &s);
QTime isoTime(const QString &s);
QDate isoDate(const QString &s);

class Q_EXPORT Variant
{
public:
    enum Type {
	Invalid,
	Map,
	List,
	String,
	StringList,
	Font,
	Pixmap,
	Brush,
	Rect,
	Size,
	Color,
	Palette,
	ColorGroup,
	IconSet,
	Point,
	Image,
	Int,
	UInt,
	Bool,
	Double,
	CString,
	PointArray,
	Region,
	Bitmap,
	Cursor,
	SizePolicy,
	Date,
	Time,
	DateTime,
	ByteArray,
	BitArray
    };

    Variant();
    ~Variant();
    Variant( const Variant& );
#ifndef QT_NO_DATASTREAM
    Variant( QDataStream& s );
#endif
    Variant( const QString& );
    Variant( const QCString& );
    Variant( const char* );
#ifndef QT_NO_STRINGLIST
    Variant( const QStringList& );
#endif
    Variant( const QFont& );
    Variant( const QPixmap& );
    Variant( const QImage& );
    Variant( const QBrush& );
    Variant( const QPoint& );
    Variant( const QRect& );
    Variant( const QSize& );
    Variant( const QColor& );
    Variant( const QPalette& );
    Variant( const QColorGroup& );
    Variant( const QIconSet& );
    Variant( const QPointArray& );
    Variant( const QRegion& );
    Variant( const QBitmap& );
    Variant( const QCursor& );
    Variant( const QDate& );
    Variant( const QTime& );
    Variant( const QDateTime& );
    Variant( const QByteArray& );
    Variant( const QBitArray& );
#ifndef QT_NO_TEMPLATE_VARIANT
    Variant( const QValueList<Variant>& );
    Variant( const QMap<QString,Variant>& );
#endif
    Variant( int );
    Variant( uint );
    // ### Problems on some compilers ?
    Variant( bool, int );
    Variant( double );
    Variant( QSizePolicy );

    Variant& operator= ( const Variant& );
    bool operator==( const Variant& ) const;
    bool operator!=( const Variant& ) const;

    Type type() const;
    const char* typeName() const;

    bool canCast( Type ) const;
    bool cast( Type );

    bool isValid() const;

    void clear();

    const QString toString() const;
    const QCString toCString() const;
#ifndef QT_NO_STRINGLIST
    const QStringList toStringList() const;
#endif
    const QFont toFont() const;
    const QPixmap toPixmap() const;
    const QImage toImage() const;
    const QBrush toBrush() const;
    const QPoint toPoint() const;
    const QRect toRect() const;
    const QSize toSize() const;
    const QColor toColor() const;
    const QPalette toPalette() const;
    const QColorGroup toColorGroup() const;
    const QIconSet toIconSet() const;
    const QPointArray toPointArray() const;
    const QBitmap toBitmap() const;
    const QRegion toRegion() const;
    const QCursor toCursor() const;
    const QDate toDate() const;
    const QTime toTime() const;
    const QDateTime toDateTime() const;
    const QByteArray toByteArray() const;
    const QBitArray toBitArray() const;
    int toInt( bool * ok=0 ) const;
    uint toUInt( bool * ok=0 ) const;
    bool toBool() const;
    double toDouble( bool * ok=0 ) const;
#ifndef QT_NO_TEMPLATE_VARIANT
    const QValueList<Variant> toList() const;
    const QMap<QString,Variant> toMap() const;
#endif
    QSizePolicy toSizePolicy() const;

#ifndef QT_NO_TEMPLATE_VARIANT
    QValueListConstIterator<QString> stringListBegin() const;
    QValueListConstIterator<QString> stringListEnd() const;
    QValueListConstIterator<Variant> listBegin() const;
    QValueListConstIterator<Variant> listEnd() const;
    QMapConstIterator<QString,Variant> mapBegin() const;
    QMapConstIterator<QString,Variant> mapEnd() const;
    QMapConstIterator<QString,Variant> mapFind( const QString& ) const;
#endif
    QString& asString();
    QCString& asCString();
#ifndef QT_NO_STRINGLIST
    QStringList& asStringList();
#endif
    QFont& asFont();
    QPixmap& asPixmap();
    QImage& asImage();
    QBrush& asBrush();
    QPoint& asPoint();
    QRect& asRect();
    QSize& asSize();
    QColor& asColor();
    QPalette& asPalette();
    QColorGroup& asColorGroup();
    QIconSet& asIconSet();
    QPointArray& asPointArray();
    QBitmap& asBitmap();
    QRegion& asRegion();
    QCursor& asCursor();
    QDate& asDate();
    QTime& asTime();
    QDateTime& asDateTime();
    QByteArray& asByteArray();
    QBitArray& asBitArray();
    int& asInt();
    uint& asUInt();
    bool& asBool();
    double& asDouble();
#ifndef QT_NO_TEMPLATE_VARIANT
    QValueList<Variant>& asList();
    QMap<QString,Variant>& asMap();
#endif
    QSizePolicy& asSizePolicy();

#ifndef QT_NO_DATASTREAM
    void load( QDataStream& );
    void save( QDataStream& ) const;
#endif
    static const char* typeToName( Type typ );
    static Type nameToType( const char* name );

private:
    void detach();

    class Private : public QShared
    {
    public:
        Private();
        Private( Private* );
        ~Private();

        void clear();

        Type typ;
        union
        {
	    uint u;
	    int i;
	    bool b;
	    double d;
	    void *ptr;
        } value;
    };

    Private* d;
};

// down here for GCC 2.7.* compatibility
#ifndef QT_H
#include "qvaluelist.h"
#include "qstringlist.h"
#include "qmap.h"
#endif // QT_H

inline Variant::Type Variant::type() const
{
    return d->typ;
}

inline bool Variant::isValid() const
{
    return (d->typ != Invalid);
}

#ifndef QT_NO_TEMPLATE_VARIANT
inline QValueListConstIterator<QString> Variant::stringListBegin() const
{
    if ( d->typ != StringList )
	return QValueListConstIterator<QString>();
    return ((const QStringList*)d->value.ptr)->begin();
}

inline QValueListConstIterator<QString> Variant::stringListEnd() const
{
    if ( d->typ != StringList )
	return QValueListConstIterator<QString>();
    return ((const QStringList*)d->value.ptr)->end();
}

inline QValueListConstIterator<Variant> Variant::listBegin() const
{
    if ( d->typ != List )
	return QValueListConstIterator<Variant>();
    return ((const QValueList<Variant>*)d->value.ptr)->begin();
}

inline QValueListConstIterator<Variant> Variant::listEnd() const
{
    if ( d->typ != List )
	return QValueListConstIterator<Variant>();
    return ((const QValueList<Variant>*)d->value.ptr)->end();
}

inline QMapConstIterator<QString,Variant> Variant::mapBegin() const
{
    if ( d->typ != Map )
	return QMapConstIterator<QString,Variant>();
    return ((const QMap<QString,Variant>*)d->value.ptr)->begin();
}

inline QMapConstIterator<QString,Variant> Variant::mapEnd() const
{
    if ( d->typ != Map )
	return QMapConstIterator<QString,Variant>();
    return ((const QMap<QString,Variant>*)d->value.ptr)->end();
}

inline QMapConstIterator<QString,Variant> Variant::mapFind( const QString& key ) const
{
    if ( d->typ != Map )
	return QMapConstIterator<QString,Variant>();
    return ((const QMap<QString,Variant>*)d->value.ptr)->find( key );
}
#endif

#ifndef QT_NO_DATASTREAM
Q_EXPORT QDataStream& operator>> ( QDataStream& s, Variant& p );
Q_EXPORT QDataStream& operator<< ( QDataStream& s, const Variant& p );
Q_EXPORT QDataStream& operator>> ( QDataStream& s, Variant::Type& p );
Q_EXPORT QDataStream& operator<< ( QDataStream& s, const Variant::Type p );
#endif

#endif // QVARIANT_H
