#include "zeecategorylistview.h"

#include "sql/qsqlquery.h"

ZeeCategoryListViewItem::ZeeCategoryListViewItem(int recipeCategoryId, QString key, QString name, QListView* parent)
    : QListViewItem(parent)
{
    m_recipeCategoryId = recipeCategoryId;
    m_key = key;

    setText(0, name);
}

ZeeCategoryListViewItem::~ZeeCategoryListViewItem()
{
}

int ZeeCategoryListViewItem::recipeCategoryId() const
{
    return m_recipeCategoryId;
}

QString ZeeCategoryListViewItem::key(int, bool) const
{
    return m_key;
}

ZeeCategoryListView::ZeeCategoryListView(int recipeId, QWidget* parent, const char* name)
    : ZeeListView(parent, name)
{
    m_recipeId = recipeId;

    setAllColumnsShowFocus(true);
    addColumn(tr("Category"));

    updateView();
}

ZeeCategoryListView::~ZeeCategoryListView()
{
}

void ZeeCategoryListView::updateView()
{
    blockSignals(true);

    int selectedId = selected();

    clear();

    QString queryString = "SELECT recipe_category.id, position, name FROM recipe_category, category";
    queryString += " WHERE recipe_id = %1 AND category_id = category.id";

    QSqlQuery query(queryString.arg(m_recipeId));

    while (query.next()) {
        int id = query.value(0).toInt();
        int position = query.value(1).toInt();
        QString name = query.value(2).toString();

        new ZeeCategoryListViewItem(id, QString().sprintf("%010d", position), name, this);
    }

    if (selectedId != -1) {
        select(selectedId);
    }

    blockSignals(false);
}

void ZeeCategoryListView::select(int recipeCategoryId)
{
    ZeeCategoryListViewItem* item = (ZeeCategoryListViewItem*)firstChild();

    while (item) {
        if (item->recipeCategoryId() == recipeCategoryId) {
            setSelected(item, true);
            ensureItemVisible(item);
            break;
        }

        item = (ZeeCategoryListViewItem*)(item->nextSibling());
    }
}

int ZeeCategoryListView::selected() const
{
    int recipeCategoryId;

    ZeeCategoryListViewItem* item = (ZeeCategoryListViewItem*)selectedItem();

    if (item) {
        recipeCategoryId = item->recipeCategoryId();
    } else {
        recipeCategoryId = -1;
    }

    return recipeCategoryId;
}
