#ifndef ZEECATEGORYLISTVIEW_H
#define ZEECATEGORYLISTVIEW_H

#include "zeelistview.h"

class ZeeCategoryListViewItem : public QListViewItem
{
public:
    ZeeCategoryListViewItem(int recipeCategoryId, QString key, QString name, QListView* parent);
    ~ZeeCategoryListViewItem();

    int recipeCategoryId() const;

    QString key(int column, bool ascending) const;

private:
    int m_recipeCategoryId;
    QString m_key;
};

class ZeeCategoryListView : public ZeeListView
{
public:
    ZeeCategoryListView(int recipeId, QWidget* parent = 0, const char* name = 0);
    ~ZeeCategoryListView();

    void updateView();

    void select(int recipeCategoryId);
    int selected() const;

private:
    int m_recipeId;
};

#endif // ZEECATEGORYLISTVIEW_H
