#include "zeecookbooklistview.h"

#include "zeeutil.h"

#include "sql/qsqldatabase.h"
#include "sql/qsqlquery.h"

#include <qpe/applnk.h>
#include <qpe/global.h>

#include <qfileinfo.h>

ZeeCookbookListViewItem::ZeeCookbookListViewItem(DocLnk* docLnk, QListView* parent)
    : QListViewItem(parent)
{
    m_pDocLnk = new DocLnk(*docLnk);

    int recipeCount = 0;
    
    QSqlDatabase* pDatabase = QSqlDatabase::addDatabase("QSQLITE2", "tmp_connection");
    pDatabase->setDatabaseName(m_pDocLnk->file());   
        
    if (pDatabase->open()) {
        QString queryString = "SELECT COUNT(*) FROM recipe";
        QSqlQuery query(queryString, pDatabase);

        if (query.first()) {
            recipeCount = query.value(0).toInt();
        }
    }  
    
    pDatabase->close();
    QSqlDatabase::removeDatabase("tmp_connection");
    
    QFileInfo fileInfo(m_pDocLnk->file());

    setPixmap(0, m_pDocLnk->pixmap());

    setText(0, m_pDocLnk->name());
    setText(1, QString::number(recipeCount));
    setText(2, zeeSizeString(fileInfo.size()));
    setText(3, zeeDateTimeString(fileInfo.lastModified()));
}

ZeeCookbookListViewItem::~ZeeCookbookListViewItem()
{
}

DocLnk* ZeeCookbookListViewItem::docLnk() const
{
    return m_pDocLnk;
}

QString ZeeCookbookListViewItem::key(int column, bool ascending) const
{
    QString resultKey;

    QFileInfo fileInfo(m_pDocLnk->file());

    switch (column) {
        case 0:
            resultKey = QListViewItem::key(column, ascending).lower();
            break;
        case 1:
            resultKey.sprintf("%010d", fileInfo.size());
            break;
        case 2:
            {
                QDateTime epoch(QDate(1980, 1, 1));
                resultKey.sprintf("%010d", epoch.secsTo(fileInfo.lastModified()));
            }
            break;
        default:
            resultKey = QListViewItem::key(column, ascending);
            break;
    }

    return resultKey;
}

ZeeCookbookListView::ZeeCookbookListView(QString filter, QWidget* parent, const char* name)
    : ZeeListView(parent, name)
{
    m_filter = filter;
    m_pDocLnkSet = 0;

    setAllColumnsShowFocus(true);

    addColumn(tr("Name"));
    addColumn(tr("Recipes"));
    addColumn(tr("Size"));
    addColumn(tr("Date"));

    setColumnAlignment(1, Qt::AlignRight),
    setColumnAlignment(2, Qt::AlignRight),
    
    updateView();
}

ZeeCookbookListView::~ZeeCookbookListView()
{
    delete m_pDocLnkSet;
}

void ZeeCookbookListView::updateView()
{
    blockSignals(true);

    if (m_pDocLnkSet) {
        delete m_pDocLnkSet;
    }

    m_pDocLnkSet = new DocLnkSet();

    clear();

    Global::findDocuments(m_pDocLnkSet, m_filter);

    QListIterator<DocLnk> it(m_pDocLnkSet->children());

    for (; it.current(); ++it) {
        if (QFile::exists(it.current()->file())) {
            new ZeeCookbookListViewItem(it.current(), this);
        }
    }

    blockSignals(false);
}

void ZeeCookbookListView::select(DocLnk* docLnk)
{
    ZeeCookbookListViewItem* item = (ZeeCookbookListViewItem*)firstChild();

    while (item) {
        if (item->docLnk()->linkFile() == docLnk->linkFile()) {
            setSelected(item, true);
            ensureItemVisible(item);
            break;
        }

        item = (ZeeCookbookListViewItem*)(item->nextSibling());
    }
}

DocLnk* ZeeCookbookListView::selected() const
{
    DocLnk* docLnk;

    ZeeCookbookListViewItem* item = (ZeeCookbookListViewItem*)selectedItem();

    if (item) {
        docLnk = item->docLnk();
    } else {
        docLnk = NULL;
    }

    return docLnk;
}
