#include "zeedoclistview.h"

#include "zeeutil.h"

#include <qpe/applnk.h>
#include <qpe/global.h>

#include <qfileinfo.h>

ZeeDocListViewItem::ZeeDocListViewItem(DocLnk* docLnk, QListView* parent)
    : QListViewItem(parent)
{
    m_pDocLnk = new DocLnk(*docLnk);
   
    QFileInfo fileInfo(m_pDocLnk->file());

    setPixmap(0, m_pDocLnk->pixmap());

    setText(0, m_pDocLnk->name());
    setText(1, zeeSizeString(fileInfo.size()));
    setText(2, zeeDateTimeString(fileInfo.lastModified()));
}

ZeeDocListViewItem::~ZeeDocListViewItem()
{
}

DocLnk* ZeeDocListViewItem::docLnk() const
{
    return m_pDocLnk;
}

QString ZeeDocListViewItem::key(int column, bool ascending) const
{
    QString resultKey;

    QFileInfo fileInfo(m_pDocLnk->file());

    switch (column) {
        case 0:
            resultKey = QListViewItem::key(column, ascending).lower();
            break;
        case 1:
            resultKey.sprintf("%010d", fileInfo.size());
            break;
        case 2:
            {
                QDateTime epoch(QDate(1980, 1, 1));
                resultKey.sprintf("%010d", epoch.secsTo(fileInfo.lastModified()));
            }
            break;
        default:
            resultKey = QListViewItem::key(column, ascending);
            break;
    }

    return resultKey;
}

ZeeDocListView::ZeeDocListView(QString filter, QWidget* parent, const char* name)
    : ZeeListView(parent, name)
{
    m_filter = filter;
    m_pDocLnkSet = 0;

    setAllColumnsShowFocus(true);

    addColumn(tr("Name"));
    addColumn(tr("Size"));
    addColumn(tr("Date"));

    setColumnAlignment(1, Qt::AlignRight),
    
    updateView();
}

ZeeDocListView::~ZeeDocListView()
{
    delete m_pDocLnkSet;
}

void ZeeDocListView::updateView()
{
    blockSignals(true);

    if (m_pDocLnkSet) {
        delete m_pDocLnkSet;
    }

    m_pDocLnkSet = new DocLnkSet();

    clear();

    Global::findDocuments(m_pDocLnkSet, m_filter);

    QListIterator<DocLnk> it(m_pDocLnkSet->children());

    for (; it.current(); ++it) {
        if (QFile::exists(it.current()->file())) {
            new ZeeDocListViewItem(it.current(), this);
        }
    }

    blockSignals(false);
}

void ZeeDocListView::select(DocLnk* docLnk)
{
    ZeeDocListViewItem* item = (ZeeDocListViewItem*)firstChild();

    while (item) {
        if (item->docLnk()->linkFile() == docLnk->linkFile()) {
            setSelected(item, true);
            ensureItemVisible(item);
            break;
        }

        item = (ZeeDocListViewItem*)(item->nextSibling());
    }
}

DocLnk* ZeeDocListView::selected() const
{
    DocLnk* docLnk;

    ZeeDocListViewItem* item = (ZeeDocListViewItem*)selectedItem();

    if (item) {
        docLnk = item->docLnk();
    } else {
        docLnk = NULL;
    }

    return docLnk;
}
