#include "zeeexportdialog.h"

#include "zeehtmlexporter.h"
#include "zeemealmasterexporter.h"

#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qradiobutton.h>

ZeeExportDialog::ZeeExportDialog(bool hasRecipe, bool isRecipeSelected, QWidget* parent, const char* name)
    : QDialog(parent, name, true)
{
    m_selection = All;

    setCaption(tr("Zee Cookbook - Export Recipe"));

    QButtonGroup* selectionButtonGroup = new QButtonGroup(0, Qt::Vertical, tr("Recipe Selection"), this);

    m_pCurrentRadioButton = new QRadioButton(tr("Current Recipe"), selectionButtonGroup);
    m_pCurrentRadioButton->setEnabled(isRecipeSelected);
    connect(m_pCurrentRadioButton, SIGNAL(clicked()), this, SLOT(selectCurrent()));

    m_pDisplayRadioButton = new QRadioButton(tr("Displayed Recipes"), selectionButtonGroup);
    m_pDisplayRadioButton->setEnabled(hasRecipe);
    connect(m_pDisplayRadioButton, SIGNAL(clicked()), this, SLOT(selectDisplay()));

    m_pAllRadioButton = new QRadioButton(tr("All Recipes"), selectionButtonGroup);
    connect(m_pAllRadioButton, SIGNAL(clicked()), this, SLOT(selectAll()));

    QGroupBox* exportGroupBox = new QGroupBox(0, Qt::Vertical, tr("Export As"), this);

    QLabel* nameLabel = new QLabel(tr("Name:"), exportGroupBox);

    m_pNameLineEdit = new QLineEdit(exportGroupBox);
    m_pNameLineEdit->setFocus();

    QLabel* formatLabel = new QLabel(tr("Format:"), exportGroupBox);
    m_pFormatComboBox = new QComboBox(exportGroupBox);

    ZeeHtmlExporter htmlExporter;
    ZeeMealMasterExporter mealMasterExporter;

    m_pFormatComboBox->insertItem(htmlExporter.name());
    m_pFormatComboBox->insertItem(mealMasterExporter.name());

    QVBoxLayout* mainLayout = new QVBoxLayout(this, 4, 4);
    selectionButtonGroup->layout()->setSpacing(4);
    exportGroupBox->layout()->setSpacing(4);
    QVBoxLayout* selectionLayout = new QVBoxLayout(selectionButtonGroup->layout(), 4);
    QGridLayout* exportLayout = new QGridLayout(exportGroupBox->layout(), 2, 2, 4);

    selectionLayout->addWidget(m_pCurrentRadioButton);
    selectionLayout->addWidget(m_pDisplayRadioButton);
    selectionLayout->addWidget(m_pAllRadioButton);

    exportLayout->addWidget(nameLabel, 0, 0);
    exportLayout->addWidget(formatLabel, 1, 0);
    exportLayout->addWidget(m_pNameLineEdit, 0, 1);
    exportLayout->addWidget(m_pFormatComboBox, 1, 1);

    mainLayout->addWidget(selectionButtonGroup);
    mainLayout->addWidget(exportGroupBox);
    mainLayout->addStretch();

    updateView();
}

ZeeExportDialog::~ZeeExportDialog()
{
}

void ZeeExportDialog::updateView()
{
    blockSignals(true);

    switch (m_selection) {
        case Current:
            m_pCurrentRadioButton->setChecked(true);
            break;
        case Display:
            m_pDisplayRadioButton->setChecked(true);
            break;
        case All:
            m_pAllRadioButton->setChecked(true);
            break;
        default:
            break;
    }

    blockSignals(false);
}

ZeeExportDialog::Selection ZeeExportDialog::selected()
{
    return m_selection;
}

QString ZeeExportDialog::selectedName()
{
    return m_pNameLineEdit->text();
}

QString ZeeExportDialog::selectedFormat()
{
    return m_pFormatComboBox->currentText();
}

void ZeeExportDialog::selectCurrent()
{
    m_selection = Current;
    updateView();
}

void ZeeExportDialog::selectDisplay()
{
    m_selection = Display;
    updateView();
}

void ZeeExportDialog::selectAll()
{
    m_selection = All;
    updateView();
}
