#ifndef ZEEEXPORTER_H
#define ZEEEXPORTER_H

#include <qobject.h>

#include <qtextstream.h>

class ZeeExporter : public QObject
{
protected:
    ZeeExporter();

public:
    virtual ~ZeeExporter();
    
    virtual QString name() const = 0;
    virtual QString mimeType() const = 0;

    virtual void exportRecipe(int recipeId, QTextStream& textStream) = 0;
    virtual void exportRecipeList(QValueList<int> recipeList, QTextStream& textStream) = 0;
};

#endif // ZEEEXPORTER_H
