#include "zeehtmlexporter.h"

#include "sql/qsqlquery.h"

ZeeHtmlExporter::ZeeHtmlExporter()
    : ZeeExporter()
{
}

ZeeHtmlExporter::~ZeeHtmlExporter()
{
}

QString ZeeHtmlExporter::name() const
{
    return tr("HTML");
}

QString ZeeHtmlExporter::mimeType() const
{
    return "text/html";
}

void ZeeHtmlExporter::exportRecipe(int recipeId, QTextStream& textStream)
{
    QString queryString = "SELECT name, yield_quantity, yield_id, direction";
    queryString += " FROM recipe WHERE id = %1";
    QSqlQuery query(queryString.arg(recipeId));

    QString name = "";
    QString yieldQuantity = "";
    int yieldId = -1;
    QString direction = "";

    if (query.first()) {
        name = query.value(0).toString();
        yieldQuantity = query.value(1).toString();
        yieldId = query.value(2).toInt();
        direction = query.value(3).toString();
    }

    QString yieldUnit = "";

    if (yieldId != -1) {
        queryString = "SELECT name FROM yield WHERE id = %1";
        query.exec(queryString.arg(yieldId));

        if (query.first()) {
            yieldUnit = query.value(0).toString();
        }
    }

    queryString = "SELECT name FROM recipe_category, category";
    queryString += " WHERE recipe_id = %1 AND category_id = category.id ORDER BY position";
    query.exec(queryString.arg(recipeId));

    QStringList categoryList;

    while (query.next()) {
        QString name = query.value(0).toString();
        categoryList.append(name);
    }

    textStream << "<a name=\"" << recipeId << "\"></a><center><h2>" << name << "</h2></center>\n";
    textStream << "<h3>" << tr("Categories:") << "</h3> " << categoryList.join(", ") << "<br>\n";
    textStream << "<h3>" << tr("Yield:") << "</h3> " << yieldQuantity << " " << yieldUnit << "<br>\n";
    textStream << "<h3>" << tr("Ingredients:") << "</h3><ul>\n";

    queryString = "SELECT quantity, unit.name, ingredient.name, is_group";
    queryString += " FROM recipe_ingredient LEFT JOIN unit ON unit_id = unit.id, ingredient";
    queryString += " WHERE recipe_id = %1 AND ingredient_id = ingredient.id ORDER BY position";
    query.exec(queryString.arg(recipeId));

    while (query.next()) {
        QString quantity = query.value(0).toString();
        QString unit = query.value(1).toString();
        QString name = query.value(2).toString();
        bool isGroup = query.value(3).toInt();

        if (isGroup) {
            textStream << "<b>" << quantity << " " << unit << " " << name << "</b>\n";
        } else {
            textStream << "<li>" << quantity << " " << unit << " " << name << "</li>\n";
        }
    }

    textStream << "</ul><h3>" << tr("Directions:") << "</h3>" << direction.replace(QRegExp("\n"), "<br>\n");
}

void ZeeHtmlExporter::exportRecipeList(QValueList<int> recipeList, QTextStream& textStream)
{
    int count = recipeList.count();

    textStream << "<center><h2>Zee Cookbook</h2></center><ul>\n";

    for (int i = 0; i < count; i++) {
        int recipeId = recipeList[i];
        QString name = "";

        QString queryString = "SELECT name FROM recipe WHERE id = %1";
        QSqlQuery query(queryString.arg(recipeId));

        if (query.first()) {
            name = query.value(0).toString();
        }

        textStream << "<li><a href=\"#" << recipeId << "\">" << name << "</a></li>\n";
    }

    textStream << "</ul>\n";

    for (int i = 0; i < count; i++) {
        int recipeId = recipeList[i];
        exportRecipe(recipeId, textStream);
    }
}
