#include "zeeimportdialog.h"

#include "zeedoclistview.h"

#include <qpe/applnk.h>

#include <qcombobox.h>
#include <qlayout.h>
#include <qlabel.h>

ZeeImportDialog::ZeeImportDialog(QWidget* parent, const char* name)
    : QDialog(parent, name, true)
{
    setCaption(tr("Zee Cookbook - Import Recipe"));

    m_pDocListView = new ZeeDocListView("text/*", this);
    QLabel* formatLabel = new QLabel(tr("Format:"), this);

    QComboBox* formatComboBox = new QComboBox(this);
    formatComboBox->insertItem(tr("Meal-Master"));

    QVBoxLayout* mainLayout = new QVBoxLayout(this, 4, 4);
    QHBoxLayout* formatLayout = new QHBoxLayout();

    formatLayout->addWidget(formatLabel);
    formatLayout->addWidget(formatComboBox, 1);

    mainLayout->addWidget(m_pDocListView);
    mainLayout->addLayout(formatLayout);
}

ZeeImportDialog::~ZeeImportDialog()
{
}

void ZeeImportDialog::select(DocLnk* docLnk)
{
    m_pDocListView->select(docLnk);
}

DocLnk* ZeeImportDialog::selected() const
{
    return m_pDocListView->selected();
}
