#include "zeeingredienteditdialog.h"

#include "sql/qsqlquery.h"

#include <qcheckbox.h>
#include <qcombobox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>

ZeeIngredientEditDialog::ZeeIngredientEditDialog(int recipeIngredientId, QWidget* parent, const char* name)
    : QDialog(parent, name, true)
{
    m_recipeIngredientId = recipeIngredientId;

    setCaption(tr("Edit Ingredient"));

    QLabel* quantityLabel = new QLabel(tr("Quantity:"), this);
    m_pQuantityLineEdit = new QLineEdit(this);

    QLabel* unitLabel = new QLabel(tr("Unit:"), this);

    m_pUnitComboBox = new QComboBox(true, this);
    m_pUnitComboBox->setAutoCompletion(true);

    QLabel* nameLabel = new QLabel(tr("Name:"), this);

    m_pIngredientComboBox = new QComboBox(true, this);
    m_pIngredientComboBox->setAutoCompletion(true);
    
    m_pIsGroupCheckBox = new QCheckBox(tr("Ingredient is a group"), this);

    QGridLayout* mainLayout = new QGridLayout(this, 4, 2, 4, 4);

    mainLayout->addWidget(quantityLabel, 0, 0);
    mainLayout->addWidget(m_pQuantityLineEdit, 0, 1);
    mainLayout->addWidget(unitLabel, 1, 0);
    mainLayout->addWidget(m_pUnitComboBox, 1, 1);
    mainLayout->addWidget(nameLabel, 2, 0);
    mainLayout->addWidget(m_pIngredientComboBox, 2, 1);
    mainLayout->addWidget(m_pIsGroupCheckBox, 3, 1);

    updateView();
}

ZeeIngredientEditDialog::~ZeeIngredientEditDialog()
{
}

void ZeeIngredientEditDialog::updateView()
{
    blockSignals(true);

    QString queryString = "SELECT name FROM unit ORDER BY name";
    QSqlQuery query(queryString);

    while (query.next()) {
        QString name = query.value(0).toString();
        m_pUnitComboBox->insertItem(name);
    }

    queryString = "SELECT name FROM ingredient ORDER BY name";
    query.exec(queryString);

    while (query.next()) {
        QString name = query.value(0).toString();
        m_pIngredientComboBox->insertItem(name);
    }

    QString quantity = "";
    QString unitName = "";
    QString ingredientName = "";
    bool isGroup = false;

    if (m_recipeIngredientId != -1) {
        queryString = "SELECT quantity, unit_id, ingredient.name, is_group";
        queryString += " FROM recipe_ingredient, ingredient";
        queryString += " WHERE recipe_ingredient.id = %1 AND ingredient_id = ingredient.id";

        query.exec(queryString.arg(m_recipeIngredientId));

        if (query.first()) {
            quantity = query.value(0).toString();
            int unitId = query.value(1).toInt();
            ingredientName = query.value(2).toString();
            isGroup = query.value(3).toInt();

            if (unitId != -1) {
                queryString = "SELECT name FROM unit WHERE id = %1";
                query.exec(queryString.arg(unitId));

                if (query.first()) {
                    unitName = query.value(0).toString();
                }
            }
        }
    }

    m_pQuantityLineEdit->setText(quantity);
    m_pUnitComboBox->setEditText(unitName);
    m_pIngredientComboBox->setEditText(ingredientName);
    m_pIsGroupCheckBox->setChecked(isGroup);

    blockSignals(false);
}

QString ZeeIngredientEditDialog::selectedQuantity() const
{
    return m_pQuantityLineEdit->text();
}

QString ZeeIngredientEditDialog::selectedUnit() const
{
    return m_pUnitComboBox->currentText();
}

QString ZeeIngredientEditDialog::selectedIngredient() const
{
    return m_pIngredientComboBox->currentText();
}

bool ZeeIngredientEditDialog::selectedIsGroup() const
{
    return m_pIsGroupCheckBox->isChecked();
}
