#include "zeemealmasterexporter.h"

#include "sql/qsqlquery.h"

ZeeMealMasterExporter::ZeeMealMasterExporter()
    : ZeeExporter()
{
}

ZeeMealMasterExporter::~ZeeMealMasterExporter()
{
}

QString ZeeMealMasterExporter::name() const
{
    return tr("Meal-Master");
}

QString ZeeMealMasterExporter::mimeType() const
{
    return "text/plain";
}

void ZeeMealMasterExporter::exportRecipe(int recipeId, QTextStream& textStream)
{
    QString queryString = "SELECT name, yield_quantity, yield_id, direction";
    queryString += " FROM recipe WHERE id = %1";
    QSqlQuery query(queryString.arg(recipeId));

    QString name = "";
    QString yieldQuantity = "";
    int yieldId = -1;
    QString direction = "";

    if (query.first()) {
        name = query.value(0).toString();
        yieldQuantity = query.value(1).toString();
        yieldId = query.value(2).toInt();
        direction = query.value(3).toString();
    }

    QString yieldUnit = "";

    if (yieldId != -1) {
        queryString = "SELECT name FROM yield WHERE id = %1";
        query.exec(queryString.arg(yieldId));

        if (query.first()) {
            yieldUnit = query.value(0).toString();
        }
    }

    queryString = "SELECT name FROM recipe_category, category";
    queryString += " WHERE recipe_id = %1 AND category_id = category.id ORDER BY position";
    query.exec(queryString.arg(recipeId));

    QStringList categoryList;

    while (query.next()) {
        QString name = query.value(0).toString();
        categoryList.append(name);
    }

    textStream << "-----------------Meal-Master------------\n\n";
    textStream << "      Title: " << name << "\n";
    textStream << " Categories: " << categoryList.join(", ") << "\n";
    textStream << "      Yield: " << yieldQuantity << " " << yieldUnit << "\n\n";

    queryString = "SELECT position, quantity, unit.name, ingredient.name, is_group";
    queryString += " FROM recipe_ingredient LEFT JOIN unit ON unit_id = unit.id, ingredient";
    queryString += " WHERE recipe_id = %1 AND ingredient_id = ingredient.id ORDER BY position";
    query.exec(queryString.arg(recipeId));

    while (query.next()) {
        int position = query.value(0).toInt();
        QString quantity = query.value(1).toString();
        QString unit = query.value(2).toString();
        QString name = query.value(3).toString();
        bool isGroup = query.value(4).toInt();

        if (isGroup) {
            if (position > 1) {
                textStream << "\n";
            }

            QString line = "----------------------------------------";
            int index = (40 - 5 - name.length()) / 2 + 5;
            textStream << line.replace(index, name.length(), name) << "\n";
        } else {
            quantity = quantity.left(7);
            quantity = QString("       ").replace(7 - quantity.length(), quantity.length(), quantity);

            unit = unit.left(2);
            unit = QString("  ").replace(2 - unit.length(), unit.length(), unit);

            textStream << quantity << " " << unit << " ";

            QString wrappedName = name.left(28);
            textStream << wrappedName << "\n";
            name = name.remove(0, wrappedName.length());

            while (name.length() > 0) {
                QString wrappedName = name.left(27);
                textStream << "           -" + wrappedName + "\n";
                name = name.remove(0, wrappedName.length());
            }
        }
    }

    textStream << "\n";

    QStringList directionList = QStringList::split("\n", direction, true);
    QStringList::Iterator it;

    QRegExp spaceRegExp = QRegExp("\\s");

    for (it = directionList.begin(); it != directionList.end(); ++it) {
        QString line = (*it);

        if (line.length() > 0) {
            while (line.length() > 0) {
                QString wrappedLine = line.left(75 + 1);

                if (wrappedLine.length() < line.length()) {
                    int index = wrappedLine.findRev(spaceRegExp);
                    wrappedLine = wrappedLine.left(index + 1);
                }

                textStream << "  " + wrappedLine.simplifyWhiteSpace() + "\n";
                line = line.remove(0, wrappedLine.length());
            }
        } else {
            textStream << "\n";
        }
    }

    textStream << "-----\n\n";
}

void ZeeMealMasterExporter::exportRecipeList(QValueList<int> recipeList, QTextStream& textStream)
{
    int count = recipeList.count();

    for (int i = 0; i < count; i++) {
        int recipeId = recipeList[i];
        exportRecipe(recipeId, textStream);
    }
}
