#include "zeerecipeeditwindow.h"

#include "zeecategoryeditdialog.h"
#include "zeecategorylistview.h"
#include "zeeingredienteditdialog.h"
#include "zeeingredientlistview.h"
#include "zeeutil.h"

#include "sql/qsqlquery.h"

#include <qpe/resource.h>

#include <qcombobox.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qmessagebox.h>
#include <qmultilineedit.h>
#include <qtabwidget.h>
#include <qtoolbutton.h>

ZeeRecipeEditWindow::ZeeRecipeEditWindow(int recipeId, QWidget* parent, const char* name)
    : ZeeModalWindow(parent, name)
{
    m_recipeId = recipeId;

    setCaption(tr("Zee Cookbook - Edit Recipe"));

    m_pTabWidget = new QTabWidget(this);

    m_pGeneralTab = new QWidget(m_pTabWidget);

    QLabel* nameLabel = new QLabel(tr("Name:"), m_pGeneralTab);

    m_pNameLineEdit = new QLineEdit(m_pGeneralTab);
    m_pNameLineEdit->setFocus();

    QLabel* yieldLabel = new QLabel(tr("Yield:"), m_pGeneralTab);
    m_pYieldQuantityLineEdit = new QLineEdit(m_pGeneralTab);

    m_pYieldUnitComboBox = new QComboBox(true, m_pGeneralTab);
    m_pYieldUnitComboBox->setAutoCompletion(true);

    QFrame* pGeneralSeparator = new QFrame(m_pGeneralTab);
    pGeneralSeparator->setFrameStyle(QFrame::HLine | QFrame::Sunken);

    m_pAddCategoryButton = new QToolButton(m_pGeneralTab);
    m_pAddCategoryButton->setAutoRaise(true);
    m_pAddCategoryButton->setIconSet(Resource::loadIconSet("zeecookbook/add"));
    connect(m_pAddCategoryButton, SIGNAL(clicked()), this, SLOT(addCategory()));

    m_pEditCategoryButton = new QToolButton(m_pGeneralTab);
    m_pEditCategoryButton->setAutoRaise(true);
    m_pEditCategoryButton->setIconSet(Resource::loadIconSet("zeecookbook/edit"));
    connect(m_pEditCategoryButton, SIGNAL(clicked()), this, SLOT(editCategory()));

    m_pRemoveCategoryButton = new QToolButton(m_pGeneralTab);
    m_pRemoveCategoryButton->setAutoRaise(true);
    m_pRemoveCategoryButton->setIconSet(Resource::loadIconSet("zeecookbook/remove"));
    connect(m_pRemoveCategoryButton, SIGNAL(clicked()), this, SLOT(removeCategory()));

    m_pMoveCategoryUpButton = new QToolButton(m_pGeneralTab);
    m_pMoveCategoryUpButton->setAutoRaise(true);
    m_pMoveCategoryUpButton->setIconSet(Resource::loadIconSet("zeecookbook/up"));
    connect(m_pMoveCategoryUpButton, SIGNAL(clicked()), this, SLOT(moveCategoryUp()));

    m_pMoveCategoryDownButton = new QToolButton(m_pGeneralTab);
    m_pMoveCategoryDownButton->setAutoRaise(true);
    m_pMoveCategoryDownButton->setIconSet(Resource::loadIconSet("zeecookbook/down"));
    connect(m_pMoveCategoryDownButton, SIGNAL(clicked()), this, SLOT(moveCategoryDown()));

    m_pCategoryListView = new ZeeCategoryListView(m_recipeId, m_pGeneralTab);
    connect(m_pCategoryListView, SIGNAL(selectionChanged()), this, SLOT(selectCategory()));

    QVBoxLayout* generalLayout = new QVBoxLayout(m_pGeneralTab, 4, 4);
    QGridLayout* fieldLayout = new QGridLayout(2, 2, 4);
    QHBoxLayout* yieldLayout = new QHBoxLayout();
    QHBoxLayout* categoryButtonLayout = new QHBoxLayout(0);

    yieldLayout->addWidget(m_pYieldQuantityLineEdit);
    yieldLayout->addWidget(m_pYieldUnitComboBox);

    fieldLayout->addWidget(nameLabel, 0, 0);
    fieldLayout->addWidget(m_pNameLineEdit, 0, 1);
    fieldLayout->addWidget(yieldLabel, 1, 0);
    fieldLayout->addLayout(yieldLayout, 1, 1);

    categoryButtonLayout->addWidget(m_pAddCategoryButton);
    categoryButtonLayout->addWidget(m_pEditCategoryButton);
    categoryButtonLayout->addWidget(m_pRemoveCategoryButton);
    categoryButtonLayout->addStretch();
    categoryButtonLayout->addWidget(m_pMoveCategoryUpButton);
    categoryButtonLayout->addWidget(m_pMoveCategoryDownButton);

    generalLayout->addLayout(fieldLayout);
    generalLayout->addWidget(pGeneralSeparator);
    generalLayout->addLayout(categoryButtonLayout);
    generalLayout->addWidget(m_pCategoryListView);

    m_pTabWidget->addTab(m_pGeneralTab, tr("General"));

    m_pIngredientTab = new QWidget(m_pTabWidget);

    m_pAddIngredientButton = new QToolButton(m_pIngredientTab);
    m_pAddIngredientButton->setAutoRaise(true);
    m_pAddIngredientButton->setIconSet(Resource::loadIconSet("zeecookbook/add"));
    connect(m_pAddIngredientButton, SIGNAL(clicked()), this, SLOT(addIngredient()));

    m_pEditIngredientButton = new QToolButton(m_pIngredientTab);
    m_pEditIngredientButton->setAutoRaise(true);
    m_pEditIngredientButton->setIconSet(Resource::loadIconSet("zeecookbook/edit"));
    connect(m_pEditIngredientButton, SIGNAL(clicked()), this, SLOT(editIngredient()));

    m_pRemoveIngredientButton = new QToolButton(m_pIngredientTab);
    m_pRemoveIngredientButton->setAutoRaise(true);
    m_pRemoveIngredientButton->setIconSet(Resource::loadIconSet("zeecookbook/remove"));
    connect(m_pRemoveIngredientButton, SIGNAL(clicked()), this, SLOT(removeIngredient()));

    m_pMoveIngredientUpButton = new QToolButton(m_pIngredientTab);
    m_pMoveIngredientUpButton->setAutoRaise(true);
    m_pMoveIngredientUpButton->setIconSet(Resource::loadIconSet("zeecookbook/up"));
    connect(m_pMoveIngredientUpButton, SIGNAL(clicked()), this, SLOT(moveIngredientUp()));

    m_pMoveIngredientDownButton = new QToolButton(m_pIngredientTab);
    m_pMoveIngredientDownButton->setAutoRaise(true);
    m_pMoveIngredientDownButton->setIconSet(Resource::loadIconSet("zeecookbook/down"));
    connect(m_pMoveIngredientDownButton, SIGNAL(clicked()), this, SLOT(moveIngredientDown()));

    m_pIngredientListView = new ZeeIngredientListView(m_recipeId, m_pIngredientTab);
    connect(m_pIngredientListView, SIGNAL(selectionChanged()), this, SLOT(selectIngredient()));

    QVBoxLayout* ingredientLayout = new QVBoxLayout(m_pIngredientTab, 4, 4);
    QHBoxLayout* ingredientButtonLayout = new QHBoxLayout(0);

    ingredientButtonLayout->addWidget(m_pAddIngredientButton);
    ingredientButtonLayout->addWidget(m_pEditIngredientButton);
    ingredientButtonLayout->addWidget(m_pRemoveIngredientButton);
    ingredientButtonLayout->addStretch();
    ingredientButtonLayout->addWidget(m_pMoveIngredientUpButton);
    ingredientButtonLayout->addWidget(m_pMoveIngredientDownButton);

    ingredientLayout->addLayout(ingredientButtonLayout);
    ingredientLayout->addWidget(m_pIngredientListView);

    m_pTabWidget->addTab(m_pIngredientTab, tr("Ingredients"));

    m_pDirectionTab = new QWidget(m_pTabWidget);

    m_pDirectionMultiLineEdit = new QMultiLineEdit(m_pDirectionTab);
    m_pDirectionMultiLineEdit->setWordWrap(QMultiLineEdit::WidgetWidth);

    QVBoxLayout* directionLayout = new QVBoxLayout(m_pDirectionTab, 4, 4);

    directionLayout->addWidget(m_pDirectionMultiLineEdit);

    m_pTabWidget->addTab(m_pDirectionTab, tr("Directions"));

    QVBoxLayout* mainLayout = new QVBoxLayout(this, 4, 4);

    mainLayout->addWidget(m_pTabWidget);

    updateView(false);
}

ZeeRecipeEditWindow::~ZeeRecipeEditWindow()
{
}

void ZeeRecipeEditWindow::closeEvent(QCloseEvent* e)
{
    updateDatabase();
    e->accept();
}

void ZeeRecipeEditWindow::updateDatabase()
{
    QString name = zeeFormatString(m_pNameLineEdit->text());
    QString yieldQuantity = zeeFormatString(m_pYieldQuantityLineEdit->text());
    QString direction = zeeFormatString(m_pDirectionMultiLineEdit->text());

    QString yieldUnit = zeeFormatString(m_pYieldUnitComboBox->currentText());
    int yieldId = -1;

    if (yieldUnit !=  "''") {
        QString queryString = "SELECT id FROM yield WHERE name = %1";
        QSqlQuery query(queryString.arg(yieldUnit));

        if (query.first()) {
            yieldId = query.value(0).toInt();
        } else {
            queryString = "INSERT INTO yield VALUES(NULL, %1)";
            query.exec(queryString.arg(yieldUnit));

            queryString = "SELECT last_insert_rowid()";
            query.exec(queryString);

            if (query.first()) {
                yieldId = query.value(0).toInt();
            }
        }
    }

    QString queryString = "UPDATE recipe SET name = %1, yield_quantity = %2, yield_id = %3, direction = %4 WHERE id = %5";
    QSqlQuery query(queryString.arg(name).arg(yieldQuantity).arg(yieldId).arg(direction).arg(m_recipeId));
}

void ZeeRecipeEditWindow::updateView(bool needDatabaseUpdate)
{
    blockSignals(true);
    
    if (needDatabaseUpdate) {
        updateDatabase();
    }

    QString queryString = "SELECT name, yield_quantity, yield_id, direction FROM recipe WHERE id = %1";
    QSqlQuery query(queryString.arg(m_recipeId));

    QString name = "";
    QString yieldQuantity = "";
    int yieldId = -1;
    QString direction = "";

    if (query.first()) {
        name = query.value(0).toString();
        yieldQuantity = query.value(1).toString();
        yieldId = query.value(2).toInt();
        direction = query.value(3).toString();
    }

    m_pNameLineEdit->setText(name);
    m_pYieldQuantityLineEdit->setText(yieldQuantity);
    m_pDirectionMultiLineEdit->setText(direction);

    queryString = "SELECT name FROM yield ORDER BY name";
    query.exec(queryString);

    while (query.next()) {
        QString name = query.value(0).toString();
        m_pYieldUnitComboBox->insertItem(name);
    }

    QString yieldUnit = "";

    if (yieldId != -1) {
            queryString = "SELECT name FROM yield WHERE id = %1";
            query.exec(queryString.arg(yieldId));

            if (query.first()) {
                yieldUnit = query.value(0).toString();
            }
    }

    m_pYieldUnitComboBox->setEditText(yieldUnit);

    int recipeCategoryId = m_pCategoryListView->selected();

    bool isCategorySelected = (recipeCategoryId != -1);
    bool isFirstCategory = false;
    bool isLastCategory = false;

    if (isCategorySelected) {
        queryString = "SELECT position FROM recipe_category WHERE id = %1";
        query.exec(queryString.arg(recipeCategoryId));

        if (query.first()) {
            int position = query.value(0).toInt();
            isFirstCategory = (position == 1);

            queryString = "SELECT COUNT(*) FROM recipe_category WHERE recipe_id = %1";
            query.exec(queryString.arg(m_recipeId));

            if (query.first()) {
                int count = query.value(0).toInt();
                isLastCategory = (position == count);
            }
        }
    }

    m_pEditCategoryButton->setEnabled(isCategorySelected);
    m_pRemoveCategoryButton->setEnabled(isCategorySelected);
    m_pMoveCategoryUpButton->setEnabled(isCategorySelected && !isFirstCategory);
    m_pMoveCategoryDownButton->setEnabled(isCategorySelected && !isLastCategory);

    int recipeIngredientId = m_pIngredientListView->selected();

    bool isIngredientSelected = (recipeIngredientId != -1);
    bool isFirstIngredient = false;
    bool isLastIngredient = false;

    if (isIngredientSelected) {
        queryString = "SELECT position FROM recipe_ingredient WHERE id = %1";
        query.exec(queryString.arg(recipeIngredientId));

        if (query.first()) {
            int position = query.value(0).toInt();
            isFirstIngredient = (position == 1);

            queryString = "SELECT COUNT(*) FROM recipe_ingredient WHERE recipe_id = %1";
            query.exec(queryString.arg(m_recipeId));

            if (query.first()) {
                int count = query.value(0).toInt();
                isLastIngredient = (position == count);
            }
        }
    }

    m_pEditIngredientButton->setEnabled(isIngredientSelected);
    m_pRemoveIngredientButton->setEnabled(isIngredientSelected);
    m_pMoveIngredientUpButton->setEnabled(isIngredientSelected && !isFirstIngredient);
    m_pMoveIngredientDownButton->setEnabled(isIngredientSelected && !isLastIngredient);

    blockSignals(false);
}

void ZeeRecipeEditWindow::addCategory()
{
    ZeeCategoryEditDialog categoryEditDialog(-1, this);

    if (categoryEditDialog.exec() == QDialog::Accepted) {
        QString categoryName = zeeFormatString(categoryEditDialog.selected());

        if (categoryName !=  "''") {
            int categoryId = -1;

            QString queryString = "SELECT id FROM category WHERE name = %1";
            QSqlQuery query(queryString.arg(categoryName));

            if (query.first()) {
                categoryId = query.value(0).toInt();
            } else {
                queryString = "INSERT INTO category VALUES(NULL, %1)";
                query.exec(queryString.arg(categoryName));

                queryString = "SELECT last_insert_rowid()";
                query.exec(queryString);

                if (query.first()) {
                    categoryId = query.value(0).toInt();
                }
            }

            queryString = "SELECT COUNT(*) FROM recipe_category WHERE recipe_id = %1";
            query.exec(queryString.arg(m_recipeId));

            int count = 0;

            if (query.first()) {
                count = query.value(0).toInt();
            }

            queryString = "INSERT INTO recipe_category VALUES(NULL, %1, %2, %3)";
            query.exec(queryString.arg(m_recipeId).arg(count + 1).arg(categoryId));

            queryString = "SELECT last_insert_rowid()";
            query.exec(queryString);

            if (query.first()) {
                int newRecipeCategoryId = query.value(0).toInt();

                m_pCategoryListView->updateView();
                m_pCategoryListView->select(newRecipeCategoryId);

                updateView();
            }
        }
    }
}

void ZeeRecipeEditWindow::editCategory()
{
    int recipeCategoryId = m_pCategoryListView->selected();

    if (recipeCategoryId != -1) {
        ZeeCategoryEditDialog categoryEditDialog(recipeCategoryId, this);

        if (categoryEditDialog.exec() == QDialog::Accepted) {
            QString categoryName = zeeFormatString(categoryEditDialog.selected());

            if (categoryName !=  "''") {
                int categoryId = -1;

                QString queryString = "SELECT id FROM category WHERE name = %1";
                QSqlQuery query(queryString.arg(categoryName));

                if (query.first()) {
                    categoryId = query.value(0).toInt();
                } else {
                    queryString = "INSERT INTO category VALUES(NULL, %1)";
                    query.exec(queryString.arg(categoryName));

                    queryString = "SELECT last_insert_rowid()";
                    query.exec(queryString);

                    if (query.first()) {
                        categoryId = query.value(0).toInt();
                    }
                }

                queryString = "UPDATE recipe_category SET category_id = %1 WHERE id = %2";
                query.exec(queryString.arg(categoryId).arg(recipeCategoryId));

                m_pCategoryListView->updateView();
                m_pCategoryListView->select(recipeCategoryId);

                updateView();
            }
        }
    }
}

void ZeeRecipeEditWindow::removeCategory()
{
    int recipeCategoryId = m_pCategoryListView->selected();

    if (recipeCategoryId != -1) {
        QMessageBox messageBox(tr("Remove Category"), tr("Do you want to remove\nthe selected category?"),
                            QMessageBox::Information, QMessageBox::Yes,
                            QMessageBox::No | QMessageBox::Escape | QMessageBox::Default,
                            QMessageBox::NoButton, this);

        messageBox.setIconPixmap(Resource::loadPixmap("zeecookbook/information"));
        messageBox.setButtonText(QMessageBox::Yes, tr("Yes"));
        messageBox.setButtonText(QMessageBox::No, tr("No"));

        if (messageBox.exec() == QMessageBox::Yes) {
            QString queryString = "SELECT position FROM recipe_category WHERE id = %1";
            QSqlQuery query(queryString.arg(recipeCategoryId));

            if (query.first()) {
                int position = query.value(0).toInt();

                queryString = "DELETE FROM recipe_category WHERE id = %1";
                query.exec(queryString.arg(recipeCategoryId));

                queryString = "UPDATE recipe_category SET position = position - 1";
                queryString += " WHERE recipe_id = %1 AND position > %2";
                query.exec(queryString.arg(m_recipeId).arg(position));

                m_pCategoryListView->updateView();
                updateView();
            }
        }
    }
}

void ZeeRecipeEditWindow::moveCategoryUp()
{
    int recipeCategoryId = m_pCategoryListView->selected();

    if (recipeCategoryId != -1) {
        QString queryString = "SELECT position FROM recipe_category WHERE id = %1";
        QSqlQuery query(queryString.arg(recipeCategoryId));

        if (query.first()) {
            int position = query.value(0).toInt();

            queryString = "UPDATE recipe_category SET position = position + 1";
            queryString += " WHERE recipe_id = %1 AND position = %2";
            query.exec(queryString.arg(m_recipeId).arg(position - 1));

            queryString = "UPDATE recipe_category SET position = position - 1 WHERE id = %1";
            query.exec(queryString.arg(recipeCategoryId));

            m_pCategoryListView->updateView();
            updateView();
        }
    }
}

void ZeeRecipeEditWindow::moveCategoryDown()
{
    int recipeCategoryId = m_pCategoryListView->selected();

    if (recipeCategoryId != -1) {
        QString queryString = "SELECT position FROM recipe_category WHERE id = %1";
        QSqlQuery query(queryString.arg(recipeCategoryId));

        if (query.first()) {
            int position = query.value(0).toInt();

            queryString = "UPDATE recipe_category SET position = position - 1";
            queryString += " WHERE recipe_id = %1 AND position = %2";
            query.exec(queryString.arg(m_recipeId).arg(position + 1));

            queryString = "UPDATE recipe_category SET position = position + 1 WHERE id = %1";
            query.exec(queryString.arg(recipeCategoryId));

            m_pCategoryListView->updateView();
            updateView();
        }
    }
}

void ZeeRecipeEditWindow::selectCategory()
{
    updateView();
}

void ZeeRecipeEditWindow::addIngredient()
{
    ZeeIngredientEditDialog ingredientEditDialog(-1, this);

    if (ingredientEditDialog.exec() == QDialog::Accepted) {
        QString quantity = zeeFormatString(ingredientEditDialog.selectedQuantity());
        QString unitName = zeeFormatString(ingredientEditDialog.selectedUnit());
        QString ingredientName = zeeFormatString(ingredientEditDialog.selectedIngredient());
        bool isGroup = ingredientEditDialog.selectedIsGroup();

        if (ingredientName !=  "''") {
            int unitId = -1;
            int ingredientId = -1;

            if (unitName !=  "''") {
                QString queryString = "SELECT id FROM unit WHERE name = %1";
                QSqlQuery query(queryString.arg(unitName));

                if (query.first()) {
                    unitId = query.value(0).toInt();
                } else {
                    queryString = "INSERT INTO unit VALUES(NULL, %1)";
                    query.exec(queryString.arg(unitName));

                    queryString = "SELECT last_insert_rowid()";
                    query.exec(queryString);

                    if (query.first()) {
                        unitId = query.value(0).toInt();
                    }
                }
            }

            QString queryString = "SELECT id FROM ingredient WHERE name = %1";
            QSqlQuery query(queryString.arg(ingredientName));

            if (query.first()) {
                ingredientId = query.value(0).toInt();
            } else {
                queryString = "INSERT INTO ingredient VALUES(NULL, %1)";
                query.exec(queryString.arg(ingredientName));

                queryString = "SELECT last_insert_rowid()";
                query.exec(queryString);

                if (query.first()) {
                    ingredientId = query.value(0).toInt();
                }
            }

            queryString = "SELECT COUNT(*) FROM recipe_ingredient WHERE recipe_id = %1";
            query.exec(queryString.arg(m_recipeId));

            int count = 0;

            if (query.first()) {
                count = query.value(0).toInt();
            }

            queryString = "INSERT INTO recipe_ingredient VALUES(NULL, %1, %2, %3, %4, %5, %6)";
            query.exec(queryString.arg(m_recipeId).arg(count + 1).arg(quantity).arg(unitId).arg(ingredientId).arg(isGroup));

            queryString = "SELECT last_insert_rowid()";
            query.exec(queryString);

            if (query.first()) {
                int newRecipeIngredientId = query.value(0).toInt();

                m_pIngredientListView->updateView();
                m_pIngredientListView->select(newRecipeIngredientId);

                updateView();
            }
        }
    }
}

void ZeeRecipeEditWindow::editIngredient()
{
    int recipeIngredientId = m_pIngredientListView->selected();

    if (recipeIngredientId != -1) {
        ZeeIngredientEditDialog ingredientEditDialog(recipeIngredientId, this);

        if (ingredientEditDialog.exec() == QDialog::Accepted) {
            QString quantity = zeeFormatString(ingredientEditDialog.selectedQuantity());
            QString unitName = zeeFormatString(ingredientEditDialog.selectedUnit());
            QString ingredientName = zeeFormatString(ingredientEditDialog.selectedIngredient());
            bool isGroup = ingredientEditDialog.selectedIsGroup();

            if (ingredientName !=  "''") {
                int unitId = -1;
                int ingredientId = -1;

                if (unitName !=  "''") {
                    QString queryString = "SELECT id FROM unit WHERE name = %1";
                    QSqlQuery query(queryString.arg(unitName));

                    if (query.first()) {
                        unitId = query.value(0).toInt();
                    } else {
                        queryString = "INSERT INTO unit VALUES(NULL, %1)";
                        query.exec(queryString.arg(unitName));

                        queryString = "SELECT last_insert_rowid()";
                        query.exec(queryString);

                        if (query.first()) {
                            unitId = query.value(0).toInt();
                        }
                    }
                }

                QString queryString = "SELECT id FROM ingredient WHERE name = %1";
                QSqlQuery query(queryString.arg(ingredientName));

                if (query.first()) {
                    ingredientId = query.value(0).toInt();
                } else {
                    queryString = "INSERT INTO ingredient VALUES(NULL, %1)";
                    query.exec(queryString.arg(ingredientName));

                    queryString = "SELECT last_insert_rowid()";
                    query.exec(queryString);

                    if (query.first()) {
                        ingredientId = query.value(0).toInt();
                    }
                }

                queryString = "UPDATE recipe_ingredient";
                queryString += " SET quantity = %1, unit_id = %2, ingredient_id = %3, is_group = %4";
                queryString += " WHERE id = %5";
                query.exec(queryString.arg(quantity).arg(unitId).arg(ingredientId).arg(isGroup).arg(recipeIngredientId));

                m_pIngredientListView->updateView();
                m_pIngredientListView->select(recipeIngredientId);

                updateView();
            }
        }
    }
}

void ZeeRecipeEditWindow::removeIngredient()
{
    int recipeIngredientId = m_pIngredientListView->selected();

    if (recipeIngredientId != -1) {
        QMessageBox messageBox(tr("Remove Ingredient"), tr("Do you want to remove\nthe selected ingredient?"),
                            QMessageBox::Information, QMessageBox::Yes,
                            QMessageBox::No | QMessageBox::Escape | QMessageBox::Default,
                            QMessageBox::NoButton, this);

        messageBox.setIconPixmap(Resource::loadPixmap("zeecookbook/information"));
        messageBox.setButtonText(QMessageBox::Yes, tr("Yes"));
        messageBox.setButtonText(QMessageBox::No, tr("No"));

        if (messageBox.exec() == QMessageBox::Yes) {
            QString queryString = "SELECT position FROM recipe_ingredient WHERE id = %1";
            QSqlQuery query(queryString.arg(recipeIngredientId));

            if (query.first()) {
                int position = query.value(0).toInt();

                queryString = "DELETE FROM recipe_ingredient WHERE id = %1";
                query.exec(queryString.arg(recipeIngredientId));

                queryString = "UPDATE recipe_ingredient SET position = position - 1";
                queryString += " WHERE recipe_id = %1 AND position > %2";
                query.exec(queryString.arg(m_recipeId).arg(position));

                m_pIngredientListView->updateView();
                updateView();
            }
        }
    }
}

void ZeeRecipeEditWindow::moveIngredientUp()
{
    int recipeIngredientId = m_pIngredientListView->selected();

    if (recipeIngredientId != -1) {
        QString queryString = "SELECT position FROM recipe_ingredient WHERE id = %1";
        QSqlQuery query(queryString.arg(recipeIngredientId));

        if (query.first()) {
            int position = query.value(0).toInt();

            queryString = "UPDATE recipe_ingredient SET position = position + 1";
            queryString += " WHERE recipe_id = %1 AND position = %2";
            query.exec(queryString.arg(m_recipeId).arg(position - 1));

            queryString = "UPDATE recipe_ingredient SET position = position - 1 WHERE id = %1";
            query.exec(queryString.arg(recipeIngredientId));

            m_pIngredientListView->updateView();
            updateView();
        }
    }
}

void ZeeRecipeEditWindow::moveIngredientDown()
{
    int recipeIngredientId = m_pIngredientListView->selected();

    if (recipeIngredientId != -1) {
        QString queryString = "SELECT position FROM recipe_ingredient WHERE id = %1";
        QSqlQuery query(queryString.arg(recipeIngredientId));

        if (query.first()) {
            int position = query.value(0).toInt();

            queryString = "UPDATE recipe_ingredient SET position = position - 1";
            queryString += " WHERE recipe_id = %1 AND position = %2";
            query.exec(queryString.arg(m_recipeId).arg(position + 1));

            queryString = "UPDATE recipe_ingredient SET position = position + 1 WHERE id = %1";
            query.exec(queryString.arg(recipeIngredientId));

            m_pIngredientListView->updateView();
            updateView();
        }
    }
}

void ZeeRecipeEditWindow::selectIngredient()
{
    updateView();
}
