#ifndef ZEERECIPELISTVIEW_H
#define ZEERECIPELISTVIEW_H

#include "zeelistview.h"

class ZeeRecipeListViewItem : public QListViewItem
{
public:
    ZeeRecipeListViewItem(int recipeId, QString name, QListView* parent);
    ~ZeeRecipeListViewItem();

    int recipeId() const;

private:
    int m_recipeId;
};

class ZeeRecipeListView : public ZeeListView
{
public:
    ZeeRecipeListView(QWidget* parent = 0, const char* name = 0);
    ~ZeeRecipeListView();

    void setFilter(QString filter);
    QString filter() const;

    void updateView();

    void select(int recipeId);
    int selected() const;

private:
    QString m_filter;
};

#endif // ZEERECIPELISTVIEW_H
