#include "zeestartupdialog.h"

#include <qpe/config.h>

#include <qlayout.h>
#include <qpushbutton.h>
#include <qradiobutton.h>

ZeeStartupDialog::ZeeStartupDialog(QWidget* parent, const char* name)
    : QDialog(parent, name, true)
{
    m_type = New;

    setCaption(tr("Choose Cookbook"));

    m_pOpenRadioButton = new QRadioButton(tr("Start with an existing cookbook"), this);
    connect(m_pOpenRadioButton, SIGNAL(clicked()), this, SLOT(selectOpen()));

    m_pLastRadioButton = new QRadioButton(tr("Start with the last cookbook opened"), this);
    connect(m_pLastRadioButton, SIGNAL(clicked()), this, SLOT(selectLast()));

    m_pNewRadioButton = new QRadioButton(tr("Start with a new cookbook"), this);
    connect(m_pNewRadioButton, SIGNAL(clicked()), this, SLOT(selectNew()));

    QVBoxLayout* mainLayout = new QVBoxLayout(this, 4, 4);

    mainLayout->addWidget(m_pOpenRadioButton);
    mainLayout->addWidget(m_pLastRadioButton);
    mainLayout->addWidget(m_pNewRadioButton);

    updateView();
}

ZeeStartupDialog::~ZeeStartupDialog()
{
}

void ZeeStartupDialog::updateView()
{
    blockSignals(true);

    Config config("zeecookbook");
    config.setGroup("General");
    m_pLastRadioButton->setEnabled(!(config.readEntry("LastCookbook").isNull()));

    switch (m_type) {
        case Open:
            m_pOpenRadioButton->setChecked(true);
            m_pLastRadioButton->setChecked(false);
            m_pNewRadioButton->setChecked(false);
            break;
        case Last:
            m_pOpenRadioButton->setChecked(false);
            m_pLastRadioButton->setChecked(true);
            m_pNewRadioButton->setChecked(false);
            break;
        case New:
            m_pOpenRadioButton->setChecked(false);
            m_pLastRadioButton->setChecked(false);
            m_pNewRadioButton->setChecked(true);
            break;
        default:
            break;
    }
    
    blockSignals(false);
}

ZeeStartupDialog::Type ZeeStartupDialog::selected() const
{
    return m_type;
}

void ZeeStartupDialog::selectOpen()
{
    m_type = Open;
    updateView();
}

void ZeeStartupDialog::selectLast()
{
    m_type = Last;
    updateView();
}

void ZeeStartupDialog::selectNew()
{
    m_type = New;
    updateView();
}
