#ifndef ZEESTARTUPDIALOG_H
#define ZEESTARTUPDIALOG_H

#include <qdialog.h>

class QRadioButton;

class ZeeStartupDialog : public QDialog
{
    Q_OBJECT

public:
    enum Type {
        Open,
        Last,
        New
    };

    ZeeStartupDialog(QWidget* parent = 0, const char* name = 0);
    ~ZeeStartupDialog();

    void updateView();

    Type selected() const;

private slots:
    void selectOpen();
    void selectLast();
    void selectNew();

private:
    Type m_type;

    QRadioButton* m_pOpenRadioButton;
    QRadioButton* m_pLastRadioButton;
    QRadioButton* m_pNewRadioButton;
};

#endif // ZEESTARTUPDIALOG_H
