#include "zeeutil.h"

#include <qpe/config.h>
#include <qpe/timestring.h>

#include <qobject.h>

QString zeeSizeString(uint size)
{
    QString result;

    double newSize = size;

    if (newSize > 1024 * 1024 * 1024) {
        result = QString().sprintf("%.1f", newSize / (1024 * 1024 * 1024)) + QObject::tr("Gb");
    } else if (newSize > 1024 * 1024) {
        result = QString().sprintf("%.1f", newSize / (1024 * 1024)) + QObject::tr("Mb");
    } else if (newSize > 1024) {
        result = QString().sprintf("%.1f", newSize / 1024) + QObject::tr("Kb");
    } else {
        result = QString::number(newSize) + QObject::tr("b");
    }

    return result;
}

QString zeeDateTimeString(QDateTime dateTime)
{
    QString result;

    Config config("qpe");
    config.setGroup("Date");

    QChar separator = config.readEntry("Separator", "/")[0];
    DateFormat::Order shortOrder = (DateFormat::Order)config .readNumEntry("ShortOrder", DateFormat::DayMonthYear);

    for (int i = 0; i < 3; i++) {
        switch((shortOrder >> (i * 3)) & 0x0007) {
            case 0x0001:
                result += QString().sprintf("%02d", dateTime.date().day());
                break;
            case 0x0002:
                result += QString().sprintf("%02d", dateTime.date().month());
                break;
            case 0x0004:
                result += QString().sprintf("%04d", dateTime.date().year());
                break;
            default:
                break;
        }

        if (i < 2) {
            result += separator;
        }
    }

    result += QString().sprintf(" %02d:%02d", dateTime.time().hour(), dateTime.time().minute());

    return result;
}

QString zeeFormatString(QString s)
{
    QString result = s;

    result.replace(QRegExp("'"), "''");
    result = "'" + result + "'";

    return result;
}

QString zeeStripRightWhiteSpace(QString s)
{
    int end = s.length() - 1;

    while (end >= 0 && s.at(end).isSpace()) {
        end--;
    }

    QString result = "";

    if (end >= 0) {
        result = s.left(end + 1);
    }
	   
    return result;
}
