/////////////////////////////////////////////////////////////////////
// Code fuer den Kreativ-Wettbewerb zum 25. c't-Geburtstag von     //
// Josef Schtzenberger, basierend auf den Delphi Code von         //
// Joe Merten, ajm@jme.de, 29.06.2008                              //
// Getestet mit Delphi 7 unter Windows XP                          //
/////////////////////////////////////////////////////////////////////

unit AstMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, AstGame, ExtCtrls, StdCtrls, ComCtrls, AstJobs,AstMath;

type
  TForm1 = class(TForm)
    ComboBoxHost: TComboBox;
    CheckBoxGraphic: TCheckBox;
    PaintBox1: TPaintBox;
    Timer1: TTimer;
    CheckBoxAutoStart: TCheckBox;
    LabelConnection: TLabel;
    LabelStatus: TLabel;
    LabelTime: TLabel;
    LabelScore: TLabel;
    StatusBar1: TStatusBar;
    CheckBoxLog: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ComboBoxHostChange(Sender: TObject);
    procedure CheckBoxGraphicClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private-Deklarationen }
    aGame: TAstGame;
    aJob:  TAstJob;
  private
    procedure OnRxFrame(Sender: TObject);
  public
    { Public-Deklarationen }
  end;
var
  Form1: TForm1;
implementation

{$R *.dfm}
uses shellapi,math,types,AstStat;

function ExecNewProcess(ProgramName,CmdLine,CurrentDirectory : String): THandle;
var
  StartInfo  : TStartupInfo;
  ProcInfo   : TProcessInformation;
  CreateOK   : Boolean;
begin
  { fill with known state }
  FillChar(StartInfo,SizeOf(TStartupInfo),#0);
  with StartInfo do begin
      dwFlags := STARTF_USESHOWWINDOW;
      wShowWindow := SW_NORMAL;
      cb := SizeOf(TStartupInfo);
  end;
  FillChar(ProcInfo,SizeOf(TProcessInformation),#0);
  CreateOK := CreateProcess(PChar(ProgramName),PChar(CmdLine), nil, nil,False,
              CREATE_NEW_PROCESS_GROUP+REALTIME_PRIORITY_CLASS	,
              nil, PChar(CurrentDirectory), StartInfo, ProcInfo);
  if CreateOK then
  result:=ProcInfo.hProcess else result:=0;;
end;
procedure TForm1.FormCreate(Sender: TObject);
begin
  aGame:=TAstGame.Create(Self);
  aGame.OnRxFrame:=OnRxFrame;
  aGame.PaintBox:=PaintBox1;
  aJob:=TAstJob.Create(aGame);
  if aGame.RemoteHost='127.0.0.1' then
  if fileexists('c:\atari\bin-recording\mameaster.exe') then
  begin
    ExecNewProcess('c:\atari\bin-recording\mameaster.exe',' asteroid -window -skip_gameinfo -sleep -speed 1','c:\atari');
    sleep(500);
  end;
  AstCompare:=TAstCompare.Create(aGame);
  AstCompare2:=TAstCompare2.Create(aGame);
  AstCompare3:=TAstCompare3.Create(aGame);
  AstCompare4:=TAstCompare4.Create(aGame);
  ShotLengthFinder:=TShotLengthFinder.Create(aGame);
  end;


procedure TForm1.FormDestroy(Sender: TObject);
  begin
   aJob.Free;
   AstCompare.Free;
  // ...
  end;

procedure TForm1.ComboBoxHostChange(Sender: TObject);
  begin
  // Neue IP zuweisen
  aGame.RemoteHost:=ComboBoxHost.Text;
  end;

procedure TForm1.CheckBoxGraphicClick(Sender: TObject);
  begin
  if CheckBoxGraphic.Checked then
    begin
    // Visualisierung aktivieren
    aGame.PaintBox:=PaintBox1;
    end
  else begin
    // Visualisierung abschalten
    aGame.PaintBox:=Nil;
    end;
  end;
procedure CalcVectorShot(aGame:TAstGame);
var pObj,pObj0 : TAstObject;
    d:TPoint;
    i,j,k,k0,dist,Epsilon:integer;found:boolean;
begin
  k:= aGame.Objects.Shots.Count-1;
  k0:= aGame.Objects0.Shots.Count-1;
  if k<0 then exit;
  for i:=0 to k do
  begin
    pObj:=aGame.Objects.Shots[i];
    found:=false;
    for j:=0 to k0 do
    begin
      pObj0:=aGame.Objects0.Shots[j];
      if pObj0.frames<0 then continue;
      d:=CalcPreDistKart(pObj,pObj0);
      if pObj0.frames=0 then Epsilon:=900 else Epsilon:=100;
      if not SameValue(d.x,pObj0.dx,Epsilon) or not SameValue(d.y,pObj0.dy,Epsilon) then continue;
      d:=CalcDistKart(pObj,pObj0);
      pObj.dx:=d.x;
      pObj.dy:=d.y;
      pObj0.frames:=-1;
      found:=true;
      break;
    end;
    if not found then
    begin
      dist:=CalcDist(aGame.Objects.pShip,pObj);
      if dist<22 then //own shot
      begin
        pObj.ownshot:=true;
        pObj.shot:=aGame.LastFrames2HitTarget;
        pObj.StartByte:=aGame.LastShotByte;
        pObj.FireFrame:=aGame.LastFireFrame;
        aGame.LastFireFrame:=0;
      end else
      begin
        pObj.ownshot:=false;
      end ;
    end;
  end;
end;

procedure CalcVectorShip(aGame:TAstGame);
var pObj,pObj0 : TAstObject;
    d:TPoint;
begin
  pObj:=aGame.Objects.pShip;
  pObj0:=aGame.Objects0.pShip;
  if pObj=nil then exit;
  if pObj0=nil then exit;
  d:=CalcDistKart(pObj,pObj0);
  pObj.dx:=d.x;
  pObj.dy:=d.y;
end;
procedure CalcVectorSoucer(aGame:TAstGame);
  var pObj,pObj0 : TAstObject;
      d:TPoint;
begin
  pObj:=aGame.Objects.pSaucer;
  pObj0:=aGame.Objects0.pSaucer;
  if pObj=nil then exit;
  if pObj0=nil then exit;
  d:=CalcDistKart(pObj,pObj0);
  pObj.dx:=d.x;
  pObj.dy:=d.y;
end;
function FindStone(pObj:TAstObject;Stones:TAstObjArr;Start:integer):integer;
var i     : Integer;
begin
  result:=-1;
  for i:=Start to Stones.Count-1 do
  begin
    if (CalcDist(pObj,Stones[i])>20) or (pObj.nScale<>Stones[i].nScale) or (pObj.nObjId<>Stones[i].nObjId) then continue;
    result:=i;
    break;
  end;
end;

procedure CalcVectorStone(aGame:TAstGame);
var pObj,pObj0 : TAstObject;
    i,k,k0,offset,se: Integer;
    d:TPoint;
begin
  k0:= aGame.Objects0.Stones.Count-1;
  k:= aGame.Objects.Stones.Count-1;
  offset:=0;
  if k=0 then
  assert(k=k*1);
  for i:=0 to k do
  begin
    if i+offset>k0 then continue; //no more old stones
    pObj:=aGame.Objects.Stones[i];
    pObj0:=aGame.Objects0.Stones[i+offset];
    if (CalcDist(pObj,pObj0)>20) or (pObj.nScale<>pObj0.nScale) or (pObj.nObjId<>pObj0.nObjId) then
    begin
      se:=FindStone(pObj,aGame.Objects0.Stones,i+offset);
      if se<0 then
      begin
        if k=0 then
        assert(k=k*1);
        dec(offset); //no old stone exists
        continue;
      end;
      offset:=se-i;
      pObj0:=aGame.Objects0.Stones[i+offset];
    end;
    d:=CalcDistKart(pObj,pObj0);
    pObj.dx:=d.x;
    pObj.dy:=d.y;
  end;
end;
procedure TForm1.Timer1Timer(Sender: TObject);
  begin
  LabelConnection.Caption:=aGame.ConnectionStatusStr;
  LabelStatus.Caption:=aGame.GameStatusStr;
  LabelTime.Caption:=aGame.PlayingTimeStr;
  LabelScore.Caption:=IntToStrP(aGame.Score);
  end;


function calcShipAngle(wbyte:byte):extended;
var b:integer;
begin
  b:=256-WByte;
  if (b>21) and (b<43) then inc(b);
  if (b>64) and (b<86) then inc(b);
  if (b>106) and (b<128) then inc(b);
  if (b>149) and (b<171) then inc(b);
  if (b>192) and (b<214) then inc(b);
  if (b>234) then inc(b);
  b:=(b*3) div 4;
  result:=-b*360/64;
  while result<=-180 do result:=result+360;
end;
function Scan(w:extended):integer;
var i:integer;wb,d,bd:extended;
begin
  result:=high(integer);
  bd:=high(integer);
  for i:=0 to 255 do
  begin
   wb:=calcShipAngle(i);
   D:=Abs(wb-w);
   if d<bd then
   begin
     result:=i;
     bd:=d;
   end;
  end;
end;
var errorcount:integer=00;
function Fullsync(aGame:TAstGame):integer;
var i,j,k,x:integer;ok:boolean;wb,d,bd:extended;
begin
  k:=0;
  repeat
    ok:=true;
    for i:=4 to 50 do
    begin
     x:=i;
     j:=wba[x,1]+k;
     if j>255 then j:=j-256;
     wb:=calcShipAngle(j);
     bd:=wba[i,0]/1000;
     D:=Abs(wb-bd);
     if d>0.3 then
     begin
       inc(k);
       ok:=false;
       break;
     end;
    end;
    if not ok then
    begin
      if k>=256 then
      begin
        startsyncwbyte:=true;
        syncwbytendx:=0;
        result:=0;
        inc(errorcount);
        if errorcount>1 then
                  result:=0;

        exit;
      end;
    end;
  until ok;
  result:=k;
end;
procedure syncWByte(aGame:TAstGame);
var w,wb:extended;k,i:integer;
begin
  begin
    w:=ArcTan2(aGame.Objects.pShip.nShipVY,aGame.Objects.pShip.nShipVX)/PI*180;
    if startsyncwbyte then
    begin
      wba[syncwbytendx,0]:=round(w*1000);
      wba[syncwbytendx,1]:=aGame.WByteArr[1];
      if syncwbytendx<255 then inc(syncwbytendx) else syncwbytendx:=0;
      if syncwbytendx > 50 then
      begin
        startsyncwbyte:=false;
        syncwbytendx:=0;
        k:=Fullsync(aGame);
        if k>0 then
        begin
          if aGame.WByte+k>255 then aGame.WByte:=aGame.WByte+k-256 else inc(aGame.WByte,k);
          if aGame.WByteArr[1]+k>255 then aGame.WByteArr[1]:=aGame.WByteArr[1]+k-256 else inc(aGame.WByteArr[1],k);
          if aGame.WByteArr[0]+k>255 then aGame.WByteArr[0]:=aGame.WByteArr[0]+k-256 else inc(aGame.WByteArr[0],k);
          myOutputDebug(['OptimLast3','fullcorr frame=',agame.RxFrameCount-285,' wship=',w]);
        end;
      end;
    end;
    if aGame.WByte=0 then exit;
    wb:=calcShipAngle(aGame.WByteArr[1]);
    k:=0;
    while not SameValue(wb, w, 0.3) do
    begin
      if CompareAngleValue(wb, w, 0.3)=LessThanValue	then   //wb<w
      begin
        myOutputDebug(['OptimLast3','corr+frame=',agame.RxFrameCount-285,' wbyte=',aGame.WByteArr[1],' wb=',wb,'wship=',w]);
        if aGame.WByte<255 then inc(aGame.WByte)else aGame.WByte:=0;
        if aGame.WByteArr[1]<255 then inc(aGame.WByteArr[1])else aGame.WByteArr[1]:=0;
        if aGame.WByteArr[0]<255 then inc(aGame.WByteArr[0])else aGame.WByteArr[0]:=0;
        if startsyncwbyte then
        begin
          for i:=0 to syncwbytendx do if wba[i,1]<255 then inc(wba[i,1]) else wba[i,1]:=0;
        end;
      end else begin
        myOutputDebug(['OptimLast3','corr-frame=',agame.RxFrameCount-285,' wbyte=',aGame.WByteArr[1],' wb=',wb,'wship=',w]);
        if aGame.WByte>0 then dec(aGame.WByte) else aGame.WByte:=255;
        if aGame.WByteArr[1]>0 then dec(aGame.WByteArr[1]) else aGame.WByteArr[1]:=255;
        if aGame.WByteArr[0]>0 then dec(aGame.WByteArr[0]) else aGame.WByteArr[0]:=255;
        if startsyncwbyte then
        begin
          for i:=0 to syncwbytendx do if wba[i,1]>0 then dec(wba[i,1]) else wba[i,1]:=255;
        end;
      end;
      inc(k);
      if k>14 then
      begin
        k:=scan(w);
        if k=high(integer) then
          k:=scan(w);
        aGame.WByteArr[1]:=k;
        aGame.WByteArr[0]:=k;
        aGame.WByte:=k;
        syncwbytendx:=0;
        k:=0;
      end;
      wb:=calcShipAngle(aGame.WByteArr[1]);
    end;
  end;
end;

function StartPosition(aGame:TAstGame):boolean;
var w,x,y:integer;
begin
  result:=false;
  if (aGame.Objects.Stones.Count=0) and (aGame.Objects.apShots.Count=0) and (aGame.Objects.pSaucer=nil) then
  begin
    result:=true;
    w:=round(-PI/4*1000);
    x:=aGame.Objects.pShip.x;
    y:=aGame.Objects.pShip.y;
    if (x>524) and (y>371) then w:=round(PI/4*1000);
    if (x>524) and (y<371) then w:=round(-PI/4*1000);
    if (x<524) and (y>371) then w:=round(PI/4*3*1000);
    if (x<524) and (y<371) then w:=round(-PI/4*3*1000);
    Form1.aJob.RotateFrames(round(DiffAngle(w,aGame.ShipAngle)/(3000*2*PI/256)));
  end;
end;
procedure CheckIfShotLost(aGame:TAstGame);
var i:integer;pObj     : TAstObject;
begin
  if (aGame.LastFireFrame>0) and (aGame.LastFireFrame<agame.RxFrameCount-1) then
  begin
    myOutputDebug(['shot lost frame=',agame.RxFrameCount-285,' shot=',aGame.LastFireFrame-285]);
    for i:=0 to aGame.Objects.Stones.Count-1 do
    begin
      pObj:=aGame.Objects.Stones[i];
      if pObj.FireFrame=aGame.LastFireFrame then
      begin
        pObj.shot:=0;
        pObj.nshots:=0;
        myOutputDebug(['shot lost stone=',agame.RxFrameCount-285,' stone=',i]);
      end;
    end;
    pObj:=aGame.Objects.pSaucer;
    if (pObj<>nil) and (pObj.FireFrame=aGame.LastFireFrame) then
    begin
        pObj.shot:=0;
        myOutputDebug(['shot lost soucer frame=',agame.RxFrameCount-285,' shot=',aGame.LastFireFrame-285]);
    end;
    aGame.LastFireFrame:=0;
  end;
end;

function getFreeShots(aGame:TAstGame):integer;
var i:integer;
begin
  result:=0;
  for i:=0 to aGame.Objects.Shots.Count-1 do
  begin
    if aGame.Objects.Shots[i].ownshot then inc(result);
  end;
  result:=4-result;//maximal vier schsse glechzeitig
end;
function StoneInBetween(tr:TTriangle;apObj:TAstObject;aGame:TAstGame):TAstObject;
var i,angle:integer;pObj:TAstObject; trn:TTriangle;
begin
  result:=nil;
  for i:=0 to aGame.Objects.Stones.Count-1 do
  begin
    pObj:=aGame.Objects.Stones[i];
    if pObj=apObj then continue;
    if pObj.shot>0 then continue;
    if pObj.frames<=3 then continue;
    trn:=CalcVorhalteWinkel(aGame.Objects.pShip,pObj);
    if trn.a<tr.a then
    begin
      angle:=round(arctan((pObj.nRadiusX)/(tr.a/1000))*1000);
      if abs(DiffAngle(trn.w,aGame.ShipAngle))< abs(angle) then result:= pObj;
     end;
  end;
end;

function doShots(shots,dist:integer;tr:TTriangle;pObj:TAstObject;aGame:TAstGame):integer;
var Frames2Hit:integer;apObj:TAstObject;
begin
     apObj:=StoneInBetween(tr,pObj,aGame);
     if apObj<>nil then
     begin
      myOutputDebug(['OptimLast4',' Between frame',agame.RxFrameCount-285,' w ',Rad2Degr(tr.w),' sa ',Rad2Degr(aGame.ShipAngle)]);
      pObj:=apObj;
      tr:=CalcVorhalteWinkel(aGame.Objects.pShip,pObj);
      dist:=tr.a;
     end;
     Frames2Hit:=(dist-pObj.nRadiusX*1000) div 8000  + 2+1;
     if Frames2Hit<=ShotLengthFinder.GetActHitDistFrames(agame.RxFrameCount) then
     begin
       shots:=Form1.aJob.StartNShots(shots);
       pObj.nshots:=pObj.nshots+shots;
       if (shots>0) and (pObj.shot<=0) then
       begin
          myOutputDebug(['OptimLast4','fire frame=',agame.RxFrameCount-285,' shots=',shots]);
         aGame.LastFrames2HitTarget:=Frames2Hit;
         pObj.shot:=Frames2Hit;
         pObj.FireFrame:=agame.RxFrameCount;
         aGame.LastFireFrame:=agame.RxFrameCount;
       end;
     end else shots:=0;
     result:=shots;
end;
function FramesTillShot(ObjRadius,RichtungSchiff,AbstandzuZiel,RichtungzuZiel,GeschwindigkeitZiel,BewegungsrichtungZiel:integer):integer;
var
c,   //Abstand zwischen Ziel und Schiff
wa, //Winkel zwischen Laufrichtung Ziel und Richtung Ziel-Schiff
a,b,wb,wc,b1,a1:extended;
begin
    c:=AbstandzuZiel/1000;b:=0;a:=0;
    wa:=PI-Abs(DiffAngle(BewegungsrichtungZiel,RichtungzuZiel)/1000);
    wb:=Abs(DiffAngle(RichtungSchiff,RichtungzuZiel)/1000);
    wc:=PI-(wa+wb);
    if wc<=0 then begin result:=High(integer); exit;end;//Schiff kann Ziel nicht treffen;
    if wc>=PI then begin result:=0; exit;end;//Ziel kommt direkt auf Schiff zu und Schiff zielt direkt auf Ziel;
    if wb<=0 then begin result:=0;exit;end;//Schiff zielt direkt auf Ziel;
    if GeschwindigkeitZiel=0 then begin result:=-1; exit;end;//Schiff kann Ziel nicht treffen;
    if wa<=0  then begin result:=round2((c-ObjRadius/sin(wb))/(GeschwindigkeitZiel/100)); exit; end;//Ziel kommt direkt auf Schiff zu
    if wa>=PI then begin b:=c/sin(wc)*sin(wb);a:=Sqrt(b*b+c*c+2*b*c);end;//Ziel entfernt sich direkt vom Schiff
    if wa>PI/2 then begin b:=c/sin(wc)*sin(wb);a:=Sqrt(b*b+c*c-2*b*c*cos(wa)); end;//entfernt sich vom Schiff
    if wa<PI/2 then begin a:=c/sin(wc)*sin(wa);b:=Sqrt(a*a+c*c-2*a*c*cos(wb)); end;//nhert sich dem Schiff
    b1:=ObjRadius/sin(wc);
    a1:=ObjRadius/tan(wc);
    result:=Round2((b-b1)/(GeschwindigkeitZiel/100))-Round2((a-a1)/8);
end;

procedure Aim2Target(tr:TTriangle;shotFrames:integer;pObj:TAstObject; aGame:TAstGame);
var f,k,angle,rotFrames,moveDir:integer;
// GeschwindigkeitZiel,BewegungsrichtungZiel,Radius:integer;
begin
     angle:=round(arctan((pObj.nRadiusX+pObj.nRadiusY)/2/(tr.a/1000))*1000);
     moveDir:=round(1000*ArcTan2(pObj.dy, pObj.dx));
     f:=-Round(sign(100*Sin((tr.w-moveDir)/1000)));
     k:=DiffAngle(tr.w,aGame.ShipAngle);
     if (abs(k)>Abs(angle)) then
     begin
       rotFrames:=(f+sign(k)) div 2;
       if rotFrames<>0 then
       begin
         Form1.aJob.RotateFrames(rotFrames);
         myOutputDebug(['OptimLast4','optAjust ',rotFrames, 'signk=',sign(k),'f=',f,' angle ',Rad2Degr(angle)
         ,' DiffAngle ',Rad2Degr(k)
         ]);
       end else
       begin
{         GeschwindigkeitZiel:=Round(Sqrt(pObj.dx*pObj.dx+pObj.dy*pObj.dy));
         BewegungsrichtungZiel:=round(ArcTan2(pObj.dy, pObj.dx)*1000);
         k:=FramesTillShot(pObj.nRadiusX,aGame.ShipAngle,tr.c,tr.wrz,GeschwindigkeitZiel,BewegungsrichtungZiel);
         myOutputDebug(['OptimLast4','HitDist ',HitDist,'tr.a ',tr.a div 1000
         ,' TillShot=',k,' tr.c=',tr.c div 1000
         ]); }
       end;
     end else
     if shotFrames<75 then
     begin
       k:=doShots(1,tr.a,tr,pObj,aGame);
       myOutputDebug(['OptimLast4','optfire frame ',agame.RxFrameCount-285, 'tra=',tr.a, 'shots=',k]);
     end;
end;

function huntSaucer(aGame:TAstGame):boolean;
var pObj : TAstObject;tr:TTriangle;shotFrames,rotFrames:integer;
    tra:TTriangleArray;
begin
  result:=false;
  pObj:=aGame.Objects.pSaucer;
  if pObj=nil then exit;
  if pObj.shot<>0 then exit;
  tra:=CalcLeadAngles(aGame.Objects.pShip,pObj,aGame.ShipAngle);
  if (tra[1].w<>high(integer)) and (tra[1].a<tra[0].a) then
    tr:=tra[1] else tr:=tra[0];
  shotFrames:=tr.a div 8000;
  rotFrames:=round(DiffAngle(tr.w,aGame.ShipAngle)/(3000*2*PI/256));
  Form1.aJob.RotateFrames(rotFrames);
  begin
    myOutputDebug(['UFOfire',agame.RxFrameCount-285,' ',pObj.Id,' ',pObj.x,' ',pObj.y,' ',pObj.dx,' ',pObj.dy,' fr ',pObj.frames]);
    Aim2Target(tr,shotFrames,pObj,aGame);
  end;
  result:=true;
end;

function CheckSoucerShotCollision(aGame:TAstGame):boolean;
var Frames,i,ownshots:integer;
begin
  result:=false; ownshots:=0;
  for i:=0 to aGame.Objects.apShots.Count-1 do
  begin
    if aGame.Objects.apShots[i].ownshot then begin inc(ownshots); continue;end;
    if aGame.Objects.apShots[i].frames<5 then continue;
    myOutputDebug(['OptimLast4','CheckSoucerShotCollision','shotat1- ',agame.RxFrameCount-285,' ',aGame.Objects.apShots[i].frames]);
    Frames:=FramesTillCollision(aGame.Objects.pShip,aGame.Objects.apShots[i]);
    if Frames<0 then continue;
    myOutputDebug(['OptimLast4','CheckSoucerShotCollision','shotat2- ',agame.RxFrameCount-285,' ',Frames]);
    if Frames<6 then
    begin
      myOutputDebug(['OptimLast4','CheckSoucerShotCollision','Hyperspace ',agame.RxFrameCount-285,' ',Frames]);
      aGame.Hyperspace;
      Form1.aJob.Reset;
      result:=true;
      break;
    end;
  end;
  if (aGame.Objects.apShots.Count>1) and (aGame.Objects.pSaucer<>nil)then
    myOutputDebug(['OptimLast4','CheckSoucerShotCollision',' sum- ',agame.RxFrameCount-285
    ,'Shotcount ',aGame.Objects.apShots.Count,'omwncount ',ownshots]);
end;

type TShotAvail=array[1..4] of integer;
function ShotsInxFramesAvailable(aGame:TAstGame):TShotAvail;
var i,s:integer;x:TShotAvail;
begin
  for i:=1 to 4 do x[i]:=-1;
  for i:=0 to aGame.Objects.Shots.Count-1 do
  begin
    if not aGame.Objects.Shots[i].ownshot then continue;
    s:=aGame.Objects.Shots[i].shot;
    if s>=x[4] then
    begin
      x[1]:=x[2];x[2]:=x[3];x[3]:=x[4];x[4]:=s;
    end else if s>=x[3] then
    begin
      x[1]:=x[2];x[2]:=x[3];x[3]:=s;
    end else if s>=x[2] then
    begin
      x[1]:=x[2];x[2]:=s;
    end else if s>=x[1] then x[1]:=s;
  end;
  result:=x;
end;
function OptimalSequence(aGame:TAstGame):boolean;
var i,k,StoneCount,shotAt,rotFrames,shotFrames,rotFrames1
,shotFrames1:integer;tr:TTriangle; pObj     : TAstObject;
    StoneInfo1:array[0..8] of TStoneInfo;
    StoneInfo1a:array[0..8] of TStoneInfo;
    tra:TTriangleArray;
    const GradPerFrame= 360/256*3;
          RadPerFrame= 360/256*3*PI/180;
begin
  result:=false;
  if aGame.Objects.Stones.Count=0 then exit;
  if aGame.Objects.Stones.Count>9 then exit;
  k:=0;StoneCount:=0;shotAt:=0;
  for i:=0 to aGame.Objects.Stones.Count-1 do
  begin
    pObj:=aGame.Objects.Stones[i];
    if pObj.nScale<>14 then exit;
    if pObj.shot>0 then begin inc(shotAt);continue; end;
    inc(StoneCount);
    if pObj.frames<=1 then continue;
    tra:=CalcLeadAngles(aGame.Objects.pShip,pObj,aGame.ShipAngle);
    StoneInfo1[k].rotAngle:=DiffAngle(tra[0].w,aGame.ShipAngle);
    StoneInfo1[k].rotFrames:=abs(round(StoneInfo1[k].rotAngle/(3000*PI/128)));
    StoneInfo1[k].shotFrames:=tra[0].a div 8000;
    StoneInfo1[k].w:=tra[0].w;
    StoneInfo1[k].pObj:=PObj;
    StoneInfo1[k].Triangle:=tra[0];
    StoneInfo1a[k].w:=tra[1].w;
    if tra[1].w<>high(integer) then
    begin
      StoneInfo1a[k].rotAngle:=DiffAngle(tra[1].w,aGame.ShipAngle);
      StoneInfo1a[k].rotFrames:=abs(round(StoneInfo1a[k].rotAngle/(3000*PI/128)));
      StoneInfo1a[k].shotFrames:=tra[1].a div 8000;
      StoneInfo1a[k].pObj:=PObj;
      StoneInfo1a[k].Triangle:=tra[1];
    end;
    inc(k);
  end;
  if k<6 then
     myOutputDebug(['OptimLast4','Optim k ',k,'shotAt ',shotAt,'StoneCount ',StoneCount,'Count ',aGame.Objects.Stones.Count]);
  if (k=1) and (StoneCount=1) then
  begin
      i:=0;
      if StoneInfo1a[i].w<>high(integer) then
      myOutputDebug(['OptimLast4','Optim1 i ',i
      ,' c=',aGame.Objects.Stones.Count
      ,' trw=',Rad2Degr(StoneInfo1[i].w)
      ,' r1f=',StoneInfo1[i].rotFrames
      ,' s1f=',StoneInfo1[i].shotFrames
      ,' trwa=',Rad2Degr(StoneInfo1a[i].w)
      ,' r1fa=',StoneInfo1a[i].rotFrames
      ,' s1fa=',StoneInfo1a[i].shotFrames
       ]) else
      myOutputDebug(['OptimLast4','Optim1 i ',i
      ,' c=',aGame.Objects.Stones.Count
      ,' trw=',Rad2Degr(StoneInfo1[i].w)
      ,' r1f=',StoneInfo1[i].rotFrames
      ,' s1f=',StoneInfo1[i].shotFrames
       ]);
     rotFrames1:=0;shotFrames1:=0;
    tr:=StoneInfo1[0].Triangle;
    rotFrames:=round(StoneInfo1[0].rotAngle/(3000*2*PI/256));
    shotFrames:=StoneInfo1[0].shotFrames;
    if rotFrames<5 then dec(shotFrames);
    if StoneInfo1a[0].w<>high(integer) then
    begin
      rotFrames1:=round(StoneInfo1a[0].rotAngle/(3000*2*PI/256));
      shotFrames1:=StoneInfo1a[0].shotFrames;
    end;
    if (StoneInfo1a[0].w<>high(integer)) and ((shotFrames>68) or (abs(rotFrames1)+shotFrames1<abs(rotFrames)+shotFrames)) then
    begin
      tr:=StoneInfo1a[0].Triangle;
      myOutputDebug(['OptimLast4','2ro frame ',agame.RxFrameCount-285,' trw ',Rad2Degr(tr.w),'wship=',Rad2Degr(aGame.ShipAngle)
      ,' rotFrames=',rotFrames,' shotFrames=',shotFrames
      ,' rotFrames1=',rotFrames1,' shotFrames1=',shotFrames1,' shotat=',shotat]);
      shotFrames:=shotFrames1;
      rotFrames:=rotFrames1;
    end else
      myOutputDebug(['OptimLast4','1ro frame ',agame.RxFrameCount-285,' trw ',Rad2Degr(tr.w)
      ,'wship=',Rad2Degr(aGame.ShipAngle),' rotFrames=',rotFrames,' shotFrames=',shotFrames,' shotat=',shotat]);

    Form1.aJob.RotateFrames(rotFrames);
    pObj:= StoneInfo1[0].pObj;
    if abs(rotFrames)<1 then Aim2Target(tr,shotFrames,pObj,aGame);
    result:=true;
    exit;
  end;
  if (k=2) and (StoneCount=2) then
  begin
  for i:=0 to 1 do
      if StoneInfo1a[i].w<>high(integer) then
      myOutputDebug(['OptimLast4','Optim2 i ',i
      ,' c=',aGame.Objects.Stones.Count
      ,' trw=',Rad2Degr(StoneInfo1[i].w)
      ,' r1f=',StoneInfo1[i].rotFrames
      ,' s1f=',StoneInfo1[i].shotFrames
      ,' trwa=',Rad2Degr(StoneInfo1a[i].w)
      ,' r1fa=',StoneInfo1a[i].rotFrames
      ,' s1fa=',StoneInfo1a[i].shotFrames
       ]) else
      myOutputDebug(['OptimLast4','Optim2 i ',i
      ,' c=',aGame.Objects.Stones.Count
      ,' trw=',Rad2Degr(StoneInfo1[i].w)
      ,' r1f=',StoneInfo1[i].rotFrames
      ,' s1f=',StoneInfo1[i].shotFrames
       ]);

    AstCompare.Reset;
    AstCompare.MinFrame(StoneInfo1[0],StoneInfo1[1].pObj,0);
    AstCompare.MinFrame(StoneInfo1a[0],StoneInfo1[1].pObj,0);
    AstCompare.MinFrame(StoneInfo1[1],StoneInfo1[0].pObj,0);
    AstCompare.MinFrame(StoneInfo1a[1],StoneInfo1[0].pObj,0);
    if AstCompare.FMinFrames=High(integer) then exit;
    rotFrames:=round(DiffAngle(AstCompare.FStone1.w,aGame.ShipAngle)/(3000*2*PI/256));
    Form1.aJob.RotateFrames(rotFrames);
    myOutputDebug(['OptimLast4','frame',agame.RxFrameCount-285,' minframes ',AstCompare.FMinFrames
         ,' shipa=',Rad2Degr(aGame.ShipAngle),' trw=',Rad2Degr(AstCompare.FStone1.w)
      ,' rotFrames=',rotFrames
      ]);
    if abs(rotFrames)<1 then Aim2Target(AstCompare.FStone1.Triangle,AstCompare.FStone1.ShotFrames,AstCompare.FStone1.pObj,aGame);
    result:=true;
    exit;
  end;
  if (k=3) and (StoneCount=3) then
  begin
  for i:=0 to 2 do
    if StoneInfo1a[i].w<>high(integer) then
      myOutputDebug(['OptimLast4','Optim3 i ',i
      ,' c=',aGame.Objects.Stones.Count
      ,' trw=',Rad2Degr(StoneInfo1[i].w)
      ,' r1f=',StoneInfo1[i].rotFrames
      ,' s1f=',StoneInfo1[i].shotFrames
      ,' trwa=',Rad2Degr(StoneInfo1a[i].w)
      ,' r1fa=',StoneInfo1a[i].rotFrames
      ,' s1fa=',StoneInfo1a[i].shotFrames
       ]) else
      myOutputDebug(['OptimLast4','Optim3 i ',i
      ,' c=',aGame.Objects.Stones.Count
      ,' trw=',Rad2Degr(StoneInfo1[i].w)
      ,' r1f=',StoneInfo1[i].rotFrames
      ,' s1f=',StoneInfo1[i].shotFrames
       ]);
    AstCompare2.Reset;
    AstCompare2.MinFrame(StoneInfo1[0],StoneInfo1[1].pObj,StoneInfo1[2].pObj,0);
    AstCompare2.MinFrame(StoneInfo1a[0],StoneInfo1[1].pObj,StoneInfo1[2].pObj,0);
    AstCompare2.MinFrame(StoneInfo1[1],StoneInfo1[0].pObj,StoneInfo1[2].pObj,0);
    AstCompare2.MinFrame(StoneInfo1a[1],StoneInfo1[0].pObj,StoneInfo1[2].pObj,0);
    AstCompare2.MinFrame(StoneInfo1[2],StoneInfo1[0].pObj,StoneInfo1[1].pObj,0);
    AstCompare2.MinFrame(StoneInfo1a[2],StoneInfo1[0].pObj,StoneInfo1[1].pObj,0);
    if AstCompare2.FMinFrames=High(integer) then exit;
    rotFrames:=round(DiffAngle(AstCompare2.FStone1.w,aGame.ShipAngle)/(3000*2*PI/256));
    Form1.aJob.RotateFrames(rotFrames);
    myOutputDebug(['OptimLast4','frame',agame.RxFrameCount-285,' minframes ',AstCompare2.FMinFrames
           ,' shipa=',Rad2Degr(aGame.ShipAngle),' trw=',Rad2Degr(AstCompare2.FStone1.w)
        ,' rotFrames=',rotFrames
        ]);
    if abs(rotFrames)<1 then Aim2Target(AstCompare2.FStone1.Triangle,AstCompare2.FStone1.ShotFrames,AstCompare2.FStone1.pObj,aGame);
    result:=true;
  end;
  if (k=4) and (StoneCount=4) then
  begin
  for i:=0 to 3 do
    if StoneInfo1a[i].w<>high(integer) then
      myOutputDebug(['OptimLast4','Optim4 i ',i
      ,' c=',aGame.Objects.Stones.Count
      ,' trw=',Rad2Degr(StoneInfo1[i].w)
      ,' r1f=',StoneInfo1[i].rotFrames
      ,' s1f=',StoneInfo1[i].shotFrames
      ,' trwa=',Rad2Degr(StoneInfo1a[i].w)
      ,' r1fa=',StoneInfo1a[i].rotFrames
      ,' s1fa=',StoneInfo1a[i].shotFrames
       ]) else
      myOutputDebug(['OptimLast4','Optim4 i ',i
      ,' c=',aGame.Objects.Stones.Count
      ,' trw=',Rad2Degr(StoneInfo1[i].w)
      ,' r1f=',StoneInfo1[i].rotFrames
      ,' s1f=',StoneInfo1[i].shotFrames
       ]);
    AstCompare3.Reset;
    AstCompare3.MinFrame(StoneInfo1[0],StoneInfo1[1].pObj,StoneInfo1[2].pObj,StoneInfo1[3].pObj,0);
    AstCompare3.MinFrame(StoneInfo1a[0],StoneInfo1[1].pObj,StoneInfo1[2].pObj,StoneInfo1[3].pObj,0);
    AstCompare3.MinFrame(StoneInfo1[1],StoneInfo1[0].pObj,StoneInfo1[2].pObj,StoneInfo1[3].pObj,0);
    AstCompare3.MinFrame(StoneInfo1a[1],StoneInfo1[0].pObj,StoneInfo1[2].pObj,StoneInfo1[3].pObj,0);
    AstCompare3.MinFrame(StoneInfo1[2],StoneInfo1[0].pObj,StoneInfo1[1].pObj,StoneInfo1[3].pObj,0);
    AstCompare3.MinFrame(StoneInfo1a[2],StoneInfo1[0].pObj,StoneInfo1[1].pObj,StoneInfo1[3].pObj,0);
    AstCompare3.MinFrame(StoneInfo1[3],StoneInfo1[0].pObj,StoneInfo1[1].pObj,StoneInfo1[2].pObj,0);
    AstCompare3.MinFrame(StoneInfo1a[3],StoneInfo1[0].pObj,StoneInfo1[1].pObj,StoneInfo1[2].pObj,0);
    if AstCompare3.FMinFrames=High(integer) then exit;
    rotFrames:=round(DiffAngle(AstCompare3.FStone1.w,aGame.ShipAngle)/(3000*2*PI/256));
    Form1.aJob.RotateFrames(rotFrames);
    myOutputDebug(['OptimLast4','frame',agame.RxFrameCount-285,' minframes ',AstCompare3.FMinFrames
           ,' shipa=',Rad2Degr(aGame.ShipAngle),' trw=',Rad2Degr(AstCompare3.FStone1.w)
        ,' rotFrames=',rotFrames
        ]);
    if abs(rotFrames)<1 then Aim2Target(AstCompare3.FStone1.Triangle,AstCompare3.FStone1.ShotFrames,AstCompare3.FStone1.pObj,aGame);
    result:=true;
  end;
  if (k=5) and (StoneCount=5) then
  begin
  for i:=0 to 4 do
    if StoneInfo1a[i].w<>high(integer) then
      myOutputDebug(['OptimLast4','Optim5 i ',i
      ,' c=',aGame.Objects.Stones.Count
      ,' trw=',Rad2Degr(StoneInfo1[i].w)
      ,' r1f=',StoneInfo1[i].rotFrames
      ,' s1f=',StoneInfo1[i].shotFrames
      ,' trwa=',Rad2Degr(StoneInfo1a[i].w)
      ,' r1fa=',StoneInfo1a[i].rotFrames
      ,' s1fa=',StoneInfo1a[i].shotFrames
       ]) else
      myOutputDebug(['OptimLast4','Optim5 i ',i
      ,' c=',aGame.Objects.Stones.Count
      ,' trw=',Rad2Degr(StoneInfo1[i].w)
      ,' r1f=',StoneInfo1[i].rotFrames
      ,' s1f=',StoneInfo1[i].shotFrames
       ]);
    AstCompare4.Reset;
    AstCompare4.MinFrame(StoneInfo1[0],StoneInfo1[1].pObj,StoneInfo1[2].pObj,StoneInfo1[3].pObj,StoneInfo1[4].pObj);
    AstCompare4.MinFrame(StoneInfo1a[0],StoneInfo1[1].pObj,StoneInfo1[2].pObj,StoneInfo1[3].pObj,StoneInfo1[4].pObj);
    AstCompare4.MinFrame(StoneInfo1[1],StoneInfo1[0].pObj,StoneInfo1[2].pObj,StoneInfo1[3].pObj,StoneInfo1[4].pObj);
    AstCompare4.MinFrame(StoneInfo1a[1],StoneInfo1[0].pObj,StoneInfo1[2].pObj,StoneInfo1[3].pObj,StoneInfo1[4].pObj);
    AstCompare4.MinFrame(StoneInfo1[2],StoneInfo1[0].pObj,StoneInfo1[1].pObj,StoneInfo1[3].pObj,StoneInfo1[4].pObj);
    AstCompare4.MinFrame(StoneInfo1a[2],StoneInfo1[0].pObj,StoneInfo1[1].pObj,StoneInfo1[3].pObj,StoneInfo1[4].pObj);
    AstCompare4.MinFrame(StoneInfo1[3],StoneInfo1[0].pObj,StoneInfo1[1].pObj,StoneInfo1[2].pObj,StoneInfo1[4].pObj);
    AstCompare4.MinFrame(StoneInfo1a[3],StoneInfo1[0].pObj,StoneInfo1[1].pObj,StoneInfo1[2].pObj,StoneInfo1[4].pObj);
    AstCompare4.MinFrame(StoneInfo1[4],StoneInfo1[0].pObj,StoneInfo1[1].pObj,StoneInfo1[2].pObj,StoneInfo1[3].pObj);
    AstCompare4.MinFrame(StoneInfo1a[4],StoneInfo1[0].pObj,StoneInfo1[1].pObj,StoneInfo1[2].pObj,StoneInfo1[3].pObj);
    if AstCompare4.FMinFrames=High(integer) then exit;
    rotFrames:=round(DiffAngle(AstCompare4.FStone1.w,aGame.ShipAngle)/(3000*2*PI/256));
    Form1.aJob.RotateFrames(rotFrames);
    myOutputDebug(['OptimLast4','frame',agame.RxFrameCount-285,' minframes ',AstCompare4.FMinFrames
           ,' shipa=',Rad2Degr(aGame.ShipAngle),' trw=',Rad2Degr(AstCompare4.FStone1.w)
        ,' rotFrames=',rotFrames
        ]);
    if abs(rotFrames)<1 then Aim2Target(AstCompare4.FStone1.Triangle,AstCompare4.FStone1.ShotFrames,AstCompare4.FStone1.pObj,aGame);
    result:=true;
  end;
end;
type Tavg=record
                rotFrames :integer;
                 freeFrames :integer;
                 colFrames :integer;
                 shotat:integer;
                 distdelay:integer;
                 distance :integer;
                 pObj:TAstObject;
                end;

var avgdist:integer;
avgStones:  array[0..27] of Tavg;
function CalcDistInXFrames(pShip,p0: TAstObject;Frames:integer): integer;
var dxy:TPoint;x1,y1:integer;
begin
  dxy:=CalcDistXY(pShip,p0);
  x1:=dxy.X+p0.dx*Frames div 100;
  y1:=dxy.y+p0.dy*Frames div 100;
  while x1>= 512 do Dec(x1,1024);
  while x1<=-512 do Inc(x1,1024);
  while y1>= 384 do Dec(y1,768);
  while y1<=-384 do Inc(y1,768);
  Result:=Round(Sqrt(x1*x1+y1*y1));
end;
procedure PrepInOut(aGame:TAstGame);
var i,m,md,nStones,
shotat,distdelay,sumdist,distance:integer; pObj     : TAstObject;
io1,io,BigStones,SmallStones:integer;
begin
  nStones:=aGame.Objects.Stones.Count; sumdist:=0;io:=0;io1:=0;
  BigStones:=0;SmallStones:=0;
  if nStones=0 then exit;
  for i:=0 to nStones-1 do
  begin
    pObj:=aGame.Objects.Stones[i];
    distance:=CalcDist(aGame.Objects.pShip,pObj);
    distdelay:=CalcDistInXFrames(aGame.Objects.pShip,pObj,180+30);
    avgStones[i].distdelay:=distdelay;
    avgStones[i].distance:=distance;
    avgStones[i].pObj:=pObj;
    sumdist:=sumdist+distance;
    if pObj.shot>0 then continue;
    if pObj.nScale=14 then inc(SmallStones);
    if pObj.nScale<>14 then inc(BigStones);
    if pObj.nScale=14 then continue;
  end;
  avgdist:=sumdist div nStones -100;
//  avgdist:=sumdist div nStones -100-50;
  for i:=0 to nStones-1 do
  begin
    pObj:=aGame.Objects.Stones[i];
   // if nVStones<7+1 then
  //  if nVStones<3 then
   if (SmallStones<5) and ((BigStones=1) or (BigStones=1)) then
   begin
    avgStones[i].shotat:=0;
    if pObj.nScale<>14 then
    begin
    avgStones[i].shotat:=-1;
      myOutputDebug(['INOUT',' bsto ',agame.RxFrameCount-285
      ,' nStones=',nStones
      ,' io=',io
      ,' io1=',io1
      ,' avgdist=',avgdist
        ]);
    end;
    continue;
   end;
   if (SmallStones<6) or (BigStones<2) then
   begin
      avgStones[i].shotat:=0;
      continue;
   end;
    pObj:=aGame.Objects.Stones[i];shotat:=0;
    m:=avgdist-avgStones[i].distance; //+innerhalb
    md:=avgdist-avgStones[i].distdelay; //+innerhalb
    if (sign(m)=-1) and (sign(md)=1) then shotat:=md-m;
    if shotat<>0 then inc(io);
    if pObj.nScale=14 then shotat:=0;
    if shotat<>0 then inc(io1);
    avgStones[i].shotat:=shotat;
 end;
      myOutputDebug(['INOUT',' INOUT ',agame.RxFrameCount-285
      ,' nStones=',nStones
      ,' io=',io
      ,' io1=',io1
      ,' avgdist=',avgdist
        ]);
end;
procedure ShotOnSight(aGame:TAstGame);
var i,k,nStones,angle,shots:integer;tr:TTriangle; pObj     : TAstObject;
begin
  nStones:=aGame.Objects.Stones.Count;
  for i:=0 to nStones-1 do
  begin
    pObj:=aGame.Objects.Stones[i];
    if avgStones[i].shotat>0 then continue;
    if pObj.frames<=1 then continue;
    if (pObj.shot>0) and ((pObj.nScale=14) or (pObj.FireFrame<=agame.RxFrameCount-3)) then continue; //bei grossen Steinen 2.Schuss ermglichen
    tr:=CalcVorhalteWinkel(aGame.Objects.pShip,pObj);
//    tr:=CalcLeadAngle(aGame.Objects.pShip,pObj,aGame.ShipAngle);
    if tr.w=-999999 then continue;
    if pObj.nScale=0 then angle:=round(arctan(StoneSizeMedium/(tr.a/1000))*1000) else
    angle:=round(arctan((pObj.nRadiusX+pObj.nRadiusY)/2/(tr.a/1000))*1000);
    k:=DiffAngle(tr.w,aGame.ShipAngle);
    if (abs(k)<Abs(angle)) and (tr.a-pObj.nRadiusX<=560000+8000) then  //68-544/69-552/70-560 frames
    begin
     if (aGame.Objects.Stones.Count+aGame.Objects.apExplos.Count>23) and (pObj.nScale<>14) then  //buffer voll: nur mehr kleine Steine absch.
     begin
       continue;
     end;
     if (aGame.Objects.Stones.Count>20) and (tr.a>400000)and (aGame.Objects.shots.Count>=3) then
     begin
       myOutputDebug(['OptimLast4','SkipLong',agame.RxFrameCount-285,'stones ',aGame.Objects.Stones.Count,'tra ',tr.a]);
       continue;
     end;
      if nStones=1 then shots:=2 else shots:=1;   //auf letzen Stein 2 mal feuern
      if pObj.nScale=0 then
      begin
        angle:=round(arctan(StoneSizeSmall/(tr.a/1000))*1000);
        if (aGame.Objects.BigStones=aGame.Objects.Stones.Count)and (pObj.frames>6) then
        begin
          if (abs(k)>2*PI/180) and (abs(k)<3*PI/180) then shots:=1 else
          shots:=0; //keinen oder mehrere schsse
        end;
//        angle:=round(arctan(StoneSizeMedium/(tr.a/1000))*1000);
        if (abs(k)<Abs(angle)) and ((tr.a<200000)or (nStones<=2) or
          ((aGame.Objects.BigStones=aGame.Objects.Stones.Count) and (pObj.frames>6))) then
          shots:=4;
        if pObj.nshots+shots >= 4 then shots:=4 - pObj.nshots;  //beim Nachschuss nicht mehr als 4 Schsse abfeuern
      end;
      if pObj.nScale=15 then
      begin
        angle:=round(arctan(StoneSizeSmall/(tr.a/1000))*1000);
        if (abs(k)<Abs(angle)) and ((tr.a<200000) or (nStones<=2)) then
        shots:=3;
        if pObj.nshots+shots >= 3 then shots:=3 - pObj.nshots;
      end;
      doShots(shots,tr.a,tr,pObj,aGame);
    end;
 end;
end;
type
 TColResult=record
                 freeFrames :integer;
                 ndx :integer;
                end;
 TColInfo=record
                 rotFrames :integer;
                 freeFrames :integer;
                 colFrames :integer;
                 angle:integer;
                 Typ:integer;
                 rotAngle :integer;
                 pObj:TAstObject;
                end;
TColInfoAr=array[0..28] of TColInfo;
function OptimizeColl(aGame:TAstGame;var ColInfo:TColInfoAr;cnt,MinNdx:integer):TColResult;
var i,ia,ib,w,FreeFrames,FreeFramesA,HandicapA,HandicapB,FreeFramesB,rotFrames,
rotFramesAB,rotFramesBA,MinFrames,MinNdx2:integer;
begin
  MinFrames:=high(integer); MinNdx2:=0;
  for i:=0 to cnt-1 do
  begin
    w:= CalcAngle(aGame.Objects.pShip,ColInfo[i].pObj);
    ColInfo[i].angle:=w;
    ColInfo[i].rotFrames:=round(DiffAngle(w,aGame.ShipAngle)/(3000*2*PI/256));
    ColInfo[i].FreeFrames:=ColInfo[i].colFrames-Abs(ColInfo[i].rotFrames);
    if i=MinNdx then continue;
    if ColInfo[i].colFrames<MinFrames then
    begin
      MinFrames:=ColInfo[i].colFrames;
      MinNdx2:=i;
    end;
  end;
  if MinFrames=high(integer) then exit;
  ia:=MinNdx;ib:=MinNdx2; HandicapA:=0;HandicapB:=0;
  if ColInfo[ia].pObj.nScale=15 then HandicapA:=4;  //mittel
  if ColInfo[ib].pObj.nScale=15 then HandicapB:=4;
  if ColInfo[ia].pObj.nScale=0 then HandicapA:=4;   //gross
  if ColInfo[ib].pObj.nScale=0 then HandicapB:=4;
  if ColInfo[ia].pObj.nScale=14 then HandicapA:=0;  //klein
  if ColInfo[ib].pObj.nScale=14 then HandicapB:=0;
  RotFrames:=Abs(round(DiffAngle(ColInfo[ia].angle,ColInfo[ib].angle)/(3000*2*PI/256)));
  RotFramesAB:=Abs(ColInfo[ia].rotFrames)+RotFrames;
  FreeFramesA:=Min(ColInfo[ib].colFrames-RotFramesAB,ColInfo[ia].FreeFrames);
  RotFramesBA:=Abs(ColInfo[ib].rotFrames)+RotFrames;
  FreeFramesB:=Min(ColInfo[ia].colFrames-RotFramesBA,ColInfo[ib].FreeFrames);
  if FreeFramesA-HandicapA > FreeFramesB-HandicapB then
  begin
   FreeFrames:=FreeFramesA;
   i:=ia;
  end else
  begin
   FreeFrames:=FreeFramesB;
   i:=ib;
  end;
  result.ndx:=i;
  result.FreeFrames:=FreeFrames;
  myOutputDebug(['OptimLast4','coloptim ',agame.RxFrameCount-285,' RotFrames ',RotFrames,' RotFramesAB ',RotFramesAB
  ,' RotFramesBA ',RotFramesBA,' FreeFramesA ',FreeFramesA,' FreeFramesB ',FreeFramesB,' FreeFrames ',FreeFrames
  ,' ia].rotFrames ',ColInfo[ia].rotFrames,' ib].rotFrames ',ColInfo[ib].rotFrames
  ,' ia].colFrames ',ColInfo[ia].colFrames,' ib].colFrames ',ColInfo[ib].colFrames
  ]);
 end;
function CheckStoneSoucerCollision(aGame:TAstGame):boolean;
var pObj ,pObj1 : TAstObject;tr:TTriangle;MinNdx,ndx,StoneCount,rotFrames,MinFrames,FreeFrames,Frames,i,k,angle,shot,CollCount:integer;
    ColInfo:TColInfoAr;Collopt:TColResult;
const Soucer=1;
      Stone=2;
begin
  result:=false;MinFrames:=99999;pObj:=nil; CollCount:=0; StoneCount:=0;ndx:=0; MinNdx:=0;
  pObj1:=aGame.Objects.pSaucer;
  if (pObj1<>nil) and (pObj1.shot<=0) then
  begin
    Frames:=FramesTillCollision(aGame.Objects.pShip,pObj1);
    if Frames>=0 then
    begin
      MinFrames:=Frames;
      pObj:=pObj1;
      pObj.bMarked:=True;  // in der Grafik ausgefuellt darstellen
      MinNdx:=ndx;
      ColInfo[ndx].colFrames:=Frames;
      ColInfo[ndx].pObj:=pObj1;
      ColInfo[ndx].Typ:=Soucer;
      inc(ndx);
      myOutputDebug(['OptimLast4','SoucerCollision ',agame.RxFrameCount-285,'mf ',MinFrames]);
    end;
  end;
  for i:=0 to aGame.Objects.Stones.Count-1 do
  begin
    pObj1:=aGame.Objects.Stones[i];
    if pObj1.frames<1 then continue;
    if (pObj1.shot>0) and ((pObj1.nScale=14) or (pObj1.FireFrame<=agame.RxFrameCount-4)) then continue; //bei grossen Steinen 2.Schuss ermglichen
    inc(StoneCount);
    Frames:=FramesTillCollision(aGame.Objects.pShip,pObj1);
    if pObj1.Collision>1 then
    begin
      angle:=CalcAngle(aGame.Objects.pShip,pObj1);
      myOutputDebug(['OptimLast4','LastCollision ',agame.RxFrameCount-285,' i ',i,' FramesTC ',Frames,' Collision ',pObj1.Collision,' angle ',Rad2Degr(angle)]);
    end;
    if Frames<0 then continue;
    if Frames>120 then continue;
    pObj1.Collision:=Frames;
    inc(CollCount);
    if Frames<MinFrames then
    begin
      MinFrames:=Frames;
      pObj:=pObj1;
      pObj.bMarked:=True;  // in der Grafik ausgefuellt darstellen
      MinNdx:=ndx;
    end;
    ColInfo[ndx].colFrames:=Frames;
    ColInfo[ndx].pObj:=pObj1;
    ColInfo[ndx].Typ:=Stone;
    inc(ndx);
  end;
  if pObj=nil then exit;
  if MinFrames<=0 then
  begin
      myOutputDebug(['OptimLast4','CheckStoneSoucerCollision','Hyperspace ',agame.RxFrameCount-285,' ',MinFrames]);
      aGame.Hyperspace;
      Form1.aJob.Reset;
      result:=true;
      exit;
   end;
   tr:=CalcVorhalteWinkel(aGame.Objects.pShip,pObj);
   if Minframes<25then   myOutputDebug(['OptimLast4','Collision ',agame.RxFrameCount-285,' frames until coll=',MinFrames,' w ',Rad2Degr(tr.w)]);
   tr.w:= CalcAngle(aGame.Objects.pShip,pObj);
   rotFrames:=round(DiffAngle(tr.w,aGame.ShipAngle)/(3000*2*PI/256));
   frames:=MinFrames-Abs(rotFrames);
   if ndx>1 then
   begin
     Collopt:=OptimizeColl(aGame,ColInfo,ndx,MinNdx);
     pObj:=ColInfo[Collopt.ndx].pObj;
     tr:=CalcVorhalteWinkel(aGame.Objects.pShip,pObj);
     tr.w:= ColInfo[Collopt.ndx].angle;
     Minframes:=ColInfo[Collopt.ndx].colFrames;
     Freeframes:=Collopt.freeFrames;
     rotFrames:=ColInfo[Collopt.ndx].rotFrames;
     myOutputDebug(['OptimLast4','Collision ndx ',agame.RxFrameCount-285,' frames until coll=',MinFrames,
    ' rotFrames=',rotFrames,' w ',Rad2Degr(tr.w),' Freeframes=',Freeframes]);
     if Freeframes>10 then exit;
   end else
   begin;
    if (StoneCount<5) and (frames>4) then exit;
    if (CollCount<=1) and (frames>10-5) then exit;
    if (CollCount<=2) and (frames>20-5) then exit;
    if frames>15 then exit;
  end;
  Form1.aJob.RotateFrames(rotFrames);
  angle:=round(arctan((pObj.nRadiusX-1)/(tr.a/1000))*1000);
  k:=DiffAngle(tr.w,aGame.ShipAngle);
  if (rotFrames=0) or (abs(k)<Abs(angle)) then
  begin
    if pObj.nScale=14 then
      shot:=doShots(1,tr.a,tr,pObj,aGame)
    else shot:=doShots(2,tr.a,tr,pObj,aGame);
    myOutputDebug(['OptimLast4','Collision shot',agame.RxFrameCount-285,' shot ',shot]);
  end else ShotOnSight(aGame);
  myOutputDebug(['OptimLast4','Collision rot-',agame.RxFrameCount-285,' angle ',Rad2Degr(angle),' k ',Rad2Degr(k),' w ',Rad2Degr(tr.w)
  ,' Minframes ',Minframes,' wship=',Rad2Degr(aGame.ShipAngle),' rotFrames=',rotFrames,' colcount=',collcount]);
  result:=true;
end;
function CountFrames(tr:TTriangle;ShipAngle:integer;const ShotAvail:TShotAvail):integer;
var f,m,d:integer;
begin
  f:=round(abs(DiffAngle(tr.w,ShipAngle))/(3000*2*PI/256));
  f:=Max(f,ShotAvail[1]);
  if LevelCount<3 then
  begin
    m:=4;d:=1;
  end else begin m:=1; d:=1;end;
  result:=f+m*(tr.a div 8000) div d; //  /2      *anfang gut        div anfang schlecht
  result:=result*10;
end;
procedure Rotate(aGame:TAstGame);
type TRStone=record
               pObj:TAstObject;
               angle,rotFrames,opt :integer;
               tr:TTriangle;
             end;
      TRStones=array[0..27] of TRStone;
var i,k,x,w,ndx,bestk,rotFrames:integer;tr:TTriangle; pObj,pObj1: TAstObject;
ShotAvail:TShotAvail;
RStones:TRStones;
begin
  if huntSaucer(aGame) then exit;
  ShotAvail:=ShotsInxFramesAvailable(aGame);
  ndx:=0;
  for i:=0 to aGame.Objects.Stones.Count-1 do
  begin
   pObj1:=aGame.Objects.Stones[i];
   if avgStones[i].shotat>0 then continue;
   if pObj1.frames<3 then continue;
   if pObj1.shot>0 then continue;
   tr:=CalcLeadAngle(aGame.Objects.pShip,pObj1,aGame.ShipAngle);
   RStones[ndx].opt:=CountFrames(tr,aGame.ShipAngle,ShotAvail);
   RStones[ndx].tr:=tr;
   RStones[ndx].pObj:=pObj1;
   RStones[ndx].rotFrames:=round(DiffAngle(tr.w,aGame.ShipAngle)/(3000*2*PI/256));
   RStones[ndx].angle:=abs(DiffAngle(tr.w,aGame.ShipAngle));
   if avgStones[i].shotat<0 then
   begin
     if (RStones[ndx].rotFrames<>0) then
     begin
       myOutputDebug(['INOUT',' rot ',agame.RxFrameCount-285
      ,' rotframes=',RStones[ndx].rotFrames
      ,' i=',i
        ]);
       pObj1.AimFrame:=agame.RxFrameCount;
       Form1.aJob.RotateFramesObj(RStones[ndx].rotFrames,agame.RxFrameCount);
       exit;
     end;
   end;
   inc(ndx);
  end;
 if LevelCount>1 then
  for i:=0 to ndx-1 do
  begin
    x:=RStones[i].tr.a div (1000);//0-1024
    if x>300 then continue;
    x:=300-x;
    x:=x div 1;
    for k:=0 to ndx-1 do
    begin
     w:=Abs(DiffAngle(RStones[k].tr.w,RStones[i].tr.w)); //0-3140
     w:=max(w div (10),1);
     RStones[k].opt:=RStones[k].opt-x div w;
    end;
  end;
  pObj:=nil;rotFrames:=0;
  bestk:=9999999;
  for i:=0 to ndx-1 do
  begin
     tr:=RStones[i].tr;
     k:=RStones[i].opt;
     if (aGame.Objects.Stones.Count+aGame.Objects.apExplos.Count<23) or (RStones[i].pObj.nScale=14) or (bestk>999999)then
     if (k<bestk) and (tr.a<644000) then
     begin
       bestk:=k;
       rotFrames:=RStones[i].rotFrames;
       pObj:=RStones[i].pObj;
     end;
  end;
  if (pObj<>nil) and (rotFrames<>0) then
  begin
    pObj.AimFrame:=agame.RxFrameCount;
    Form1.aJob.RotateFramesObj(rotFrames,agame.RxFrameCount);
  end;
end;

procedure CalcJob(aGame:TAstGame);
begin
  if StartPosition(aGame) then exit;
  CheckIfShotLost(aGame);
  if CheckSoucerShotCollision(aGame) then exit;
  if CheckStoneSoucerCollision(aGame) then exit;
  if OptimalSequence(aGame) then exit;
  ShotOnSight(aGame);
  Rotate(aGame);
end;
procedure TForm1.OnRxFrame(Sender: TObject);
var pShip    : TAstObject;
begin
  if CheckBoxAutoStart=nil then exit;
  aGame.ResetKeys;
  if CheckBoxAutoStart.Checked and
     ((aGame.GameStatus=ags_Standby) or
      (aGame.GameStatus=ags_Highscore)) then
  begin
    aGame.StartButton;
    ShotLengthFinder.Reset;
  end;
  CalcVectorStone(aGame);
  DoStat(aGame);
  pShip:=aGame.Objects.Ship;
  if pShip=Nil then
  begin
   Form1.aJob.Reset;
   Exit;
  end;
  syncWByte(aGame);
  ShotLengthFinder.FireTestShot;
  CalcVectorShip(aGame);
  CalcVectorShot(aGame);
  CalcVectorSoucer(aGame);
  PrepInOut(aGame);
  CalcJob(aGame);
  Form1.aJob.Run;
end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  // Indy macht beim Beenden zuweilen Aerger
  agame.Free;
end;

end.
