#ifndef AIMATH_H
#define AIMATH_H

#include "aitest.h"

class Vector3
{
	public:
		Vector3();
		Vector3(const Vector3 &other);
		Vector3(const QPointF &point, double zVal);
		Vector3(double xVal, double yVal, double zVal);
		~Vector3();
		
		operator QPointF() const;
		Vector3& operator = (const Vector3 &other);

		Vector3 operator + (const Vector3 &vector) const;
		Vector3 operator - (const Vector3 &vector) const;
		
		
			
		Vector3 vectorProduct(const Vector3 &other) const;
		double scalarProduct(const Vector3 &other) const;
		double length() const;
		void normalize();

		friend Vector3 operator * (const Vector3 &vector, double factor);
		friend Vector3 operator * (double factor, const Vector3 &vector);
		friend Vector3 operator / (const Vector3 &vector, double factor); 

		double x;
		double y;
		double z;
};

class AIMath
{
	public:
		static QPair<double, double> SolveQuad(double a, double b, double c, bool &solution);
};



#endif