#include "asteroid.h"

#include "framedata.h"



QPainterPath* Asteroid::path1 = 0;
QPainterPath* Asteroid::path2 = 0;
QPainterPath* Asteroid::path3 = 0;
QPainterPath* Asteroid::path4 = 0;

Asteroid::Asteroid():
	QGraphicsItem(),data(0)
{
}

Asteroid::~Asteroid()
{
}

void Asteroid::paint(QPainter *painter, const QStyleOptionGraphicsItem *, QWidget *)
{
	if(data)
	{
		if(data->willCollide)
		{
			painter->setPen(Qt::red);
		}
		else
		{
			painter->setPen(data->color);
		}
		painter->save();
		painter->scale(1.0, -1.0);
		switch(data->size)
		{
			case Target::Small:
				painter->scale(0.25, 0.25);
				break;
			case Target::Medium:
				painter->scale(0.5, 0.5);
				break;
			case Target::Big:
			default:
				break;
		}
		painter->drawPath(*Asteroid::getPath(data->look));
		painter->drawEllipse(QRectF(-44.0, -44.0, 88.0, 88.0));
		painter->restore();
		if(data->hasSpeed)
		{
			
			QPen pen = painter->pen();
			pen.setWidthF(4.0);
			pen.setColor(Qt::red);
			painter->setPen(pen);
			
			painter->drawLine(QPointF(0.0, 0.0), data->velocity * 25 * data->vVec);
		}
	}
}

QRectF Asteroid::boundingRect() const
{
	return QRectF(-50.0, -50.0, 100.0, 100.0);
}


void Asteroid::setData(AsteroidData* dt)
{
	data = dt;
	setPos(data->position);
}


void Asteroid::GenPathes()
{
	//Asteroid Typ 1:
	path1 = new QPainterPath(QPointF(0.0, 0.0));
	path1->moveTo(28.0, 1.0);
	path1->lineTo(36.0, 21.0);
	path1->lineTo(9.0, 40.0);
	path1->lineTo(-22.0, 40.0);
	path1->lineTo(-40.0, 21.0);
	path1->lineTo(-40.0, -17.0);
	path1->lineTo(-21.0, -36.0);
	path1->lineTo(-3.0, -17.0);
	path1->lineTo(17.0, -36.0);
	path1->lineTo(36.0, -17.0);
	path1->lineTo(28.0, 1.0);

	// Asteroid Typ 2:
	path2 = new QPainterPath(QPointF(0.0, 0.0));
	path2->moveTo(2.0, -28.0);
	path2->lineTo(21.0, -36.0);
	path2->lineTo(40.0, -17.0);
	path2->lineTo(22.0, -7.0);
	path2->lineTo(40.0, 11.0);
	path2->lineTo(21.0, 39.0);
	path2->lineTo(-6.0, 31.0);
	path2->lineTo(-17.0, 39.0);
	path2->lineTo(-36.0, 20.0);
	path2->lineTo(-31.0, 2.0);
	path2->lineTo(-36.0, -17.0);
	path2->lineTo(-17.0, -36.0);
	path2->lineTo(2.0, -28.0);

	// Asteroid Typ 3:
	path3 = new QPainterPath(QPointF(0.0, 0.0));
	path3->moveTo(-9.0, -42.0);
	path3->lineTo(20.0, -42.0);
	path3->lineTo(39.0, -15.0);
	path3->lineTo(39.0, -6.0);
	path3->lineTo(20.0, 33.0);
	path3->lineTo(1.0, 33.0);
	path3->lineTo(1.0, 6.0);
	path3->lineTo(-18.0, 33.0);
	path3->lineTo(-37.0, 5.0);
	path3->lineTo(-19.0, -5.0);
	path3->lineTo(-37.0, -14.0);
	path3->lineTo(-9.0, -42.0);

	// Asteroid Typ 4:
	path4 = new QPainterPath(QPointF(0.0, 0.0));
	path4->moveTo(7.0, -37.0);
	path4->lineTo(35.0, -19.0);
	path4->lineTo(35.0, -8.0);
	path4->lineTo(8.0, 1.0);
	path4->lineTo(35.0, 20.0);
	path4->lineTo(16.0, 38.0);
	path4->lineTo(6.0, 30.0);
	path4->lineTo(-21.0, 38.0);
	path4->lineTo(-41.0, 11.0);
	path4->lineTo(-41.0, -18.0);
	path4->lineTo(-14.0, -18.0);
	path4->lineTo(-22.0, -37.0);
	path4->lineTo(7.0, -37.0);

}

void Asteroid::mousePressEvent(QGraphicsSceneMouseEvent *)
{
	if(data)
	{
		data->color = Qt::green;
	}
}

QPainterPath* Asteroid::getPath(int type)
{
	switch(type)
	{
		case 1:
			return path1;
		case 2:
			return path2;
		case 3:
			return path3;
		case 4:
			return path4;
		default:
			return path4;
	}
}