// comm_model.hpp
// --------------
//
//  (C) Copyright Gerald Thaler 2008.
//
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef INTREPID_COMM_MODEL_HPP
#define INTREPID_COMM_MODEL_HPP

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
# pragma once
#endif // defined(_MSC_VER) && (_MSC_VER >= 1200)

namespace intrepid
{
    namespace comm_model
    {
        namespace keys
        {
            static uint8_t const none       = 0x00;
            static uint8_t const hyperspace = 0x01;
            static uint8_t const fire       = 0x02;
            static uint8_t const thrust     = 0x04;
            static uint8_t const right      = 0x08;
            static uint8_t const left       = 0x10;
        }

        size_t const vectorram_size = 1024;

        struct frame_packet
        {
            uint8_t vectorram[vectorram_size];
            uint8_t frameno;
            uint8_t ping;
        };
        BOOST_STATIC_ASSERT(sizeof(frame_packet) == 1026);
        size_t const frame_packet_size = sizeof(frame_packet);

        typedef array<uint8_t, 256> ping_to_keys_map;

    } // end of namespace comm_model
} // end of namespace intrepid

#endif // include guard
