// angles.cpp
// ----------
//
//  (C) Copyright Gerald Thaler 2008.
//
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "stdafx.hpp"

#include "angles.hpp"

namespace intrepid
{
    namespace
    {
        short const orientation_map_data[64][4] =
                          {{ 1536,     0, 253,   3}, { 1528,   152,   4,   7},
                           { 1504,   296,   8,  11}, { 1472,   440,  12,  15},
                           { 1416,   584,  16,  19}, { 1360,   720,  20,  23},
                           { 1280,   856,  24,  27}, { 1192,   976,  28,  31},
                           { 1088,  1088,  32,  35}, {  976,  1192,  36,  39},
                           {  856,  1280,  40,  43}, {  720,  1360,  44,  47},
                           {  584,  1416,  48,  51}, {  440,  1472,  52,  55},
                           {  296,  1504,  56,  59}, {  152,  1528,  60,  63},
                           {    0,  1536,  64,  64}, { -152,  1528,  65,  68},
                           { -296,  1504,  69,  72}, { -440,  1472,  73,  76},
                           { -584,  1416,  77,  80}, { -720,  1360,  81,  84},
                           { -856,  1280,  85,  88}, { -976,  1192,  89,  92},
                           {-1088,  1088,  93,  96}, {-1192,   976,  97, 100},
                           {-1280,   856, 101, 104}, {-1360,   720, 105, 108},
                           {-1416,   584, 109, 112}, {-1472,   440, 113, 116},
                           {-1504,   296, 117, 120}, {-1528,   152, 121, 124},
                           {-1536,     0, 125, 131}, {-1528,  -152, 132, 135},
                           {-1504,  -296, 136, 139}, {-1472,  -440, 140, 143},
                           {-1416,  -584, 144, 147}, {-1360,  -720, 148, 151},
                           {-1280,  -856, 152, 155}, {-1192,  -976, 156, 159},
                           {-1088, -1088, 160, 163}, { -976, -1192, 164, 167},
                           { -856, -1280, 168, 171}, { -720, -1360, 172, 175},
                           { -584, -1416, 176, 179}, { -440, -1472, 180, 183},
                           { -296, -1504, 184, 187}, { -152, -1528, 188, 191},
                           {    0, -1536, 192, 192}, {  152, -1528, 193, 196},
                           {  296, -1504, 197, 200}, {  440, -1472, 201, 204},
                           {  584, -1416, 205, 208}, {  720, -1360, 209, 212},
                           {  856, -1280, 213, 216}, {  976, -1192, 217, 220},
                           { 1088, -1088, 221, 224}, { 1192,  -976, 225, 228},
                           { 1280,  -856, 229, 232}, { 1360,  -720, 233, 236},
                           { 1416,  -584, 237, 240}, { 1472,  -440, 241, 244},
                           { 1504,  -296, 245, 248}, { 1528,  -152, 249, 252}};

        class orientation_map
        {
        public:
            pair<uint8_t, uint8_t> lookup(point orientation) const;

            static orientation_map const instance;

        private:
            orientation_map();
            orientation_map(orientation_map const &); // = delete;
            orientation_map &operator=(orientation_map const &); // = delete;

            typedef pair<int, int> key_type;
            typedef pair<uint8_t, uint8_t> value_type;
            typedef std::map<key_type, value_type> map_t;
            map_t map_;
        };

        inline pair<uint8_t, uint8_t>
            orientation_map::lookup(point orientation) const
        {
            map_t::const_iterator it = map_.find(key_type(orientation.x,
                                                          orientation.y));
            if (it == map_.end())
            {
                assert(false);
                return value_type(253, 3);
            }
            else
            {
                return it->second;
            }
        }

        orientation_map::orientation_map()
        {
            for (int n = 0; n < 64; ++n)
            {
                short const *d = orientation_map_data[n];
                map_[key_type(d[0], d[1])]
                                      = value_type(static_cast<uint8_t>(d[2]),
                                                   static_cast<uint8_t>(d[3]));
            }
        }

        orientation_map const orientation_map::instance;
    }

    void angles_from_ship_orientation(point orientation,
                                      uint8_t &min_angle,
                                      uint8_t &max_angle)
    {
        pair<uint8_t, uint8_t> p =
                                orientation_map::instance.lookup(orientation);
        min_angle = p.first;
        max_angle = p.second;
    }
} // end of namespace intrepid
