// ast_cossin.cpp
// --------------
//
//  (C) Copyright Gerald Thaler 2008.
//
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#include "stdafx.hpp"

#include "ast_cossin.hpp"

#include <cmath>

namespace intrepid
{
    namespace
    {
        struct ast_sine_tab
        {
            ast_sine_tab();

            int tab[65];
        };

        static ast_sine_tab const sine_table;

        ast_sine_tab::ast_sine_tab()
        {
            double const pi = 3.14159265;
            for (int angle = 0; angle < 65; ++angle)
            {
                tab[angle] = int(std::sin(angle * pi / 128.0) * 127.0 +.5);
            }
        }

        inline int ast_sine(uint8_t angle)
        {
            if (angle >= 128)
            {
                return - ast_sine(angle - 128);
            }
            if (angle > 64)
            {
                return ast_sine(128 - angle);
            }
            return sine_table.tab[angle];
        }

        inline int ast_cosine(uint8_t angle)
        {
            return ast_sine(static_cast<uint8_t>(angle + 64));
        }
    }

    point ast_cossin(uint8_t angle)
    {
        return point(ast_cosine(angle), ast_sine(angle));
    }
} // end of namespace intrepid
