// ast_random.hpp
// --------------
//
//  (C) Copyright Gerald Thaler 2008.
//
// Distributed under the Boost Software License, Version 1.0.
//    (See accompanying file LICENSE_1_0.txt or copy at
//          http://www.boost.org/LICENSE_1_0.txt)

#ifndef INTREPID_AST_RANDOM_HPP
#define INTREPID_AST_RANDOM_HPP

#if defined(_MSC_VER) && (_MSC_VER >= 1200)
# pragma once
#endif // defined(_MSC_VER) && (_MSC_VER >= 1200)

namespace intrepid
{
    class ast_random
    {
    public:
        static int const random_period = 32767;
        typedef array<uint8_t, random_period + 1024> sequence;
        struct index_entry
        {
            unsigned int key, value;

            index_entry();
            index_entry(unsigned int key,
                        unsigned int value);

            bool operator<(index_entry other) const;
        };
        typedef array<index_entry, random_period> index;

        static uint8_t get_rand(int seed);
        static index const &get_index();
        static sequence const &get_sequence();

    private:
        ast_random();
        ast_random(ast_random const &); // = delete;
        ast_random &operator=(ast_random const &); // = delete;

        void create_index();
        void create_random_seq();

        index    index_;
        sequence sequence_;

        static void next_rand_number(uint8_t &low, uint8_t &high);

        static ast_random instance_;
    };

// class ast_random
// public:

    inline uint8_t ast_random::get_rand(int seed)
    {
        return instance_.sequence_[seed];
    }

    inline ast_random::index const &ast_random::get_index()
    {
        return instance_.index_;
    }

    inline ast_random::sequence const &ast_random::get_sequence()
    {
        return instance_.sequence_;
    }

// private:

    inline ast_random::index_entry::index_entry()
    {
    }

    inline ast_random::index_entry::index_entry(unsigned int keya,
                                                unsigned int valuea)
        :   key(keya), value(valuea)
    {
    }

    inline bool ast_random::index_entry::operator<(index_entry other) const
    {
        return key < other.key || (key == other.key
                                   && value < other.value);
    }
} // end of namespace intrepid

#endif // include guard
