#include "Asteroid.h"
#include "iostream"
using namespace std;

void Asteroid::set(int x, int y, int type, int sf)
{
	plotted = false;
	isPresent  = true;
	position.x = x;
    position.y = y;
	dir.x = 0;
	dir.y = 0;
	speed = 0;
	distanceToShip = 1000000;
	aimLocation = position;
    this->type = type;
       
    switch (sf)
    {  
	case  0:
		r=31;
		rcol = 45;
		maxShots = 4;
		break;
	case 15: 
		r=15;
		rcol = 35;
		maxShots = 3;
		break;
	case 14: 
		r=7;
		rcol = 10;
		maxShots = 1;
		break;
    default: 
		break;
       }
	   nShots = 0;
}

void Asteroid::calcRelationsToShip(GameObject ship)
{  
	
	if (plotted)
	{
		calcSpeed();
		if(maxShots <= nShots)
		{
			shotAt = true;
			if(++shotResetCounter >= SHOTRESETFRAMES)
			{
				nShots = 0;
			}
		}
		else
		{
			shotAt = false;
			shotResetCounter = 0;
		}
		// calculate collision point C and distance AC & SC
		virtualPosition = position + dir;
		Vector2D AS = virtualPosition - ship.position;
		//wrap around
		if(AS.x > -1024 && AS.y > -1024)
		{
			while (AS.x < -512)
			{	
				virtualPosition.x += 1024;
				AS = virtualPosition - ship.position;
			}
			while (AS.x > 511)
			{
				virtualPosition.x -= 1024;
				AS = virtualPosition - ship.position;
			}
			while (AS.y < -384)
			{
				virtualPosition.y += 768;
				AS = virtualPosition - ship.position;
			}
			while (AS.y > 383)
			{
				virtualPosition.y -= 768;
				AS = virtualPosition - ship.position;
			}
		}
		distanceToShip = AS.Length();
		Vector2D direction = dir;
		direction.Normalize();
		distTC = direction.Dot(AS);
		if (distTC > 0)
		{  
			C = position + distTC*direction;
			Vector2D SC = C - ship.position;
			distSC = SC.Length();
			willCollide = (distSC < (r+ship.r));
		}
		else 
			willCollide = false;

		Vector2D ST;
		AS.Normalize();
        bool   calccomplete = false;

		double beta = acos(AS.Dot(direction));

		double alpha = asin((sin(beta) * (speed/7.8)));

		double gamma = PI-alpha-beta;

		double check;
		double check2;
		if(gamma != 0)
		{
			double roidtotarget = (sin(alpha)/sin(gamma)) * distanceToShip;
			aimLocation = virtualPosition + direction * roidtotarget;
			ST = aimLocation - ship.position;
			
			double d=pow(10.0,5);
			
			check = ST.Length()/7.8;
			check = floor(check*d+0.5)/d;

			check2 = roidtotarget/speed;
			check2 = floor(check2*d+0.5)/d;

			if(check == check2)
				calccomplete = true;
		}
		else
		{
			aimLocation = position;
			calccomplete = true;
		}

		if(!calccomplete && beta != 0)
		{
			beta = PI - beta;
					
			double alpha = asin((sin(beta) * (speed/7.8)));

			double gamma = PI-alpha-beta;

			if(gamma != 0)
			{
				double roidtotarget = (sin(alpha)/sin(gamma)) * distanceToShip;
				aimLocation = virtualPosition + direction * roidtotarget;
				ST = aimLocation - ship.position;
				double d=pow(10.0,5);
			
				check = ST.Length()/7.8;
				check = floor(check*d+0.5)/d;

				check2 = roidtotarget/speed;
				check2 = floor(check2*d+0.5)/d;
				if(check == check2)
					calccomplete = true;
			}
			else
			{
				aimLocation = position;
				calccomplete = true;
			}
		}
		if(calccomplete = false)
			cout << "something is wrong with the calculation of an asteroid \n";


		ST = aimLocation - ship.position;
		// calculate angle between SH & ST
		ST.Normalize();
		Vector2D shipDir = ship.shotVector->getcurrentvec();
		shipDir.Normalize();
		angleToShipDEG = acos(shipDir.Dot(ST)) * RAD2DEG;
		double angleRot = ST.AngleDEG() - ship.dir.AngleDEG();
		if (angleRot<0) 
			angleRot+=360;
		rotationDir =  (angleRot < 180) ? 1 : -1;
   } 
   else 
   {  
	   willCollide = false;
	   Vector2D AS = position - ship.position;
	   distanceToShip = AS.Length();
	   aimLocation = position;
       angleToShipDEG = 0;
       distSC = 0;
       distTC = 0;
       distSH = 0;
       distTH = 0;
       nFramesTH = -1;
       nFramesSH = -1;
       nFramesDeltaH = -1;
   }
}

bool Asteroid::isEqual(Asteroid roid2)
{
	if(this->type == roid2.type && ((abs(this->position.x - roid2.position.x) + abs(this->position.y - roid2.position.y)) < MAX_DISTANCE_TRAVELLED))
	{
		return true;
	}
	return false;
}
