/*

  ASTEROIDS Subroutines

  Notizen:

  29.5.08 - der Suchradius fr eigene Schsse stimmt noch nicht.
            hat irgendwie ein anderes Flip-Over als die Asteroiden
			irgendwo bei 0x380 zu 0x080 statt beo 0x400 zu 0x000 ?

*/

#include "asteroid.h"
#include "shotable.h"

static int WinSocketsInitialized = 0  ;
static int AstSSocket = (-1)          ;
static int AstRSocket = (-1)          ;

extern unsigned char  Tsknam[]        ;
extern unsigned int   TraceF          ;
extern          FILE *TraceFp         ;
extern unsigned long  ServIP          ;
extern int            GloSka          ;
extern int            AstKeys         ;
extern int            SchiffDa        ;
extern int            UFODa           ;
extern int            ShotAnz         ;
extern int            MaxObjects      ;
extern int            AstThreadStatus ;
extern int            AstUseThreads   ;
extern double         AstSafeX        ;
extern double         AstSafeY        ;
extern int            AsterAnz        ;
extern int            ShotCntr        ;
extern int            LeftCntr        ;
extern int            RightCntr       ;
extern int            ThrustCntr      ;
extern int            HyperCntr       ;

extern int            SetKeyRight     ;
extern int            SetKeyLeft      ;
extern int            SetKeyFire      ;
extern int            SetKeyThrust    ;
extern int            SetKeyHyper     ;

extern int            LastShotT       ;
extern int            LastShotX       ;
extern int            LastShotY       ;

extern int            ShotTabPtr      ;

extern int            FrameCounter    ;
extern int            FrameMissed     ;
extern int            LastFrame       ;

extern double         Dtemp           ;

extern OBJREC         Objects[MAX_OBJECTS] ;
extern OBJREC         Objecto[MAX_OBJECTS] ;

static int            ShipManz  =    0 ;
static int            ShipWpos  =    0 ;
static int            ShipShots =    0 ;

static OBJREC        *ObjTarget = NULL ;
static OBJREC        *ObjShip   = NULL ;



static _inline void memxchg ( void *a, void *b, int s )
/* --------------------------------------------------------------------- */
/* Kleine Exchange-Routine                                               */
/* --------------------------------------------------------------------- */
{
	unsigned char *pa ;
	unsigned char *pb ;
	unsigned char   c ;

	pa = (unsigned char *) a ;
	pb = (unsigned char *) b ;

	while ( 0 < s ) {
        c     = *pa ;
		*pa++ = *pb ;
        *pb++ =   c ;
		-- s ;
	}

	return ;
}


void ast_init ( void )
/* --------------------------------------------------------------------- */
/* Kleine Init-Routine                                                   */
/* --------------------------------------------------------------------- */
{
	int   i ;
	int   k ;
	int   s ;
	int   x ;
	int   y ;

	s = sizeof ( AstShotTable ) / sizeof ( SHOTRECORD ) ;

	for ( i = 0 ; i < s ; ++ i ) {
		k = 0 ;
		x = 0 ;
		y = 0 ;
		while ( k < SHOT_LOOK_AHEAD ) {
           x = x + AstShotTable[i].sht_dif_xy[k++] ;
           y = y + AstShotTable[i].sht_dif_xy[k++] ;
		}
		AstShotTable[i].sht_shot_a = atan2 ( (double) y, (double) x ) * 180.0 / PI ;
		if ( NULL != TraceFp ) {
    		fprintf ( TraceFp, "ShotTab[%2d] = %7.2f,%7.2f %7.2f  %7.2f\n",
				                i, AstShotTable[i].sht_ship_x,
								AstShotTable[i].sht_ship_y,
								AstShotTable[i].sht_ship_a,
								AstShotTable[i].sht_shot_a ) ;
		}
	}

    return ;
}



static unsigned char HexTab[] = { "0123456789ABCDEFabcdef" } ;

void ast_errdmp ( unsigned char *txt, unsigned char *bp, int size ) 
/* --------------------------------------------------------------------- */
/* Kleine Dump-Routine                                                   */
/* --------------------------------------------------------------------- */
{
   int        c       ;
   int        i       ;
   int        k       ;
   char       tb[128] ;

   if ( size <= 0 ) {
      return ;
   }

   if ( NULL == TraceFp ) {
	   return ;
   }

   if ( size > 2048 ) {
      size = 2048 ;
   } 

   if ( NULL == bp ) {
       bp = "errdmp(): error NULL pointer given !" ;
       size = strlen ( bp ) ;
   }

   if ( NULL == txt ) {
       txt = "(null)" ;
   }

   i = 0 ;

   fprintf ( TraceFp, "\015\012\012'%s':", txt ) ;

   while ( i < size  &&  0 != ( TraceF & TRACE_DUMP ) ) {
      memset ( tb, ' ', sizeof ( tb ) - 1 ) ;
      tb[79] = 0 ;
	  tb[0] = '<' ;
	  tb[1] = HexTab[(i>>12) & 0x0F] ;
	  tb[2] = HexTab[(i>> 8) & 0x0F] ;
	  tb[3] = HexTab[(i>> 4) & 0x0F] ;
	  tb[4] = HexTab[ i      & 0x0F] ;
	  tb[5] = '>' ;
      k = 0 ;
      while ( i < size  &&  k < 16 ) {
         c = bp[i] ;
         tb[7+k+k+k/2]   = HexTab[(int) c >> 4] ;
         tb[7+k+k+k/2+1] = HexTab[(int) c & 15] ;
         if ( c > ' ' && c != 0x7f ) {
            tb[50+k] =  c ;
         }
         else {
            tb[50+k] = '.';
         }
         ++ k ;
         ++ i ;
      }
      fprintf ( TraceFp, "\015\012%s", tb ) ;
   } /* end while () */

   fprintf ( TraceFp, "\015\012" ) ;

   return ;
}



static void trace_txt ( char *s1, char *s2 )
/* --------------------------------------------------------------------- */
/* Meldungstexte ausgeben                                                */
/* --------------------------------------------------------------------- */
{
	if ( NULL != TraceFp ) {
	    fprintf ( TraceFp, "%s %s\n", s1, s2 ) ;
	}
	return ;
}



void ast_close ( void )
/* --------------------------------------------------------------------- */
/* WINDOWS: Socket schlieen                                             */
/* --------------------------------------------------------------------- */
{
   Sleep ( 1500 ) ;
   if ( 0 <= AstSSocket ) {
      // shutdown ( AstSSocket, 0x0002 ) ;
      // Sleep ( 50 ) ;
      closesocket ( AstSSocket ) ;
      AstSSocket = (-1) ;
      // Sleep ( 50 ) ;
   }
   if ( 0 <= AstRSocket ) {
      // shutdown ( AstRSocket, 0x0002 ) ;
      // Sleep ( 50 ) ;
      closesocket ( AstRSocket ) ;
      AstRSocket = (-1) ;
      // Sleep ( 50 ) ;
   }
   Sleep ( 100 ) ;
   WSACleanup ( ) ;
   WinSocketsInitialized = 0 ;
   Sleep ( 100 ) ;
   return ;
}



void ast_sock_init ( void )
/* --------------------------------------------------------------------- */
/* WINDOWS: Sockets initialisieren                                       */
/* --------------------------------------------------------------------- */
{
   int       err   ;
   int       lowb  ;
   int       highb ;
   WORD      wVersionRequested;
   WSADATA   wsaData;
   char      tb[128] ;

   /* -------------- */
   /* Versions Check */
   /* -------------- */
   err   = 1 ;
   highb = 2 ;
   while ( 0 != err  &&  0 < highb ) {
      lowb = 2 ;
      while ( 0 != err  &&  0 <= lowb ) {
         wVersionRequested = MAKEWORD( highb, lowb );
         memset ( &wsaData, 0, sizeof ( WSADATA ) ) ;
         err = WSAStartup( wVersionRequested, &wsaData ) ;
         sprintf ( tb, "WSAStartup rc=%d", err ) ;
		 trace_txt ( "SYSMSG", tb ) ;
         if ( 0 != err ) {
           -- lowb ;
         }
         else {
            if ( LOBYTE( wsaData.wVersion ) != lowb ||
                 HIBYTE( wsaData.wVersion ) != highb ) {
               err = 1 ;
               Sleep ( 100 ) ;
               WSACleanup( );
               Sleep ( 100 ) ;
               -- lowb ;
            }
         }
      }
      if ( 0 != err ) {
         -- highb ;
      }
   }
 
   if ( err != 0 ) {
      sprintf ( tb, "%s: unable to locate an usable WinSock-DLL!", Tsknam ) ;
	  trace_txt ( "SYSMSG", tb ) ;
      exit ( 1 ) ;
   }
   else {
      sprintf ( tb, "%s: System has Socket Version %d.%d",
                Tsknam, highb, lowb ) ;
      trace_txt ( "SYSMSG", tb ) ;
   }

   /* ---------------------------------------------------
    * Confirm that the WinSock DLL supports 2.2.        *
    * Note that if the DLL supports versions greater    *
    * than 2.2 in addition to 2.2, it will still return *
    * 2.2 in wVersion since that is the version we      *
    * requested.                                        *
 
   if ( LOBYTE( wsaData.wVersion ) != 2 ||
        HIBYTE( wsaData.wVersion ) != 2 ) {
       * Tell the user that we could not find a usable  *
       * WinSock DLL.                                   *
      WSACleanup( );
   }
   ---------------------------------------------------- */
   WinSocketsInitialized = 1 ;
   // atexit ( ast_close ) ;
   return ;
}



static int soclose ( int s ) 
/* --------------------------------------------------------------------- */
/* WINDOWS: Socket schlieen                                             */
/* --------------------------------------------------------------------- */
{
   int    i       ;
   int    k       ;
   char   tb[128] ;

   i = shutdown ( s, 0x0002 ) ;
   if ( 0 != i  &&  0 != TraceF  &&  NULL != TraceFp ) {
       k = WSAGetLastError ( ) ;
       sprintf ( tb, "%s: shutdown(%d,0x02) returned %d(Err=%d)",
                     Tsknam, s, i, k ) ;
       trace_txt ( "HD_00001", tb ) ;
   }
   Sleep ( 33 ) ;
   i = closesocket ( s ) ;
   if ( 0 != i  &&  0 != TraceF  &&  NULL != TraceFp ) {
       k = WSAGetLastError ( ) ;
       sprintf ( tb, "%s: closesocket(%d) returned %d(Err=%d)",
                     Tsknam, s, i, k ) ;
       trace_txt ( "HD_00001", tb ) ;
   }
   return ( i ) ;
}



static int psock_errno ( char *s )
/* --------------------------------------------------------------------- */
/* WINDOWS: Socket Fehler im Klartext anzeigen                           */
/* --------------------------------------------------------------------- */
{
   int  i ;

   i = WSAGetLastError ( ) ;
   if ( 0 != TraceF  &&  NULL != TraceFp ) {
      fprintf ( TraceFp, "\015\012%s WSAGetLastError = %d.\015\012", s, i ) ;
   }
   if ( i == WSAECONNREFUSED ) {
       Sleep ( 100 ) ;
   }
   WSASetLastError ( 0 ) ; /* Reset the error code */
   return ( i ) ;
}



int ast_sock_read ( SOCKET socket, unsigned char *buffer, int blklen )
/* --------------------------------------------------------------------- */
/*                                                                       */
/* UDP Read                                                              */
/*                                                                       */
/* Return Value: number of packet dropped - should be 0 ;-)              */
/*                                                                       */
/* --------------------------------------------------------------------- */
{
   int          sendsz  ;
   int          byrecv  ;
   int          errcod  ;
   int          droppd  ;
   fd_set       readfd  ;
   fd_set       writfd  ;
   fd_set       excpfd  ;

   struct sockaddr_in  sender  ;
   struct timeval      zerova  ;

   char         tb[128] ;

   byrecv = 0 ;
   droppd = (-1) ;
   sendsz = sizeof ( sender ) ;
   memset ( &sender, 0, sizeof ( sender ) ) ;

   do { /* */
      FD_ZERO ( &readfd ) ;
	  FD_ZERO ( &writfd ) ;
	  FD_ZERO ( &excpfd ) ;

	  FD_SET ( socket, &readfd ) ;
	  FD_SET ( socket, &excpfd ) ;

	  /* Blocking Wait for Data or Error */

	  select ( socket + 1, &readfd, &writfd, &excpfd, NULL ) ; 
	  byrecv = recv ( socket, (char *)buffer, blklen, 0 ) ;
      ++ droppd ;

      if ( byrecv != blklen) {
			errcod = WSAGetLastError ( ) ;
			sprintf ( tb, "Fehler %d bei recvfrom().\n", errcod ) ;
			trace_txt ( "AST_SOCKET_READ", tb ) ;
			exit ( 1 ) ;
	  }

	  FD_ZERO ( &readfd ) ;
	  FD_ZERO ( &writfd ) ;
	  FD_ZERO ( &excpfd ) ;
	  FD_SET ( socket, &readfd ) ;
	  zerova.tv_sec  = 0 ;
	  zerova.tv_usec = 0 ;
	  select ( socket + 1, &readfd, &writfd, &excpfd, &zerova ) ;
	} while ( FD_ISSET ( socket, &readfd ) ) ;

   return ( droppd ) ;
}



int ast_sock_write ( SOCKET socket, unsigned char *buffer, int blklen ) 
/* --------------------------------------------------------------------- */
/* UDP Write                                                             */
/* --------------------------------------------------------------------- */
{
	int         length  ;
	int         errcod  ;
	char        tb[128] ;

	struct sockaddr_in server  ;

    SYSTEMTIME      t       ; 

	memset(&server, 0, sizeof server);

	server.sin_family      = AF_INET        ;
	server.sin_port        = htons ( AST_PORT_NO ) ;
	server.sin_addr.s_addr = ServIP ;

	strncpy ( buffer, "ctmame@x", 8 ) ;
    buffer[6] = '@' | AstKeys ; // keys
	buffer[7] =  0 ; // ping

	length = sendto ( socket, buffer, blklen, 0, (struct sockaddr*) &server, sizeof server ) ;

	AstKeyStack[AstKeyStackWP++] = ( LastFrame << 8 ) | AstKeys ;
	if ( AstKeyStackFS < AstKeyStackSZ ) {
	    AstKeyStackFS++ ;
	}
	if ( AstKeyStackWP >= AstKeyStackSZ ) {
		AstKeyStackWP = 0 ;
	}

    if ( 0 != ( TraceF & TRACE_SEND )  &&  NULL != TraceFp ) {
  	    GetSystemTime ( &t ) ;
        fprintf ( TraceFp, "\n*ShotAnz=%d* t=%d,%d sent %c = ", 
			                ShotAnz, t.wSecond, t.wMilliseconds , buffer[6] ) ;
		if ( 0 != ( buffer[6] & KEY_HYPER )  ) fprintf ( TraceFp, "HYPERSPACE " ) ;
		if ( 0 != ( buffer[6] & KEY_FIRE )   ) fprintf ( TraceFp, "FIRE " ) ;
		if ( 0 != ( buffer[6] & KEY_THRUST ) ) fprintf ( TraceFp, "THRUST " ) ;
		if ( 0 != ( buffer[6] & KEY_LEFT )   ) fprintf ( TraceFp, "LEFT " ) ;
		if ( 0 != ( buffer[6] & KEY_RIGHT )  ) fprintf ( TraceFp, "RIGHT " ) ;
		fprintf ( TraceFp, "\n" ) ;
	}

	if ( blklen != length )
	{
		errcod = WSAGetLastError ( ) ;
		if ( errcod != WSAEWOULDBLOCK ) {
			sprintf ( tb, "Fehler %d bei sendto().\n", errcod ) ;
			trace_txt ( "AST_SOCKET_WRITE", tb ) ;
			exit ( 1 ) ;
		}
	}
	return ( length ) ;
}



void ast_print_err_message ( int code )
/* ---------------------------------------------------------------------------- */
/* Ausgabe einer Fehlermeldung                                                  */
/* ---------------------------------------------------------------------------- */
{
   char   tb[192] ;

   memset ( tb, 0, sizeof ( tb ) ) ;
   FormatMessage(
      FORMAT_MESSAGE_FROM_SYSTEM,   // source and processing options
                            NULL,   // pointer to  message source
                            code,   // requested message identifier
      MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),    // language identifier for requested message
                              tb,   // pointer to message buffer
                             192,   // maximum size of message buffer
                            NULL ) ;// address of array of message inserts
   trace_txt ( Tsknam, tb ) ;
   return ;
}



unsigned long ast_create_thread ( PTID           ptid, 
								  PFNTHREAD     function,
								  /*
                                  void (_cdecl *function)(void *),
								  */
                                  unsigned long  parameter,
                                  unsigned long  flags,
                                  unsigned long  stacksize )
/* ---------------------------------------------------------------------------- */
/* Erzeugt und startet einen Thread                                             */
/* ---------------------------------------------------------------------------- */
{
   unsigned long  retcod ;
   unsigned long  thrdid ;
   HANDLE         th     ;

   retcod = 87 ;
   if ( ( NULL != ptid )  && ( NULL != function ) ) {
      if ( flags != 0 ) {
         flags = CREATE_SUSPENDED ;
      }
     th = (HANDLE) _beginthread ( (void*)function, 0, (void *)parameter ) ;
     thrdid = (unsigned long) th ;
      if ( NULL == th ) {
         retcod = (int) GetLastError () ;
         ast_print_err_message ( retcod ) ;
         retcod = 87 ;
      }
      else {
         *ptid = thrdid ;
         retcod = 0 ;
      }
   }
   return ( retcod ) ;
}



static _inline void ast_copy_orientation ( OBJREC *pobj, OBJREC *pnme ) 
/* --------------------------------------------------------------------- */
/* Objekt-"Eigenschaften" aus Vorgnger-Datensatz bernehmen             */
/* --------------------------------------------------------------------- */
{

	int   i ;
	
	pobj->obj_manz = pnme->obj_manz ;
	pobj->obj_wpos = pnme->obj_wpos ;
	pobj->obj_mysh = pnme->obj_mysh ;

	pobj->obj_tart = pnme->obj_tart ;
	pobj->obj_tarx = pnme->obj_tarx ;
	pobj->obj_tary = pnme->obj_tary ;

	for ( i = 0 ; i < DEPTH_ORIENTATION_STACK ; ++ i ) {
	   pobj->obj_xdif[i] = pnme->obj_xdif[i] ;
	   pobj->obj_ydif[i] = pnme->obj_ydif[i] ;
	}

	return ;
}



static _inline double ast_add_orientation ( OBJREC *pobj, double x, double y ) 
/* --------------------------------------------------------------------- */
/* Werte in den (Wackel-)Bewegungs-Stack eingeben, Winkel 0..360 zurck */
/* --------------------------------------------------------------------- */
{
	int    i      ;
	int    anzahl ;
	int    wposit ;
	double myxdif ;
	double myydif ;

	anzahl = pobj->obj_manz ;
	wposit = pobj->obj_wpos ;
    pobj->obj_xdif[wposit] = x ;
	pobj->obj_ydif[wposit] = y ;
	if ( anzahl < DEPTH_ORIENTATION_STACK ) {
	   ++ anzahl ;
	   ++ pobj->obj_manz ;
	}
	myxdif = 0.0 ;
	myydif = 0.0 ;
    pobj->obj_wpos = ( wposit + 1 ) % DEPTH_ORIENTATION_STACK ;
	for ( i = 0 ; i < anzahl ; ++ i ) {
       myxdif = myxdif + pobj->obj_xdif[wposit] ;
       myydif = myydif + pobj->obj_ydif[wposit] ;
	   -- wposit ;
	   if ( wposit < 0 ) {
		   wposit = DEPTH_ORIENTATION_STACK - 1 ;
	   }
	}
	return ( atan2 ( myydif, myxdif ) * 180.0 / PI ) ;
}



int ast_frame_decode ( FRAMEPACK *fp )
/* --------------------------------------------------------------------- */
/* Frame dekodieren                                                      */
/* --------------------------------------------------------------------- */
{
	int             i      ;
	int             k      ;
	int             n      ;
	int             schiff ;
	int             shiftc ;
	int             ocount ;
	int             object ;
	int             opcode ;
	int             intens ;
	int             zeichn ;

	double          diviso ;

	double          xschif ;
	double          yschif ;
	double          xposit ;
	double          yposit ;
	double          xlalab ;
	double          ylalab ;
	double          xdelta ;
	double          ydelta ;

	unsigned short *sp      ;
	OBJREC         *ptrobj  ;
	OBJREC         *ptrcpy  ;

	char            tb[128] ;
    SYSTEMTIME      t       ; 

    sp = (unsigned short *) fp ;
	n = sp[512] ;
    i = *sp++ & 0x01FF ;

	schiff   = 0 ;
	SchiffDa = 0 ;
	UFODa    = 0 ;
	ShotAnz  = 0 ;
	AsterAnz = 0 ;

	if ( 1 == i ) {

	   ++ FrameCounter ;
	   if ( n != ( ( LastFrame + 1 ) &0xFF ) ) {
		   ++ FrameMissed ;
	   }
	   LastFrame = n ;

	   memcpy ( Objecto, Objects, sizeof ( OBJREC ) * MAX_OBJECTS ) ;
	   memset ( Objects,    0x00, sizeof ( OBJREC ) * MAX_OBJECTS ) ;

	   ptrobj = Objects ;
	   ocount = 0 ;

       while ( i <= 0x200 ) {

		   object = OBJ_NIXNIX ;
		   zeichn = 0 ;

     	   if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
		      fprintf ( TraceFp, "\n%03X %04X ", i, *sp ) ;
		   }
  	       opcode = *sp & 0xF000 ;

           switch ( opcode ) {
		   case OPC_LABS:  /* Strahl positionieren                */
			   yposit = (double) ( *sp & 0x03FF ) ;
			   ++ sp ;
			   ++  i ;
			   xposit = (double) ( *sp & 0x03FF ) ;
			   xlalab = xposit ;
			   ylalab = yposit ;
			   GloSka = ( *sp >> 12 ) & 0x0F ;
			   if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
  		          fprintf ( TraceFp, "%04X LABS  x=%7.2f,  y=%7.2f skal=%2d", *sp, xposit, yposit, GloSka ) ;
			   }
			   break ;

		   case OPC_HALT:  /* HALT Opcode fr den Vektorgenerator  */
			   if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
			      fprintf ( TraceFp, "     HALT " ) ;
			   }
               if ( 0 != ( TraceF & TRACE_FRAME )  &&  NULL != TraceFp ) {
				  GetSystemTime ( &t ) ;
				  sprintf ( tb, "Frame %d t=%2d,%3d", n, t.wSecond, t.wMilliseconds ) ;
	        	  ast_errdmp ( tb, (unsigned char *) fp, ( i*2 + 0x0F ) & 0xFFF0 ) ;
			   }
			   i = 0x200 ; 
			   break ;

		   case OPC_JSRL:  /* Unterprogrammaufruf at x,y           */
			   /* Vorerst keine Auswertung der genauen Vektordaten */

			   if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
  			      fprintf ( TraceFp, "     JSRL *** " ) ;
			   }
			   switch ( *sp & 0x0FFF ) {
			   case 0x08F3: /* Asteroid Typ 1 */
			       if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
				      fprintf ( TraceFp, "Asteroid Typ 1 - skal %2d", GloSka ) ;
				   } 
				   object = OBJ_ASTER1 ;
				   break ;
			   case 0x08FF: /* Asteroid Typ 2 */
			       if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
				      fprintf ( TraceFp, "Asteroid Typ 2 - skal %2d", GloSka ) ;
				   }
				   object = OBJ_ASTER2 ;
				   break ;
			   case 0x090D: /* Asteroid Typ 3 */
			       if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
				      fprintf ( TraceFp, "Asteroid Typ 3 - skal %2d", GloSka ) ;
				   }
				   object = OBJ_ASTER3 ;
				   break ;
			   case 0x091A: /* Asteroid Typ 4 */
			       if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
				      fprintf ( TraceFp, "Asteroid Typ 4 - skal %2d", GloSka ) ;
				   }
				   object = OBJ_ASTER4 ;
				   break ;
			   case 0x0929: /* UFO            */
   			       if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
				      fprintf ( TraceFp, "UFO - skal %2d ------------", GloSka ) ;
				   }
				   object = OBJ_UFOUFO ;
				   UFODa = 1 ;
				   break ;
			   default:
			       switch ( *sp & 0x0FFF ) {
				   case 0x0ADD: zeichn = '0' ; break ;
				   case 0x0B2C: zeichn = ' ' ; break ;
				   case 0x0B2E: zeichn = '1' ; break ;
				   case 0x0B32: zeichn = '2' ; break ;
				   case 0x0B3A: zeichn = '3' ; break ;
				   case 0x0B41: zeichn = '4' ; break ;
				   case 0x0B48: zeichn = '5' ; break ;
				   case 0x0B4F: zeichn = '6' ; break ;
				   case 0x0B56: zeichn = '7' ; break ;
				   case 0x0B5B: zeichn = '8' ; break ;
				   case 0x0B63: zeichn = '9' ; break ;
				   default:
					   break ;
				   } /* End JSR zeichn switch() */
   			       if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
				      fprintf ( TraceFp, "%04X - skal %2d", *sp & 0xFFF, GloSka ) ;
					  if ( 0 != zeichn ) {
						  fprintf ( TraceFp, " - '%c'", zeichn ) ;
					  }
				   }
				   break ;
			   }

			   break ;

		   case OPC_RTSL:  /* Rckkehr Subroutine                  */
			   /* Vorerst nicht ausgewertet                        */
			   break ;

		   case OPC_JMPL:  /* Unbedingter Sprung, na gut ...       */
               i = *sp & 0x01FF ;
			   sp = (unsigned short *) fp ;
			   sp = &sp[i] ;
 			   if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
  			      fprintf ( TraceFp, "     JMPL loc %04X", i ) ;
			   }
			   break ;

		   case OPC_SVEC:  /* Kurzer Vektor                        */
               intens = ( *sp >> 4 ) & 0x0F ;
			   k = *sp & 0x0808 ;
			   k = ( ( ( k >> 2 ) | ( k >> 11 ) ) & 0x03 ) + GloSka ;
			   shiftc = 7 - ( k & 0x03 ) ;
			   diviso = (double) ( 1 << shiftc ) ;
			   ydelta = (double) ( *sp & 0x300 ) / diviso ;
			   if ( 0 != ( *sp & 0x400 ) ) {
				   ydelta = -ydelta ;
			   }
			   xdelta = (double) ( ( *sp & 0x003 ) << 8 ) / diviso ;
			   if ( 0 != ( *sp & 0x0004) ) {
				   xdelta = -xdelta ;
			   }
			   xposit = xposit + xdelta ;
			   yposit = yposit + ydelta ;
 			   if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
			      fprintf ( TraceFp, "     SVEC dx=%7.2f, dy=%7.2f div=%5.1f intens=%2d", 
					                  xdelta, ydelta, diviso, intens ) ;
			   }
			   break ;

		   case OPC_VCTR:  /* langer Vektor                        */
		   default:
			   shiftc = ( 9 - ( ( opcode >> 12 ) + GloSka ) ) & 0x0F ;
			   diviso = (double) ( 1 << shiftc ) ;
			   ydelta = (double) ( *sp & 0x03FF ) / diviso ;
			   if ( 0 != ( *sp & 0x400 ) ) {
				   ydelta = -ydelta ;
			   }
			   ++ sp ;
			   ++  i ;
               intens = ( *sp >> 12 ) & 0x0F ;
			   xdelta = ( *sp & 0x03FF ) / diviso ;
			   if ( 0 != ( *sp & 0x400 ) ) {
				   xdelta = -xdelta ;
			   }
			   xposit = xposit + xdelta ;
			   yposit = yposit + ydelta ;
			   if ( 15 == intens  &&  0.0 == xdelta  &&  0.0 == ydelta ) {
				   object = OBJ_A_SHOT ;
				   ++ ShotAnz ;
     			   if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
			          fprintf ( TraceFp, "%04X SHOT  x=%7.2f,  y=%7.2f div=%5.1f intens=%2d *", 
						                 *sp, xposit, yposit, diviso, intens ) ;
				   }
			   }
			   else {
				   if ( VEC_SHIP == opcode  &&  12 == intens  &&  0.0 != xdelta  &&  0.0 != ydelta ) {
                       if ( 0 == schiff ) {
					       ++ schiff ;
					       xschif = xposit ;
					       yschif = yposit ;
     			           if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
			                  fprintf ( TraceFp, "%04X SHIP dx=%7.2f, dy=%7.2f div=%5.1f intens=%2d spx=%7.2f spy=%7.2f", 
								                 *sp, xdelta, ydelta, diviso, intens, xschif, yschif ) ;
						   }  
					   }
				       else {
						   if ( 1 == schiff ) {
						       ++ schiff   ;
							   ++ SchiffDa ;
						       object = OBJ_MYSHIP ;
						       xschif = xschif - xlalab ;
						       yschif = yschif - ylalab ;
       			               if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
			                       fprintf ( TraceFp, "%04X SHIP dx=%7.2f, dy=%7.2f div=%5.1f intens=%2d orx=%7.2f ory=%7.2f", 
									                  *sp, xdelta, ydelta, diviso, intens, xschif, yschif ) ;
							   }  
						   }
						   else {
       			               if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
 			                        fprintf ( TraceFp, "%04X VCTR dx=%7.2f, dy=%7.2f div=%5.1f intens=%2d", 
								                        *sp, xdelta, ydelta, diviso, intens ) ;
							   }
						   }
				           if ( 1 == schiff ) { /* Trmmer-Vektor */
					           schiff = 0 ;
						   }
					   }
				   }
			       else {
		               if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
    			           fprintf ( TraceFp, "%04X VCTR dx=%7.2f, dy=%7.2f div=%5.1f intens=%2d", 
	    					                  *sp, xdelta, ydelta, diviso, intens ) ;
					   }
				       if ( 1 == schiff ) { /* Trmmer-Vektor */
					       schiff = 0 ;
					   }
				   }
			   }
			   break ;
		   } /* end switch ( opcode ) */
		   ++  i ;
		   ++ sp ;

		   if ( OBJ_NIXNIX != object ) {
			   if ( ocount < MAX_OBJECTS ) {
				   ptrobj->obj_type = object ;
				   ptrobj->obj_xpos = xlalab ;
				   ptrobj->obj_ypos = ylalab ;
				   switch ( object ) {
				   case OBJ_ASTER1:
				   case OBJ_ASTER2:
				   case OBJ_ASTER3:
				   case OBJ_ASTER4:
					   ++ AsterAnz ;
				   case OBJ_UFOUFO:
					   switch ( GloSka ) {
					   case 0:
					       ptrobj->obj_size = 60 ;
						   break ;
					   case 15:
					       ptrobj->obj_size = 45 ;
						   break ;
					   case 14:
					       ptrobj->obj_size = 27 ;
						   break ;
					   default:
				           ptrobj->obj_size = 27 ;
						   break ;
					   }
					   break ;
				   default:
				       ptrobj->obj_size = 30 ;
					   break ;
				   }
				   if ( OBJ_MYSHIP == object ) {
					   ptrobj->obj_manz = ShipManz ;
					   ptrobj->obj_wpos = ShipWpos ;
             		   ptrobj->obj_angl = ast_add_orientation ( ptrobj, xschif, yschif ) ;
					   ShipWpos = ptrobj->obj_wpos ;
				   }
				   if ( OBJ_UFOUFO == object ) {
				       ptrcpy = ptrobj ;
					   ++ ptrcpy ;
					   memcpy ( ptrcpy, ptrobj, sizeof (OBJREC) ) ;
					   xposit = ptrobj->obj_xpos + ptrobj->obj_size * 2 / 5 ;
					   if ( xposit <    0.0 ) xposit = xposit + 1024.0 ;
					   if ( xposit > 1024.0 ) xposit = xposit - 1024.0 ;
					   ptrcpy->obj_xpos = xposit ;
					   ++ ptrcpy ;
					   memcpy ( ptrcpy, ptrobj, sizeof (OBJREC) ) ;
					   yposit = ptrobj->obj_ypos - ptrobj->obj_size * 2 / 5 ;
					   if ( yposit <    0.0 ) yposit = yposit + 1024.0 ;
					   if ( yposit > 1024.0 ) yposit = yposit - 1024.0 ;
					   ptrcpy->obj_ypos = yposit ;
					   ++ ptrcpy ;
					   memcpy ( ptrcpy, ptrobj, sizeof (OBJREC) ) ;
					   xposit = ptrobj->obj_xpos - ptrobj->obj_size * 2 / 5 ;
					   if ( xposit <    0.0 ) xposit = xposit + 1024.0 ;
					   if ( xposit > 1024.0 ) xposit = xposit - 1024.0 ;
					   ptrcpy->obj_xpos = xposit ;
					   ++ ptrcpy ;
					   memcpy ( ptrcpy, ptrobj, sizeof (OBJREC) ) ;
					   yposit = ptrobj->obj_ypos + ptrobj->obj_size * 2 / 5 ;
					   if ( yposit <    0.0 ) yposit = yposit + 1024.0 ;
					   if ( yposit > 1024.0 ) yposit = yposit - 1024.0 ;
					   ptrcpy->obj_ypos = yposit ;
					   ptrcpy = ptrobj ;
				       ++ ocount ;
				       ++ ocount ;
    				   ++ ptrobj ;
    				   ++ ptrobj ;
					   // memxchg ( ptrobj, ptrcpy, sizeof ( OBJREC ) ) ;
				       ++ ocount ;
				       ++ ocount ;
    				   ++ ptrobj ;
    				   ++ ptrobj ;
				   }
				   ++ ptrobj ;
				   ++ ocount ;
				   if ( ocount > MaxObjects ) {
					   MaxObjects = ocount ;
				   }
				   if ( ocount > MAX_OBJECTS ) {
					   fprintf ( stderr, "\n%s: Oops ! Too many objects (%d) ?", Tsknam, ocount ) ;
					   fprintf ( stderr, "\nCheck MAX_OBJECTS %d in Program !\n", MAX_OBJECTS ) ;
					   exit ( 1 ) ;
				   }
			   }
		   }
	   } /* end switch ( opcode ) */
	} /* end if *sp == 0xE001 oder 0xE201 */

	if ( 0 == SchiffDa ) {
		ShipWpos = 0 ;
		ShipManz = 0 ;
	}

	return ( ocount ) ;
}



void ast_calc_parameters ( void )
/* --------------------------------------------------------------------- */
/* Verfgbare Objekt-Parameter berechnen                                 */
/* --------------------------------------------------------------------- */
{
	OBJREC    *ptrobj ;
	OBJREC    *ptrold ;
	OBJREC    *ptrnxt ;
	int        countr ;
    int        ocount ;

	double     distan ;
	double     nearst ;
	double     merkdx ;
	double     merkdy ;
	double     dx, dy ;
	double     xs, ys ;

	xs = -1.0 ;
	ys = -1.0 ;

	countr = 0 ;
	ptrobj = Objects ;
	while ( countr < MAX_OBJECTS  &&  OBJ_NIXNIX != ptrobj->obj_type ) {
		if ( OBJ_MYSHIP == ptrobj->obj_type ) {
			xs = ptrobj->obj_xpos ;
			ys = ptrobj->obj_ypos ;
			countr = MAX_OBJECTS  ;
		}
       ++ countr ;
       ++ ptrobj ;
	}

	countr = 0 ;
	ptrobj = Objects ;
	while ( countr < MAX_OBJECTS  &&  OBJ_NIXNIX != ptrobj->obj_type ) {

	   ptrold = Objecto ;
	   ocount = 0 ;
	   nearst = +1.0e+10 ;
	   ptrnxt = NULL ;

	   while ( ocount < MAX_OBJECTS  &&  OBJ_NIXNIX != ptrold->obj_type ) {
		   if ( ptrold->obj_type == ptrobj->obj_type  &&  ptrobj->obj_type != OBJ_MYSHIP ) {
			   dx = ptrobj->obj_xpos - ptrold->obj_xpos ;
			   dy = ptrobj->obj_ypos - ptrold->obj_ypos ;
               distan = sqrt ( dy * dy + dx * dx ) ;
			   if ( distan < nearst && SUCH_RADIUS >= distan ) {
				   nearst = distan ;
				   ptrnxt = ptrold ;
				   merkdx = dx ;
				   merkdy = dy ;
			   }
		   }
		   ++ ocount ;
		   ++ ptrold ;
	   }

	   if ( NULL != ptrnxt ) { /* Vorgnger gefunden */
		   ast_copy_orientation ( ptrobj, ptrnxt ) ;
		   ptrobj->obj_angl = ast_add_orientation ( ptrobj, merkdx, merkdy ) ;
	   }
	   else {                  /* Kein Vrgnger in der Nhe. 1024er bergang ? */
	       ptrold = Objecto ;
	       ocount = 0 ;
	       nearst = +1.0e+10 ;
	       ptrnxt = NULL ;
	       while ( ocount < MAX_OBJECTS  &&  OBJ_NIXNIX != ptrold->obj_type ) {
		       if ( ptrold->obj_type == ptrobj->obj_type  &&  ptrobj->obj_type != OBJ_MYSHIP ) {

			       dx = ptrobj->obj_xpos - ptrold->obj_xpos ;

				   if ( dx > ( 1024.0 - SUCH_RADIUS ) ) {
					   dx = dx - 1024.0 ;
				   }
   				   if ( dx < ( -1024.0 + SUCH_RADIUS ) ) {
    				   dx = 1024.0 + dx ;
				   }

   			       dy = ptrobj->obj_ypos - ptrold->obj_ypos ;

				   if ( ptrobj->obj_type != OBJ_A_SHOT ) {
				       if ( dy > ( 1024.0 - SUCH_RADIUS ) ) {
					       dy = dy - 1024.0 ;
					   }
				       if ( dy < ( -1024.0 + SUCH_RADIUS ) ) {
					       dy = 1024.0 + dy ;
					   } 
				   }
				   else {
    			       dy = ptrobj->obj_ypos - ptrold->obj_ypos ;
				       if ( dy > ( ( 869.0 - 128.0 ) - SUCH_RADIUS ) ) {
					       dy = dy - ( 896.0 - 128.0 ) ;
					   }
				       if ( dy < ( - ( 896.0 - 128.0 ) + SUCH_RADIUS ) ) {
					       dy = ( 896.0 - 128.0 ) + dy ;
					   } 
				   }
                   distan = sqrt ( dy * dy + dx * dx ) ; /* sqrt() May be time consuming */
		    	   if ( distan < nearst && SUCH_RADIUS >= distan ) {
			    	   nearst = distan ;
				       ptrnxt = ptrold ;
				       merkdx = dx ;
				       merkdy = dy ;
				   }
			   }
		       ++ ocount ;
		       ++ ptrold ;
		   }
		   if ( NULL != ptrnxt ) { /* Vorgnger (wraped around) gefunden */
		       ast_copy_orientation ( ptrobj, ptrnxt ) ;
		       ptrobj->obj_angl = ast_add_orientation ( ptrobj, merkdx, merkdy ) ;
		   }
		   else { /* Neues Objekt. */
			   if ( OBJ_A_SHOT == ptrobj->obj_type  &&  xs >= 0.0 ) {
				   dx = ptrobj->obj_xpos - xs ;
				   dy = ptrobj->obj_ypos - ys ;
				   distan = sqrt ( dx * dx + dy * dy ) ;
				   if ( 25.0 >= distan ) {
					   ptrobj->obj_tart = LastShotT ;
					   ptrobj->obj_tarx = LastShotX ;
					   ptrobj->obj_tary = LastShotY ;
				   }
			   }
		   }
	   } /* end while ( ocount ... */

       ++ countr ;
       ++ ptrobj ;

	} /* end while ( countr < ... */
	return ;
}



void ast_frame_dump ( char *txt, OBJREC *pcur, OBJREC *pold )
/* --------------------------------------------------------------------- */
/* Text-Dump der ASTEROID Vektor-Records                                 */
/* --------------------------------------------------------------------- */
{
	int    i ;
	int    k ;
	int    p ;
	int    m ;

	if ( NULL == TraceFp  ||  NULL == pcur  ||  NULL == pold  ||  NULL == txt ) {
		return ;
	}

	if ( 0 == ( TraceF & TRACE_FRAME ) ) {
		return ;
	}

	i = 0 ;
	while ( i < MAX_OBJECTS  &&  ( OBJ_NIXNIX != pcur->obj_type || OBJ_NIXNIX != pold->obj_type ) ) {
		fprintf ( TraceFp, "\n%02d - ", i+1 ) ;
		if ( OBJ_NIXNIX != pcur->obj_type ) {
		   p = ( pcur->obj_wpos - 1 + DEPTH_ORIENTATION_STACK ) % DEPTH_ORIENTATION_STACK ;
		   m = pcur->obj_mysh ;
		   if ( m != '*' ) {
			   m = ' ' + m % 26 ;
		   }
		    fprintf ( TraceFp, "%4.4s%c(%2d)X=%7.2f Y=%7.2f DX=%7.2f DY=%7.2f A=%7.2f ", 
			        (char *)&pcur->obj_type, 
					m,
					pcur->obj_size,
				    pcur->obj_xpos, pcur->obj_ypos,
				    pcur->obj_xdif[p], pcur->obj_ydif[p],
					pcur->obj_angl ) ;
			fprintf ( TraceFp, "OD=(%02d) ", pcur->obj_manz ) ;
		    if ( OBJ_NIXNIX != pcur->obj_tart ) {
			    fprintf ( TraceFp, "(T:%4.4s:%d,%d)", (char *)&pcur->obj_tart, pcur->obj_tarx, pcur->obj_tary ) ;
			}
			for ( k = 0 ; k < DEPTH_ORIENTATION_STACK ; ++ k ) {
				fprintf ( TraceFp, "%2d,%2d ", (int) pcur->obj_xdif[k], (int)pcur->obj_ydif[k] ) ;
			}
		}
		else {
			fprintf ( TraceFp, "---- ------------- --------- ---------- ---------- --------- ------- --,-- --,-- --,-- --,-- --,-- --,-- --,-- --,-- " ) ;
		}
		if ( OBJ_NIXNIX != pold->obj_type ) {
		   p = ( pold->obj_wpos - 1 + DEPTH_ORIENTATION_STACK ) % DEPTH_ORIENTATION_STACK ;
		   m = pold->obj_mysh ;
		   if ( m != '*' ) {
			   m = ' ' + m % 26 ;
		   }
		   fprintf ( TraceFp, "%4.4s%c(%2d)X=%7.2f Y=%7.2f DX=%7.2f DY=%7.2f A=%7.2f ", 
			        (char *)&pold->obj_type, 
					m,
					pold->obj_size,
				    pold->obj_xpos, pold->obj_ypos,
				    pold->obj_xdif[p], pold->obj_ydif[p],
					pold->obj_angl ) ;
			fprintf ( TraceFp, "OD=(%02d) ", pold->obj_manz ) ;
			for ( k = 0 ; k < DEPTH_ORIENTATION_STACK ; ++ k ) {
				fprintf ( TraceFp, "%2d,%2d ", (int)pold->obj_xdif[k], (int)pold->obj_ydif[k] ) ;
			}
		}
		else {
			fprintf ( TraceFp, "---- ------------- --------- ---------- ---------- --------- ------- --,-- --,-- --,-- --,-- --,-- --,-- --,-- --,--" ) ;
		}
		++i ;
		++pcur ;
		++pold ;
	} /* end while */

	fprintf ( TraceFp, "\n" ) ;

	return ;
}




static void ast_predict_movements ( void )
/* ------------------------------------------------------------------------ */
/* Berechne die nchsten "DEPTH_LOOKAHEAD" Bewegungen der Objekte,          */
/* setze Kollisions-Flag und -Zeit(-Step)                                   */
/* ------------------------------------------------------------------------ */
{
	int        i   ;
	int        o   ;
	int        p   ;
	int        r   ;
	int        x   ;
	int        y   ;
	int        xs  ;
	int        ys  ;
	int        sz  ;
	int        dq  ;
	double     rx  ;
	double     ry  ;
	double     ox  ;
	double     oy  ;
	double     dt  ;
    OBJREC    *po  ;

	xs = (-1) ;
	ys = (-1) ;
    ox =  0.0 ;
	oy =  0.0 ;
	po = Objects ;
	o  =       0 ;

	while ( o < MAX_OBJECTS  &&  po->obj_type != OBJ_NIXNIX ) {
		if ( OBJ_MYSHIP == po->obj_type ) {
 	        xs = (int) po->obj_xpos ;
	        ys = (int) po->obj_ypos ;
			p = ( po->obj_wpos - 1 + DEPTH_ORIENTATION_STACK ) % DEPTH_ORIENTATION_STACK ;
			ox = po->obj_xdif[p] * SQRT2 ;
			oy = po->obj_ydif[p] * SQRT2 ;
			o = MAX_OBJECTS ;
		}
		++ po ;
		++  o ;
	}

	ShipShots = 0 ;

	if ( xs >= 0  &&  ys >= 0 ) {
    	po = Objects ;
		o = 0 ;
	    while ( o < MAX_OBJECTS  &&  po->obj_type != OBJ_NIXNIX ) {
			if ( OBJ_A_SHOT == po->obj_type ) {
               rx = po->obj_xpos - (double) xs - ox ;
               ry = po->obj_ypos - (double) ys - oy ;
			   dt = rx * rx + ry * ry ;
			   if ( 20.0 > dt  &&  0 == po->obj_manz ) {
			       if ( Dtemp < dt ) Dtemp = dt ;          /* Globaler Trace: Max. Schuss-Distanz */
				   po->obj_mysh = '*' ;
				   ++ ShipShots ;
			   }
			}
			if ( OBJ_A_SHOT != po->obj_type  &&  OBJ_MYSHIP != po->obj_type ) {
			   if ( po->obj_mysh > 0 ) {
				   -- po->obj_mysh ;
			   }
               rx = po->obj_xpos ;
               ry = po->obj_ypos ;
		       r = po->obj_wpos ;
			   sz = po->obj_size / 2 + 15 ;
               for ( i = 0 ; i < DEPTH_LOOKAHEAD ; ++ i ) {
                  rx = rx + po->obj_xdif[r] ;
                  ry = ry + po->obj_ydif[r] ;
			      x = (int) ( rx + 0.000005 ) ;
			      y = (int) ( ry + 0.000005 ) ;
			      while ( x <    0 ) x = x + 1024 ;
			      while ( y <    0 ) y = y + 1024 ;
			      while ( x > 1023 ) x = x - 1024 ;
			      while ( y > 1023 ) y = y - 1024 ;
                  po->obj_ixpo[i] = x ;
                  po->obj_iypo[i] = y ;
	     	      ++ r ;
			      if ( r >= DEPTH_ORIENTATION_STACK ) {
			         r = 0 ;
				  }
			      /* --------------------- */
    		      /* Kollision ? Wann ?    */
			      /* --------------------- */
				  if ( 0 == po->obj_kolf ) {
    				  dt = (double) ( ( xs - x ) * ( xs - x ) + ( ys - y ) * ( ys - y ) ) ;
                      dq = (int) sqrt ( dt ) ;
		              if ( dq < sz ) {
			              po->obj_kolf = 1 ;
			              po->obj_kolt = i + 1 ;
					  } 
				  }
			   } /* LOOKAHEAD "Flugpunkte" rechnen */
			} /* if (UFO or ASTEROID) */
			if ( 0 != po->obj_kolf ) {
                if ( 0 != ( TraceF & TRACE_DECODE )  &&  NULL != TraceFp ) {
    		        fprintf ( TraceFp, "(%d) %4.4s kolf=%d kolt=%d \n", o+1, &po->obj_type, po->obj_kolf, po->obj_kolt ) ;
				}
			}
			++ po ;
			++  o ;
		} /* end for (all real objects... */
        //sprintf ( tb, "Debugger." ) ;
	} /* if Schiff da (xs >= 0  &&  ys >= 0) */

    return ;
}



static void ast_pick_target ( void )
/* ------------------------------------------------------------------------ */
/* Worker Thread #1                                                         */
/* Suche das aktuell wichtigste Ziel und speichere dessen Objekt-Index nach */
/* "AstCurrentTargetIndex"                                                  */
/* 1 - UFO                                                                  */
/* 2 - Zeitlich nchstes Kollisions-Objekt ("kolf" != 0 && "kolt" min)      */
/* 3 - Rumlich nahes Objekt                                                */
/* 4 - Objekt                                                               */
/* ------------------------------------------------------------------------ */
{
	int      i     ;
	int      k     ;
	double   aship ;
	double   xship ;
	double   yship ;
	double   xdiff ;
	double   ydiff ;
	double   dtemp ;

    OBJREC  *pobj  ; 
    OBJREC  *qobj  ; 

    ObjTarget = NULL ;
    ObjShip   = NULL ;

	i     =       0 ;
	pobj  = Objects ;
	qobj  =    NULL ;
    xship =     0.0 ;
	yship =     0.0 ;

	/* ---------------------------------------------------- */
	/* Wo ist mein Schiff ?                                 */
	/* ---------------------------------------------------- */
	while ( i < MAX_OBJECTS  &&  OBJ_NIXNIX != pobj->obj_type ) {
   		if ( OBJ_MYSHIP == pobj->obj_type ) {
            xship = pobj->obj_xpos ;
            yship = pobj->obj_ypos ;
			aship = pobj->obj_angl ;
			ObjShip = pobj ;
			i = MAX_OBJECTS ;
		}
			
        ++ pobj ;
		++ i ;
	}

	/* ---------------------------------------------------- */
	/* Wie weit sind die Objekte entfernt ?                 */
	/* ---------------------------------------------------- */
	i     =       0 ;
	pobj  = Objects ;
	while ( i < MAX_OBJECTS  &&  OBJ_NIXNIX != pobj->obj_type ) {
        xdiff = xship - pobj->obj_xpos ;
        ydiff = yship - pobj->obj_ypos ;
    	pobj->obj_dist = (int) sqrt ( xdiff * xdiff + ydiff * ydiff ) ;
		k = pobj->obj_dist / 8 ;
        xdiff = pobj->obj_ixpo[k % DEPTH_LOOKAHEAD] - xship ;
        ydiff = pobj->obj_iypo[k % DEPTH_LOOKAHEAD] - yship ;
		dtemp = aship - atan2 ( ydiff, xdiff ) * 180.0 / PI ; 
    	if ( dtemp < -180.0 ) {
	    	dtemp = 360.0 + dtemp ;
		} 
	    if ( dtemp > +180.0 ) {
		    dtemp = dtemp - 360.0 ;
		} 
		pobj->obj_dreh = (int) ( fabs ( dtemp ) / 4.0 ) ;
        ++ pobj ;
		++ i ;
	}

	/* ---------------------------------------------------- */
	/* Was ist das zeitlich nchste Kollisions-Objekt ?     */
	/* ---------------------------------------------------- */
	i    =       0 ;
	k    =   99999 ;
	pobj = Objects ;
	qobj =    NULL ;
	while ( NULL == ObjTarget  &&  i < MAX_OBJECTS  &&  OBJ_NIXNIX != pobj->obj_type ) {
        if ( OBJ_A_SHOT != pobj->obj_type  &&  OBJ_MYSHIP != pobj->obj_type ) {
			if ( 0 != pobj->obj_kolf ) {
				if ( k > ( pobj->obj_kolt + pobj->obj_dreh ) ) {
					k = pobj->obj_kolt + pobj->obj_dreh ;
					qobj = pobj ;
				}
			}
		}
        ++ pobj ;
		++ i ;
	}
	if ( NULL == ObjTarget  &&  NULL != qobj ) {
        if ( 128 > qobj->obj_kolt  &&  0 < qobj->obj_kolt  &&  0 == qobj->obj_mysh ) {
		    ObjTarget = qobj ;
		}
	}

	pobj  = Objects ;
	i     =       0 ;
	/* ---------------------------------------------------- */
	/* Gibt's ein nahes UFO ?                               */
	/* ---------------------------------------------------- */
	while ( NULL == ObjTarget  &&  i < MAX_OBJECTS  &&  OBJ_NIXNIX != pobj->obj_type ) {
        if ( OBJ_UFOUFO == pobj->obj_type ) {     /* UFO */
			if ( 0 == pobj->obj_mysh ) {          /* Nicht (mehr) drauf geschossen */
                if ( pobj->obj_dist < 256 ) {     /* Nah genug ? */
        			ObjTarget = pobj ;            /* Nahes UFO ist das Ziel */
				}
			}
		}
        ++ pobj ;
		++ i ;
	}

	/* ---------------------------------------------------- */
	/* Was ist das zeitlich bernchste Kollisions-Objekt ? */
	/* ---------------------------------------------------- */
	i    =       0 ;
	k    =   99999 ;
	pobj = Objects ;
	qobj =    NULL ;
	while ( NULL == ObjTarget  &&  i < MAX_OBJECTS  &&  OBJ_NIXNIX != pobj->obj_type ) {
        if ( OBJ_A_SHOT != pobj->obj_type  &&  OBJ_MYSHIP != pobj->obj_type ) {
			if ( 0 != pobj->obj_kolf ) {
				if ( k > pobj->obj_kolt ) {
					k = pobj->obj_kolt ;
					qobj = pobj ;
				}
			}
		}
        ++ pobj ;
		++ i ;
	}
	if ( NULL == ObjTarget  &&  NULL != qobj ) {
        if ( 512 > qobj->obj_kolt  &&  0 < qobj->obj_kolt  &&  0 == qobj->obj_mysh ) {
   		    // ObjTarget = qobj ;
		}
	}

	/* ---------------------------------------------------- */
	/* Gibt's ein UFO ?                                     */
	/* ---------------------------------------------------- */
	i    =       0 ;
	pobj = Objects ;
	qobj = NULL ;
	while ( NULL == ObjTarget  &&  i < MAX_OBJECTS  &&  OBJ_NIXNIX != pobj->obj_type ) {
        if ( OBJ_UFOUFO == pobj->obj_type ) {     /* UFO */
			if ( 0 == pobj->obj_mysh ) {          /* Nicht (mehr) drauf geschossen */
       			qobj = pobj ;                     /* Das UFO ist das Ziel */
			}
		}
        ++ pobj ;
		++ i ;
	}
	if ( NULL == ObjTarget  &&  NULL != qobj ) {
		ObjTarget = qobj ;
	}

#ifdef schubbiduah
	/* ---------------------------------------------------- */
	/* Was ist denn sonst so an grossen Asteroiden nah ?    */
	/* ---------------------------------------------------- */
	i    =       0 ;
	k    =  999999 ;
	pobj = Objects ;
	qobj = NULL    ;
	while ( NULL == ObjTarget  &&  i < MAX_OBJECTS  &&  OBJ_NIXNIX != pobj->obj_type  &&  NULL != ObjShip ) {
        if ( OBJ_A_SHOT != pobj->obj_type  &&  OBJ_MYSHIP != pobj->obj_type  &&  0 == pobj->obj_mysh ) {
		   if ( pobj->obj_dist < k  &&  pobj->obj_size > 50 ) {
			   k    = pobj->obj_dist + pobj->obj_dreh * 2 ;
			   qobj = pobj  ;
		   }
		}
        ++ pobj ;
		++ i ;
	}
	if ( NULL == ObjTarget  &&  NULL != qobj ) {
		ObjTarget = qobj ;
	}

	/* ---------------------------------------------------- */
	/* Was ist denn sonst so an mittleren Asteroiden nah ?  */
	/* ---------------------------------------------------- */
	i    =       0 ;
	k    =  999999 ;
	pobj = Objects ;
	qobj = NULL    ;
	while ( NULL == ObjTarget  &&  i < MAX_OBJECTS  &&  OBJ_NIXNIX != pobj->obj_type  &&  NULL != ObjShip ) {
        if ( OBJ_A_SHOT != pobj->obj_type  &&  OBJ_MYSHIP != pobj->obj_type  &&  0 == pobj->obj_mysh ) {
		   if ( pobj->obj_dist < k  &&  pobj->obj_size < 50 ) {
			   k    = pobj->obj_dist + pobj->obj_dreh * 2 ;
			   qobj = pobj  ;
		   }
		}
        ++ pobj ;
		++ i ;
	}
	if ( NULL == ObjTarget  &&  NULL != qobj ) {
		ObjTarget = qobj ;
	}
#endif

	/* ---------------------------------------------------- */
	/* Was ist denn sonst so in der Nhe ?                  */
	/* ---------------------------------------------------- */
	i    =       0 ;
	k    =  999999 ;
	pobj = Objects ;
	qobj = NULL    ;
	while ( NULL == ObjTarget  &&  i < MAX_OBJECTS  &&  OBJ_NIXNIX != pobj->obj_type  &&  NULL != ObjShip ) {
        if ( OBJ_A_SHOT != pobj->obj_type  &&  OBJ_MYSHIP != pobj->obj_type  &&  0 == pobj->obj_mysh ) {
		   if ( ( pobj->obj_dist + pobj->obj_dreh * 30 ) < k ) {
			   k    = pobj->obj_dist + pobj->obj_dreh * 30 ;
			   qobj = pobj  ;
		   }
		}
        ++ pobj ;
		++ i ;
	}
	if ( NULL == ObjTarget  &&  NULL != qobj ) {
		ObjTarget = qobj ;
	}

    return ;
}



static void ast_adjust_shot_table_pointer ( int idir, OBJREC *ship )
/* ------------------------------------------------------------------------ */
/* Fhre den Index in der "Winkel-Schuss-Winkel-Laufindices-Tabelle" mit    */
/* und korrigiere ihn erforderlichenfalls                                   */
/* ------------------------------------------------------------------------ */
{
	int     i        ;
	int     p        ;
	int     stabsize ;
	double  shipsori ;

	stabsize = sizeof ( AstShotTable ) / sizeof ( SHOTRECORD ) ;

	ShotTabPtr = ( ShotTabPtr - idir + stabsize ) % stabsize ;
	shipsori = ship->obj_angl ;

	i = 1 ;
	p = ShotTabPtr ;
	while ( ( i < ( stabsize / 2 + 1 ) )  && 
		    ( 2.5 < fabs ( shipsori - AstShotTable[p].sht_shot_a ) )
			) {
		p = ( ShotTabPtr + i + stabsize ) % stabsize ;
		if ( 2.5 < fabs ( shipsori - AstShotTable[p].sht_ship_x ) ) {
			ShotTabPtr = p ;
			i = stabsize ;
		}
		p = ( ShotTabPtr - i + stabsize ) % stabsize ;
		if ( 2.5 < fabs ( shipsori - AstShotTable[p].sht_ship_x ) ) {
			ShotTabPtr = p ;
			i = stabsize ;
		}
		++ i ;
	}

	return ;
}



static void ast_shoot_target ( void )
/* ------------------------------------------------------------------------ */
/* Drehe das Schiff zum "Treff"-Punkt des Ziels und lse den Schuss aus     */
/* Vermerke "drauf geschossen" (Timer im Objekt-Satz, der bei jedem "Copy"  */
/* heruntergezhlt wird) Sind weniger als 2 Schsse im Bild, so darf beim   */
/* "Drehen" auch auf dazwischen liegende Ziele geballert werden,            */
/* ------------------------------------------------------------------------ */
{
	int    tu ;
	int    pl ;
	int    ix ;
	int    id ;

	double dx ;
	double dy ;
	double ds ;
	double xs ;
	double ys ;
	double xt ;
	double yt ;
	double ws ;
	double su ;
	double di ;

	/* Drehungen berechnen */

    xs = ObjShip->obj_xpos ;
	ys = ObjShip->obj_ypos ;

    xt = ObjTarget->obj_xpos ;
	yt = ObjTarget->obj_ypos ;

	dx = xt - xs ;
	dy = yt - ys ;

    ds = sqrt ( dx * dx + dy * dy ) ;

	if ( AsterAnz > 20 ) {
		id = 20 ;
	}
	else {
		if ( AsterAnz > 10 ) {
			id = 30 ;
		}
		else {
			id = 40 ;
		}
	}

	ix = ObjTarget->obj_wpos ;
	di = 8.9 ;
  	pl = (int) ( ds / di ) ;
	
	xt = ObjTarget->obj_ixpo[pl % DEPTH_LOOKAHEAD] ;
	yt = ObjTarget->obj_iypo[pl % DEPTH_LOOKAHEAD] ;

	dx = xt - xs ;
	dy = yt - ys ;

	ws = atan2 ( dy, dx ) * 180.0 / PI ; 

	ws = ObjShip->obj_angl - ws ;
	if ( ws < -180.0 ) {
		ws = 360.0 + ws ;
	}
	if ( ws >  +180.0 ) {
		ws = ws - 360.0 ;
	}

	su = +0.1 ;
	if ( ws < 0.0 ) {
		su = -0.1 ;
	}

    tu = (int) ( ( ws + su ) / 3.6 ) ;
    tu = (int) ( ws / 3.6 ) ;

	if ( tu < 0 ) {
		SetKeyLeft  = 1 ;
		SetKeyRight = 0 ;
		ast_adjust_shot_table_pointer ( -1, ObjShip ) ;
	}
	else {
	    if ( tu > 0 ) {
		    SetKeyRight = 1 ;
		    SetKeyLeft  = 0 ;
		    ast_adjust_shot_table_pointer ( +1, ObjShip ) ;
		} 
		else {
			if ( OBJ_UFOUFO == ObjTarget->obj_type ) {
			    if ( ShipShots < 4  &&  0 == ( AstKeys & KEY_FIRE ) ) {
				    ObjTarget->obj_mysh =  ObjTarget->obj_dist / id  ;
    			    SetKeyFire = 1 ;
				}
			}
			else {
				if ( ShipShots < 4  &&  0 == ( AstKeys & KEY_FIRE ) ) {
	                ObjTarget->obj_mysh =  ObjTarget->obj_dist * 3 / id ;
		            SetKeyFire = 1 ;
				}
			}
		}
	}

	if ( 0 != SetKeyFire ) {
		LastShotT = ObjTarget->obj_type ;
		LastShotX = (int) ObjTarget->obj_xpos ;
		LastShotY = (int) ObjTarget->obj_ypos ;
		if ( 0 != ( TraceF & TRACE_SHOTS )  &&  NULL != TraceFp ) {
            fprintf ( TraceFp, "*Shot initiated: a=%6.2f L=%d R=%d AstKeys=0x%02X\n", 
				      ObjShip->obj_angl, SetKeyLeft, SetKeyRight, AstKeys ) ;
		}
	}

    return ;
}



static void ast_dodge ( void )
/* ------------------------------------------------------------------------ */
/* Halte Ausschau nach                                                      */
/* - unvermeidbaren Kollisionen                                             */
/* - UFO Schssen                                                           */
/* und drckt notfalls den "Hyperspace"-Knopf                               */
/* Zeigt das Schiff gerade in die Richtung von AstSafeX,AstSafeY dann gib   */
/* ab und zu mal Schub dahin mit dem "Thrust"-Knopf                         */
/* ------------------------------------------------------------------------ */
{
	int      ix   ;
	double   xs   ;
	double   ys   ;
	double   xd   ;
	double   yd   ;
	double   xt   ;
	double   yt   ;
	double   ra   ;
	OBJREC  *pt   ;


	xs = ObjShip->obj_xpos ;
	ys = ObjShip->obj_ypos ;

	ix =       0 ;
	pt = Objects ;
	while ( OBJ_NIXNIX != pt->obj_type  &&  ix < MAX_OBJECTS ) {
        if ( OBJ_A_SHOT == pt->obj_type  &&  '*' != pt->obj_mysh ) {
			xt = pt->obj_xpos ;
			yt = pt->obj_ypos ;
			xd = xs - xt ;
			yd = ys - yt ;
			if ( 30.0 > sqrt ( xd * xd + yd * yd ) ) {
               ++ SetKeyHyper ;
			   // fprintf ( stderr, "Hyper - UFO shot ! \n" ) ;
			   ix = MAX_OBJECTS ;
			}
		} /* end if ein UFO Schuss */
		++ ix ;
		++ pt ;
	}

	ix =       0 ;
	pt = Objects ;
	while ( 0 == SetKeyHyper  &&  OBJ_NIXNIX != pt->obj_type  &&  ix < MAX_OBJECTS ) {
        if ( OBJ_UFOUFO == pt->obj_type  ||  
			 OBJ_ASTER1 == pt->obj_type  ||
			 OBJ_ASTER2 == pt->obj_type  ||
			 OBJ_ASTER3 == pt->obj_type  ||
			 OBJ_ASTER4 == pt->obj_type ) {
			xt = (double) pt->obj_ixpo[0] ;
			yt = (double) pt->obj_iypo[0] ;
			xd = xs - xt ;
			yd = ys - yt ;
			if ( ( pt->obj_size * 0.9 ) > sqrt ( xd * xd + yd * yd ) ) {
			   // fprintf ( stderr, "Hyper - Collision ! \n" ) ;
               ++ SetKeyHyper ;
			   ix = MAX_OBJECTS ;
			}
		} /* end if ein Zielobjekt */
		++ ix ;
		++ pt ;
	}

	if ( 0 == SetKeyHyper  &&  0 == SetKeyFire ) {
		xd = AstSafeX - xs ;
		yd = AstSafeY - ys ;
		if ( 100.0 < sqrt ( xd * xd + yd * yd ) ) {
            ra = atan2 ( yd, xd ) * 180.0 / PI ;
			if ( fabs ( ra - ObjShip->obj_angl ) < 20.0 ) {
				if ( 0 == ( FrameCounter % 5 )  &&  0 < AsterAnz ) {
    				++ SetKeyThrust ;
				}
			}
		}
	}

    return ;
}



void ast_berechnungen ( void )
/* --------------------------------------------------------------------- */
/* Berechne die Flugbahnen und die Schuss-Prioritten                    */
/* --------------------------------------------------------------------- */
{
	ast_predict_movements ( ) ;
	ast_pick_target ( ) ;
	if ( NULL != ObjShip ) {
	    if ( NULL != ObjTarget ) {
   		    ast_shoot_target ( ) ;
		}
   		ast_dodge ( ) ;
	}
	return ;
}