// Marcus Brand

#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#include "player.h"
#include <stdio.h>
#include <math.h>

// global
/////////////////////////////////////////////////////////////////////////////
// dx normalisieren auf -512 ... 511, dy normalisieren auf -384 ... 383
void Normalize(int &x, int &y)
{
	while (x < -512) 
		x += 1024;
	while (x > 511) 
		x -= 1024;
	while (y < -384) 
		y += 768;
	while (y > 383) 
		y -= 768;
}

// dx normalisieren auf -512 ... 511, dy normalisieren auf -384 ... 383
void Normalize(double &x, double &y)
{
	while (x < -512.) 
		x += 1024.;
	while (x > 511.) 
		x -= 1024.;
	while (y < -384.) 
		y += 768.;
	while (y > 383.) 
		y -= 768.;
}

// dx normalisieren auf 0 ... 1023, dy normalisieren auf 128 ... 895 (?)
void NormPos(int &x, int &y)
{
	while (x < 0) 
		x += 1024;
	while (x > 1023) 
		x -= 1024;
	while (y < 128) 
		y += 768;
	while (y > 895) 
		y -= 768;
}

int norm256(int i) // funktioniert nur ab -256
{ 
	return (i + 256) % 256; 
}

int DoubleToInt(double d)
{
	if (d > 0) {
		return (int)(d + 0.5);
	} else {
		return (int)(d - 0.5);
	}
}

double absSquare(const MyVektor &A, const MyVektor &B)
{
	double Diffx = A.x - B.x;
	double Diffy = A.y - B.y;
	Normalize(Diffx, Diffy);

	return Diffx*Diffx + Diffy*Diffy;
}

// msste OK sein, ohne Normierungen (vorausgesetzt, dass A und B normiert sind)
double Kreuzprodukt(const MyVektor &A, const MyVektor &B)
{
	return A.x*B.y - A.y*B.x;
}

/*void MyVektor::NormVekt(double dx, double dy) // macht einen normierten Vektor draus
{
	x = sqrt(1);
}*/

//Asteroid
//////////////////////////////////////////////////////////////////////////////
void Asteroid::set(int x, int y, int type, int sf)
{
	this->x = x;
	this->y = y;
	this->type = type;
	this->sf = sf;
}

void Shot::set(int x, int y)
{
	this->x = x;
	this->y = y;
}

void Saucer::set(int x, int y, int Size)
{
	m_Size = Size;
	this->x = x;
	this->y = y;
}

void Ship::set(int x, int y, int LookX, int LookY)
{
	this->x = x;
	this->y = y;
	m_LookX = LookX;
	m_LookY = LookY;
}

GameStatus::GameStatus()
{
	m_iShotMapPos = 0;
	m_iShotMapModify = 0;
	m_bFire = false;

	m_Ship.x = 524;
	m_Ship.y = 524;
	m_Ship.m_dDX = 0.0;
	m_Ship.m_dDY = 0.0;
	m_iShotMapPos = 0;
	m_iShotMapModify = 0;
}

void GameStatus::clear(void)
{
	ship_present = false;
	saucer_present = false;
	nasteroids = 0;
	nshots = 0;
}

KeysPacket::KeysPacket(void)
{
	signature[0] = 'c';
	signature[1] = 't';
	signature[2] = 'm';
	signature[3] = 'a';
	signature[4] = 'm';
	signature[5] = 'e';
	keys = '@';
	ping = 0;
}

void KeysPacket::clear(void)
{
	keys = '@';
}

/*void KeysPacket::hyperspace(bool b)
{
	if (b)
		keys |= KEY_HYPERSPACE;
	else
		keys &= ~KEY_HYPERSPACE;
}

void KeysPacket::fire(bool b)
{
	if (b)
		keys |= KEY_FIRE;
	else
		keys &= ~KEY_FIRE;
}

void KeysPacket::thrust(bool b)
{
	if (b)
		keys |= KEY_THRUST;
	else
		keys &= ~KEY_THRUST;
}

void KeysPacket::left(bool b)
{
	if (b)
	{
		keys |= KEY_LEFT;
		right(false);
	}
	else
		keys &= ~KEY_LEFT;
}

void KeysPacket::right(bool b)
{
	if (b)
	{
		keys |= KEY_RIGHT;
		left(false);
	}
	else
		keys &= ~KEY_RIGHT;
}*/

//////////////////////////////////////////////////////////////////
// print

void printTarget(FlyingObj *pTarget)
{
	char sTyp[100], sSize[100];
	memset(sTyp, 0, 100);
	memset(sSize, 0, 100);
	int iCC;

	//Abstand muss natrlich abhngig sein von Geschwindigkeit Schuss/Target (vielleicht reicht Schuss)
	if (pTarget->IsAsteroid()) {
		sprintf_s(sTyp, "Asteroid");
		Asteroid *pAst = dynamic_cast<Asteroid *>(pTarget);
		if (pAst->IsBig()) {// && dDiff < 40) {
			sprintf_s(sSize, "Big");
		} else if (pAst->IsMiddle()) {// && dDiff < 20) {
			sprintf_s(sSize, "Middle");
		} else {// if (dDiff < 8) {
			sprintf_s(sSize, "Small");
		}
		iCC = pAst->m_iCC;
	} else {
		if (!pTarget->IsSaucer())
			int iDebug = 0;
		sprintf_s(sTyp, "Saucer");
		Saucer *pSau = dynamic_cast<Saucer *>(pTarget);
		if (pSau->IsBig()) {// && dDiff < 15) {
			sprintf_s(sSize, "Big");
		} else {// if (dDiff < 7) {
			sprintf_s(sSize, "Small");
		}
		iCC = -1;
	}
	printf("Target: %s %s, x = %d, y = %d, CC = %d\n", sTyp, sSize, pTarget->x, pTarget->y, iCC);
}