// player.cpp: Beispielspieler fr Asteroids
// Harald Bgeholz / c't
// weiterentwickelt von Marcus Brand

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include <math.h>

#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes fr socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes fr inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes fr fcntl()
#include <unistd.h>
#include <fcntl.h>
// fr memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#include "player.h"

Player::Player(SOCKET sd, ADDRESS server_ip) : sd(sd), server_ip(server_ip) 
{
	InitShotMap();

	m_nMyShots = 0;
	m_Keys = '@';
	m_iPrevPrevMod = 0;
	m_StatPrev.clear();
	m_iNextShotInd = 0;
	m_iNextTargetInd = 0;
	t = 0;
	m_iCCMin = 0;
	m_iCCReduce = 1;//CC_SIZE;
	m_CCSize = 1;
	m_CCCount = 1;
}


void Player::Run(void)
{
	FramePacket frame;
	KeysPacket keys;
	char prevframe = 0;

	for (;;)
	{
		++t;         // Zeit
#ifdef _DEBUG
		if (t == 18000)
			int iDebug = 0;
#endif
		++keys.ping; // jedes gesendete Pckchen erhlt eine individuelle Nummer zur Latenzmessung
		keys.setPacket(m_Keys);
		SendPacket(keys);
		ReceivePacket(frame);

		if (frame.frameno != ++prevframe || frame.ping != keys.ping)
		{
			m_nLostFrames = frame.frameno - prevframe + 1;
			printf("\nLatenz %d. %d Frames verloren.\n\n", keys.ping - frame.ping, m_nLostFrames);
			prevframe = frame.frameno;
		} else {
			m_nLostFrames = 0;
		}

		InterpretScreen(frame);

	//todo bin mir noch nicht sicher, ob das gut ist, ich denke aber doch, 96000 bers Netz
		if (m_StatCur.m_Ship.x < 768 && m_StatCur.m_Ship.x > 256) { // mittig
			m_CCSize = 1;
			m_CCCount = 1;
		} else {
			m_CCSize = CC_SIZE;
			m_CCCount = CC_COUNT;
		}
		// Erstmal das 0 setzen, was nicht gesetzt worden ist, alternativ knnte man das auch in 
		// InterpretScreen machen
		InitStatCur();

		keys.clear();   // alle Tasten loslassen
		m_Keys = '@';
		m_pPrimTarget = NULL;

		ReduceCC();

		// Asteroiden checken
		SetAsteroidVektoren();
		// UFO checken
		SetSaucerVektor();

/*		for (int i = 0; i < m_StatCur.nshots; i++) { // Quadrat von Abstand Schuss/Schiff < 450
			if ((m_StatCur.m_Ship.x - m_StatCur.shots[i].x) * (m_StatCur.m_Ship.x - m_StatCur.shots[i].x) +
				(m_StatCur.m_Ship.y - m_StatCur.shots[i].y) * (m_StatCur.m_Ship.y - m_StatCur.shots[i].y) < 450)
				int iDebug = 0;
		}*/

		// Schsse checken
		SetShotVektoren();

		//SetShipVektor(); //Test1

		// Geschah bisher in CheckandDoFire, besser mal vor CheckAndDoFire!
		// den virtuellen, tatschlich aktuellen Spielstand (der gerade mit meinen Eingaben berechnet wird), ermitteln
		CalcStatVirt(); 

		CompareShotsAndCorrectMap();

		// nur handeln, wenn Schiff prsent, analysieren aber auch ohne!
		if (m_StatCur.ship_present)
		{
			if (NeedToJump()) {
				m_Keys |= KEY_HYPERSPACE;
			} else { // ohne else wird ShotMap sonst falsch
				// Ziel bestimmen und schiessen
				int CCFound = SetCollClasses();
				CheckAndDoFire(CCFound);

				// 21.6. neu, Extrashot, wenn gesprungen oder kaputt, 23.6. nur noch dann, m_iExtraShot gelscht
				if (!m_StatCur.m_bFire && m_StatCur.ship_present && !m_StatPrev.ship_present) {
					Shoot(NULL);
				}

				CenterBackOfShip();
			}

		} else { // if (m_StatCur.ship_present)
			// wenn Schiff gerade gesprungen oder zerstrt, muss die letzte nderung zurckgenommen werden
			if (m_StatPrev.ship_present) {
				m_StatCur.m_iShotMapPos = norm256(m_StatCur.m_iShotMapPos - m_iPrevPrevMod);
				resetMyShots();
			}
			// diese Befehle sind nicht mehr umgesetzt worden
			m_StatPrev.m_iShotMapModify = 0;
			m_StatCur.m_iShotMapModify = 0;
//			m_iPrevPrevMod = 0; // dieser schon!
		}

		m_iPrevPrevMod = m_StatPrev.m_iShotMapModify; // Stand vorher in (if ShipPresent, so deutlich besser)

		m_StatPrev = m_StatCur; // fr nchste Runde m_StatCur als Prev speichern

	} // for (;;)
}

void Player::InterpretScreen(FramePacket &packet)
{
	unsigned short vector_ram[512];
	int dx, dy, sf, vx, vy, vz, vs;
	int v1x = 0;
	int v1y = 0;
	int shipdetect = 0;

	m_StatCur.clear();

	/* Vektor-RAM in 16-Bit-Worte konvertieren. War in der ersten Version mal ein sportlicher
	Typecast: unsigned short *vector_ram = (unsigned short*)packet.vectorram;
	Das klappt aber nur auf Little-Endian-Systemen, daher besser portabel: */
	for (int i=0; i<512; ++i)
		vector_ram[i] = (unsigned char)packet.vectorram[2*i] | (unsigned char)packet.vectorram[2*i+1] << 8;

	if (vector_ram[0] != 0xe001 && vector_ram[0] != 0xe201)
		return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

	int pc = 1;
	while (pc < 512)
	{
		int op = vector_ram[pc] >> 12;
		switch (op)
		{
		case 0xa: // LABS
			vy = vector_ram[pc] & 0x3ff;
			vx = vector_ram[pc+1] & 0x3ff;
			vs = vector_ram[pc+1] >> 12;
			break;
		case 0xb: // HALT
			return;
		case 0xc: // JSRL
			switch (vector_ram[pc] & 0xfff)
			{
			case 0x8f3:
				m_StatCur.asteroids[m_StatCur.nasteroids++].set(vx, vy, 1, vs);
				break;
			case 0x8ff:
				m_StatCur.asteroids[m_StatCur.nasteroids++].set(vx, vy, 2, vs);
				break;
			case 0x90d:
				m_StatCur.asteroids[m_StatCur.nasteroids++].set(vx, vy, 3, vs);
				break;
			case 0x91a:
				m_StatCur.asteroids[m_StatCur.nasteroids++].set(vx, vy, 4, vs);
				break;
			case 0x929:
				m_StatCur.saucer_present = true;
				m_StatCur.m_Saucer.x = vx;
				m_StatCur.m_Saucer.y = vy;
				m_StatCur.m_Saucer.m_Size = vs;
				break;
			}  
			break;
		case 0xd: // RTSL
			return;
		case 0xe: // JMPL
			/*
			pc = vector_ram[pc] & 0xfff;
			break;
			*/
			return;
		case 0xf: // SVEC
			/*
			dy = vector_ram[pc] & 0x300;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = (vector_ram[pc] & 3) << 8;
			if ((vector_ram[pc] & 4) != 0)
				dx = -dx;
			sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
			vz = (vector_ram[pc] & 0xf0) >> 4;
			*/
			break;
		default:
			dy = vector_ram[pc] & 0x3ff;
			if ((vector_ram[pc] & 0x400) != 0)
				dy = -dy;
			dx = vector_ram[pc+1] & 0x3ff;
			if ((vector_ram[pc+1] & 0x400) != 0)
				dx = -dx;
			sf = op;
			vz = vector_ram[pc+1] >> 12;
			if (dx == 0 && dy == 0 && vz == 15)
				m_StatCur.shots[m_StatCur.nshots++].set(vx, vy);
			if (op == 6 && vz == 12 && dx != 0 && dy != 0)
			{
				switch (shipdetect)
				{
				case 0:
					v1x = dx;
					v1y = dy;
					++shipdetect;
					break;
				case 1:
					m_StatCur.ship_present = true;
					m_StatCur.m_Ship.x = vx;
					m_StatCur.m_Ship.y = vy;
					m_StatCur.m_Ship.m_LookX = v1x - dx;
					m_StatCur.m_Ship.m_LookY = v1y - dy;
					++shipdetect;
					break;
				}
			}
			else if (shipdetect == 1)
				shipdetect = 0;

			break;
		}
		if (op <= 0xa)
			++pc;
		if (op != 0xe) // JMPL
			++pc;
	}   

}



void Player::ReceivePacket(FramePacket &packet)
{
	sockaddr_in sender;
	int sender_size = sizeof sender;
	fd_set readfds, writefds, exceptfds;

//	int iTry = 0; //MB

	do
	{
//		TRACE("%d Trys ReceivePacket\n", iTry++); //MB
//		iTry++;

		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		FD_SET(sd, &exceptfds);
		select(sd+1, &readfds, &writefds, &exceptfds, NULL);
		int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
		if (bytes_received != sizeof packet)
		{
			int err = WSAGetLastError();
			fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
			exit(1);
		}
		FD_ZERO(&readfds);
		FD_ZERO(&writefds);
		FD_ZERO(&exceptfds);
		FD_SET(sd, &readfds);
		timeval zero;
		zero.tv_sec = zero.tv_usec = 0;
		select(sd+1, &readfds, &writefds, &exceptfds, &zero);
	} while(FD_ISSET(sd, &readfds));

//liefert immer 1	printf("%d Trys ReceivePacket\n", iTry); //MB, nicht, wenn Pause gedrckt
}

void Player::SendPacket(KeysPacket &packet)
{
	sockaddr_in server;
	memset(&server, 0, sizeof server);
	server.sin_family = AF_INET;
	server.sin_port = htons(1979);
	server.sin_addr.s_addr = server_ip;
	if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
	{
#if defined(WINDOWS)
		int err = WSAGetLastError();
		if (err != WSAEWOULDBLOCK)
		{
			fprintf(stderr, "Fehler %d bei sendto().\n", err);
			exit(1);
		}
#else
		if (errno != EAGAIN)
		{
			perror("Fehler bei sendto()");
			exit(1);
		}
#endif
	}
} 

bool Player::CheckAndDoFire(int CCFound)
{		
	// hier knnen auch wieder die Konstanten genommen werden, rausgenommen
	m_iMaxTurns = TURNS_FOR_SHOOT_CALC;
	//todo bin mir noch nicht sicher, ob das gut ist, scheint ohne etwas besser
/*	if (m_StatCur.nasteroids > 17) {
		m_iMaxSlt = 33;
	} else if (m_StatCur.nasteroids > 11) {
		m_iMaxSlt = 55;p
	} else*/ {
		m_iMaxSlt = SLT;
	}

	int iAst, iRadius, iStep;

	bool bHit = false, bShot = false, bTurned = false, bReturn = false;
	double dDiffM, dDiffL, dDiffR, dDiffMPrim = DBL_MAX, dDiffRPrim = DBL_MAX, dDiffLPrim = DBL_MAX;
	int iMaxTurn = m_iMaxTurns; //TURNS_FOR_SHOOT_CALC;

	if (!CCFound) { // Prioritt der kleinsten Klasse vor UFO setzen
		m_pPrimTarget = NULL;
	}

	if (!m_pPrimTarget) { // sonst UFO
		for (iAst = 0; iAst < m_StatVirt.nasteroids; iAst++) {
			Asteroid &Ast = m_StatVirt.asteroids[iAst];
			if (Ast.m_iCC == CCFound) {
/*				if (m_StatCur.m_Ship.m_dDX > 0.0 || m_StatCur.m_Ship.m_dDX > 0.0) {
					iRadius = Ast.m_iSmallRadius / 2;
					iRadius *= iRadius;
				} else {*/
					iRadius = Ast.m_iSmallRadius * Ast.m_iSmallRadius; // hier Quadrat
//				}
				if (CalcTimeToShoot(iRadius, iStep, dDiffM, dDiffR, dDiffL, &Ast, iMaxTurn)) {
					m_pPrimTarget = &Ast;
					dDiffLPrim = dDiffL;
					dDiffRPrim = dDiffR;
					dDiffMPrim = dDiffM;
					iMaxTurn = iStep;
					bHit = true;
					if (iMaxTurn == 0) {
						break;
					}
				}
			}
		}

	} else {
		if (!m_pPrimTarget->IsSaucer()) {
			int iDebug = 0;
		}
/*		if (m_StatCur.m_Ship.m_dDX > 0.0 || m_StatCur.m_Ship.m_dDX > 0.0) {
			iRadius = m_pPrimTarget->m_iSmallRadius / 2;
			iRadius *= iRadius;
		} else {*/
			iRadius = m_pPrimTarget->m_iSmallRadius * m_pPrimTarget->m_iSmallRadius; // hier Quadrat
//		}
		bHit = CalcTimeToShoot(iRadius, iMaxTurn, dDiffMPrim, dDiffRPrim, dDiffLPrim, m_pPrimTarget, 
			m_iMaxTurns); //TURNS_FOR_SHOOT_CALC);
	}

	if (bHit) {
		bReturn = true;
		if (iMaxTurn == 0) { 
			Shoot(m_pPrimTarget);
			bShot = true;
		}
		// wenn geschossen, fertig fr Ufos und Kleine
		if (iMaxTurn || !WasShotAt(*m_pPrimTarget)) { //!(m_pPrimTarget->IsSaucer() || m_pPrimTarget->IsSmall())) {
			if (dDiffLPrim < dDiffMPrim && dDiffLPrim < dDiffRPrim) { 
				TurnLeft();
			} else if (dDiffRPrim < dDiffMPrim) { 
				TurnRight();
			}
			bTurned = true; // auch wenn er wartet, also nicht wirklich gedreht hat
		}
	}

	if (bTurned) {
		if (bShot || iMaxTurn == 1) {
			return true; // wenn er geschossen hat und hinterherdreht oder auf Schussposition gedreht hat, fertig
		} else { //fr alle mit CC <= m_CCCount prfen, ob ich sie direkt treffe
			for (iAst = 0; iAst < m_StatVirt.nasteroids; iAst++) {
				Asteroid &Ast = m_StatVirt.asteroids[iAst];
				if (Ast.m_iCC <= m_CCCount) {
/*					if (m_StatCur.m_Ship.m_dDX > 0.0 || m_StatCur.m_Ship.m_dDX > 0.0) {
						iRadius = Ast.m_iSmallRadius / 2;
						iRadius *= iRadius;
					} else {*/
						iRadius = Ast.m_iSmallRadius * Ast.m_iSmallRadius;
//					}
					if (CalcTimeToShoot(iRadius, iStep, dDiffM, dDiffR, dDiffL, &Ast, 0) 
						&& !iStep) // CalcTimeToShoot prft auch auf 1, wegen Drehrichtung, prfen, ob ntig
					{
						Shoot(&m_StatVirt.asteroids[iAst]);
						return true;
					}
				}
			}
		}
		return true;
	} else {
		// kommt hierher, wenn er nichts gefunden hat (bHit == false und bTurned == false, oder wenn er das PrimTarget 
		// abgeschossen hat und nicht weiter hinterherdrehen will (WasShotAt == true)
/*todo... lasse ich erstmal, ist wohl weniger wichtig
		if (bShot) { // fertig mit PrimTar (deshalb oben bTurned, auch wenn nicht gedreht)
			// neues suchen, versuchen drauf zuzudrehen
			m_pPrimTarget = NULL;
			if (m_pPrimTarget) {
				return;
			}
		}*/
		// Zeit, um sich das nchstbeste Ziel zu suchen, bis PrimTarget "eingeloggt"
		double dDiffMSec, dDiffRSec, dDiffLSec;
		bHit = false;
		iMaxTurn = m_iMaxTurns; //TURNS_FOR_SHOOT_CALC;
		for (iAst = 0; iAst < m_StatVirt.nasteroids; iAst++) {
			Asteroid &Ast = m_StatVirt.asteroids[iAst];
			if (Ast.m_iCC <= m_CCCount) {
/*				if (m_StatCur.m_Ship.m_dDX > 0.0 || m_StatCur.m_Ship.m_dDX > 0.0) {
					iRadius = Ast.m_iSmallRadius / 2;
					iRadius *= iRadius;
				} else {*/
					iRadius = Ast.m_iSmallRadius * Ast.m_iSmallRadius; // hier Quadrat
//				}
				if (CalcTimeToShoot(iRadius, iStep, dDiffM, dDiffR, dDiffL, &Ast, iMaxTurn)) {
					m_pPrimTarget = &Ast;
					dDiffLSec = dDiffL;
					dDiffRSec = dDiffR;
					dDiffMSec = dDiffM;
					iMaxTurn = iStep;
					bHit = true;
					if (iMaxTurn == 0) {
						break;
					}
				}
			}
		}

		if (bHit) {
			if (iMaxTurn == 0 && !bShot) { 
				Shoot(m_pPrimTarget);
			}
			// wenn geschossen, fertig fr Kleine, dann knnte ich jetzt nochmal das nchste suchen
			if (iMaxTurn || !WasShotAt(*m_pPrimTarget)) { //!m_pPrimTarget->IsSmall()) {
				if (dDiffLSec < dDiffMSec && dDiffLSec < dDiffRSec) { 
					TurnLeft();
				} else if (dDiffRSec < dDiffMSec) { 
					TurnRight();
				}
				bTurned = true; // auch wenn er wartet, also nicht wirklich gedreht hat
			}
			return true;
		}
	}
	return bReturn;

	//erstmal raus, wenn Funktion in Schleife aufgerufen wird
	if (!bTurned && t%2
		) { // nochmal das nchste ist mir jetzt zu aufwndig, drehe auf das Prim zu
		if (dDiffLPrim < dDiffMPrim && dDiffLPrim < dDiffRPrim) { 
			TurnLeft();
		} else if (dDiffRPrim < dDiffMPrim) { 
			TurnRight();
		}
	}
}

#ifdef SLT_INCL
// berechnet, wie nahe der Schuss dem Ziel kommt, wenn Schiff fr diesen Schuss gedreht worden ist, geht das in 
// iShotIndex und iTimeToTurn ein
void Player::CalcShot(FlyingObj *pTarget, int iShotIndex, double &DistMin, int iTimeToTurn, int iRadius, int &iHit)
{
	iHit = INT_MAX;
	// o = Ortsvektor, r = Richtungsvektor, s = Ship, t = Target
	double xos = m_StatVirt.m_Ship.x + m_ShotMap[iShotIndex].m_xFirst,
		yos = m_StatVirt.m_Ship.y + m_ShotMap[iShotIndex].m_yFirst,
		xrs = m_ShotMap[iShotIndex].m_dDX, yrs = m_ShotMap[iShotIndex].m_dDY, // Flugbahn des Schusses
		xot = pTarget->x, yot = pTarget->y, 
		xrt = pTarget->m_dDX, yrt = pTarget->m_dDY;
	// Zeit bis zum 1. Auftauchen des Schusses (+2 bei StatCur), gendert auf 1 (bei StatVirt)
	double dT = (double)(iTimeToTurn + 1); 
	// x-Gleichung nach M umstellen
	// xos + (dT + L)*xrs = xot + M*xrt
	// M = (xos - xot + (dT + L)*xrs)/xrt;
	// y-Gleichung nach L
	// L = (yot - yos + (M - dT)*yrt)/yrs;
	// einsetzen
	// L = (yot - yos + (((xos - xot + (dT + L)*xrs)/xrt) - dT)*yrt)/yrs;
	// umstellen
	// L * (yrs*xrt - xrs*yrt) = xrt*(yot - yos) + yrt(xos - xoa + iT*(xrs - xra));
	double xs = DBL_MAX, ys = DBL_MAX, xt = DBL_MAX, yt = DBL_MAX, DistTmp, DiffX, DiffY;//, iTime;
	DistMin = DBL_MAX;
//	double xsTmp, ysTmp, xtTmp, ytTmp;
	//++ statt + 0.1 scheint nicht (kaum?) schlechter (0.1 = 0.5 = 76000, ++ 79000 (mit allerdings mehr Versuchen)
//	for (double i = dT; i < SLT + dT; // das ist wohl dafr verantwortlich, dass er manchmal so spt schiesst && i < 80; 
	for (double i = dT; i < m_iMaxSlt + dT; // das ist wohl dafr verantwortlich, dass er manchmal so spt schiesst && i < 80; 
		i++) {
		//i += 0.2) { // sicher: 60. 
		xs = xos + (i - dT)*xrs;
		ys = yos + (i - dT)*yrs;
		xt = xot + i*xrt;
		yt = yot + i*yrt;
		DiffX = xs - xt;
		DiffY = ys - yt;
		Normalize(DiffX, DiffY); // kann es hieran liegen, dass er schneller den Index verliert?
		DistTmp = DiffX * DiffX + DiffY * DiffY;
		if (DistTmp < DistMin) {
			DistMin = DistTmp; // eigentlich wrde es auch der 1. tun, wre sogar besser
			if (DistMin <= iRadius) {
				iHit = (int)i;
				return;
			}
		}
	}
}

#else

// berechnet, wie nahe der Schuss dem Ziel kommt, wenn Schiff fr diesen Schuss gedreht worden ist, geht das in 
// iShotIndex und iTimeToTurn ein
void Player::CalcShot(FlyingObj *pTarget, int iShotIndex, double &DistMin, int iTimeToTurn)
{
	// o = Ortsvektor, r = Richtungsvektor, s = Ship, t = Target
	double xos = m_StatVirt.m_Ship.x + m_ShotMap[iShotIndex].m_xFirst,
		yos = m_StatVirt.m_Ship.y + m_ShotMap[iShotIndex].m_yFirst,
		xrs = m_ShotMap[iShotIndex].m_dDX, yrs = m_ShotMap[iShotIndex].m_dDY, // Flugbahn des Schusses
		xot = pTarget->x, yot = pTarget->y, 
		xrt = pTarget->m_dDX, yrt = pTarget->m_dDY;
	// Zeit bis zum 1. Auftauchen des Schusses (+2 bei StatCur), gendert auf 1 (bei StatVirt)
	double dT = (double)(iTimeToTurn + 1); 
	// x-Gleichung nach M umstellen
	// xos + (dT + L)*xrs = xot + M*xrt
	// M = (xos - xot + (dT + L)*xrs)/xrt;
	// y-Gleichung nach L
	// L = (yot - yos + (M - dT)*yrt)/yrs;
	// einsetzen
	// L = (yot - yos + (((xos - xot + (dT + L)*xrs)/xrt) - dT)*yrt)/yrs;
	// umstellen
	// L * (yrs*xrt - xrs*yrt) = xrt*(yot - yos) + yrt(xos - xoa + iT*(xrs - xra));
	double xs = DBL_MAX, ys = DBL_MAX, xt = DBL_MAX, yt = DBL_MAX, DistTmp, DiffX, DiffY;//, iTime;
	DistMin = DBL_MAX;
//	double xsTmp, ysTmp, xtTmp, ytTmp;
	//++ statt + 0.1 scheint nicht (kaum?) schlechter (0.1 = 0.5 = 76000, ++ 79000 (mit allerdings mehr Versuchen)
//	for (double i = dT; i < SLT + dT; // das ist wohl dafr verantwortlich, dass er manchmal so spt schiesst && i < 80; 
	for (double i = dT; i < m_iMaxSlt + dT; // das ist wohl dafr verantwortlich, dass er manchmal so spt schiesst && i < 80; 
#ifdef _DEBUG
		i++) {
#else
		i += SHOT_CALC_STEP_WIDTH) {
#endif
		xs = xos + (i - dT)*xrs;
		ys = yos + (i - dT)*yrs;
		xt = xot + i*xrt;
		yt = yot + i*yrt;
		DiffX = xs - xt;
		DiffY = ys - yt;
		Normalize(DiffX, DiffY); // kann es hieran liegen, dass er schneller den Index verliert?
		DistTmp = DiffX * DiffX + DiffY * DiffY;
		if (DistTmp < DistMin) {
			DistMin = DistTmp; // eigentlich wrde es auch der 1. tun, wre sogar besser
		}
	}
}

#endif

void Player::TurnLeft()
{
#ifdef _DEBUG
	if (m_Keys & KEY_LEFT || m_Keys & KEY_RIGHT) // sollte nicht passieren
		int iDebug = 0;
#endif

	m_Keys |= KEY_LEFT;
	m_StatCur.m_iShotMapModify = -1;
}

void Player::TurnRight()
{
#ifdef _DEBUG
	if (m_Keys & KEY_LEFT || m_Keys & KEY_RIGHT) // sollte nicht passieren
		int iDebug = 0;
#endif

	m_Keys |= KEY_RIGHT;
	m_StatCur.m_iShotMapModify = 1;
}

//todo: zumindest auf den Saucer deutlich frher schiessen (70 Frames), aber das noch nicht als getroffen zhlen
void Player::SetSaucerVektor() 
{
	//todo: alle PrimTarget Zuweisungen raus, Abfrage auf WasShotAt in SetTarget
	int i;

	if (m_StatCur.saucer_present)
	{
		if (m_StatCur.m_Saucer.IsBig()) {
			m_StatCur.m_Saucer.m_iSmallRadius = 12; //OK 9, scheint OK 17 Forum 12/20, Sample-Programm: dist = 20*12
			m_StatCur.m_Saucer.m_iBigRadius = 21; // 20 zu klein
		} else {
			m_StatCur.m_Saucer.m_iSmallRadius = 7; //OK 4, scheint OK 6 Forum 8/10, Sample-Programm: dist = 10*6
			m_StatCur.m_Saucer.m_iBigRadius = 10;
		}

		// Richtungsvektor setzen, ID etc. vererben
		if (m_StatPrev.saucer_present) {
			m_StatCur.m_Saucer.m_dDX = m_StatCur.m_Saucer.x - m_StatPrev.m_Saucer.x;
			m_StatCur.m_Saucer.m_dDY = m_StatCur.m_Saucer.y - m_StatPrev.m_Saucer.y;
			Normalize(m_StatCur.m_Saucer.m_dDX, m_StatCur.m_Saucer.m_dDY);
			if (m_nLostFrames > 0) {
				m_StatCur.m_Saucer.m_dDX /= m_nLostFrames;
				m_StatCur.m_Saucer.m_dDY /= m_nLostFrames;
			}
			m_StatCur.m_Saucer.m_iID = m_StatPrev.m_Saucer.m_iID;

			//todo 1. Schritt: UFO nur dann als PrimTarget, wenn es entweder die Richtung gewechselt hat oder neu
			if (m_StatCur.m_Saucer.m_dDX != m_StatPrev.m_Saucer.m_dDX
				|| m_StatCur.m_Saucer.m_dDY != m_StatPrev.m_Saucer.m_dDY) // hat Richtung gewechselt
			{
				m_pPrimTarget = &m_StatCur.m_Saucer;
				for (i = 0; i < 4; i++) { // Schleife ber MyShots
					// wenn MyShot das UFO als Target hat
					if (m_MyShots[i].m_iTargetID == m_StatCur.m_Saucer.m_iID) {
						m_MyShots[i].m_iTargetID = -1;
					}
				}
			} else {
/*				for (i = 0; i < 4; i++) {
					if (m_MyShots[i].m_iID != -1 && m_MyShots[i].m_iTargetID == m_StatCur.m_Saucer.m_iID) {
						break;
					}
				}
				if (i == 4) {*/
				// es fliegt bereits ein Schuss auf den Saucer zu => der einzige Fall, in dem es nicht
				// PrimTarget wird
				if (!WasShotAt(m_StatCur.m_Saucer)) {
					m_pPrimTarget = &m_StatCur.m_Saucer;
				}
			}
		} else {
			m_StatCur.m_Saucer.m_iID = m_iNextTargetInd++ % MAX_TARGET_IND;
			m_StatCur.m_Saucer.m_dDX = 0.0;
			m_StatCur.m_Saucer.m_dDY = 0.0;

			m_pPrimTarget = &m_StatCur.m_Saucer;
		}
	}
}

void Player::SetAsteroidVektoren()
{
	double dDX, dDY;
	int dx, dy;

	int anNeedsPrev[12]; // 12 versch. Ast-Typen
	for (int i = 0; i < 12; i++)
		anNeedsPrev[i] = 0;
	int iPrevInd;
	int iSummeNP = 0;
	for (int i = 0; i < m_StatCur.nasteroids; i++) {
		// fr jeden Asteroid den Zhler seiner Klasse hochzhlen
		if (m_StatCur.asteroids[i].IsSmall()) {
			iPrevInd = -1;
		} else if (m_StatCur.asteroids[i].IsMiddle()) {
			iPrevInd = 3;
		} else {
			iPrevInd = 7;
		}
		iPrevInd += m_StatCur.asteroids[i].type;
		anNeedsPrev[iPrevInd]++;
		iSummeNP++;
	}

	int sfAkt, typeAkt;

	for (int k = 0; k < 12; k++) { // Schleife ber die Typen
		if (k > 3) {
			if (k > 7) {
				sfAkt = 0; // gro
			} else {
				sfAkt = 15; // mittel
			}
		} else {
			sfAkt = 14; // klein
		}
		typeAkt = (k % 4) + 1;

		// erst die suchen, die sich ber die Vorgnger und deren Bewegungsvektoren halbwegs sicher erkennen lassen
		for (int i = 0; i < m_StatCur.nasteroids; i++) {
			if (m_StatCur.asteroids[i].sf != sfAkt || m_StatCur.asteroids[i].type != typeAkt) { // falscher Typ
				continue;
			}
			for (int j = 0; j < m_StatPrev.nasteroids; j++) {
				if (m_StatPrev.asteroids[j].m_dDX == DBL_MAX // den hat schon ein anderer als Vorgnger erkannt
					|| m_StatPrev.asteroids[j].sf != sfAkt || m_StatPrev.asteroids[j].type != typeAkt) 
				{
					continue;
				}
				// die Strecke, die er im letzten Frame zurckgelegt hat
				dx = m_StatCur.asteroids[i].x - m_StatPrev.asteroids[j].x;
				dy = m_StatCur.asteroids[i].y - m_StatPrev.asteroids[j].y;
				Normalize(dx, dy);
				if (m_nLostFrames > 0) {
					dx /= m_nLostFrames;
					dy /= m_nLostFrames;
				}
				// die Differenz zur vermuteten Strecke
				dDX = dx - m_StatPrev.asteroids[j].m_dDX;
				dDY = dy - m_StatPrev.asteroids[j].m_dDY;

				if (fabs(dDX) <= 1.0 && fabs(dDY) <= 1.0) { // hchstwahrscheinlich gefunden (akzeptier ich so)
					int iHowExactTmp = m_StatPrev.asteroids[j].iHowExact;
					if (iHowExactTmp > 0xFFFF) { // wird wohl reichen (irgendwann luft es sonst ber)
						iHowExactTmp = 0x7FFF;
					}
					// Richtungsvektoren iterativ genauer machen
					m_StatCur.asteroids[i].m_dDX = (m_StatPrev.asteroids[j].m_dDX * iHowExactTmp + dx) 
						/ (iHowExactTmp + 1);
					m_StatCur.asteroids[i].m_dDY = (m_StatPrev.asteroids[j].m_dDY * iHowExactTmp + dy) 
						/ (iHowExactTmp + 1);
					m_StatCur.asteroids[i].iHowExact = iHowExactTmp + 1;
					// ID und ShotID vererben
					m_StatCur.asteroids[i].m_iID = m_StatPrev.asteroids[j].m_iID;

					m_StatPrev.asteroids[j].m_dDX = DBL_MAX;
					anNeedsPrev[k]--;
					iSummeNP--;
					break;
				}
			}
		}
	} // for (int k = 0; k < 12; k++) { // Schleife ber die Typen
	// fertig mit denen, deren Vorgnger ich leicht gefunden habe

	// hier kommt jetzt das eigentliche, anfngliche zuordnen
	// todo: verbessern mit Kandidatenlisten (s. Zettel)
	// erstmal einfach den nchsten suchen und als Vorgnger nehmen
	// (knnte dazu fhren, dass er immer wegspringt)
	if (iSummeNP // es gibt noch welche, die keinen Vorgnger haben
		&& m_StatPrev.nasteroids > m_StatCur.nasteroids - iSummeNP) // und es gibt noch Kandidaten dafr
	{
		int iIndex = -1, iCand, distTmp, iMinTmp;
		for (int i = 0; i < iSummeNP; i++) { // die Verbliebenen
			iIndex++;
			while (m_StatCur.asteroids[iIndex].m_dDX != 0.0 && m_StatCur.asteroids[iIndex].m_dDY != 0.0) {
				iIndex++;
			}
			// Gre und Typ, die jetzt gesucht werden
			sfAkt = m_StatCur.asteroids[iIndex].sf;
			typeAkt = m_StatCur.asteroids[iIndex].type;
			if (m_StatCur.asteroids[iIndex].IsSmall()) {
					if (!anNeedsPrev[typeAkt - 1])
						continue;
			} else if (m_StatCur.asteroids[iIndex].IsMiddle()) {
					if (!anNeedsPrev[3 + typeAkt])
						continue;
			} else {
					if (!anNeedsPrev[7 + typeAkt])
						continue;
			}

			iMinTmp = INT_MAX, iCand = -1;
			// den raussuchen, der den gleichen Typ hat und am nchsten dran ist
			for (int j = 0; j < m_StatPrev.nasteroids; j++) {
				if (m_StatPrev.asteroids[j].m_dDX == DBL_MAX
					|| m_StatPrev.asteroids[j].sf != sfAkt || m_StatPrev.asteroids[j].type != typeAkt) 
				{
					continue; // der passt nicht oder hat schon Nachfolger
				}
				// passt vom Typ, den aussuchen, der am nchsten ist
				dx = m_StatCur.asteroids[iIndex].x - m_StatPrev.asteroids[j].x;
				dy = m_StatCur.asteroids[iIndex].y - m_StatPrev.asteroids[j].y;
				Normalize(dx, dy);
				if (m_nLostFrames > 0) {
					dx /= m_nLostFrames;
					dy /= m_nLostFrames;
				}
				// Sicherheitsschranke, die kann mit Sicherheit deutlich kleiner werden
				if (abs(dx) < 10 && abs(dy) < 10) { // wieder von 9 auf 10 hochgesetzt, bei Schssen war 9 def. zu klein
					distTmp = dx*dx + dy*dy;
					if (distTmp < iMinTmp) {
						iMinTmp = distTmp;
						iCand = j;
					}
				}
			}

			if (iCand >= 0) { // Kandidaten fr Vorgnger gefunden
				// Richtungsvektor setzen
				m_StatCur.asteroids[iIndex].m_dDX = 
					(double)m_StatCur.asteroids[iIndex].x - m_StatPrev.asteroids[iCand].x;
				m_StatCur.asteroids[iIndex].m_dDY = 
					(double)m_StatCur.asteroids[iIndex].y - m_StatPrev.asteroids[iCand].y;
				Normalize(m_StatCur.asteroids[iIndex].m_dDX, m_StatCur.asteroids[iIndex].m_dDY);
				if (m_nLostFrames > 0) {
					m_StatCur.asteroids[iIndex].m_dDX /= m_nLostFrames;
					m_StatCur.asteroids[iIndex].m_dDY /= m_nLostFrames;
				}
				m_StatCur.asteroids[iIndex].iHowExact = 1;
				// ID und ShotID vererben
				m_StatCur.asteroids[iIndex].m_iID = m_StatPrev.asteroids[iCand].m_iID;

				m_StatPrev.asteroids[iCand].m_dDX = DBL_MAX;

			}
		}
	}
	// denen, die jetzt noch keinen Vorgnger (und damit keine ID) haben, eine zuordnen
	for (int i = 0; i < m_StatCur.nasteroids; i++) {
		if (m_StatCur.asteroids[i].m_iID == -1) {
			m_StatCur.asteroids[i].m_iID = m_iNextTargetInd++ % MAX_TARGET_IND;
//			printf("new ID\n");
		}
	}
}

void Player::SetShotVektoren()
{
	double dDX, dDY;
	int dx, dy;
	int nNeedsPrev = m_StatCur.nshots;

	// erst die suchen, die sich ber die Vorgnger und deren Bewegungsvektoren halbwegs sicher erkennen lassen
	for (int i = 0; i < m_StatCur.nshots; i++) {
		for (int j = 0; j < m_StatPrev.nshots; j++) {
			if (m_StatPrev.shots[j].m_dDX == DBL_MAX) { // den hat schon ein anderer als Vorgnger erkannt
				continue;
			}
			dx = m_StatCur.shots[i].x - m_StatPrev.shots[j].x;
			dy = m_StatCur.shots[i].y - m_StatPrev.shots[j].y;
			Normalize(dx, dy);
			if (m_nLostFrames > 0) {
				dx /= m_nLostFrames;
				dy /= m_nLostFrames;
			}
			dDX = dx - m_StatPrev.shots[j].m_dDX;
			dDY = dy - m_StatPrev.shots[j].m_dDY;

			if (fabs(dDX) <= 1.0 && fabs(dDY) <= 1.0) { // hchstwahrscheinlich gefunden (akzeptier ich so)
				int &iHowExactTmp = m_StatPrev.shots[j].iHowExact;
//				if (iHowExactTmp > 0xFFFF) { // wird wohl reichen (irgendwann luft es sonst ber), fr Shots Quatsch
//					iHowExactTmp = 0x7FFF;
//				}
				m_StatCur.shots[i].m_dDX = (m_StatPrev.shots[j].m_dDX * iHowExactTmp + dx) 
					/ (iHowExactTmp + 1);
				m_StatCur.shots[i].m_dDY = (m_StatPrev.shots[j].m_dDY * iHowExactTmp + dy) 
					/ (iHowExactTmp + 1);
				m_StatCur.shots[i].iHowExact = iHowExactTmp + 1;
				if (m_StatPrev.shots[j].m_iID != -1) {
					m_StatCur.shots[i].m_iID = m_StatPrev.shots[j].m_iID;
				} else {
					// dann msste er vom UFO sein, wenn alles richtig
					m_StatCur.shots[i].m_iID = m_iNextShotInd++ % MAX_SHOT_IND; 
				}

				m_StatPrev.shots[j].m_dDX = DBL_MAX;
				nNeedsPrev--;
				break;
			}
		}
	} // fertig mit denen, deren Vorgnger ich leicht gefunden habe

	// hier kommt jetzt das eigentliche, anfngliche zuordnen
	// todo: verbessern mit Kandidatenlisten (s. Zettel)
	if (nNeedsPrev // es gibt noch welche, die keinen Vorgnger haben
		&& m_StatPrev.nshots > m_StatCur.nshots - nNeedsPrev) // und es gibt noch Kandidaten dafr
	{
		int iIndex = -1, iMinTmp, iCand, distTmp;
		for (int i = 0; i < nNeedsPrev; i++) { // die Verbliebenen
			iIndex++;
			while (m_StatCur.shots[iIndex].m_dDX != 0.0 && m_StatCur.asteroids[iIndex].m_dDY != 0.0) {
				iIndex++;
			}
			// erstmal einfach den nchsten suchen und als Vorgnger nehmen
			// (knnte dazu fhren, dass er immer wegspringt)
			iCand = -1, iMinTmp = INT_MAX;
			for (int j = 0; j < m_StatPrev.nshots; j++) {
				if (m_StatPrev.shots[j].m_dDX == DBL_MAX) {
					continue;
				}
				dx = m_StatCur.shots[iIndex].x - m_StatPrev.shots[j].x;
				dy = m_StatCur.shots[iIndex].y - m_StatPrev.shots[j].y;
				Normalize(dx, dy);
				if (m_nLostFrames > 0) {
					dx /= m_nLostFrames;
					dy /= m_nLostFrames;
				}
				if (abs(dx) < 10 && abs(dy) < 10) { // 1.6. wieder gendert, 9 ist zu klein!
					distTmp = dx*dx + dy*dy;
					if (distTmp < iMinTmp) {
						iMinTmp = distTmp;
						iCand = j;
					}
				}
			}

			if (iCand >= 0) {
				m_StatCur.shots[iIndex].m_dDX = m_StatCur.shots[iIndex].x - m_StatPrev.shots[iCand].x;
				m_StatCur.shots[iIndex].m_dDY = m_StatCur.shots[iIndex].y - m_StatPrev.shots[iCand].y;
				Normalize(m_StatCur.shots[iIndex].m_dDX, m_StatCur.shots[iIndex].m_dDY);
				if (m_nLostFrames > 0) {
					m_StatCur.shots[iIndex].m_dDX /= m_nLostFrames;
					m_StatCur.shots[iIndex].m_dDY /= m_nLostFrames;
				}

				m_StatCur.shots[iIndex].iHowExact = 1;
				if (m_StatPrev.shots[iCand].m_iID != -1) {
					m_StatCur.shots[iIndex].m_iID = m_StatPrev.shots[iCand].m_iID;
				} else {
					// dann msste er vom UFO sein, wenn alles richtig
					m_StatCur.shots[iIndex].m_iID = m_iNextShotInd++ % MAX_SHOT_IND; 
				}

				m_StatPrev.shots[iCand].m_dDX = DBL_MAX;
			}
			// bei Asteroiden kommt an dieser Stell noch //
			// } else { // wenn nichts gefunden, zumindest noch den Abstand checken!
			// hier natrlich nicht, sonst springt er vor seinen eigenen Schssen weg
			else {
				m_StatCur.shots[iIndex].m_dDX = 0.0;
				m_StatCur.shots[iIndex].m_dDY = 0.0;
				m_StatCur.shots[iIndex].iHowExact = 0;
			}
		}
	}
}

void Player::CalcStatVirt()
{
	m_StatVirt = m_StatCur;

	for (int i = 0; i < m_StatVirt.nasteroids; i++) {
		m_StatVirt.asteroids[i].x += DoubleToInt(m_StatVirt.asteroids[i].m_dDX);
		m_StatVirt.asteroids[i].y += DoubleToInt(m_StatVirt.asteroids[i].m_dDY);
	}
	for (int i = 0; i < m_StatVirt.nshots; i++) {
		m_StatVirt.shots[i].x += DoubleToInt(m_StatVirt.shots[i].m_dDX);
		m_StatVirt.shots[i].y += DoubleToInt(m_StatVirt.shots[i].m_dDY);
	}
	if (m_StatVirt.saucer_present) {
		m_StatVirt.m_Saucer.x += DoubleToInt(m_StatVirt.m_Saucer.m_dDX);
		m_StatVirt.m_Saucer.y += DoubleToInt(m_StatVirt.m_Saucer.m_dDY);
	}
	m_StatVirt.m_iShotMapPos = norm256(m_StatCur.m_iShotMapPos + m_StatPrev.m_iShotMapModify);

	m_StatVirt.m_Ship.x += DoubleToInt(m_StatVirt.m_Ship.m_dDX); //Test1
	m_StatVirt.m_Ship.y += DoubleToInt(m_StatVirt.m_Ship.m_dDY);
//	m_StatVirt.m_Ship.x += (2 * DoubleToInt(m_StatVirt.m_Ship.m_dDX)); //Test1
//	m_StatVirt.m_Ship.y += (2 * DoubleToInt(m_StatVirt.m_Ship.m_dDY));
}

void Player::Shoot(FlyingObj *pTarget)
{
//27.6. verschoben		
	UpdateMyShots();

	if (!m_StatPrev.m_bFire && m_nMyShots < 4) {
//		printf("Shot Time %d\n", t);
		m_Keys |= KEY_FIRE;
		m_StatCur.m_bFire = true;

		for (int i = 0; i < 4; i++) {
			if (m_MyShots[i].m_iID == -1) {
				m_nMyShots++;
				m_MyShots[i].m_IndexWhenShot = m_StatVirt.m_iShotMapPos;
				m_MyShots[i].m_TimeFirstAppear = t + 2;
				m_MyShots[i].x = m_StatVirt.m_Ship.x; // Achtung, wenn Schiff sich bewegt!
				m_MyShots[i].y = m_StatVirt.m_Ship.y;
				m_MyShots[i].m_iPrevMod = m_iPrevPrevMod;

				m_MyShots[i].m_iID = m_iNextShotInd++ % MAX_SHOT_IND;
				if (pTarget) {
					m_MyShots[i].m_iTargetID = pTarget->m_iID;
				} else {
					m_MyShots[i].m_iTargetID = -1;
				}

				break;
			}
		}
	} else {
		int iDebug = 0; // nur zum testen
	}
}

//todo? Zuweisung von ID von MyShot an Shot: ist das nicht falschrum?
void Player::CompareShotsAndCorrectMap()
{
	// vorneweg Abfrage, ob berhaupt Schsse da
	if (!m_StatCur.nshots) {
		//22.6. Hilfsfunktionalitt, damit Fehler, Ast glaubt es wre auf ihn geschossen worden, obwohl lange kein Schuss
		// mehr da, nicht so durchschlgt.
		// todo: Fehler finden! (wichtig)
		if (!m_StatPrev.m_bFire) {
			resetMyShots();
		}
		return;
	}
//	UpdateMyShots(); //28.6. test hierher verschoben dann erkennt er offenbar nicht, das auf irgendwas geschossen wurde

	int i, j, k = 0, iIndex;
	for (i = 0; i < 4; i++) {
		if (m_MyShots[i].m_iID == -1) {
			continue;
		}
		int MyTime = m_MyShots[i].m_TimeFirstAppear;
		ShotMapEntry &MyEntry = m_ShotMap[m_MyShots[i].m_IndexWhenShot];

		// in 1. Schleife die finden, die schon einen Shot zugeordnet haben und berprfen
		for (j = 0; j < m_StatCur.nshots; j++) {
			// die berprfung scheint noch nicht so ganz zu gehen, funktioniert aber auch ohne ganz gut, deshalb 
			// auskomm., 21.6. gelscht
			if (m_StatCur.shots[j].m_iID == m_MyShots[i].m_iID) {
				break; // j
			}
		}
		// in 2. Schleife denen einen shot zuordnen, die noch keinen haben (1. Auftauchen)
		if (j == m_StatCur.nshots) { // keinen mit gleicher ID gefunden
			if (MyTime == t) { // 1. Auftauchen
				m_MyShots[i].x = m_StatVirt.m_Ship.x; // Achtung, wenn Schiff sich bewegt!
				m_MyShots[i].y = m_StatVirt.m_Ship.y;
				for (j = 0; j < m_StatCur.nshots; j++) { // Vergleiche ShotMap_Cur und MyShot
					Shot &ShotCmp = m_StatCur.shots[j];
					// vorherberechnete Position: Ausgangspunkt + 1. Auftauchen
					// Vorhersage richtig
					if (abs(m_MyShots[i].x + MyEntry.m_xFirst - ShotCmp.x) == 0 //todo wieso abs ??
						&& abs(m_MyShots[i].y + MyEntry.m_yFirst - ShotCmp.y) == 0)
					{
						ShotCmp.m_iID = m_MyShots[i].m_iID;
//22.6. Shot.m_iTargetID gelscht						ShotCmp.m_iTargetID = m_MyShots[i].m_iTargetID;
						break;
					}
				}
				if (j == m_StatCur.nshots) { // Vorhersage falsch
					int iFound = 0;
					int xFirst, yFirst;

					for (j = 0; j < m_StatCur.nshots; j++) {
						Shot &ShotCmp = m_StatCur.shots[j];
						// das 1. auftauchen kann max 2 x 15^2 = 450 sein
						if ((m_MyShots[i].x - ShotCmp.x)*(m_MyShots[i].x - ShotCmp.x) 
							+ (m_MyShots[i].y - ShotCmp.y)*(m_MyShots[i].y - ShotCmp.y) < 500
							&& ShotCmp.m_iID == -1) // der wirds dann wohl sein
						{
							xFirst = ShotCmp.x - m_MyShots[i].x;
							yFirst = ShotCmp.y - m_MyShots[i].y;

							// wie oben: erst den linken Nachbarn, dann vom rechten Nachbarn ausgehend
							iIndex = norm256(m_MyShots[i].m_IndexWhenShot - 1);
							if (m_ShotMap[iIndex].m_xFirst == xFirst
								&& m_ShotMap[iIndex].m_yFirst == yFirst
		&& m_StatCur.m_Ship.m_LookX == m_ShotMap[norm256(m_StatCur.m_iShotMapPos - 1)].m_Ship_LookX
			&& m_StatCur.m_Ship.m_LookY == m_ShotMap[norm256(m_StatCur.m_iShotMapPos - 1)].m_Ship_LookY) 
							{
								iFound = -1;
							}
							if (!iFound) {
								for (k = 1; k < 255; k++) {
									iIndex = norm256(m_MyShots[i].m_IndexWhenShot + k);
									if (m_ShotMap[iIndex].m_xFirst == xFirst
										&& m_ShotMap[iIndex].m_yFirst == yFirst
		&& m_StatCur.m_Ship.m_LookX == m_ShotMap[norm256(m_StatCur.m_iShotMapPos + k)].m_Ship_LookX
			&& m_StatCur.m_Ship.m_LookY == m_ShotMap[norm256(m_StatCur.m_iShotMapPos + k)].m_Ship_LookY) 
									{
										iFound = k;
										break;
									}
								}
							}
							if (!iFound) {
								int iDebug = 0;
							} else { // einen gefunden, als Nachfolger setzen und ShotMapIndex korrigieren
								m_MyShots[i].m_IndexWhenShot = norm256(m_MyShots[i].m_IndexWhenShot + iFound);
//									- m_MyShots[i].m_iPrevMod);
								ShotCmp.m_iID = m_MyShots[i].m_iID;
#if 1 // passend zu #if0/1 unten (genau anders)
#ifndef SLT_INCL
								m_StatCur.m_iShotMapPos = norm256(m_StatCur.m_iShotMapPos + iFound);
//								resetMyShots();
								m_MyShots[i].m_iTargetID = -1; // davon ausgehen, dass er nicht trifft

								printf("\n ShotMapCorrected\n\n");
#endif
#endif
								break;
							}
						}
					} // for j
					if (j == m_StatCur.nshots) {
						//fter geworfen, ich denke jetzt, dass das kommt, wenn FrameDrops im Debugger aufgetreten
						// tritt immer noch hin und wieder auf, auch in Release und ohne FrameDrops, aber sehr selten und
						// scheint nicht allzu schlimm zu sein
//todo: tritt ziemlich oft auf, kommt wohl seltener, seit UpdateMyShots hier gerufen wird
						//printf("\n Error 1, Frame dropped?\n\n"); 
					}
				}
			} else if (MyTime < t) { // dann sollte er schon einen zugehrigen shot haben
				// wenn ich UpdateMyShots vor dieser Funktion aufrufe, dann wird das hier zwar nicht mehr geworfen,
				// aber dafr ist die ShotMap vllig falsch!! Lass es erstmal so (in der Regel ist dieser Fehler
				// nicht schlimm)
//				printf("\n Error 2, Frame dropped?\n\n"); // liegt daran, dass MyShots noch nicht UpToDate
			}
		} // if (j == m_StatCur.nshots)
#if 0 // passend zu #if0/1 oben (genau anders)
		if (MyTime + 8 == t) { // dann msste es doch eigentlich passen, oder?
			// todo: prfen, ob Schuss mit gleicher ID ex.
			for (j = 0; j < m_StatCur.nshots; j++) {
				if (m_StatCur.shots[j].m_iID == m_MyShots[i].m_iID) {
					// ist er genau da, wo er sein sollte?
					if (m_MyShots[i].x + MyEntry.m_xFirst + 8*MyEntry.m_dDX - m_StatCur.shots[j].x != 0 
						|| m_MyShots[i].y + MyEntry.m_yFirst + 8*MyEntry.m_dDY - m_StatCur.shots[j].y != 0)
					{
						// nein: ist irgendein anderer da?
						for (k = 0; k < m_StatCur.nshots; k++) {
							if (m_MyShots[i].x + MyEntry.m_xFirst + 8*MyEntry.m_dDX - m_StatCur.shots[k].x == 0 
								&& m_MyShots[i].y + MyEntry.m_yFirst + 8*MyEntry.m_dDY - m_StatCur.shots[k].y == 0)
							{
								// ja: wohl falsch zugeordnet, erstmal ignorieren,
								break;
							}
						}
						// nein: korrigieren
						if (k == m_StatCur.nshots) {
							for (k = 0; k < 256; k++) {
								if (m_MyShots[i].x + m_ShotMap[norm256(m_MyShots[i].m_IndexWhenShot + k)].m_xFirst 
									+ 8*m_ShotMap[norm256(m_MyShots[i].m_IndexWhenShot + k)].m_dDX 
									== m_StatCur.shots[j].x
									&& m_MyShots[i].y + m_ShotMap[norm256(m_MyShots[i].m_IndexWhenShot + k)].m_yFirst 
									+ 8*m_ShotMap[norm256(m_MyShots[i].m_IndexWhenShot + k)].m_dDY 
									== m_StatCur.shots[j].y)
								{
								m_MyShots[i].m_IndexWhenShot = norm256(m_MyShots[i].m_IndexWhenShot + k
									- m_MyShots[i].m_iPrevMod);
//								ShotCmp.m_iID = m_MyShots[i].m_iID;
								for (int l = 0; l < 4; l++) { //21.6. alle Ziele mglicherweise verfehlt!
									m_MyShots[l].m_iTargetID = -1;
								}
									m_StatCur.m_iShotMapPos = norm256(m_StatCur.m_iShotMapPos + k
										- m_MyShots[i].m_iPrevMod);
//									m_StatVirt.m_iShotMapPos = norm256(m_StatVirt.m_iShotMapPos + k - 1);
									printf("\n ShotMapCorrected 2\n\n");
									break;
								}
							}
						}
						break;
					}
				}
			}
		}
#endif
	}

	//UpdateMyShots(); //27.6. hierher verschoben, sollte immer getan werden!
}


void Player::UpdateMyShots()
{
	// prfen, ob Shots, die zu MyShots passen, noch da!
	int i, j, iFound = 0;
	for (i = 0; i < 4; i++) {
		if (m_MyShots[i].m_iID != -1) {
			for (j = 0; j < m_StatCur.nshots; j++) {
				if (m_StatCur.shots[j].m_iID == m_MyShots[i].m_iID) { // den gibts noch
					iFound++;
					break;
				}
			}
			if (j == m_StatCur.nshots) {
				if (m_MyShots[i].m_TimeFirstAppear == t + 1) { // wird erst im nchsten Frame sichtbar
					iFound++;
				} else {
					m_MyShots[i].m_iID = -1;
					m_MyShots[i].m_iTargetID = -1;
					m_nMyShots--;
				}
			}
		}
	}
	if (iFound != m_nMyShots)
		int iDebug = 0;
}

bool Player::NeedToJump()
{
	for (int i = 0; i < m_StatVirt.nshots; i++) {
		if (//(m_StatVirt.shots[i].m_dDX != 0.0 || m_StatVirt.shots[i].m_dDY != 0.0) && // sieht fr mich so aus, als ob er manchmal vor seinen eigenen wegspringt
			WillCollide(m_StatVirt.m_Ship, m_StatVirt.shots[i],
			m_StatVirt.m_Ship.m_iBigRadius + m_StatVirt.shots[i].m_iBigRadius, 0, 2) // fr shots mal auf 3
			// knnte noch prfen: m_TimeFirstAppear != t, m_iID != MyShot[i].m_iID fr alle MyShots
			&& m_StatVirt.shots[i].iHowExact > 2)
		{
			return true;
		}
	}
	for (int i = 0; i < m_StatVirt.nasteroids; i++) {
		if (WillCollide(m_StatVirt.m_Ship, m_StatVirt.asteroids[i], 
			m_StatVirt.m_Ship.m_iBigRadius + m_StatVirt.asteroids[i].m_iBigRadius, 0, 2))
		{
			return true;
		}
	}
	if (m_StatVirt.saucer_present
		&& WillCollide(m_StatVirt.m_Ship, m_StatVirt.m_Saucer, 
		m_StatVirt.m_Ship.m_iBigRadius + m_StatVirt.m_Saucer.m_iBigRadius, 0, 2))
	{
		return true;
	}

	return false;
}

bool Player::WillCollide(FlyingObj &ObjStand, FlyingObj &ObjMove, int iRadius, int iMinTime, int iMaxTime)
{
	// reicht erstmal Rckgabe true/false. Bei Bedarf den tatschlichen Wert als zustzlichen ReferenzParam in 
	// berladener Funktion
//	double dReturn = 0.0;
	bool bReturn = false;

	MyVektor A(ObjMove.x + iMinTime*ObjMove.m_dDX, ObjMove.y + iMinTime*ObjMove.m_dDY); // StartPosition des Beweglichen
	MyVektor B(ObjMove.x + iMaxTime*ObjMove.m_dDX, ObjMove.y + iMaxTime*ObjMove.m_dDY); // EndPosition des Beweglichen
	MyVektor M(ObjStand.x, ObjStand.y); // Mittelpunkt des Stationren
	// 22.6. neu, M so verschieben, dass bewegliches Objekt auch drauf zu fliegt
	if (B.x > A.x) {
		while (A.x > M.x)
			M.x += 1024;
	} else if (B.x < A.x) {
		while (A.x < M.x)
			M.x -= 1024;
	}
	if (B.y > A.y) {
		while (A.y > M.y)
			M.y += 768;
	} else if (B.y < A.y) {
		while (A.y < M.y)
			M.y -= 768;
	}

	iRadius *= iRadius; // es wird vereinfacht mit den Quadraten gerechnet

	// Es soll geprft werden, ob die Strecke zwischen A und B den Kreis (M, Radius) schneidet.
	// wenn B nher an A liegt als M => Abstand von B zu M ist Minimum
	if (absSquare(A, B) < absSquare(A, M)) {
		if (absSquare(M, B) <= iRadius) {
			bReturn = true;
		}
	// B weiter weg als M: das bewegliche ist vorbeigeflogen. Berechne die Hhe des Dreiecks auf der Seite AB und nimm
	// sie als MinAbstand.
	} else if (absSquare(B, A) > absSquare(B, M)) { // sonst fliegt er in die falsche Richtung!
		MyVektor AB(A.x-B.x, A.y-B.y);
		MyVektor AM(A.x-M.x, A.y-M.y);
		double KP = Kreuzprodukt(AB, AM);
		if (KP*KP / absSquare(A, B) <= iRadius) {
			bReturn = true;
		}
	}

	return bReturn;
}

void Player::ReduceCC()
{
	if (--m_iCCReduce == 0) {
		m_iCCReduce = m_CCSize;
		// wird erstmal nicht benutzt, wahrscheinlich nie, weil ich jede Runde neu klassifiziere
		m_iCCMin = ++m_iCCMin % m_CCCount; 
	}
}

//todo: knnte man abhngig von der Eingestellten Suchgre machen, oder wie viele noch da sind
// wenn nasteroids >= 25 (?) && Ast.CC > 0 (?) return true (Gro und Mittel)
bool Player::WasShotAt(CTarget &Obj)
{
	int iCount = 0;
	if (Obj.IsSaucer() || Obj.IsSmall()) {
		for (int i = 0; i < 4; i++) {
			if (m_MyShots[i].m_iID != -1 && m_MyShots[i].m_iTargetID == Obj.m_iID) {
				return true;
			}
		}
	} else { // Big oder Middle
		Asteroid &Ast = dynamic_cast<Asteroid &>(Obj); // Saucer oben schon weg
		if (m_StatCur.nasteroids == 1 && iCount <= 3) // der letzte: 3x drauf schiessen
			return false;
		// wenn es schon viele gibt (austesten, wieviele), am besten nicht mehr drauf schiessen
		if (m_StatCur.nasteroids >= 24) { //23 oder 24 scheint kein groer Unterschied (23: 103000--)
			if (Ast.m_iCC > 0) {
				return true;
			}
		}
		if (Obj.IsMiddle()) {
			for (int i = 0; i < 4; i++) {
				if (m_MyShots[i].m_iID != -1 && m_MyShots[i].m_iTargetID == Obj.m_iID) {
					iCount++;
				}
			}
			if (Ast.m_iCC == 0 && iCount < 3)
				return false; // auf mittlere, die direkt auf mich zukommen, 3x schiessen
			if (iCount >= 1)
				return true;
		} else { //Big
			for (int i = 0; i < 4; i++) {
				if (m_MyShots[i].m_iID != -1 && m_MyShots[i].m_iTargetID == Obj.m_iID) {
					iCount++;
				}
			}
			if (iCount >= 1)
				return true;
		}
	}

	return false;
}

void Player::InitStatCur()
{
	m_StatCur.m_bFire = false;
	for (int i = 0; i < m_StatCur.nasteroids; i++) {
		m_StatCur.asteroids[i].m_dDX = 0.0;
		m_StatCur.asteroids[i].m_dDY = 0.0;
		m_StatCur.asteroids[i].iHowExact = 0;
		m_StatCur.asteroids[i].m_iID = -1;
		m_StatCur.asteroids[i].m_iCC = m_CCCount; // die StandardKlasse, wei ich praktisch nichts drber
		m_StatCur.asteroids[i].Mwt = 0;

		if (m_StatCur.asteroids[i].IsSmall()) {
			m_StatCur.asteroids[i].m_iSmallRadius = 7; //OK 4, scheint OK 6 Forum 7/8
			m_StatCur.asteroids[i].m_iBigRadius = 8;
		} else if (m_StatCur.asteroids[i].IsMiddle()) {
			m_StatCur.asteroids[i].m_iSmallRadius = 15; //OK 13, scheint OK 19 Forum: 15/16
			m_StatCur.asteroids[i].m_iBigRadius = 17;
		} else {
			m_StatCur.asteroids[i].m_iSmallRadius = 31; //OK 25, scheint OK 37 Forum: 31/32
			m_StatCur.asteroids[i].m_iBigRadius = 33; //22.6. von 32 auf 33
		}
	}
	for (int i = 0; i < m_StatCur.nshots; i++) {
		m_StatCur.shots[i].m_dDX = 0.0;
		m_StatCur.shots[i].m_dDY = 0.0;
		m_StatCur.shots[i].iHowExact = 0;
		m_StatCur.shots[i].m_iID = -1;
	}
/*	if (m_StatPrev.nshots > m_StatCur.nshots) { //22.6. test bringt nichts
		for (int i = m_StatCur.nshots; i < m_StatPrev.nshots; i++) {
			m_StatCur.shots[i].m_iID = -1;
		}
	}*/

	m_StatCur.m_iShotMapPos = norm256(m_StatPrev.m_iShotMapPos + m_iPrevPrevMod);
	m_StatCur.m_iShotMapModify = 0;
}

#ifdef SLT_INCL

// zurckgeben, ob er was trifft, wie lange man dafr drehen muss (iStep), in welche Richtung
bool Player::CalcTimeToShoot(int iRadius, int &iStep, double &dDiffM, double &dDiffR, double &dDiffL, FlyingObj *pTarget,
							 int iMaxStep)
{
	double DistMin;
	int iTimeToHit = INT_MAX, iTTHM = INT_MAX, iTTHL = INT_MAX, iTTHR = INT_MAX, iHit;
	dDiffM = DBL_MAX, dDiffL = DBL_MAX, dDiffR = DBL_MAX;
	iMaxStep += m_iMaxSlt;

	CalcShot(pTarget, m_StatVirt.m_iShotMapPos, DistMin, 0, iRadius, iTTHM);
	// Vergleichen einmal links drehen, einmal rechts, einmal warten, auch wenn er direkt trifft, fr Drehrichtung
	CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos + 1), dDiffR, 1, iRadius, iTTHR);
	CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos - 1), dDiffL, 1, iRadius, iTTHL);
	CalcShot(pTarget, m_StatVirt.m_iShotMapPos, dDiffM, 1, iRadius, iTTHM); //msste so einfach einmal warten

	if (DistMin < iRadius) { // trifft direkt, wenn er jetzt schiet
		iStep = 0;
		return true;
	}

//	if (iMaxStep > 0) {
	// wenn er nur einmal drehen oder warten muss, wird das wohl auch ziemlich optimal sein
		if (dDiffM < iRadius || dDiffR < iRadius || dDiffL < iRadius) {
			iStep = 1;
			return true;
		}

		// trifft nicht direkt:
		for (iStep = 2; iStep <= iMaxStep; iStep++) { //23.6. 88 scheint nicht besser als 44
			CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos + iStep), DistMin, iStep, iRadius, iHit);
			if (DistMin < dDiffR) {
				dDiffR = DistMin;
			}
			if (iHit < iTTHR) {
				iTTHR = iHit;
				if (iHit < iMaxStep)
					iMaxStep = iHit; // -1 ?
			}
			// iStep - 1 mal drehen und einmal warten
			CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos + iStep - 1), DistMin, iStep, iRadius, iHit);
			if (DistMin < dDiffR) {
				dDiffR = DistMin;
			}
			if (iHit < iTTHR) {
				iTTHR = iHit;
				if (iHit < iMaxStep)
					iMaxStep = iHit;
			}
			CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos - iStep), DistMin, iStep, iRadius, iHit);
			if (DistMin < dDiffL) {
				dDiffL = DistMin;
			}
			if (iHit < iTTHL) {
				iTTHL = iHit;
				if (iHit < iMaxStep)
					iMaxStep = iHit;
			}
			CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos - iStep + 1), DistMin, iStep, iRadius, iHit);
			if (DistMin < dDiffL) {
				dDiffL = DistMin;
			}
			if (iHit < iTTHL) {
				iTTHL = iHit;
				if (iHit < iMaxStep)
					iMaxStep = iHit;
			}

//			if (dDiffL < iRadius || dDiffR < iRadius) {
//				return true;
//			}
		}
		// erstmal "symbolische" Werte fr dDiffR etc. setzen, werden nur gebraucht, um die Richtung zu bestimmen
		if (iTTHL < INT_MAX || iTTHR < INT_MAX || iTTHM < INT_MAX) {
			if (iTTHL <= iTTHR) {
				dDiffR = 1.0;
/*				if (iTTHM <= iTTHL) {
					dDiffL = 1.0;
					dDiffM = 0.0;
					iStep = iTTHM;
				} else {*/
					dDiffM = 1.0;
					dDiffL = 0.0;
					iStep = iTTHL;
//				}
			} else {
				dDiffL = 1.0;
/*				if (iTTHM <= iTTHR) {
					dDiffR = 1.0;
					dDiffM = 0.0;
					iStep = iTTHM;
				} else {*/
					dDiffM = 1.0;
					dDiffR = 0.0;
					iStep = iTTHR;
//				}
			}
			return true;
		} else {
			return false;
		}
//	}

//	return false;
}

#else

#define _ALT
#ifdef _ALT
// zurckgeben, ob er was trifft, wie lange man dafr drehen muss (iStep), in welche Richtung
bool Player::CalcTimeToShoot(int iRadius, int &iStep, double &dDiffM, double &dDiffR, double &dDiffL, FlyingObj *pTarget,
							 int iMaxStep)
{
	double DistMin;
	dDiffM = DBL_MAX, dDiffL = DBL_MAX, dDiffR = DBL_MAX;

	CalcShot(pTarget, m_StatVirt.m_iShotMapPos, DistMin, 0);
	// Vergleichen einmal links drehen, einmal rechts, einmal warten, auch wenn er direkt trifft, fr Drehrichtung
	CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos + 1), dDiffR, 1);
	CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos - 1), dDiffL, 1);
	CalcShot(pTarget, m_StatVirt.m_iShotMapPos, dDiffM, 1); //msste so einfach einmal warten

	if (DistMin < iRadius) { // trifft direkt, wenn er jetzt schiet
		iStep = 0;
		return true;
	}

	if (iMaxStep > 0) {
		if (dDiffM < iRadius || dDiffR < iRadius || dDiffL < iRadius) {
			iStep = 1;
			return true;
		}

		// trifft nicht direkt:
		for (iStep = 2; iStep <= iMaxStep; iStep++) { //23.6. 88 scheint nicht besser als 44
			CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos + iStep), DistMin, iStep);
			if (DistMin < dDiffR) {
				dDiffR = DistMin;
			}
			// iStep - 1 mal drehen und einmal warten
			CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos + iStep - 1), DistMin, iStep);
			if (DistMin < dDiffR) {
				dDiffR = DistMin;
			}
			CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos - iStep), DistMin, iStep);
			if (DistMin < dDiffL) {
				dDiffL = DistMin;
			}
			CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos - iStep + 1), DistMin, iStep);
			if (DistMin < dDiffL) {
				dDiffL = DistMin;
			}

			if (dDiffL < iRadius || dDiffR < iRadius) {
				return true;
			}
		}
	}

	return false;
}

#else //#ifdef _ALT

// zurckgeben, ob er was trifft, wie lange man dafr drehen muss (iStep), in welche Richtung
// 3. Version
bool Player::CalcTimeToShoot(int iRadius, int &iStep, double &dDiffM, double &dDiffR, double &dDiffL, FlyingObj *pTarget,
							 int iMaxStep)
{
	int iTurn;
	double DistMin;
	dDiffM = DBL_MAX, dDiffL = DBL_MAX, dDiffR = DBL_MAX;

	CalcShot(pTarget, m_StatVirt.m_iShotMapPos, DistMin, 0);
	if (iMaxStep < 2) {
		// Vergleichen einmal links drehen, einmal rechts, einmal warten, auch wenn er direkt trifft, fr Drehrichtung
		CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos + 1), dDiffR, 1);
		CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos - 1), dDiffL, 1);
		CalcShot(pTarget, m_StatVirt.m_iShotMapPos, dDiffM, 1); //msste so einfach einmal warten
	}

	if (DistMin < iRadius) { // trifft direkt, wenn er jetzt schiet
		iStep = 0;
		return true;
	}
	if (dDiffM < iRadius || dDiffR < iRadius || dDiffL < iRadius) {
		iStep = 1;
		return true;
	}
	if (iMaxStep == 0) {
		return false;
	}

	// trifft nicht direkt:
	for (int i = 2; i <= 2*iMaxStep + 1; i++) { //23.6. 88 scheint nicht besser als 44
		iStep = (i%2 ? i/-2 : i/2);
		if (iStep > 0 && (dDiffL < iRadius || dDiffM < iRadius || dDiffR < iRadius)) {
			return true;
		}
		double &dDiffCmp = (iStep > 0 ? dDiffR : dDiffL);
		//Mitte wird so doppelt so oft geprft wie ntig
		CalcShot(pTarget, m_StatVirt.m_iShotMapPos, DistMin, abs(iStep)); //msste so einfach einmal warten
		if (DistMin < dDiffM) {
			dDiffM = DistMin;
		}
		for (int j = 0; j < abs(iStep); j++) {
			iTurn = (iStep > 0 ? iStep - j : iStep + j);
			CalcShot(pTarget, norm256(m_StatVirt.m_iShotMapPos + iTurn), DistMin, j);

			if (DistMin < dDiffCmp) {
				dDiffCmp = DistMin;
			}
		}
	}

	return false;
}
#endif //#ifdef _ALT
#endif

void Player::CenterBackOfShip()
{
	/* aus Sample:
	// Schiff in Richtung auf das nchstgelegene Objekt drehen
	// mathematisch wird hier das Kreuzprodukt aus den Vektoren 
	// ship_dx/y/0 und min_dx/y/0 berechnet
	if (game.ship_dx * min_dy - game.ship_dy * min_dx > 0)
		keys.left(true);
	else
		keys.right(true);
	*/

	if (!(m_StatVirt.nasteroids || m_StatVirt.saucer_present)) {
		if (m_StatVirt.m_Ship.m_LookX * (524 - m_StatVirt.m_Ship.y) -
			m_StatVirt.m_Ship.m_LookY * (524 - m_StatVirt.m_Ship.x) > 0) 
		{
			TurnRight();
		} else {
			TurnLeft();
		}
	}
}

void Player::resetMyShots()
{
	m_nMyShots = 0;
	for (int i = 0; i < 4; i++) {
		m_MyShots[i].m_iID = -1;
		m_MyShots[i].m_iTargetID = -1;
	}
}

int Player::SetCollClasses()
{
//Kollisionsklassen bestimmen
	int iCC, CCFound = m_CCCount, iAst, iRadius;
	Ship &Ship = m_StatVirt.m_Ship;
	int iMinBound, iMaxBound; // Grenzen der Klassen

	// Schleife ber die Klassen: jeder Ast wird jetzt eingeordnet, allein um die beschossenen rauszusortieren
	for (iAst = 0; iAst < m_StatVirt.nasteroids; iAst++) {
		Asteroid &Ast = m_StatVirt.asteroids[iAst];
		// als erstes die nicht betrachten, auf die schon geschossen wurde (wenn klein)
		if (//Ast.IsSmall() && 
			WasShotAt(Ast)) 
		{
			Ast.m_iCC = m_CCCount + 1; // kommt nicht mehr als Target in Betracht
			continue;
		}
		iRadius = Ship.m_iBigRadius + Ast.m_iBigRadius;
		//todo: prfen: groe und mittlere fr Kollisionserkennung vergrern: Ergebnis verschlechtert sich dadurch
		// erstmal (oder?), 23.6. vergrert, scheint besser
		if (Ast.IsMiddle())
			iRadius += 20;
		else if (Ast.IsBig())
			iRadius += 40;

		iMinBound = 0;
		iMaxBound = m_iCCReduce;
		for (iCC = 0; iCC < m_CCCount; iCC++) { //nach unten geschoben
			if (WillCollide(Ship, Ast, iRadius, iMinBound, iMaxBound)) {
				Ast.m_iCC = iCC;
				if (iCC < CCFound) {// && !(m_pPrimTarget && m_pPrimTarget->IsSaucer())) {
					CCFound = iCC;
				}
				break;
			}
			iMinBound = iMaxBound;
			iMaxBound += m_CCSize; // die 1. Klasse schrumpft mit m_iCCReduce, die anderen natrlich nicht
		}
	}
//	printf("CCFound: %d\n", CCFound);

	return CCFound;
}

void Player::SetShipVektor() 
{
	int dx, dy;

	if (m_StatCur.ship_present)
	{
		if (!m_StatPrev.ship_present) {
			m_StatCur.m_Ship.m_dDX = 0.0;
			m_StatCur.m_Ship.m_dDY = 0.0;
			m_StatCur.m_Ship.iHowExact = 0;
			return;
		}

		dx = m_StatCur.m_Ship.x - m_StatPrev.m_Ship.x;
		dy = m_StatCur.m_Ship.y - m_StatPrev.m_Ship.y;
/*		if (dx == 0 && dy == 0
			&& m_StatPrev.m_Ship.m_dDX == 0.0 && m_StatPrev.m_Ship.m_dDX == 0.0) 
		{
			return;
		}*/
		// Vereinfachte ShotMap-Korrektur: wenn das drin ist, schiesst er immer mehrfach selbst auf Kleine, 
		// wenn das nicht drin ist, gibt es Probleme, wenn Frames verloren gehen
#ifdef MOVE 
		int iMapMod;

		if (m_StatCur.m_Ship.m_LookX != m_ShotMap[m_StatCur.m_iShotMapPos].m_Ship_LookX
			|| m_StatCur.m_Ship.m_LookY != m_ShotMap[m_StatCur.m_iShotMapPos].m_Ship_LookY) 
		{
			for (int i = 2; i <= 256; i++) {
				iMapMod = (i%2 ? i/2 : i/-2);
				if (m_StatCur.m_Ship.m_LookX == m_ShotMap[norm256(m_StatCur.m_iShotMapPos + iMapMod)].m_Ship_LookX
					&& m_StatCur.m_Ship.m_LookY == m_ShotMap[norm256(m_StatCur.m_iShotMapPos + iMapMod)].m_Ship_LookY) 
				{
					m_StatCur.m_iShotMapPos = norm256(m_StatCur.m_iShotMapPos + iMapMod);
					printf("\n ShotMapCorrected 3\n\n");
					break;
				}
			}
		}
#endif

		// Richtungsvektor setzen
//		dx = m_StatCur.m_Ship.x - m_StatPrev.m_Ship.x;
//		dy = m_StatCur.m_Ship.y - m_StatPrev.m_Ship.y;
		if (dx == 0 && dy == 0
			&& m_StatPrev.m_Ship.m_dDX < 0.2 && m_StatPrev.m_Ship.m_dDX < 0.2) 
		{
			if (m_StatPrev.m_Ship.m_dDX > 0.0 || m_StatPrev.m_Ship.m_dDX > 0.0) {
				resetMyShots(); //Test2
			}
			// bewegt sich nicht mehr, fertig
			m_StatCur.m_Ship.m_dDX = 0.0;
			m_StatCur.m_Ship.m_dDY = 0.0;
			m_StatCur.m_Ship.iHowExact = 0; // damit scheint ShotMap sehr viel besser, warum???
		} else {
			Normalize(dx, dy);

			m_StatCur.m_Ship.iHowExact = m_StatPrev.m_Ship.iHowExact + 1;
			m_StatCur.m_Ship.m_dDX = (m_StatPrev.m_Ship.m_dDX * max(3, m_StatPrev.m_Ship.iHowExact) + dx) 
				/ m_StatCur.m_Ship.iHowExact;
			m_StatCur.m_Ship.m_dDY = (m_StatPrev.m_Ship.m_dDY * max(3, m_StatPrev.m_Ship.iHowExact) + dy) 
				/ m_StatCur.m_Ship.iHowExact;
		}
	}
}
