/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid;

import de.caff.asteroid.GameObjectVisitor;
import de.caff.asteroid.Glyph;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.Property;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceShip
extends MovingGameObject {
    private static final Color COLOR = new Color(128, 128, 128);
    public static final Glyph SHIP_GLYPH = new Glyph(new byte[]{16, 24, 0, -16, 24, 7, -32, 40, 7, 0, -56, 7, 32, 40, 7, 16, 24, 7, -64, 0, 0});
    public static final Glyph THRUSTING_SHIP_GLYPH = new Glyph(new byte[]{16, 24, 0, 0, 56, 7, -16, 24, 7, -32, 40, 7, 0, -56, 7, 32, 40, 7, 16, 24, 7, -64, 0, 0});
    public static final double SHIP_SCALING = 0.25;
    public static final Integer IDENT = new Integer(-1);
    private static final Shape SHIP_SHAPE;
    private static final Shape THRUSTING_SHIP_SHAPE;
    private final int dx;
    private final int dy;
    private boolean thrusting;

    public SpaceShip(int x, int y, int dx, int dy) {
        super(x, y);
        this.dx = dx;
        this.dy = dy;
        this.setIdentity(IDENT);
    }

    @Override
    public int getSize() {
        return 13;
    }

    public int getDirX() {
        return this.dx;
    }

    public int getDirY() {
        return this.dy;
    }

    public double getDirectionAngle() {
        return Math.atan2(this.dy, this.dx);
    }

    public Point getDirection() {
        return new Point(this.dx, this.dy);
    }

    @Override
    public void draw(Graphics2D g) {
        g.setColor(COLOR);
        g.draw(SpaceShip.getShipShape(this.getX(), this.getY(), this.getDirectionAngle(), this.thrusting));
        this.drawVelocityVector(g, Color.green);
    }

    public static Shape getShipShape(int px, int py, double angle, boolean thrusting) {
        AffineTransform at = AffineTransform.getTranslateInstance(px, py);
        at.concatenate(AffineTransform.getRotateInstance(angle));
        return at.createTransformedShape(thrusting ? THRUSTING_SHIP_SHAPE : SHIP_SHAPE);
    }

    public String toString() {
        return String.format("SpaceShip@(%d,%d)>(%-3.1f\u00b0)", this.getX(), this.getY(), 180.0 * this.getDirectionAngle() / Math.PI);
    }

    @Override
    public Collection<Property> getProperties() {
        Collection<Property> props = super.getProperties();
        props.add(new Property<Point>("Direction", this.getDirection()));
        props.add(new Property<Double>("Direction Angle (\u00b0)", 180.0 * this.getDirectionAngle() / Math.PI));
        props.add(new Property<Boolean>("Thrusting", this.isThrusting()));
        return props;
    }

    public boolean isThrusting() {
        return this.thrusting;
    }

    public void setThrusting(boolean thrusting) {
        this.thrusting = thrusting;
    }

    @Override
    public String getObjectType() {
        return "Space Ship";
    }

    @Override
    public void visitedBy(GameObjectVisitor visitor) {
        visitor.handle(this);
    }

    static {
        AffineTransform at = AffineTransform.getRotateInstance(-1.5707963267948966);
        at.concatenate(AffineTransform.getScaleInstance(0.25, 0.25));
        SHIP_SHAPE = at.createTransformedShape(SHIP_GLYPH.getPath());
        THRUSTING_SHIP_SHAPE = at.createTransformedShape(THRUSTING_SHIP_GLYPH.getPath());
    }
}

