/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.human;

import de.caff.asteroid.human.HumanClient;
import de.caff.asteroid.human.NewGameDialog;
import de.caff.i18n.I18n;
import de.caff.i18n.swing.RJButton;
import de.caff.i18n.swing.RJLabel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JDialog;
import javax.swing.JLabel;

class ServerBusyDialog
extends JDialog {
    private JLabel message;
    private JLabel timeToWait;
    private int secondsToWait;

    ServerBusyDialog(final HumanClient client) {
        super((Frame)client, true);
        this.setTitle(I18n.getString("diaServerBusy"));
        Box box = Box.createVerticalBox();
        box.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(NewGameDialog.BORDER_WIDTH, NewGameDialog.BORDER_WIDTH, NewGameDialog.BORDER_WIDTH, NewGameDialog.BORDER_WIDTH)));
        this.getContentPane().add((Component)box, "Center");
        this.message = new RJLabel("lbServerBusy", 0);
        box.add(this.message);
        this.message.setFont(this.message.getFont().deriveFont(NewGameDialog.FONT_SIZE));
        box.add(Box.createVerticalStrut(NewGameDialog.BORDER_WIDTH));
        this.timeToWait = new JLabel("00:00", 0);
        box.add(this.timeToWait);
        this.timeToWait.setFont(this.timeToWait.getFont().deriveFont(NewGameDialog.FONT_SIZE));
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    JLabel jLabel = ServerBusyDialog.this.timeToWait;
                    synchronized (jLabel) {
                        int stw = ServerBusyDialog.this.getSecondsToWait();
                        if (stw > 0) {
                            ServerBusyDialog.this.refreshTimeToWait(stw - 1);
                        }
                    }
                }
            }
        }, "TTW Updater").start();
        RJButton button = new RJButton("btEndGame");
        Box bbox = Box.createHorizontalBox();
        bbox.add(Box.createHorizontalGlue());
        bbox.add(button);
        bbox.add(Box.createHorizontalGlue());
        bbox.setBorder(BorderFactory.createEmptyBorder(NewGameDialog.BORDER_WIDTH, NewGameDialog.BORDER_WIDTH, NewGameDialog.BORDER_WIDTH, NewGameDialog.BORDER_WIDTH));
        this.getContentPane().add((Component)bbox, "South");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                client.exit(0);
            }
        });
        this.setDefaultCloseOperation(0);
        this.pack();
        this.setLocationRelativeTo(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshTimeToWait(int seconds) {
        JLabel jLabel = this.timeToWait;
        synchronized (jLabel) {
            this.secondsToWait = seconds;
            this.timeToWait.setText(String.format("%02d:%02d", seconds / 60, seconds % 60));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int getSecondsToWait() {
        JLabel jLabel = this.timeToWait;
        synchronized (jLabel) {
            return this.secondsToWait;
        }
    }

    void setMessage(String msg) {
        this.message.setText(msg);
    }
}

