/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Communication;
import de.caff.asteroid.Drawable;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.GameData;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.rammi.AsteroidPlayer;
import de.caff.asteroid.rammi.BulletLifetimeInformation;
import de.caff.util.Tools;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractBasicAsteroidPlayer
implements GameData {
    private static final int BASE = 4;
    protected static final GeneralPath HIT_POINT = new GeneralPath();
    protected static final double ROT_ANGLE = 0.07479982508547127;
    protected static final double ROT_BORDER;
    protected static final InfoDrawer NULL_INFO_DRAWER;
    protected Communication com;
    private boolean hyperPressedInLastFrame;
    private boolean firedInLastFrame;
    private BulletLifetimeInformation bulletInformation8;
    private BulletLifetimeInformation bulletInformation16;
    private BulletLifetimeInformation bulletInformation32;
    private static final int MAGICAL_HORIZONT = 966;
    private static final double DECISION_ANGLE1;
    private static final double DECISION_ANGLE2;
    private static final double DECISION_ANGLE3;

    protected AbstractBasicAsteroidPlayer() {
        try {
            int overscan = 2;
            this.bulletInformation8 = BulletLifetimeInformation.getLifetimeInformation(8, 2);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    protected AbstractBasicAsteroidPlayer(Communication com) {
        this();
        this.com = com;
    }

    private BulletLifetimeInformation getLifetimeInformation(int size) {
        return this.bulletInformation8;
    }

    protected void pushButton(int button) {
        if (this.com != null) {
            if (this.hyperPressedInLastFrame) {
                button &= 0xFFFFFFFE;
            }
            if (this.firedInLastFrame) {
                button &= 0xFFFFFFFD;
            }
            this.com.pushButton(button);
            this.hyperPressedInLastFrame = (button & 1) != 0;
            this.firedInLastFrame = (button & 2) != 0;
        }
    }

    protected boolean haveFiredInLastFrame() {
        return this.firedInLastFrame;
    }

    protected static Point2D getShootDirection(SpaceShip ship, Target target) {
        return AbstractBasicAsteroidPlayer.getShootDirection(ship, target.getObject());
    }

    static Point2D getShootDirection(SpaceShip ship, MovingGameObject target) {
        double vb2;
        double vt2;
        double f2;
        double deltaY;
        int bulletSpeed = 8;
        Point2D shipPos = ship.getCorrectedNextLocation();
        Point2D.Double targetVel = new Point2D.Double(target.getVelocityX() - ship.getVelocityX(), target.getVelocityY() - ship.getVelocityY());
        Point2D.Double targetPos = new Point2D.Double(target.getCorrectedX() + target.getVelocityX(), target.getCorrectedY() + target.getVelocityY());
        double deltaX = GameObject.normalizeDeltaX(((Point2D)targetPos).getX() - shipPos.getX());
        double q2 = -4.0 * (deltaX * deltaX + (deltaY = GameObject.normalizeDeltaY(((Point2D)targetPos).getY() - shipPos.getY())) * deltaY) * (f2 = (vt2 = Tools.square(((Point2D)targetVel).getX()) + Tools.square(((Point2D)targetVel).getY())) - (vb2 = 64.0)) + vt2;
        if (q2 >= 0.0) {
            double lambda;
            double q = 0.5 * Math.sqrt(q2) / f2;
            double p = -0.5 * Tools.scalarProduct(deltaX, deltaY, ((Point2D)targetVel).getX(), ((Point2D)targetVel).getY()) / f2;
            double lambda1 = p + q;
            double lambda2 = p - q;
            if (lambda1 > 0.0) {
                lambda = lambda2 > 0.0 ? Math.min(lambda1, lambda2) : lambda1;
            } else if (lambda2 > 0.0) {
                lambda = lambda2;
            } else {
                return null;
            }
            return new Point2D.Double(deltaX + lambda * ((Point2D)targetVel).getX(), deltaY + lambda * ((Point2D)targetVel).getY());
        }
        return null;
    }

    static int getFramesUntilCollision(MovingGameObject obj1, MovingGameObject obj2, int maxFrames) {
        int minFrames;
        double dist;
        double vLen;
        Point2D pos1 = obj1.getCorrectedNextLocation();
        Point2D pos2 = obj2.getCorrectedNextLocation();
        double deltaVX = obj1.getVelocityX() - obj2.getVelocityX();
        double deltaVY = obj1.getVelocityY() - obj2.getVelocityY();
        double deltaX = pos2.getX() - pos1.getX();
        double deltaY = pos2.getY() - pos1.getY();
        double size = obj1.getSize() + obj2.getSize();
        if (deltaVX != 0.0) {
            if (deltaX < -size && deltaVX > 0.0) {
                deltaX += 1024.0;
            } else if (deltaX > size && deltaVX < 0.0) {
                deltaX -= 1024.0;
            }
        }
        if (deltaVY != 0.0) {
            if (deltaY < -size && deltaVY > 0.0) {
                deltaY += 768.0;
            } else if (deltaY > size && deltaVY < 0.0) {
                deltaY -= 768.0;
            }
        }
        if ((vLen = Tools.getLength(deltaVX, deltaVY)) > 0.0 && (dist = Math.abs(Tools.crossProduct(deltaX, deltaY, deltaVX, deltaVY) / vLen)) <= 2.0 * size && (minFrames = (int)Math.floor(Math.sqrt(deltaX * deltaX + deltaY * deltaY - size * size) / vLen)) <= maxFrames) {
            int frames = (int)Math.ceil(Math.sqrt(deltaX * deltaX + deltaY * deltaY) / vLen);
            if (minFrames < 0) {
                minFrames = 0;
            }
            boolean hits = false;
            while (frames >= minFrames) {
                if (obj1.isHitting(obj2, frames)) {
                    hits = true;
                    break;
                }
                --frames;
            }
            if (hits) {
                while (frames > minFrames && obj1.isHitting(obj2, frames)) {
                    --frames;
                }
                return frames + 1;
            }
        }
        return 0;
    }

    protected static double bulletWillHit(SpaceShip ship, FrameInfo.Direction bulletDir, MovingGameObject target) {
        Point2D shipPos = ship.getCorrectedNextLocation();
        Point2D targetPos = target.getCorrectedNextLocation();
        shipPos.setLocation(shipPos.getX() + (double)bulletDir.getDisplacement().x, shipPos.getY() + (double)bulletDir.getDisplacement().y);
        double deltaVX = bulletDir.getBulletVelocity().getX() + ship.getVelocityX() - target.getVelocityX();
        double deltaVY = bulletDir.getBulletVelocity().getY() + ship.getVelocityY() - target.getVelocityY();
        Point2D delta = GameObject.getTorusDelta(targetPos, shipPos);
        List<Point2D> possibleTargetPositions = AbstractBasicAsteroidPlayer.getRelevantOffsets(delta, deltaVX, deltaVY);
        int size = 8;
        double vLen = Tools.getLength(deltaVX, deltaVY);
        if (vLen > 0.0) {
            double minFrames = 0.0;
            for (Point2D pos : possibleTargetPositions) {
                double frames;
                double dist = Tools.crossProduct(pos.getX(), pos.getY(), deltaVX, deltaVY) / vLen;
                if (!(Math.abs(dist) < (double)size) || !(Tools.scalarProduct(pos.getX(), pos.getY(), deltaVX, deltaVY) >= 0.0) || !((frames = Math.ceil((Math.sqrt(pos.getX() * pos.getX() + pos.getY() * pos.getY() - dist * dist) - Math.sqrt((double)(size * size) - dist * dist)) / vLen)) < 69.0) || !(frames > 0.0) || minFrames != 0.0 && !(frames < minFrames)) continue;
                minFrames = frames;
            }
            return minFrames;
        }
        return 0.0;
    }

    private static List<Point2D> getRelevantOffsets(Point2D delta, double deltaVX, double deltaVY) {
        ArrayList<Point2D> possibleTargetPositions = new ArrayList<Point2D>(9);
        possibleTargetPositions.add(delta);
        double angle = Math.atan2(deltaVY, deltaVX);
        double absAngle = Math.abs(angle);
        if (absAngle < DECISION_ANGLE3) {
            possibleTargetPositions.add(new Point2D.Double(delta.getX() + 1024.0, delta.getY()));
            if (absAngle >= DECISION_ANGLE1) {
                possibleTargetPositions.add(new Point2D.Double(delta.getX() + 1024.0, delta.getY() + deltaVY > 0.0 ? 768.0 : -768.0));
                if (absAngle >= DECISION_ANGLE2) {
                    possibleTargetPositions.add(new Point2D.Double(delta.getX(), delta.getY() + deltaVY > 0.0 ? 768.0 : -768.0));
                }
            }
        } else if (absAngle > Math.PI - DECISION_ANGLE3) {
            possibleTargetPositions.add(new Point2D.Double(delta.getX() - 1024.0, delta.getY()));
            if (absAngle <= Math.PI - DECISION_ANGLE1) {
                possibleTargetPositions.add(new Point2D.Double(delta.getX() - 1024.0, delta.getY() + deltaVY > 0.0 ? 768.0 : -768.0));
                if (absAngle <= Math.PI - DECISION_ANGLE2) {
                    possibleTargetPositions.add(new Point2D.Double(delta.getX(), delta.getY() + deltaVY > 0.0 ? 768.0 : -768.0));
                }
            }
        } else {
            possibleTargetPositions.add(new Point2D.Double(delta.getX(), delta.getY() + deltaVY > 0.0 ? 768.0 : -768.0));
        }
        assert (possibleTargetPositions.size() <= 4);
        return possibleTargetPositions;
    }

    protected RotateAndWait getRotationForHit(SpaceShip ship, byte dirByte, MovingGameObject target, int maxSize, int minFutureFrames, int maxFutureFrames) {
        Point2D shipPos = ship.getCorrectedNextLocation();
        Point2D targetPos = target.getCorrectedNextLocation();
        Point2D delta = GameObject.getTorusDelta(targetPos, shipPos);
        double tvx = target.getVelocityX();
        double tvy = target.getVelocityY();
        if (tvx == 0.0 && tvy == 0.0) {
            return null;
        }
        double deltaVX = tvx - ship.getVelocityX();
        double deltaVY = tvy - ship.getVelocityY();
        double distance = Tools.getLength(delta);
        double speed = Tools.getLength(deltaVX, deltaVY);
        int minFrame = Math.max((int)Math.floor(distance / (speed + 8.0)), minFutureFrames);
        RotateAndWait result = null;
        for (int frame = minFrame; frame <= maxFutureFrames; ++frame) {
            BulletLifetimeInformation.BulletFrameInfo[] hitInfos;
            for (BulletLifetimeInformation.BulletFrameInfo info : hitInfos = this.getLifetimeInformation(Math.min(maxSize, target.getSize())).getHitBulletInfos(delta.getX() + (double)frame * deltaVX, delta.getY() + (double)frame * deltaVY)) {
                byte deltaDir;
                int framesTillShoot = frame - info.getFrame();
                if (framesTillShoot <= 0 || Math.abs(deltaDir = (byte)(info.getDirection() - dirByte)) >= framesTillShoot) continue;
                return new RotateAndWait(deltaDir, framesTillShoot - Math.abs(deltaDir) - 1, info.getFrame());
            }
        }
        return result;
    }

    public abstract void destroy();

    static {
        HIT_POINT.moveTo(12.0f, 4.0f);
        HIT_POINT.lineTo(4.0f, 4.0f);
        HIT_POINT.lineTo(4.0f, 12.0f);
        HIT_POINT.lineTo(-4.0f, 12.0f);
        HIT_POINT.lineTo(-4.0f, 4.0f);
        HIT_POINT.lineTo(-12.0f, 4.0f);
        HIT_POINT.lineTo(-12.0f, -4.0f);
        HIT_POINT.lineTo(-4.0f, -4.0f);
        HIT_POINT.lineTo(-4.0f, -12.0f);
        HIT_POINT.lineTo(4.0f, -12.0f);
        HIT_POINT.lineTo(4.0f, -4.0f);
        HIT_POINT.lineTo(12.0f, -4.0f);
        HIT_POINT.closePath();
        ROT_BORDER = Math.sin(0.037399912542735635);
        NULL_INFO_DRAWER = new InfoDrawer(){

            public void setDanger(Target danger) {
            }

            public void addHitTarget(MovingGameObject target, Point2D hitPos) {
            }
        };
        DECISION_ANGLE1 = Math.acos(0.39751552795031053);
        DECISION_ANGLE2 = Math.atan2(768.0, 1024.0);
        DECISION_ANGLE3 = Math.acos(0.5300207039337475);
    }

    protected static class Target {
        private final MovingGameObject object;
        private Point2D hitPoint;

        protected Target(MovingGameObject object) {
            this.object = object;
        }

        public MovingGameObject getObject() {
            return this.object;
        }

        public Point2D getVelocity() {
            return this.object.getVelocity();
        }

        public int getX() {
            return this.object.getX();
        }

        public int getY() {
            return this.object.getY();
        }

        public int getSize() {
            return this.object.getSize();
        }

        public double getVX() {
            return this.object.getVelocityX();
        }

        public double getVY() {
            return this.object.getVelocityY();
        }

        public void setHitPoint(Point2D hitPoint) {
            this.hitPoint = hitPoint;
        }

        public void draw(Graphics2D g) {
            g.fill(AffineTransform.getTranslateInstance(this.hitPoint.getX(), this.hitPoint.getY()).createTransformedShape(AsteroidPlayer.HIT_POINT));
            int size = this.object.getSize();
            g.drawOval(this.object.getX() - size, this.object.getY() - size, 2 * size, 2 * size);
        }
    }

    protected static class DefaultInfoDrawer
    implements InfoDrawer,
    Drawable {
        private static final Color[] COLOR_CYCLE = new Color[]{Color.red, Color.magenta, Color.cyan, Color.orange};
        private Collection<Target> targets = new LinkedList<Target>();
        private Target danger;

        protected DefaultInfoDrawer() {
        }

        public void setDanger(Target danger) {
            this.danger = danger;
        }

        public void addHitTarget(MovingGameObject obj, Point2D hitPos) {
            Target target = new Target(obj);
            target.setHitPoint(hitPos);
            this.targets.add(target);
        }

        public void draw(Graphics2D g) {
            Stroke stroke = g.getStroke();
            g.setStroke(new BasicStroke(4.0f));
            if (this.danger != null) {
                g.setColor(Color.red);
                g.drawLine(this.danger.getX() - this.danger.getSize(), this.danger.getY() - this.danger.getSize(), this.danger.getX() + this.danger.getSize(), this.danger.getY() + this.danger.getSize());
                g.drawLine(this.danger.getX() - this.danger.getSize(), this.danger.getY() + this.danger.getSize(), this.danger.getX() + this.danger.getSize(), this.danger.getY() - this.danger.getSize());
            }
            int c = 0;
            for (Target target : this.targets) {
                g.setColor(COLOR_CYCLE[c]);
                c = (c + 1) % COLOR_CYCLE.length;
                target.draw(g);
            }
            g.setStroke(stroke);
        }
    }

    protected static interface InfoDrawer {
        public void setDanger(Target var1);

        public void addHitTarget(MovingGameObject var1, Point2D var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RotateAndWait
    implements Comparable<RotateAndWait> {
        private final int rotation;
        private final int wait;
        private final int fly;

        public RotateAndWait(int rotation, int wait, int fly) {
            this.rotation = rotation;
            this.wait = wait;
            this.fly = fly;
        }

        public int getRotation() {
            return this.rotation;
        }

        public int getWait() {
            return this.wait;
        }

        public int getFly() {
            return this.fly;
        }

        public int getShootFrames() {
            return Math.abs(this.rotation) + this.wait;
        }

        public int getHitFrames() {
            return this.getShootFrames() + this.fly;
        }

        @Override
        public int compareTo(RotateAndWait o) {
            return this.getHitFrames() - o.getHitFrames();
        }
    }
}

