/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Bullet;
import de.caff.asteroid.Explosion;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.GameObject;
import de.caff.asteroid.GameObjectVisitor;
import de.caff.asteroid.MovingGameObject;
import de.caff.asteroid.Property;
import de.caff.asteroid.ShipExplosion;
import de.caff.asteroid.SpaceShip;
import de.caff.asteroid.Text;
import de.caff.asteroid.Ufo;
import de.caff.asteroid.analysis.DumpFile;
import de.caff.asteroid.analysis.FrameKeyInfo;
import de.caff.asteroid.analysis.statistics.AbstractBasicDumpFileStatistics;
import de.caff.asteroid.rammi.ImprovedVelocityPreparer;
import de.caff.util.Tools;
import java.awt.geom.Point2D;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HitAnalysis
extends AbstractBasicDumpFileStatistics {
    private List<HitInfo> smallAsteroidsInfo = new LinkedList<HitInfo>();
    private List<HitInfo> middleAsteroidsInfo = new LinkedList<HitInfo>();
    private List<HitInfo> largeAsteroidsInfo = new LinkedList<HitInfo>();
    private List<HitInfo> smallUfosInfo = new LinkedList<HitInfo>();
    private List<HitInfo> largeUfosInfo = new LinkedList<HitInfo>();
    private List<HitInfo> shipsInfo = new LinkedList<HitInfo>();
    private Collection<List<HitInfo>> hitInfoLists = new LinkedList<List<HitInfo>>();
    private HitInfoDispatcher dispatcher;
    public static final Comparator<MovingGameObject> ID_COMPARATOR = new Comparator<MovingGameObject>(){

        @Override
        public int compare(MovingGameObject o1, MovingGameObject o2) {
            return o1.getIdentity() - o2.getIdentity();
        }
    };
    public static final Comparator<HitInfo> PRE_DESTRUCTION_COMPARATOR = new Comparator<HitInfo>(){

        @Override
        public int compare(HitInfo o1, HitInfo o2) {
            double delta = o1.getPreDestructionDistance() - o2.getPreDestructionDistance();
            return delta > 0.0 ? 1 : (delta < 0.0 ? -1 : 0);
        }
    };
    public static final Comparator<HitInfo> DESTRUCTION_COMPARATOR = new Comparator<HitInfo>(){

        @Override
        public int compare(HitInfo o1, HitInfo o2) {
            double delta = o1.getDestructionDistance() - o2.getDestructionDistance();
            return delta > 0.0 ? 1 : (delta < 0.0 ? -1 : 0);
        }
    };
    public static final Comparator<HitInfo> FRAME_COMPARATOR = new Comparator<HitInfo>(){

        @Override
        public int compare(HitInfo o1, HitInfo o2) {
            return o1.getFrameIndex() - o2.getFrameIndex();
        }
    };
    private static final Comparator<HitInfo> HITINFO_COMPARATOR = DESTRUCTION_COMPARATOR;
    private boolean collecting;

    public HitAnalysis() {
        this(false);
    }

    public HitAnalysis(boolean collecting) {
        this.hitInfoLists.add(this.smallAsteroidsInfo);
        this.hitInfoLists.add(this.middleAsteroidsInfo);
        this.hitInfoLists.add(this.largeAsteroidsInfo);
        this.hitInfoLists.add(this.smallUfosInfo);
        this.hitInfoLists.add(this.largeUfosInfo);
        this.hitInfoLists.add(this.shipsInfo);
        this.dispatcher = new HitInfoDispatcher();
        this.collecting = collecting;
    }

    @Override
    public String getTitle() {
        return "Bullet Hit";
    }

    @Override
    public void analyse(Collection<FrameKeyInfo> infos) {
        if (!this.collecting) {
            for (List<HitInfo> list : this.hitInfoLists) {
                list.clear();
            }
        }
        ArrayList<Asteroid> oldAsteroids = null;
        ArrayList<Bullet> oldBullets = null;
        int oldShipCount = 0;
        SpaceShip oldShip = null;
        Ufo oldUfo = null;
        boolean first = true;
        for (FrameKeyInfo frameKeyInfo : infos) {
            if (first) {
                first = false;
                continue;
            }
            FrameInfo info = frameKeyInfo.getFrameInfo();
            ArrayList<Asteroid> newAsteroids = new ArrayList<Asteroid>(info.getAsteroids());
            ArrayList<Bullet> newBullets = new ArrayList<Bullet>(info.getBullets());
            Collections.sort(newAsteroids, ID_COMPARATOR);
            Collections.sort(newBullets, ID_COMPARATOR);
            if (oldAsteroids != null) {
                LinkedList<Bullet> vanishedBullets = new LinkedList<Bullet>();
                Iterator newBull = newBullets.iterator();
                Integer newId = newBull.hasNext() ? ((Bullet)newBull.next()).getIdentity() : null;
                for (Bullet bull : oldBullets) {
                    if (bull.getIdentity().equals(newId)) {
                        newId = newBull.hasNext() ? ((Bullet)newBull.next()).getIdentity() : null;
                        continue;
                    }
                    vanishedBullets.add(bull);
                }
                if (!vanishedBullets.isEmpty()) {
                    LinkedList<MovingGameObject> vanishedObjects = new LinkedList<MovingGameObject>();
                    Iterator newAst = newAsteroids.iterator();
                    newId = newAst.hasNext() ? ((Asteroid)newAst.next()).getIdentity() : null;
                    for (Asteroid ast : oldAsteroids) {
                        if (ast.getIdentity().equals(newId)) {
                            newId = newAst.hasNext() ? ((Asteroid)newAst.next()).getIdentity() : null;
                            continue;
                        }
                        vanishedObjects.add(ast);
                    }
                    if (oldShipCount > info.getNrShips() && oldShip != null && info.getSpaceShip() == null) {
                        vanishedObjects.add(oldShip);
                    }
                    if (oldUfo != null && info.getUfo() == null) {
                        vanishedObjects.add(oldUfo);
                    }
                    ArrayList<HitInfo> possibleHits = new ArrayList<HitInfo>(vanishedBullets.size() * vanishedObjects.size());
                    for (Bullet bull : vanishedBullets) {
                        for (MovingGameObject obj : vanishedObjects) {
                            possibleHits.add(new HitInfo(bull, obj, info.getIndex()));
                        }
                    }
                    Collections.sort(possibleHits, HITINFO_COMPARATOR);
                    while (!possibleHits.isEmpty()) {
                        HitInfo hitInfo = (HitInfo)possibleHits.remove(0);
                        if (hitInfo.getDestructionDistance() <= (double)(2 * hitInfo.getObject().getSize())) {
                            this.dispatcher.dispatch(hitInfo);
                        }
                        ListIterator it = possibleHits.listIterator();
                        while (it.hasNext()) {
                            HitInfo i = (HitInfo)it.next();
                            if (i.getBullet() != hitInfo.getBullet() && i.getObject() != hitInfo.getObject()) continue;
                            it.remove();
                        }
                    }
                }
            }
            oldAsteroids = newAsteroids;
            oldBullets = newBullets;
            oldShipCount = info.getNrShips();
            oldShip = info.getSpaceShip();
            oldUfo = info.getUfo();
        }
        for (List list : this.hitInfoLists) {
            Collections.sort(list, HITINFO_COMPARATOR);
            Collections.reverse(list);
        }
    }

    @Override
    public Collection<Property> getProperties() {
        LinkedList<Property> props = new LinkedList<Property>();
        for (List<HitInfo> list : this.hitInfoLists) {
            for (HitInfo info : list) {
                props.add(new Property<String>(String.format("=== %s size %d ===", info.getObject().getObjectType(), info.getObject().getSize()), String.format("%s / %s", info.getDestructionDelta(), info.getPreDestructionDelta())));
            }
        }
        return props;
    }

    private static void appendListTable(StringBuilder b, List<HitInfo> list) {
        HitAnalysis.appendOpenTag(b, "table", HitAnalysis.attr("border", 1));
        HitAnalysis.appendOpenTag(b, "tr", new String[0]);
        HitAnalysis.appendTaggedText(b, "Pre Delta", "th", new String[0]);
        HitAnalysis.appendTaggedText(b, "Pre Dist", "th", new String[0]);
        HitAnalysis.appendTaggedText(b, "Delta", "th", new String[0]);
        HitAnalysis.appendTaggedText(b, "Dist", "th", new String[0]);
        HitAnalysis.appendTaggedText(b, "Bullet   LT", "th", new String[0]);
        HitAnalysis.appendTaggedText(b, "Asteroid LT", "th", new String[0]);
        HitAnalysis.appendTaggedText(b, "Frame", "th", new String[0]);
        HitAnalysis.appendCloseTag(b, "tr");
        for (HitInfo info : list) {
            HitAnalysis.appendOpenTag(b, "tr", new String[0]);
            HitAnalysis.appendTaggedText(b, info.getPreDestructionDelta().toString(), "td", new String[0]);
            HitAnalysis.appendTaggedText(b, Double.toString(info.getPreDestructionDistance()), "td", new String[0]);
            HitAnalysis.appendTaggedText(b, info.getDestructionDelta().toString(), "td", new String[0]);
            HitAnalysis.appendTaggedText(b, Double.toString(info.getDestructionDistance()), "td", new String[0]);
            HitAnalysis.appendTaggedText(b, Integer.toString(info.getBullet().getLifetime()), "td", new String[0]);
            HitAnalysis.appendTaggedText(b, Integer.toString(info.getObject().getLifetime()), "td", new String[0]);
            HitAnalysis.appendTaggedText(b, Integer.toString(info.getFrameIndex()), "td", new String[0]);
            HitAnalysis.appendCloseTag(b, "tr");
        }
        HitAnalysis.appendCloseTag(b, "table");
    }

    @Override
    public void appendToHtml(StringBuilder html) {
        this.appendToHtml(html, "h2", "h3");
    }

    private void appendToHtml(StringBuilder html, String sectionTag, String subsectionTag) {
        HitAnalysis.appendTaggedText(html, "Hit Positions", sectionTag, new String[0]);
        HitAnalysis.appendTaggedText(html, "Small Asteroids", subsectionTag, new String[0]);
        HitAnalysis.appendListTable(html, this.smallAsteroidsInfo);
        HitAnalysis.appendTaggedText(html, "Middle Asteroids", subsectionTag, new String[0]);
        HitAnalysis.appendListTable(html, this.middleAsteroidsInfo);
        HitAnalysis.appendTaggedText(html, "Large Asteroids", subsectionTag, new String[0]);
        HitAnalysis.appendListTable(html, this.largeAsteroidsInfo);
        HitAnalysis.appendTaggedText(html, "Small Ufos", subsectionTag, new String[0]);
        HitAnalysis.appendListTable(html, this.smallUfosInfo);
        HitAnalysis.appendTaggedText(html, "Large Ufos", subsectionTag, new String[0]);
        HitAnalysis.appendListTable(html, this.largeUfosInfo);
        HitAnalysis.appendTaggedText(html, "Ships", subsectionTag, new String[0]);
        HitAnalysis.appendListTable(html, this.shipsInfo);
    }

    @Override
    protected void appendHtmlBody(StringBuilder b) {
        this.appendToHtml(b, "h1", "h2");
    }

    @Override
    public boolean needPreparation() {
        return true;
    }

    public Collection<HitInfo> getSmallAsteroidsInfo() {
        return Collections.unmodifiableCollection(this.smallAsteroidsInfo);
    }

    public Collection<HitInfo> getMiddleAsteroidsInfo() {
        return Collections.unmodifiableCollection(this.middleAsteroidsInfo);
    }

    public Collection<HitInfo> getLargeAsteroidsInfo() {
        return Collections.unmodifiableCollection(this.largeAsteroidsInfo);
    }

    public Collection<HitInfo> getSmallUfosInfo() {
        return Collections.unmodifiableCollection(this.smallUfosInfo);
    }

    public Collection<HitInfo> getLargeUfosInfo() {
        return Collections.unmodifiableCollection(this.largeUfosInfo);
    }

    public Collection<HitInfo> getShipsInfo() {
        return Collections.unmodifiableCollection(this.shipsInfo);
    }

    public static void main(String[] args) throws IOException {
        HitAnalysis ana = new HitAnalysis(true);
        for (String arg : args) {
            DumpFile df = new DumpFile(arg);
            df.runPreparerDirectly(new ImprovedVelocityPreparer());
            ana.analyse(df.getInfos());
        }
        FileWriter writer = new FileWriter("hitanalysis.html");
        writer.write(ana.getHtmlReport());
        writer.close();
    }

    private class HitInfoDispatcher
    implements GameObjectVisitor {
        private HitInfo toDispatch;

        private HitInfoDispatcher() {
        }

        public void dispatch(HitInfo info) {
            this.toDispatch = info;
            info.getObject().visitedBy(this);
        }

        public void handle(Asteroid asteroid) {
            switch (asteroid.getScore()) {
                case 100: {
                    HitAnalysis.this.smallAsteroidsInfo.add(this.toDispatch);
                    break;
                }
                case 50: {
                    HitAnalysis.this.middleAsteroidsInfo.add(this.toDispatch);
                    break;
                }
                case 20: {
                    HitAnalysis.this.largeAsteroidsInfo.add(this.toDispatch);
                }
            }
        }

        public void handle(Bullet bullet) {
        }

        public void handle(Explosion explosion) {
        }

        public void handle(ShipExplosion explosion) {
        }

        public void handle(SpaceShip ship) {
            HitAnalysis.this.shipsInfo.add(this.toDispatch);
        }

        public void handle(Text text) {
        }

        public void handle(Ufo ufo) {
            switch (ufo.getScore()) {
                case 1000: {
                    HitAnalysis.this.smallUfosInfo.add(this.toDispatch);
                    break;
                }
                case 200: {
                    HitAnalysis.this.largeUfosInfo.add(this.toDispatch);
                }
            }
        }
    }

    public static class HitInfo {
        private final Bullet bullet;
        private final MovingGameObject object;
        private final int frameIndex;

        HitInfo(Bullet bullet, MovingGameObject object, int frameIndex) {
            this.bullet = bullet;
            this.object = object;
            this.frameIndex = frameIndex;
        }

        public Bullet getBullet() {
            return this.bullet;
        }

        public MovingGameObject getObject() {
            return this.object;
        }

        public int getFrameIndex() {
            return this.frameIndex;
        }

        public Point2D getPreDestructionDelta() {
            return this.object.getCorrectedDelta(this.bullet);
        }

        public Point2D getDestructionDelta() {
            Point2D nextPosBullet = this.bullet.getCorrectedNextLocation();
            Point2D nextPosObject = this.object.getCorrectedNextLocation();
            return GameObject.getTorusDelta(nextPosBullet, nextPosObject);
        }

        public double getPreDestructionDistance() {
            return Tools.getLength(this.getPreDestructionDelta());
        }

        public double getDestructionDistance() {
            return Tools.getLength(this.getDestructionDelta());
        }
    }
}

