/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.DrawableProvider;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.rammi.AbstractBasicFuturologist;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;

public class StandardFuturologist
extends AbstractBasicFuturologist
implements DrawableProvider {
    private static final Color COLOR = Color.yellow;
    private static final Font FONT = new Font("SansSerif", 1, 24);
    private Map<Integer, Integer> asteroidHits = new HashMap<Integer, Integer>();

    public void frameReceived(FrameInfo frame) {
        this.handleFrameInfo(frame);
    }

    protected int getFramesTillDestroyed(Integer ident, FrameInfo frameInfo) {
        Integer hitFrame = this.asteroidHits.get(ident);
        if (hitFrame != null) {
            return hitFrame - frameInfo.getIndex();
        }
        return -1;
    }

    protected void addHit(Integer astIdent, int frameCounter) {
        Integer currentCounter = this.asteroidHits.get(astIdent);
        if (currentCounter == null || currentCounter > frameCounter) {
            this.asteroidHits.put(astIdent, frameCounter);
        }
    }

    protected void forgetEverything() {
        this.asteroidHits.clear();
    }

    public void draw(Graphics2D g, FrameInfo frame) {
        this.frameReceived(frame);
        g.setFont(FONT);
        g.setColor(COLOR);
        FontMetrics metrics = g.getFontMetrics();
        for (Asteroid ast : frame.getAsteroids()) {
            int ttl = this.getFramesTillDestroyed(ast, frame);
            if (ttl < 0) continue;
            Point pos = ast.getLocation();
            String txt = Integer.toString(ttl);
            Rectangle2D bbox = metrics.getStringBounds(txt, g);
            AffineTransform oldTrafo = g.getTransform();
            g.translate(pos.x, pos.y);
            g.scale(1.0, -1.0);
            g.drawString(txt, (float)(-bbox.getCenterX()), (float)(-bbox.getCenterY()));
            g.setTransform(oldTrafo);
        }
    }
}

