/*
 * Decompiled with CFR 0.152.
 */
package de.caff.asteroid.rammi;

import de.caff.asteroid.Asteroid;
import de.caff.asteroid.Communication;
import de.caff.asteroid.FrameInfo;
import de.caff.asteroid.FrameListener;
import de.caff.asteroid.GameData;
import de.caff.asteroid.SpaceShip;
import de.caff.util.Tools;
import java.awt.Point;

class SuicidePlayer
implements FrameListener,
GameData {
    private Communication com;

    SuicidePlayer(Communication com) {
        this.com = com;
    }

    public void frameReceived(FrameInfo frame) {
        SpaceShip ship = frame.getSpaceShip();
        if (ship != null) {
            if (frame.getAsteroidCount() < 10) {
                if (frame.getIndex() % 2 == 0) {
                    this.com.pushButton(1);
                }
                return;
            }
            int minDist2 = Integer.MAX_VALUE;
            Asteroid nearest = null;
            for (Asteroid ast : frame.getAsteroids()) {
                Point delta = ship.getDelta(ast);
                int dist2 = delta.x * delta.x + delta.y * delta.y;
                if (dist2 >= minDist2) continue;
                minDist2 = dist2;
                nearest = ast;
            }
            if (nearest != null) {
                double cross = Tools.crossProduct(ship.getDelta(nearest), ship.getDirection());
                if (cross <= 0.0) {
                    this.com.pushButton(16);
                } else {
                    this.com.pushButton(8);
                }
                this.com.pushButton(4);
            }
        }
    }
}

