/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import java.util.MissingResourceException;
import javax.swing.JCheckBox;

public class RJCheckBox
extends JCheckBox
implements Localizable {
    protected String resTag;

    public RJCheckBox(String resTag, boolean selected) {
        super("", selected);
        this.setTag(resTag);
    }

    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener(this);
    }

    public void removeNotify() {
        I18n.removeLocalizationChangeListener(this);
        super.removeNotify();
    }

    public void setTag(String tag) {
        this.resTag = tag;
        this.setText(I18n.getString(this.resTag + "-TEXT", this.getLocale()));
        try {
            this.setToolTipText(I18n.getString(this.resTag + "-TTT", this.getLocale()));
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    public void setLocale(Locale l) {
        Locale oldLocale = this.getLocale();
        super.setLocale(l);
        if (oldLocale != null && !oldLocale.equals(l) && this.resTag != null) {
            this.setText(I18n.getString(this.resTag + "-TEXT", l));
            try {
                this.setToolTipText(I18n.getString(this.resTag + "-TTT", this.getLocale()));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
    }

    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException x) {
            return null;
        }
    }
}

