/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.JLabel;

public class RJLabel
extends JLabel
implements Localizable {
    protected String textResource;
    protected String addText;

    private void init(String textRes, String add) {
        if (add != null) {
            this.setText(I18n.getString(textRes + "-TEXT", this.getLocale()) + add);
        } else {
            this.setText(I18n.getString(textRes + "-TEXT", this.getLocale()));
        }
        this.textResource = textRes;
        this.addText = add;
        I18n.addLocalizationChangeListener(this);
    }

    public RJLabel(String textRes) {
        this.init(textRes, null);
    }

    public RJLabel(String textRes, int align) {
        this.init(textRes, null);
        this.setHorizontalAlignment(align);
    }

    public RJLabel(String textRes, String add) {
        this.init(textRes, add);
    }

    public RJLabel(String textRes, String add, int align) {
        this.init(textRes, add);
        this.setHorizontalAlignment(align);
    }

    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener(this);
    }

    public void removeNotify() {
        I18n.removeLocalizationChangeListener(this);
        super.removeNotify();
    }

    public void setLocale(Locale l) {
        Locale oldLocale = this.getLocale();
        super.setLocale(l);
        if (oldLocale != null && !oldLocale.equals(l) && this.textResource != null) {
            if (this.addText == null) {
                this.setText(I18n.getString(this.textResource + "-TEXT", l));
            } else {
                this.setText(I18n.getString(this.textResource + "-TEXT", l) + this.addText);
            }
            this.invalidate();
        }
    }

    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException x) {
            return null;
        }
    }
}

