/*
 * Decompiled with CFR 0.152.
 */
package de.caff.i18n.swing;

import de.caff.i18n.I18n;
import de.caff.i18n.Localizable;
import de.caff.i18n.swing.I18nHelper;
import java.awt.IllegalComponentStateException;
import java.util.Locale;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class RJMenu
extends JMenu
implements Localizable {
    protected String resTag;

    public RJMenu(String tag) {
        this.setTag(tag);
    }

    public RJMenu(String tag, boolean tearoff) {
        super("", tearoff);
        this.setTag(tag);
    }

    public void addNotify() {
        super.addNotify();
        I18n.addLocalizationChangeListener(this);
    }

    public void removeNotify() {
        I18n.removeLocalizationChangeListener(this);
        super.removeNotify();
    }

    public void setTag(String tag) {
        this.resTag = tag;
        I18nHelper.setProperties(this, tag, this.getLocale());
    }

    public void setLocale(Locale l) {
        Locale oldLocale = this.getLocale();
        super.setLocale(l);
        if (oldLocale != null && !oldLocale.equals(l) && this.resTag != null) {
            I18nHelper.setProperties(this, this.resTag, this.getLocale());
        }
    }

    public Locale getLocale() {
        try {
            return super.getLocale();
        }
        catch (IllegalComponentStateException x) {
            return null;
        }
    }

    public JMenuItem add(JMenuItem m) {
        Localizable l;
        if (m instanceof Localizable && (l = (Localizable)((Object)m)).getLocale() == null) {
            l.setLocale(this.getLocale());
        }
        return super.add(m);
    }

    public JMenuItem insert(JMenuItem m, int index) {
        Localizable l;
        if (m instanceof Localizable && (l = (Localizable)((Object)m)).getLocale() == null) {
            l.setLocale(this.getLocale());
        }
        return super.insert(m, index);
    }
}

