/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util;

import de.caff.util.EventQueueExceptionListener;
import de.caff.util.EventQueueExceptionWrapper;
import java.applet.Applet;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ImageProducer;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.Icon;

public class Utility {
    public static final float PHYS_RED_SCALE = 0.3f;
    public static final float PHYS_GREEN_SCALE = 0.53f;
    public static final float PHYS_BLUE_SCALE = 0.17000002f;
    private static Component preparer = new Canvas();
    private static boolean weAreOnDOS = File.separatorChar == '\\';
    private static String resourceDir = "resources/";
    private static Applet applet = null;
    private static EventQueueExceptionWrapper exceptionWrapper = null;
    private static boolean debugging = false;

    public static void setDebug(boolean mode) {
        debugging = mode;
    }

    public static boolean isDebug() {
        return debugging;
    }

    public static Image loadImage(String path) {
        return Utility.loadImage(path, preparer);
    }

    public static Image loadImage(String path, Component renderer) {
        if (resourceDir != null && !path.startsWith("/")) {
            path = resourceDir + path;
        }
        return new Utility().loadAnImage(path, renderer);
    }

    private Image loadAnImage(String path, Component renderer) {
        Image img = null;
        try {
            URL url = this.getClass().getResource(path);
            if (url == null) {
                if (applet != null) {
                    url = new URL(applet.getDocumentBase(), "de/caff/gimmicks/" + path);
                } else {
                    return null;
                }
            }
            img = applet != null ? applet.getImage(url) : Toolkit.getDefaultToolkit().createImage((ImageProducer)url.getContent());
        }
        catch (Exception x) {
            Utility.debug(x);
        }
        if (img != null) {
            renderer.prepareImage(img, null);
        }
        return img;
    }

    public static String loadText(String path) {
        if (resourceDir != null) {
            path = resourceDir + path;
        }
        return new Utility().loadAText(path);
    }

    private String loadAText(String path) {
        String txt = "";
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(path)));
            while ((line = reader.readLine()) != null) {
                txt = txt + line + "\n";
            }
            reader.close();
        }
        catch (Exception x) {
            Utility.debug(x);
        }
        return txt;
    }

    public static boolean areWeOnDOS() {
        return weAreOnDOS;
    }

    public static void setResourceDir(String dir) {
        resourceDir = dir;
    }

    public static String compileString(String tag, Object[] args, ResourceBundle res) {
        String format = res.getString(tag);
        StringBuffer ret = new StringBuffer(format.length());
        for (int i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (c == '%' || c == '@') {
                int argNum = -1;
                if (i < format.length() - 1) {
                    switch (format.charAt(i + 1)) {
                        case '%': {
                            if (c != '%') break;
                            ret.append('%');
                            ++i;
                            break;
                        }
                        case '@': {
                            if (c != '@') break;
                            ret.append("@");
                            ++i;
                            break;
                        }
                        case '0': {
                            argNum = 0;
                            break;
                        }
                        case '1': {
                            argNum = 1;
                            break;
                        }
                        case '2': {
                            argNum = 2;
                            break;
                        }
                        case '3': {
                            argNum = 3;
                            break;
                        }
                        case '4': {
                            argNum = 4;
                            break;
                        }
                        case '5': {
                            argNum = 5;
                            break;
                        }
                        case '6': {
                            argNum = 6;
                            break;
                        }
                        case '7': {
                            argNum = 7;
                            break;
                        }
                        case '8': {
                            argNum = 8;
                            break;
                        }
                        case '9': {
                            argNum = 9;
                            break;
                        }
                    }
                }
                if (argNum < 0 || argNum >= args.length) continue;
                if (c == '%') {
                    ret.append(args[argNum]);
                } else {
                    ret.append(res.getString(args[argNum].toString()));
                }
                ++i;
                continue;
            }
            ret.append(c);
        }
        return new String(ret);
    }

    public static Frame getFrame(Component comp) {
        while (comp != null) {
            if (comp instanceof Frame) {
                return (Frame)comp;
            }
            comp = comp.getParent();
        }
        return new Frame();
    }

    public static boolean equalBytes(byte[] arr1, int off1, byte[] arr2, int off2, int len) {
        while (len-- > 0) {
            if (arr1[off1++] == arr2[off2++]) continue;
            return false;
        }
        return true;
    }

    public static void setApplet(Applet applet) {
        Utility.applet = applet;
    }

    public static Applet getApplet() {
        return applet;
    }

    public static boolean areWeInAnApplet() {
        return applet != null;
    }

    public static boolean getBooleanParameter(String key, boolean def) {
        String value = Utility.getStringParameter(key, null);
        if (value != null) {
            return "true".equals(value.toLowerCase());
        }
        return def;
    }

    public static String getStringParameter(String key, String def) {
        try {
            String value;
            String string = value = Utility.areWeInAnApplet() ? applet.getParameter(key) : System.getProperty(key);
            if (value != null) {
                return value;
            }
        }
        catch (Exception x) {
            Utility.debug(x);
        }
        return def;
    }

    public static Color getColorParameter(String key, Color def) {
        String value = Utility.getStringParameter(key, null);
        if (value != null) {
            try {
                return Color.decode(value);
            }
            catch (Exception x) {
                Utility.debug(x);
            }
        }
        return def;
    }

    public static int getIntParameter(String key, int def) {
        return Utility.getIntParameter(key, def, 10);
    }

    public static int getIntParameter(String key, int def, int base) {
        String value = Utility.getStringParameter(key, null);
        if (value != null) {
            try {
                return Integer.parseInt(value, base);
            }
            catch (NumberFormatException x) {
                Utility.debug(x);
            }
        }
        return def;
    }

    public static double getDoubleParameter(String key, double def) {
        String value = Utility.getStringParameter(key, null);
        if (value != null) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException x) {
                Utility.debug(x);
            }
        }
        return def;
    }

    public static float getFloatParameter(String key, float def) {
        String value = Utility.getStringParameter(key, null);
        if (value != null) {
            try {
                return Float.valueOf(value).floatValue();
            }
            catch (NumberFormatException x) {
                Utility.debug(x);
            }
        }
        return def;
    }

    public static void debug(Object x) {
        if (debugging) {
            System.out.println(x == null ? "<null>" : x.toString());
        }
    }

    public static void debug(Throwable x) {
        if (debugging) {
            x.printStackTrace();
        }
    }

    public static void printProperty(String prop) {
        try {
            Utility.debug(prop + "=" + System.getProperty(prop));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void printProperties() {
        if (Utility.isDebug()) {
            String[] useful = new String[]{"java.version", "java.vendor", "os.name", "os.arch", "os.version"};
            for (int u = 0; u < useful.length; ++u) {
                Utility.printProperty(useful[u]);
            }
        }
    }

    public static boolean globEquals(String mask, String str) {
        int maskLen = mask.length();
        int strLen = str.length();
        if (maskLen > 0) {
            char first = mask.charAt(0);
            switch (first) {
                case '*': {
                    return Utility.globEquals(mask.substring(1), str) || strLen > 0 && Utility.globEquals(mask, str.substring(1));
                }
                case '?': {
                    return strLen > 0 && Utility.globEquals(mask.substring(1), str.substring(1));
                }
            }
            return strLen > 0 && first == str.charAt(0) && Utility.globEquals(mask.substring(1), str.substring(1));
        }
        return maskLen == strLen;
    }

    public static void addEventQueueExceptionListener(EventQueueExceptionListener listener) {
        if (exceptionWrapper == null) {
            exceptionWrapper = new EventQueueExceptionWrapper();
        }
        exceptionWrapper.addEventQueueExceptionListener(listener);
    }

    public static void removeEventQueueExceptionListener(EventQueueExceptionListener listener) {
        if (exceptionWrapper != null) {
            exceptionWrapper.removeEventQueueExceptionListener(listener);
        }
    }

    public static Cursor createCustomCursor(Icon icon, Color bgColor, String name, Cursor fallback) {
        return Utility.createCustomCursor(icon, bgColor, null, name, fallback);
    }

    public static Cursor createCustomCursor(Icon icon, Color bgColor, Point hotspot, String name, Cursor fallback) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension size = toolkit.getBestCursorSize(icon.getIconWidth(), icon.getIconHeight());
        if (size.width >= icon.getIconWidth() && size.height >= icon.getIconHeight()) {
            Cursor cursor;
            int x = (size.width - icon.getIconWidth()) / 2;
            int y = (size.height - icon.getIconHeight()) / 2;
            BufferedImage image = new BufferedImage(size.width, size.height, 2);
            preparer.setBackground(bgColor);
            icon.paintIcon(preparer, image.getGraphics(), x, y);
            if (hotspot == null) {
                hotspot = new Point(icon.getIconWidth() / 2, icon.getIconHeight() / 2);
            }
            if ((cursor = toolkit.createCustomCursor(image, new Point(hotspot.x + x, hotspot.y + y), name)) != null) {
                return cursor;
            }
        }
        return fallback;
    }

    public static float getPhysiologicalBrightness(Color color) {
        return 0.3f * (float)color.getRed() / 255.0f + 0.53f * (float)color.getGreen() / 255.0f + 0.17f * (float)color.getBlue() / 255.0f;
    }

    public static Color getPhysiologicalGray(Color color) {
        float brightness = Utility.getPhysiologicalBrightness(color);
        return new Color(brightness, brightness, brightness);
    }

    public static float getColorBrightnessDistance(Color color1, Color color2) {
        return Math.abs(Utility.getPhysiologicalBrightness(color1) - Utility.getPhysiologicalBrightness(color2));
    }
}

