/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.util.debug.CookedMessageDebugListener;
import de.caff.util.debug.Debug;
import de.caff.util.debug.DebugLevelSwitchBoard;
import de.caff.util.debug.DebugMessageCook;
import de.caff.util.debug.MemoryUsagePanel;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class DebugMessageWindow
extends JFrame
implements CookedMessageDebugListener {
    private JTextArea _msgArea;
    private int _endPos;

    public DebugMessageWindow(boolean extended) {
        super("Debug Messages");
        this.setDefaultCloseOperation(0);
        this._msgArea = new JTextArea(25, 100);
        this._msgArea.setFont(new Font("Monospaced", 0, 12));
        this._msgArea.setEditable(false);
        this.getContentPane().add(new JScrollPane(this._msgArea));
        JPanel panel = new JPanel(new BorderLayout());
        this.getContentPane().add("East", panel);
        if (extended) {
            MemoryUsagePanel memPanel = new MemoryUsagePanel();
            memPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Memory"));
            panel.add("North", memPanel);
            DebugLevelSwitchBoard switchPanel = new DebugLevelSwitchBoard();
            panel.add("Center", switchPanel);
            switchPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Global Settings"));
            panel.add(switchPanel);
        }
        JPanel allButtons = new JPanel(new BorderLayout());
        allButtons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add("South", allButtons);
        JButton b = new JButton("Print System Properties");
        allButtons.add("North", b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMessageWindow.this.printProperties();
            }
        });
        b.setToolTipText("Print the system properties in the text window");
        JPanel buttonPanel = new JPanel(new GridLayout(0, 1));
        allButtons.add("South", buttonPanel);
        b = new JButton("Clear");
        buttonPanel.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMessageWindow.this.clear();
            }
        });
        b.setToolTipText("Clears the text window");
        b = new JButton("Save...");
        buttonPanel.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DebugMessageWindow.this.save();
            }
        });
        b.setToolTipText("Allows to save the content of the text window");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Debug.removeCookedMessageDebugListener(DebugMessageWindow.this);
                DebugMessageWindow.this.dispose();
            }
        });
        Debug.addCookedMessageDebugListener(this);
        this.pack();
        this.setVisible(true);
    }

    public void receiveCookedMessage(int msgType, final String message, final String pos) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DebugMessageWindow.this.append(message + DebugMessageCook.cookedPosition(pos));
            }
        });
    }

    private void append(String text) {
        this._msgArea.append(text);
        this._endPos += text.length();
        this._msgArea.setCaretPosition(this._endPos);
    }

    private void clear() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DebugMessageWindow.this._msgArea.setText("");
                DebugMessageWindow.this._endPos = 0;
            }
        });
    }

    private void save() {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showDialog(this, "Sichern") == 0) {
            File file = chooser.getSelectedFile();
            try {
                FileWriter out = new FileWriter(file);
                out.write(this._msgArea.getText());
                out.close();
                Debug.message("Debugmeldungen gesichert in \"%1\"", (Object)file);
            }
            catch (Exception x) {
                Debug.error("Sichern von \"%1\" gescheitert.\nGrund:\n%2", (Object)file, x.getMessage());
            }
        }
    }

    private void printProperties() {
        ArrayList<String> lines = new ArrayList<String>();
        Enumeration<?> p = System.getProperties().propertyNames();
        while (p.hasMoreElements()) {
            String prop = (String)p.nextElement();
            try {
                lines.add("\t" + prop + " = \"" + System.getProperty(prop) + "\"\n");
            }
            catch (SecurityException x) {
                lines.add("\t" + prop + " not available due to security restrictions\n");
            }
        }
        Collections.sort(lines);
        this.append("SYSTEM PROPERTIES:\n");
        for (String line : lines) {
            this.append(line);
        }
    }
}

