/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.debug;

import de.caff.util.debug.CookedMessageDebugListener;
import de.caff.util.debug.Debug;
import de.caff.util.debug.DebugLevelSwitchBoard;
import de.caff.util.debug.DebugMessageCook;
import de.caff.util.debug.MemoryUsagePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FilteringDebugMessageWindow
extends JFrame
implements CookedMessageDebugListener {
    private static final String[] TYPE_NAMES = new String[]{Character.toString('T'), Character.toString('S'), Character.toString('W'), Character.toString('E'), Character.toString('F'), Character.toString('L'), Character.toString('A')};
    private JTextArea _msgArea;
    private int _endPos;
    private Collection _msgList = new LinkedList();
    private long _filterMask = 127L;
    private PositionTree _positionTree;
    private JLabel _statusLine;
    private int _nrDisplayed;
    private int[] _nrMessages = new int[7];
    private boolean _appendWindow = true;
    private StringBuffer _refilterBuffer = new StringBuffer();

    public FilteringDebugMessageWindow() {
        super("Debug Messages");
        this.setDefaultCloseOperation(0);
        Border tabBorder = BorderFactory.createLoweredBevelBorder();
        this._msgArea = new JTextArea(25, 100);
        this._msgArea.setFont(new Font("Monospaced", 0, 12));
        this._msgArea.setEditable(false);
        JSplitPane split = new JSplitPane();
        this.getContentPane().add(split);
        split.setLeftComponent(new JScrollPane(this._msgArea));
        this._statusLine = new JLabel();
        this.getContentPane().add("South", this._statusLine);
        this._statusLine.setBorder(BorderFactory.createEtchedBorder());
        JPanel panel = new JPanel(new BorderLayout());
        JTabbedPane tabbed = new JTabbedPane();
        tabbed.setPreferredSize(new Dimension(300, 400));
        panel.add(tabbed);
        split.setRightComponent(panel);
        JPanel comp = new DebugLevelSwitchBoard();
        comp.setBorder(tabBorder);
        tabbed.addTab("Global Settings", null, comp, "Allows to change global debug settings");
        comp = new MemoryUsagePanel();
        comp.setBorder(BorderFactory.createCompoundBorder(tabBorder, BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        tabbed.addTab("Memory", null, comp, "Memory Usage and Garbage Collection");
        comp = new MessageTypeFilterBoard();
        comp.setBorder(tabBorder);
        tabbed.addTab("Filter by Type", null, comp, "Filtering of received and future messages by message type");
        this._positionTree = new PositionTree();
        comp = this._positionTree;
        comp.setBorder(tabBorder);
        tabbed.addTab("Filter by Position", null, comp, "Filtering of received and future messages by file position");
        JPanel allButtons = new JPanel(new BorderLayout());
        allButtons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add("South", allButtons);
        JButton b = new JButton("Print System Properties");
        allButtons.add("North", b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilteringDebugMessageWindow.this.printProperties();
            }
        });
        b.setToolTipText("Print the system properties in the text window");
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
        allButtons.add("South", buttonPanel);
        b = new JButton("Clear");
        buttonPanel.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilteringDebugMessageWindow.this.clear();
            }
        });
        b.setToolTipText("Clears the text window and the message storage");
        b = new JButton("Save...");
        buttonPanel.add(b);
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilteringDebugMessageWindow.this.save();
            }
        });
        b.setToolTipText("Allows to save the content of the text window");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                Debug.removeCookedMessageDebugListener(FilteringDebugMessageWindow.this);
                FilteringDebugMessageWindow.this.dispose();
            }
        });
        Debug.addCookedMessageDebugListener(this);
        this.pack();
        this.setVisible(true);
    }

    public void receiveCookedMessage(int msgType, String message, String pos) {
        Message msg = this.addToMessageList(msgType, message, pos);
        this.possiblyDisplayMessage(msg);
        this.updateStatus();
    }

    private Message addToMessageList(int msgType, String message, String pos) {
        int n = msgType;
        this._nrMessages[n] = this._nrMessages[n] + 1;
        Message msg = new Message(msgType, message, pos);
        this._msgList.add(msg);
        Object node = this._positionTree.appendPosition(pos);
        msg.setNode(node);
        return msg;
    }

    private void possiblyDisplayMessage(final Message msg) {
        if (msg.isTypeConform(this._filterMask) && this._positionTree.allows(msg)) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.showMessage(msg);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        FilteringDebugMessageWindow.this.showMessage(msg);
                    }
                });
            }
        }
    }

    private void showMessage(Message msg) {
        String message = msg.toString();
        this.append(message);
    }

    private void append(String text) {
        ++this._nrDisplayed;
        if (this._appendWindow) {
            this._msgArea.append(text);
            this._endPos += text.length();
            this._msgArea.setCaretPosition(this._endPos);
        } else {
            this._refilterBuffer.append(text);
        }
    }

    private void clear() {
        this._msgList.clear();
        Arrays.fill(this._nrMessages, 0);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FilteringDebugMessageWindow.this.clearTextWindow();
            }
        });
    }

    private void clearTextWindow() {
        this._msgArea.setText("");
        this._nrDisplayed = 0;
        this._endPos = 0;
        this.updateStatus();
    }

    private void updateStatus() {
        StringBuffer buf = new StringBuffer();
        buf.append(" Shown messages: ").append(this._nrDisplayed).append('/').append(this._msgList.size()).append(" (");
        for (int m = 0; m < TYPE_NAMES.length; ++m) {
            if (m != 0) {
                buf.append('+');
            }
            buf.append(this._nrMessages[m]).append(TYPE_NAMES[m]);
        }
        buf.append(')');
        this._statusLine.setText(buf.toString());
    }

    private void save() {
        JFileChooser chooser = new JFileChooser();
        if (chooser.showDialog(this, "Sichern") == 0) {
            File file = chooser.getSelectedFile();
            try {
                FileWriter out = new FileWriter(file);
                out.write(this._msgArea.getText());
                out.write("\n=== Memory Usage Information ===\n");
                System.gc();
                Runtime rt = Runtime.getRuntime();
                long freeMem = rt.freeMemory();
                long totalMem = rt.totalMemory();
                long usedMem = totalMem - freeMem;
                out.write("\t used JVM memory: " + usedMem + " Bytes\n");
                out.write("\t free JVM memory: " + freeMem + " Bytes\n");
                out.write("\ttotal JVM memory: " + totalMem + " Bytes\n");
                out.write("\n=== System Information ===\n");
                Iterator it = FilteringDebugMessageWindow.getSystemPropertyList().iterator();
                while (it.hasNext()) {
                    out.write("\t" + it.next().toString() + "\n");
                }
                out.write("=== EOF ===\n");
                out.close();
                Debug.message("Debugmeldungen gesichert in \"%1\"", (Object)file);
            }
            catch (Exception x) {
                Debug.error("Sichern von \"%1\" gescheitert.\nGrund:\n%2", (Object)file, x.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void refilterDisplay() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.clearTextWindow();
            this._refilterBuffer.setLength(0);
            this._appendWindow = false;
            Iterator it = this._msgList.iterator();
            while (it.hasNext()) {
                this.possiblyDisplayMessage((Message)it.next());
            }
            this._appendWindow = true;
            this.append(this._refilterBuffer.toString());
            --this._nrDisplayed;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
            this.updateStatus();
        }
    }

    private void printProperties() {
        this.append("SYSTEM PROPERTIES:\n");
        Iterator it = FilteringDebugMessageWindow.getSystemPropertyList().iterator();
        while (it.hasNext()) {
            this.append("\t" + it.next().toString() + "\n");
        }
    }

    public static Collection getSystemPropertyList() {
        ArrayList<String> array = new ArrayList<String>();
        Enumeration<?> p = System.getProperties().propertyNames();
        while (p.hasMoreElements()) {
            String prop = (String)p.nextElement();
            try {
                array.add(prop + " = \"" + System.getProperty(prop) + "\"");
            }
            catch (SecurityException x) {
                array.add(prop + " not available due to security restrictions");
            }
        }
        Collections.sort(array);
        return array;
    }

    private class PositionTree
    extends JPanel {
        private JTree _tree;
        private HashMap _positions;

        public PositionTree() {
            super(new BorderLayout());
            this._positions = new HashMap(89);
            this._tree = new JTree(new DefaultTreeModel(new PositionNode(""), true));
            this._tree.putClientProperty("JTree.lineStyle", "Angled");
            this._tree.setRootVisible(false);
            this._tree.setShowsRootHandles(true);
            this._tree.setCellRenderer(new DefaultTreeCellRenderer(){
                private Font _excludedFont;
                private Font _includedFont;

                private void initFonts(JTree tree) {
                    Font font = tree.getFont();
                    this._includedFont = font.deriveFont(1);
                    this._excludedFont = font.deriveFont(0);
                }

                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                    PositionNode node = (PositionNode)value;
                    JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
                    label.setFont(tree.getFont().deriveFont(node.isIncluded() ? 1 : 0));
                    return label;
                }
            });
            this.add((Component)new JScrollPane(this._tree), "Center");
            JPanel buttonPanel = new JPanel(new GridLayout(0, 2));
            JButton b = new JButton("Include");
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PositionTree.this.includeSelection();
                }
            });
            b.setToolTipText("Includes the currently selected nodes and branches into the displayed messages");
            buttonPanel.add(b);
            b = new JButton("Exclude");
            b.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    PositionTree.this.excludeSelection();
                }
            });
            b.setToolTipText("Excludes the currently selected nodes and branches from the displayed messages");
            buttonPanel.add(b);
            this.add((Component)buttonPanel, "South");
        }

        public void clear() {
            this._tree.setModel(new DefaultTreeModel(new PositionNode(""), true));
            this._positions.clear();
        }

        public Object appendPosition(String pos) {
            Object node = this._positions.get(pos);
            if (node == null) {
                Object[] elems;
                if ("???".equals(pos)) {
                    elems = new Object[]{pos};
                } else {
                    StringTokenizer st = new StringTokenizer(pos, "()");
                    String className = st.nextToken();
                    String lineNr = st.nextToken();
                    StringTokenizer pst = new StringTokenizer(className, ".");
                    ArrayList<Object> tokens = new ArrayList<Object>(32);
                    while (pst.hasMoreTokens()) {
                        String tok = pst.nextToken();
                        int dollar = tok.indexOf(36);
                        if (dollar > 0) {
                            tokens.add(tok.substring(0, dollar));
                            tokens.add(tok.substring(dollar));
                            continue;
                        }
                        tokens.add(tok);
                    }
                    int index = lineNr.indexOf(58) + 1;
                    if (index <= 0) {
                        index = lineNr.indexOf(44) + 1;
                        if (index <= 0) {
                            tokens.add(lineNr);
                        } else {
                            tokens.add(lineNr.substring(index).trim());
                        }
                    } else {
                        lineNr = lineNr.substring(index);
                        try {
                            tokens.add(Integer.decode(lineNr));
                        }
                        catch (NumberFormatException x) {
                            tokens.add(lineNr);
                        }
                    }
                    elems = tokens.toArray();
                }
                node = this.appendPath(elems);
                this._positions.put(pos, node);
            }
            return node;
        }

        private Object appendPath(Object[] elements) {
            TreeModel model = this._tree.getModel();
            PositionNode node = (PositionNode)model.getRoot();
            return this.append(node, elements, 0);
        }

        private Object append(PositionNode node, Object[] elems, int index) {
            int insertPos;
            for (insertPos = 0; insertPos < node.getChildCount(); ++insertPos) {
                PositionNode sub = (PositionNode)node.getChildAt(insertPos);
                Object obj = sub.getUserObject();
                int comp = obj.getClass() == elems[index].getClass() ? ((Comparable)obj).compareTo(elems[index]) : obj.toString().compareTo(elems[index].toString());
                if (comp == 0) {
                    if (++index == elems.length) {
                        return sub;
                    }
                    return this.append(sub, elems, index);
                }
                if (comp > 0) break;
            }
            DefaultTreeModel model = (DefaultTreeModel)this._tree.getModel();
            PositionNode sub = null;
            while (index < elems.length) {
                sub = new PositionNode(elems[index], index < elems.length - 1);
                sub.setIncluded(node.isIncluded());
                model.insertNodeInto(sub, node, insertPos);
                node = sub;
                insertPos = 0;
                ++index;
            }
            return sub;
        }

        private PositionNode nodeForPath(TreePath path) {
            return (PositionNode)path.getLastPathComponent();
        }

        private void includeSelection() {
            TreePath[] paths = this._tree.getSelectionPaths();
            for (int p = 0; p < paths.length; ++p) {
                PositionNode node = this.nodeForPath(paths[p]);
                node.setIncluded(true);
            }
            FilteringDebugMessageWindow.this.refilterDisplay();
        }

        private void excludeSelection() {
            TreePath[] paths = this._tree.getSelectionPaths();
            for (int p = 0; p < paths.length; ++p) {
                PositionNode node = this.nodeForPath(paths[p]);
                node.setIncluded(false);
            }
            FilteringDebugMessageWindow.this.refilterDisplay();
        }

        public boolean allows(Message msg) {
            return ((PositionNode)msg.getNode()).isIncluded();
        }

        private class PositionNode
        extends DefaultMutableTreeNode {
            private boolean _included;

            public PositionNode(Object obj) {
                super(obj);
                this._included = true;
            }

            public PositionNode(Object obj, boolean b) {
                super(obj, b);
                this._included = true;
            }

            private void setIncludedDirect(boolean inc) {
                if (inc != this._included) {
                    this._included = inc;
                    ((DefaultTreeModel)PositionTree.this._tree.getModel()).nodeChanged(this);
                }
            }

            public void setIncluded(boolean inc) {
                this.setIncludedDirect(inc);
                if (!this.isLeaf()) {
                    Enumeration<TreeNode> c = this.children();
                    while (c.hasMoreElements()) {
                        ((PositionNode)c.nextElement()).setIncluded(inc);
                    }
                }
            }

            public boolean isIncluded() {
                return this._included;
            }

            private void checkChildrenInclude() {
                if (!this._included) {
                    Enumeration<TreeNode> c = this.children();
                    while (c.hasMoreElements()) {
                        if (((PositionNode)c.nextElement()).isIncluded()) continue;
                        return;
                    }
                    this.setIncludedDirect(true);
                    PositionNode parent = (PositionNode)this.getParent();
                    if (parent != null) {
                        parent.checkChildrenInclude();
                    }
                }
            }

            public Object clone() {
                return new PositionNode(this.getUserObject(), this.allowsChildren);
            }
        }
    }

    private class MessageTypeFilterBoard
    extends JPanel {
        public MessageTypeFilterBoard() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(new FilterCheckBox("Display trace messages", 1L, "Toggles the display of trace debug messages."));
            this.add(new FilterCheckBox("Display standard messages", 2L, "Toggles the display of standard debug messages."));
            this.add(new FilterCheckBox("Display warning messages", 4L, "Toggles the display of warning debug messages."));
            this.add(new FilterCheckBox("Display error messages", 8L, "Toggles the display of error debug messages."));
            this.add(new FilterCheckBox("Display fatal error messages", 16L, "Toggles the display of fatal error debug messages."));
            this.add(new FilterCheckBox("Display logging messages", 32L, "Toggles the display of logging messages."));
            this.add(new FilterCheckBox("Display failed assertion messages", 64L, "Toggles the display of failed assertion messages."));
        }
    }

    private class FilterCheckBox
    extends JCheckBox
    implements ItemListener {
        private long _mask;

        public FilterCheckBox(String text, long mask, String ttt) {
            super(text, true);
            this.setSelected((FilteringDebugMessageWindow.this._filterMask & mask) != 0L);
            this._mask = mask;
            this.addItemListener(this);
            if (ttt != null) {
                this.setToolTipText(ttt);
            }
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                FilteringDebugMessageWindow.this._filterMask |= this._mask;
            } else {
                FilteringDebugMessageWindow.this._filterMask &= this._mask ^ 0xFFFFFFFFFFFFFFFFL;
            }
            FilteringDebugMessageWindow.this.refilterDisplay();
        }
    }

    private static class Message {
        private long _mask;
        private String _message;
        private String _pos;
        private Object _node;

        public Message(int type, String msg, String pos) {
            this._mask = 1L << type;
            this._message = msg;
            this._pos = pos;
        }

        public void setNode(Object node) {
            this._node = node;
        }

        public Object getNode() {
            return this._node;
        }

        public String toString() {
            return this._message + DebugMessageCook.cookedPosition(this._pos);
        }

        public boolean isTypeConform(long mask) {
            return (mask & this._mask) != 0L;
        }
    }
}

