/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.util.settings.AbstractBasicEnumValue;
import java.util.prefs.Preferences;

public class IntegerEnumValue
extends AbstractBasicEnumValue {
    private final int value;
    private final Integer realValue;

    public IntegerEnumValue(String baseTag, int value) {
        super(baseTag);
        this.value = value;
        this.realValue = new Integer(value);
    }

    public void storeTo(Preferences preferences, String key) {
        preferences.putInt(key, this.value);
    }

    public boolean isEqualTo(Preferences preferences, String key) {
        return preferences.getInt(key, this.value + 1) == this.value;
    }

    public Object getRealValue() {
        return this.realValue;
    }

    public int getValue() {
        return this.value;
    }
}

