/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.i18n.swing.RJButton;
import de.caff.util.settings.swing.AbstractBasicEditorProvider;
import de.caff.util.settings.swing.SwingColorPreferenceProperty;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;

public class ColorEditor
extends AbstractBasicEditorProvider
implements PropertyChangeListener {
    private static final int IMAGE_WIDTH = 48;
    private static final int IMAGE_HEIGHT = 16;
    private final SwingColorPreferenceProperty property;
    private final JButton button;
    private Color color;

    public ColorEditor(SwingColorPreferenceProperty prop, Locale l) {
        this(prop, l, false);
    }

    public ColorEditor(SwingColorPreferenceProperty prop, final Locale l, final boolean autoSave) {
        super(prop, l);
        this.property = prop;
        this.color = this.property.getValue();
        this.button = new RJButton("btChangeColor", ColorEditor.createColoredIcon(this.color));
        this.button.setLocale(l);
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(ColorEditor.this.button, ColorEditor.this.property.getName(l), ColorEditor.this.color);
                if (newColor != null) {
                    ColorEditor.this.setColor(newColor);
                    if (autoSave) {
                        ColorEditor.this.save();
                    }
                }
            }
        });
        this.property.addValueChangeListener(this);
    }

    private void setColor(Color color) {
        this.color = color;
        this.button.setIcon(ColorEditor.createColoredIcon(color));
    }

    static Icon createColoredIcon(Color color) {
        BufferedImage image = new BufferedImage(48, 16, 1);
        Graphics g = ((Image)image).getGraphics();
        g.setColor(color);
        g.fillRect(0, 0, 48, 16);
        return new ImageIcon(image);
    }

    public JComponent getEditor() {
        return this.button;
    }

    public void reset() {
        this.setColor(this.property.getValue());
    }

    public void save() {
        this.property.setValue(this.color);
    }

    public void goodBye() {
        this.property.removeValueChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.color.equals(evt.getOldValue())) {
            this.setColor((Color)evt.getNewValue());
        }
    }
}

