/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings.swing;

import de.caff.i18n.I18n;
import de.caff.util.settings.PreferenceProperty;
import de.caff.util.settings.swing.EditablePreferenceProperty;
import de.caff.util.settings.swing.EditorProvider;
import de.caff.util.settings.swing.PanelGroupEditor;
import de.caff.util.settings.swing.TabbedGroupEditor;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.prefs.Preferences;

public class EditablePreferenceGroup
implements EditablePreferenceProperty {
    public static final String TABBED_SUFFIX = "-TABIDX";
    private Collection propertyList = new LinkedList();
    private final String nameTag;
    private final boolean tabbed;
    private int tabIndex = 0;

    public EditablePreferenceGroup(String nameTag, boolean tabbed) {
        this.nameTag = nameTag;
        this.tabbed = tabbed;
    }

    public EditablePreferenceGroup(String nameTag, boolean tabbed, EditablePreferenceProperty[] properties) {
        this(nameTag, tabbed);
        if (properties != null) {
            this.propertyList.addAll(Arrays.asList(properties));
        }
    }

    public EditorProvider getEditorProvider(Locale l) {
        return this.tabbed ? new TabbedGroupEditor(this, l) : new PanelGroupEditor(this, l);
    }

    public String getName(Locale l) {
        return I18n.getString(this.nameTag, l);
    }

    public void readFrom(Preferences preferences) {
        for (PreferenceProperty property : this.propertyList) {
            property.readFrom(preferences);
        }
        if (this.tabbed) {
            this.tabIndex = preferences.getInt(this.nameTag + TABBED_SUFFIX, this.tabIndex);
        }
    }

    public void storeTo(Preferences preferences) {
        for (PreferenceProperty property : this.propertyList) {
            property.storeTo(preferences);
        }
        if (this.tabbed) {
            preferences.putInt(this.nameTag + TABBED_SUFFIX, this.tabIndex);
        }
    }

    String getNameTag() {
        return this.nameTag;
    }

    Iterator propertyIterator() {
        return this.propertyList.iterator();
    }

    public void addValueChangeListener(PropertyChangeListener listener) {
        for (PreferenceProperty property : this.propertyList) {
            property.addValueChangeListener(listener);
        }
    }

    public void removeValueChangeListener(PropertyChangeListener listener) {
        for (PreferenceProperty property : this.propertyList) {
            property.removeValueChangeListener(listener);
        }
    }

    protected void addProperty(EditablePreferenceProperty property) {
        this.propertyList.add(property);
    }

    int getTabIndex() {
        return this.tabIndex;
    }

    void setTabIndex(int tabIndex) {
        this.tabIndex = tabIndex;
    }
}

